/*
 * Decompiled with CFR 0.152.
 */
package com.srx.widget;

import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.srx.widget.PullCallback;
import com.srx.widget.R;
import com.srx.widget.RecyclerViewPositionHelper;
import com.srx.widget.ScrollDirection;

public class PullToLoadView
extends FrameLayout {
    private SwipeRefreshLayout mSwipeRefreshLayout;
    private RecyclerView mRecyclerView;
    private ProgressBar mProgressBar;
    private PullCallback mPullCallback;
    private RecyclerViewPositionHelper mRecyclerViewHelper;
    protected ScrollDirection mCurScrollingDirection;
    protected int mPrevFirstVisibleItem = 0;
    private int mLoadMoreOffset = 5;
    private boolean mIsLoadMoreEnabled = false;

    public PullToLoadView(Context context) {
        this(context, null);
    }

    public PullToLoadView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PullToLoadView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        mInflater.inflate(R.layout.loadview, (ViewGroup)this, true);
        this.mSwipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipeRefreshLayout);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.init();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mRecyclerViewHelper = RecyclerViewPositionHelper.createHelper(this.mRecyclerView);
    }

    private void init() {
        this.mSwipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                if (null != PullToLoadView.this.mPullCallback) {
                    PullToLoadView.this.mPullCallback.onRefresh();
                }
            }
        });
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                PullToLoadView.this.mCurScrollingDirection = null;
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                Log.e((String)"pull to load view", (String)("on scrolled " + dx + "--" + dy));
                if (PullToLoadView.this.mCurScrollingDirection == null) {
                    PullToLoadView.this.mCurScrollingDirection = ScrollDirection.SAME;
                    PullToLoadView.this.mPrevFirstVisibleItem = PullToLoadView.this.mRecyclerViewHelper.findFirstVisibleItemPosition();
                } else {
                    int firstVisibleItem = PullToLoadView.this.mRecyclerViewHelper.findFirstVisibleItemPosition();
                    Log.e((String)"pull to load view", (String)("firstVisibleItem " + firstVisibleItem));
                    PullToLoadView.this.mCurScrollingDirection = firstVisibleItem > PullToLoadView.this.mPrevFirstVisibleItem ? ScrollDirection.UP : (firstVisibleItem < PullToLoadView.this.mPrevFirstVisibleItem ? ScrollDirection.DOWN : ScrollDirection.SAME);
                    PullToLoadView.this.mPrevFirstVisibleItem = firstVisibleItem;
                }
                Log.e((String)"pull to load view ", (String)("mCurScrollingDirection-----" + PullToLoadView.this.mCurScrollingDirection.toString() + "-------PrevFirstVisibleItem:" + PullToLoadView.this.mPrevFirstVisibleItem));
                if (PullToLoadView.this.mIsLoadMoreEnabled && PullToLoadView.this.mCurScrollingDirection == ScrollDirection.UP && !PullToLoadView.this.mPullCallback.isLoading() && !PullToLoadView.this.mPullCallback.hasLoadedAllItems()) {
                    int lastAdapterPosition;
                    int visibleItemCount;
                    int totalItemCount = PullToLoadView.this.mRecyclerViewHelper.getItemCount();
                    int firstVisibleItem = PullToLoadView.this.mRecyclerViewHelper.findFirstVisibleItemPosition();
                    int lastVisiblePosition = firstVisibleItem + (visibleItemCount = Math.abs(PullToLoadView.this.mRecyclerViewHelper.findLastVisibleItemPosition() - firstVisibleItem)) - 1;
                    if (lastVisiblePosition >= (lastAdapterPosition = totalItemCount - 1) - PullToLoadView.this.mLoadMoreOffset && null != PullToLoadView.this.mPullCallback) {
                        PullToLoadView.this.mProgressBar.setVisibility(0);
                        PullToLoadView.this.mPullCallback.onLoadMore();
                    }
                }
                Log.e((String)"pull to load view", (String)("isLoading:  " + PullToLoadView.this.mPullCallback.isLoading()));
                Log.e((String)"pull to load view", (String)("hasLoadedAllItems:  " + PullToLoadView.this.mPullCallback.hasLoadedAllItems()));
                Log.e((String)"pull to load view", (String)("isLoadMoreEnabled " + PullToLoadView.this.mIsLoadMoreEnabled));
            }
        });
    }

    public void setComplete() {
        this.mProgressBar.setVisibility(8);
        this.mSwipeRefreshLayout.setRefreshing(false);
    }

    public void initLoad() {
        if (null != this.mPullCallback) {
            this.mSwipeRefreshLayout.post(new Runnable(){

                @Override
                public void run() {
                    PullToLoadView.this.mSwipeRefreshLayout.setRefreshing(true);
                }
            });
            this.mPullCallback.onRefresh();
        }
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public void setPullCallback(PullCallback mPullCallback) {
        this.mPullCallback = mPullCallback;
    }

    public void setLoadMoreOffset(int mLoadMoreOffset) {
        this.mLoadMoreOffset = mLoadMoreOffset;
    }

    public void isLoadMoreEnabled(boolean mIsLoadMoreEnabled) {
        this.mIsLoadMoreEnabled = mIsLoadMoreEnabled;
    }
}

