/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.ipc;

import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.RootServiceManager;
import com.topjohnwu.superuser.internal.RootServiceServer;
import com.topjohnwu.superuser.internal.UiThreadHandler;
import com.topjohnwu.superuser.internal.Utils;
import java.io.IOException;
import java.util.concurrent.Executor;

public abstract class RootService
extends ContextWrapper {
    public static final String CATEGORY_DAEMON_MODE = "com.topjohnwu.superuser.DAEMON_MODE";

    @MainThread
    public static void bind(@NonNull Intent intent, @NonNull Executor executor, @NonNull ServiceConnection conn) {
        if (Utils.isRootImpossible()) {
            return;
        }
        Shell.Task task = RootService.bindOrTask(intent, executor, conn);
        if (task != null) {
            Shell.EXECUTOR.execute(RootService.asRunnable(task));
        }
    }

    @MainThread
    public static void bind(@NonNull Intent intent, @NonNull ServiceConnection conn) {
        RootService.bind(intent, UiThreadHandler.executor, conn);
    }

    @MainThread
    @Nullable
    public static Shell.Task bindOrTask(@NonNull Intent intent, @NonNull Executor executor, @NonNull ServiceConnection conn) {
        return RootServiceManager.getInstance().createBindTask(intent, executor, conn);
    }

    @MainThread
    public static void unbind(@NonNull ServiceConnection conn) {
        RootServiceManager.getInstance().unbind(conn);
    }

    @MainThread
    public static void stop(@NonNull Intent intent) {
        if (Utils.isRootImpossible()) {
            return;
        }
        Shell.Task task = RootService.stopOrTask(intent);
        if (task != null) {
            Shell.EXECUTOR.execute(RootService.asRunnable(task));
        }
    }

    @MainThread
    @Nullable
    public static Shell.Task stopOrTask(@NonNull Intent intent) {
        return RootServiceManager.getInstance().createStopTask(intent);
    }

    private static Runnable asRunnable(Shell.Task task) {
        return () -> {
            try {
                Shell shell = Shell.getShell();
                if (shell.isRoot()) {
                    shell.execTask(task);
                }
            }
            catch (IOException e) {
                Utils.err((Throwable)e);
            }
        };
    }

    public RootService() {
        super(null);
    }

    protected final void attachBaseContext(Context base) {
        super.attachBaseContext(this.onAttach(Utils.getContextImpl((Context)base)));
        RootServiceServer.getInstance(base).register(this);
        this.onCreate();
    }

    @NonNull
    protected Context onAttach(@NonNull Context base) {
        return base;
    }

    @NonNull
    public ComponentName getComponentName() {
        return new ComponentName((Context)this, ((Object)((Object)this)).getClass());
    }

    public final Context getApplicationContext() {
        return Utils.context;
    }

    public abstract IBinder onBind(@NonNull Intent var1);

    public void onCreate() {
    }

    public boolean onUnbind(@NonNull Intent intent) {
        return false;
    }

    public void onRebind(@NonNull Intent intent) {
    }

    public void onDestroy() {
    }

    public final void stopSelf() {
        RootServiceServer.getInstance((Context)this).selfStop(this.getComponentName());
    }

    @Deprecated
    @MainThread
    @Nullable
    public static Runnable createBindTask(@NonNull Intent intent, @NonNull Executor executor, @NonNull ServiceConnection conn) {
        Shell.Task task = RootService.bindOrTask(intent, executor, conn);
        return task == null ? null : RootService.asRunnable(task);
    }
}

