/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Process;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.ShellUtils;
import com.topjohnwu.superuser.internal.BinderHolder;
import com.topjohnwu.superuser.internal.HiddenAPIs;
import com.topjohnwu.superuser.internal.IRootServiceManager;
import com.topjohnwu.superuser.internal.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class RootServiceManager
implements Handler.Callback {
    private static RootServiceManager mInstance;
    static final String TAG = "IPC";
    static final String LOGGING_ENV = "LIBSU_VERBOSE_LOGGING";
    static final String DEBUG_ENV = "LIBSU_DEBUGGER";
    static final int MSG_STOP = 1;
    private static final String BUNDLE_BINDER_KEY = "binder";
    private static final String INTENT_BUNDLE_KEY = "extra.bundle";
    private static final String INTENT_DAEMON_KEY = "extra.daemon";
    private static final String RECEIVER_BROADCAST = "com.topjohnwu.superuser.RECEIVER_BROADCAST";
    private static final String API_27_DEBUG = "-Xrunjdwp:transport=dt_android_adb,suspend=n,server=y -Xcompiler-option --debuggable";
    private static final String API_28_DEBUG = "-XjdwpProvider:adbconnection -XjdwpOptions:suspend=n,server=y -Xcompiler-option --debuggable";
    private static final String JVMTI_ERROR = " \n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n! Warning: JVMTI agent is enabled. Please enable the !\n! 'Always install with package manager' option in    !\n! Android Studio. For more details and information,  !\n! check out RootService's Javadoc.                   !\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n";
    private static final int REMOTE_EN_ROUTE = 1;
    private static final int DAEMON_EN_ROUTE = 2;
    private static final int RECEIVER_REGISTERED = 4;
    private RemoteProcess mRemote;
    private RemoteProcess mDaemon;
    private int flags = 0;
    private final List<BindTask> pendingTasks = new ArrayList<BindTask>();
    private final Map<ServiceKey, RemoteServiceRecord> services = new ArrayMap();
    private final Map<ServiceConnection, ConnectionRecord> connections = new ArrayMap();

    public static RootServiceManager getInstance() {
        if (mInstance == null) {
            mInstance = new RootServiceManager();
        }
        return mInstance;
    }

    @SuppressLint(value={"WrongConstant"})
    static Intent getBroadcastIntent(IBinder binder, boolean isDaemon) {
        Bundle bundle = new Bundle();
        bundle.putBinder(BUNDLE_BINDER_KEY, binder);
        return new Intent(RECEIVER_BROADCAST).setPackage(Utils.getContext().getPackageName()).addFlags(HiddenAPIs.FLAG_RECEIVER_FROM_SHELL).putExtra(INTENT_DAEMON_KEY, isDaemon).putExtra(INTENT_BUNDLE_KEY, bundle);
    }

    private static void enforceMainThread() {
        if (!ShellUtils.onMainThread()) {
            throw new IllegalStateException("This method can only be called on the main thread");
        }
    }

    @NonNull
    private static ServiceKey parseIntent(Intent intent) {
        ComponentName name = intent.getComponent();
        if (name == null) {
            throw new IllegalArgumentException("The intent does not have a component set");
        }
        if (!name.getPackageName().equals(Utils.getContext().getPackageName())) {
            throw new IllegalArgumentException("RootServices outside of the app are not supported");
        }
        return new ServiceKey(name, intent.hasCategory("com.topjohnwu.superuser.DAEMON_MODE"));
    }

    private RootServiceManager() {
    }

    @SuppressLint(value={"InlinedApi"})
    private Shell.Task startRootProcess(ComponentName name, String action) {
        Context context = Utils.getContext();
        if (Utils.hasStartupAgents((Context)context)) {
            Log.e((String)TAG, (String)JVMTI_ERROR);
        }
        if ((this.flags & 4) == 0) {
            IntentFilter filter = new IntentFilter(RECEIVER_BROADCAST);
            if (Build.VERSION.SDK_INT >= 26) {
                context.registerReceiver((BroadcastReceiver)new ServiceReceiver(), filter, "android.permission.BROADCAST_PACKAGE_REMOVED", null, 4);
            } else {
                context.registerReceiver((BroadcastReceiver)new ServiceReceiver(), filter, "android.permission.BROADCAST_PACKAGE_REMOVED", null);
            }
            this.flags |= 4;
        }
        return (stdin, stdout, stderr) -> {
            String niceNameCmd;
            Context ctx = Utils.getDeContext();
            File mainJar = new File(ctx.getCacheDir(), "main.jar");
            try (InputStream in = ctx.getResources().getAssets().open("main.jar");
                 FileOutputStream out = new FileOutputStream(mainJar);){
                Utils.pump((InputStream)in, (OutputStream)out);
            }
            String env = "";
            String params = "";
            if (Utils.vLog()) {
                env = "LIBSU_VERBOSE_LOGGING=1 ";
            }
            if (Build.VERSION.SDK_INT >= 27 && Debug.isDebuggerConnected()) {
                env = env + "LIBSU_DEBUGGER=1 ";
                params = Build.VERSION.SDK_INT == 27 ? API_27_DEBUG : API_28_DEBUG;
            }
            if (Build.VERSION.SDK_INT >= 21) {
                params = params + " -Xnoimage-dex2oat";
            }
            switch (action) {
                case "start": {
                    niceNameCmd = String.format(Locale.ROOT, "--nice-name=%s:root:%d", ctx.getPackageName(), Process.myUid() / 100000);
                    break;
                }
                case "daemon": {
                    niceNameCmd = "--nice-name=" + ctx.getPackageName() + ":root:daemon";
                    break;
                }
                default: {
                    niceNameCmd = "";
                }
            }
            String app_process = "/system/bin/app_process";
            if (Build.VERSION.SDK_INT >= 21) {
                app_process = app_process + (Utils.isProcess64Bit() ? "64" : "32");
            }
            String cmd = String.format(Locale.ROOT, "(%s CLASSPATH=%s %s %s /system/bin %s com.topjohnwu.superuser.internal.RootServerMain '%s' %d %s >/dev/null 2>&1)&", env, mainJar, app_process, params, niceNameCmd, name.flattenToString(), Process.myUid(), action);
            Utils.log((String)TAG, (Object)cmd);
            byte[] bytes = cmd.getBytes(StandardCharsets.UTF_8);
            stdin.write(bytes);
            stdin.write(10);
            stdin.flush();
        };
    }

    private ServiceKey bindInternal(Intent intent, Executor executor, ServiceConnection conn) {
        RemoteProcess p;
        RootServiceManager.enforceMainThread();
        ServiceKey key = RootServiceManager.parseIntent(intent);
        RemoteServiceRecord s = this.services.get((Object)key);
        if (s != null) {
            this.connections.put(conn, new ConnectionRecord(s, executor));
            ++s.refCount;
            IBinder binder = s.binder;
            executor.execute(() -> conn.onServiceConnected(key.getName(), binder));
            return null;
        }
        RemoteProcess remoteProcess = p = key.isDaemon() ? this.mDaemon : this.mRemote;
        if (p == null) {
            return key;
        }
        try {
            IBinder binder = p.mgr.bind(intent);
            if (binder != null) {
                s = new RemoteServiceRecord(key, binder, p);
                this.connections.put(conn, new ConnectionRecord(s, executor));
                this.services.put(key, s);
                executor.execute(() -> conn.onServiceConnected(key.getName(), binder));
            } else if (Build.VERSION.SDK_INT >= 28) {
                executor.execute(() -> conn.onNullBinding(key.getName()));
            }
        }
        catch (RemoteException e) {
            Utils.err((String)TAG, (Throwable)e);
            p.binderDied();
            return key;
        }
        return null;
    }

    public Shell.Task createBindTask(Intent intent, Executor executor, ServiceConnection conn) {
        ServiceKey key = this.bindInternal(intent, executor, conn);
        if (key != null) {
            int mask;
            this.pendingTasks.add(() -> this.bindInternal(intent, executor, conn) == null);
            int n = mask = key.isDaemon() ? 2 : 1;
            if ((this.flags & mask) == 0) {
                this.flags |= mask;
                String action = key.isDaemon() ? "daemon" : "start";
                return this.startRootProcess(key.getName(), action);
            }
        }
        return null;
    }

    public void unbind(@NonNull ServiceConnection conn) {
        RootServiceManager.enforceMainThread();
        ConnectionRecord r = this.connections.remove(conn);
        if (r != null) {
            RemoteServiceRecord s = r.getService();
            --s.refCount;
            if (s.refCount == 0) {
                this.services.remove((Object)s.key);
                try {
                    s.host.mgr.unbind(s.key.getName());
                }
                catch (RemoteException e) {
                    Utils.err((String)TAG, (Throwable)e);
                }
            }
            r.disconnect(conn);
        }
    }

    private void dropConnections(Predicate predicate) {
        Iterator<Map.Entry<ServiceConnection, ConnectionRecord>> it = this.connections.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ServiceConnection, ConnectionRecord> e = it.next();
            ConnectionRecord r = e.getValue();
            if (!predicate.eval(r.getService())) continue;
            r.disconnect(e.getKey());
            it.remove();
        }
    }

    private void onServiceStopped(ServiceKey key) {
        RemoteServiceRecord s = this.services.remove((Object)key);
        if (s != null) {
            this.dropConnections(s::equals);
        }
    }

    public Shell.Task createStopTask(Intent intent) {
        RemoteProcess p;
        RootServiceManager.enforceMainThread();
        ServiceKey key = RootServiceManager.parseIntent(intent);
        RemoteProcess remoteProcess = p = key.isDaemon() ? this.mDaemon : this.mRemote;
        if (p == null) {
            if (key.isDaemon()) {
                return this.startRootProcess(key.getName(), "stop");
            }
            return null;
        }
        try {
            p.mgr.stop(key.getName(), -1);
        }
        catch (RemoteException e) {
            Utils.err((String)TAG, (Throwable)e);
        }
        this.onServiceStopped(key);
        return null;
    }

    public boolean handleMessage(@NonNull Message msg) {
        if (msg.what == 1) {
            this.onServiceStopped(new ServiceKey((ComponentName)msg.obj, msg.arg1 != 0));
        }
        return false;
    }

    private static interface Predicate {
        public boolean eval(RemoteServiceRecord var1);
    }

    private class RemoteProcess
    extends BinderHolder {
        final IRootServiceManager mgr;

        RemoteProcess(IRootServiceManager s) throws RemoteException {
            super(s.asBinder());
            this.mgr = s;
        }

        @Override
        protected void onBinderDied() {
            if (RootServiceManager.this.mRemote == this) {
                RootServiceManager.this.mRemote = null;
            }
            if (RootServiceManager.this.mDaemon == this) {
                RootServiceManager.this.mDaemon = null;
            }
            Iterator sit = RootServiceManager.this.services.values().iterator();
            while (sit.hasNext()) {
                if (((RemoteServiceRecord)sit.next()).host != this) continue;
                sit.remove();
            }
            RootServiceManager.this.dropConnections(s -> s.host == this);
        }
    }

    private static class ServiceKey
    extends Pair<ComponentName, Boolean> {
        ServiceKey(ComponentName name, boolean isDaemon) {
            super((Object)name, (Object)isDaemon);
        }

        ComponentName getName() {
            return (ComponentName)this.first;
        }

        boolean isDaemon() {
            return (Boolean)this.second;
        }
    }

    private class ServiceReceiver
    extends BroadcastReceiver {
        private final Messenger m;

        ServiceReceiver() {
            Handler h = new Handler(Looper.getMainLooper(), (Handler.Callback)RootServiceManager.this);
            this.m = new Messenger(h);
        }

        public void onReceive(Context context, Intent intent) {
            Bundle bundle = intent.getBundleExtra(RootServiceManager.INTENT_BUNDLE_KEY);
            if (bundle == null) {
                return;
            }
            IBinder binder = bundle.getBinder(RootServiceManager.BUNDLE_BINDER_KEY);
            if (binder == null) {
                return;
            }
            IRootServiceManager mgr = IRootServiceManager.Stub.asInterface(binder);
            try {
                mgr.connect(this.m.getBinder());
                RemoteProcess p = new RemoteProcess(mgr);
                if (intent.getBooleanExtra(RootServiceManager.INTENT_DAEMON_KEY, false)) {
                    RootServiceManager.this.mDaemon = p;
                    RootServiceManager.this.flags &= -3;
                } else {
                    RootServiceManager.this.mRemote = p;
                    RootServiceManager.this.flags &= -2;
                }
                for (int i = RootServiceManager.this.pendingTasks.size() - 1; i >= 0; --i) {
                    if (!((BindTask)RootServiceManager.this.pendingTasks.get(i)).run()) continue;
                    RootServiceManager.this.pendingTasks.remove(i);
                }
            }
            catch (RemoteException e) {
                Utils.err((String)RootServiceManager.TAG, (Throwable)e);
            }
        }
    }

    private static class RemoteServiceRecord {
        final ServiceKey key;
        final IBinder binder;
        final RemoteProcess host;
        int refCount = 1;

        RemoteServiceRecord(ServiceKey key, IBinder binder, RemoteProcess host) {
            this.key = key;
            this.binder = binder;
            this.host = host;
        }
    }

    private static class ConnectionRecord
    extends Pair<RemoteServiceRecord, Executor> {
        ConnectionRecord(RemoteServiceRecord s, Executor e) {
            super((Object)s, (Object)e);
        }

        RemoteServiceRecord getService() {
            return (RemoteServiceRecord)this.first;
        }

        void disconnect(ServiceConnection conn) {
            ((Executor)this.second).execute(() -> conn.onServiceDisconnected(((RemoteServiceRecord)this.first).key.getName()));
        }
    }

    private static interface BindTask {
        public boolean run();
    }
}

