/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.system.OsConstants;
import androidx.annotation.NonNull;
import com.topjohnwu.superuser.internal.FileImpl;
import com.topjohnwu.superuser.internal.IFileSystemService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class RemoteFile
extends FileImpl<RemoteFile> {
    private final IFileSystemService fs;

    RemoteFile(IFileSystemService f, String path) {
        super(path);
        this.fs = f;
    }

    RemoteFile(IFileSystemService f, String parent, String child) {
        super(parent, child);
        this.fs = f;
    }

    @Override
    protected RemoteFile create(String path) {
        return new RemoteFile(this.fs, path);
    }

    @Override
    @NonNull
    public RemoteFile getChildFile(String name) {
        return new RemoteFile(this.fs, this.getPath(), name);
    }

    protected RemoteFile[] createArray(int n) {
        return new RemoteFile[n];
    }

    @Override
    @NonNull
    public String getCanonicalPath() throws IOException {
        try {
            return (String)this.fs.getCanonicalPath(this.getPath()).tryAndGet();
        }
        catch (RemoteException e) {
            throw new IOException(e);
        }
    }

    private boolean checkAccess(int access) {
        try {
            return this.fs.checkAccess(this.getPath(), access);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean canRead() {
        return this.checkAccess(OsConstants.R_OK);
    }

    @Override
    public boolean canWrite() {
        return this.checkAccess(OsConstants.W_OK);
    }

    @Override
    public boolean canExecute() {
        return this.checkAccess(OsConstants.X_OK);
    }

    @Override
    public boolean exists() {
        return this.checkAccess(OsConstants.F_OK);
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.fs.isDirectory(this.getPath());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean isFile() {
        try {
            return this.fs.isFile(this.getPath());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean isBlock() {
        try {
            return OsConstants.S_ISBLK((int)this.fs.getMode(this.getPath()));
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean isCharacter() {
        try {
            return OsConstants.S_ISCHR((int)this.fs.getMode(this.getPath()));
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean isSymlink() {
        try {
            return OsConstants.S_ISLNK((int)this.fs.getMode(this.getPath()));
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean isNamedPipe() {
        try {
            return OsConstants.S_ISFIFO((int)this.fs.getMode(this.getPath()));
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean isSocket() {
        try {
            return OsConstants.S_ISSOCK((int)this.fs.getMode(this.getPath()));
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean isHidden() {
        try {
            return this.fs.isHidden(this.getPath());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public long lastModified() {
        try {
            return this.fs.lastModified(this.getPath());
        }
        catch (RemoteException e) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    public long length() {
        try {
            return this.fs.length(this.getPath());
        }
        catch (RemoteException e) {
            return 0L;
        }
    }

    @Override
    public boolean createNewFile() throws IOException {
        try {
            return (Boolean)this.fs.createNewFile(this.getPath()).tryAndGet();
        }
        catch (RemoteException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean createNewLink(String existing) throws IOException {
        try {
            return (Boolean)this.fs.createLink(this.getPath(), existing, false).tryAndGet();
        }
        catch (RemoteException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean createNewSymlink(String target) throws IOException {
        try {
            return (Boolean)this.fs.createLink(this.getPath(), target, true).tryAndGet();
        }
        catch (RemoteException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean delete() {
        try {
            return this.fs.delete(this.getPath());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public void deleteOnExit() {
        throw new UnsupportedOperationException("deleteOnExit() is not supported in RemoteFile");
    }

    @Override
    public String[] list() {
        try {
            return this.fs.list(this.getPath());
        }
        catch (RemoteException e) {
            return null;
        }
    }

    @Override
    public boolean mkdir() {
        try {
            return this.fs.mkdir(this.getPath());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean mkdirs() {
        try {
            return this.fs.mkdirs(this.getPath());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean renameTo(@NonNull File dest) {
        try {
            return this.fs.renameTo(this.getPath(), dest.getAbsolutePath());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean setLastModified(long time) {
        try {
            return this.fs.setLastModified(this.getPath(), time);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean setReadOnly() {
        try {
            return this.fs.setReadOnly(this.getPath());
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        try {
            return this.fs.setWritable(this.getPath(), writable, ownerOnly);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        try {
            return this.fs.setReadable(this.getPath(), readable, ownerOnly);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        try {
            return this.fs.setExecutable(this.getPath(), executable, ownerOnly);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public long getTotalSpace() {
        try {
            return this.fs.getTotalSpace(this.getPath());
        }
        catch (RemoteException e) {
            return 0L;
        }
    }

    @Override
    public long getFreeSpace() {
        try {
            return this.fs.getFreeSpace(this.getPath());
        }
        catch (RemoteException e) {
            return 0L;
        }
    }

    @Override
    public long getUsableSpace() {
        try {
            return this.fs.getUsableSpace(this.getPath());
        }
        catch (RemoteException e) {
            return 0L;
        }
    }

    @Override
    @NonNull
    public InputStream newInputStream() throws IOException {
        ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
        try {
            this.fs.openReadStream(this.getPath(), pipe[1]).checkException();
        }
        catch (RemoteException e) {
            pipe[0].close();
            throw new IOException(e);
        }
        finally {
            pipe[1].close();
        }
        return new ParcelFileDescriptor.AutoCloseInputStream(pipe[0]);
    }

    @Override
    @NonNull
    public OutputStream newOutputStream(boolean append) throws IOException {
        ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
        try {
            this.fs.openWriteStream(this.getPath(), pipe[0], append).checkException();
        }
        catch (RemoteException e) {
            pipe[1].close();
            throw new IOException(e);
        }
        finally {
            pipe[0].close();
        }
        return new ParcelFileDescriptor.AutoCloseOutputStream(pipe[1]);
    }
}

