/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.io.SuFile;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class SuRandomAccessFile
implements DataInput,
DataOutput,
Closeable {
    @NonNull
    public static SuRandomAccessFile open(@NonNull File file, String mode) throws FileNotFoundException {
        if (file instanceof SuFile) {
            return IOFactory.shellIO((SuFile)((Object)file), mode);
        }
        try {
            return IOFactory.raf(file, mode);
        }
        catch (FileNotFoundException e) {
            return IOFactory.shellIO(new SuFile(file), mode);
        }
    }

    @NonNull
    public static SuRandomAccessFile open(@NonNull String path, String mode) throws FileNotFoundException {
        return SuRandomAccessFile.open(new File(path), mode);
    }

    public abstract int read() throws IOException;

    public abstract int read(byte[] var1) throws IOException;

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public abstract void seek(long var1) throws IOException;

    public abstract void setLength(long var1) throws IOException;

    public abstract long length() throws IOException;

    public abstract long getFilePointer() throws IOException;
}

