/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.ShellUtils;
import com.topjohnwu.superuser.internal.ByteOutputStream;
import com.topjohnwu.superuser.internal.DataInputImpl;
import com.topjohnwu.superuser.internal.DataOutputImpl;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.internal.ShellBlockIO;
import com.topjohnwu.superuser.internal.Utils;
import com.topjohnwu.superuser.io.SuFile;
import com.topjohnwu.superuser.io.SuRandomAccessFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

class ShellIO
extends SuRandomAccessFile
implements DataInputImpl,
DataOutputImpl {
    private static final String TAG = "SHELLIO";
    private final SuFile file;
    private boolean readOnly;
    boolean eof;
    long fileOff;

    static ShellIO get(SuFile file, String mode) throws FileNotFoundException {
        if (file.isBlock()) {
            return new ShellBlockIO(file, mode);
        }
        return new ShellIO(file, mode);
    }

    ShellIO(SuFile file, String mode) throws FileNotFoundException {
        FileNotFoundException fnf = new FileNotFoundException("No such file or directory");
        this.file = file;
        if (file.isDirectory()) {
            throw fnf;
        }
        this.fileOff = 0L;
        switch (mode) {
            case "r": {
                if (!file.exists()) {
                    throw fnf;
                }
                this.readOnly = true;
                break;
            }
            case "w": {
                if (file.clear()) break;
                throw fnf;
            }
            case "rw": {
                if (file.exists() || file.createNewFile()) break;
                throw fnf;
            }
        }
    }

    protected String getConv() {
        return "conv=notrunc";
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readOnly) {
            throw new IOException("File is opened as read-only");
        }
        if (this.fileOff > 0L && this.fileOff < 512L && len > 512) {
            int size = 512 - (int)this.fileOff;
            this.write0(b, off, size);
            len -= size;
            off += size;
        }
        this.write0(b, off, len);
    }

    private void write0(@NonNull byte[] b, int off, int len) throws IOException {
        this.file.getShell().execTask((in, out, err) -> {
            String cmd = this.fileOff == 0L ? String.format(Locale.ROOT, "dd of=%s bs=%d count=1 %s 2>/dev/null; echo\n", this.file.getEscapedPath(), len, this.getConv()) : String.format(Locale.ROOT, "dd of=%s ibs=%d count=1 obs=%d seek=1 %s 2>/dev/null; echo\n", this.file.getEscapedPath(), len, this.fileOff, this.getConv());
            Utils.log((String)TAG, (Object)cmd);
            in.write(cmd.getBytes(StandardCharsets.UTF_8));
            in.flush();
            in.write(b, off, len);
            in.flush();
            out.read(IOFactory.JUNK);
        });
        this.fileOff += (long)len;
    }

    @Override
    public int read() throws IOException {
        return DataInputImpl.super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return DataInputImpl.super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.eof) {
            return -1;
        }
        int bs = (int)ShellUtils.gcd((long)this.fileOff, (long)len);
        if (bs >= 512 || len < 512) {
            len = this.alignedRead(b, off, len / bs, (int)(this.fileOff / (long)bs), bs);
        } else {
            bs = 4096;
            long skip = this.fileOff / (long)bs;
            int count = (int)((this.fileOff + (long)len + (long)bs - 1L) / (long)bs - skip);
            byte[] buf = new byte[count * bs];
            long start = skip * (long)bs;
            int read = this.alignedRead(buf, 0, count, (int)skip, bs);
            if (read > 0) {
                int valid = (int)(start + (long)read - this.fileOff);
                if (valid < len) {
                    this.eof = true;
                }
                len = Math.min(valid, len);
                System.arraycopy(buf, (int)(this.fileOff - start), b, off, len);
            }
        }
        this.fileOff += (long)len;
        return len == 0 ? -1 : len;
    }

    protected int alignedRead(byte[] b, int _off, int count, int skip, int bs) throws IOException {
        if (this.eof) {
            return 0;
        }
        int[] total = new int[1];
        int len = count * bs;
        this.file.getShell().execTask((in, out, err) -> {
            int off = _off;
            String cmd = String.format(Locale.ROOT, "dd if=%s ibs=%d skip=%d count=%d obs=%d 2>/dev/null; echo >&2\n", this.file.getEscapedPath(), bs, skip, count, len);
            Utils.log((String)TAG, (Object)cmd);
            in.write(cmd.getBytes(StandardCharsets.UTF_8));
            in.flush();
            while (total[0] != len && err.available() == 0 || out.available() != 0) {
                int read = out.read(b, off, out.available());
                off += read;
                total[0] = total[0] + read;
            }
            err.read(IOFactory.JUNK);
        });
        if (total[0] == 0 || total[0] != len) {
            this.eof = true;
        }
        return total[0];
    }

    @Override
    public String readLine() throws IOException {
        long skip;
        byte[] buf;
        int read;
        ByteOutputStream bs = new ByteOutputStream();
        boolean eos = false;
        while ((read = this.alignedRead(buf = new byte[512], 0, 1, (int)(skip = this.fileOff / 512L), 512)) != 0) {
            int i;
            for (i = (int)(this.fileOff - skip * 512L); i < read; ++i) {
                byte b = buf[i];
                bs.write(b);
                if (b != 10) continue;
                ++i;
                eos = true;
                break;
            }
            if (this.eof && i != read) {
                this.eof = false;
            }
            if (!this.eof && !eos) continue;
        }
        int size = bs.size();
        if (size == 0) {
            return null;
        }
        this.fileOff += (long)size;
        byte[] bytes = bs.getBuf();
        if (bytes[size - 1] == 10 && --size > 0 && bytes[size - 1] == 13) {
            --size;
        }
        return new String(bytes, 0, size, StandardCharsets.UTF_8);
    }

    @Override
    public void seek(long pos) throws IOException {
        this.fileOff = pos;
        this.eof = false;
    }

    @Override
    public void setLength(long newLength) throws IOException {
        if (newLength == 0L) {
            if (!this.file.clear()) {
                throw new IOException("Cannot clear file");
            }
            return;
        }
        this.file.getShell().execTask((in, out, err) -> {
            String cmd = String.format(Locale.ROOT, "dd of=%s bs=%d seek=1 count=0 2>/dev/null; echo\n", this.file.getEscapedPath(), newLength);
            Utils.log((String)TAG, (Object)cmd);
            in.write(cmd.getBytes(StandardCharsets.UTF_8));
            in.flush();
            out.read(IOFactory.JUNK);
        });
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public long getFilePointer() {
        return this.fileOff;
    }

    @Override
    public int skipBytes(int n) {
        if (n <= 0) {
            return 0;
        }
        long old = this.fileOff;
        this.fileOff = Math.min(this.length(), this.fileOff + (long)n);
        return (int)(this.fileOff - old);
    }

    @Override
    public void close() {
    }
}

