/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.FileUtils;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.internal.Utils;
import com.topjohnwu.superuser.io.SuFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class ShellPipeStream {
    private static final int FIFO_TIMEOUT = 250;
    private static final String TAG = "FIFOIO";
    private static final byte[] END_CMD = "echo\n".getBytes(StandardCharsets.UTF_8);

    ShellPipeStream() {
    }

    static InputStream openReadStream(SuFile file) throws FileNotFoundException {
        if (file.isDirectory() || !file.canRead()) {
            throw new FileNotFoundException("No such file or directory: " + file.getPath());
        }
        File f = null;
        try {
            File fifo;
            f = fifo = FileUtils.createTempFIFO();
            file.getShell().execTask((in, out, err) -> {
                String cmd = "cat " + file.getEscapedPath() + " > " + fifo + " 2>/dev/null &";
                Utils.log((String)TAG, (Object)cmd);
                in.write(cmd.getBytes(StandardCharsets.UTF_8));
                in.write(10);
                in.flush();
                in.write(END_CMD);
                in.flush();
                out.read(IOFactory.JUNK);
            });
            Future<InputStream> stream = Shell.EXECUTOR.submit(() -> new FileInputStream(fifo));
            InputStream inputStream = stream.get(250L, TimeUnit.MILLISECONDS);
            return inputStream;
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            Throwable cause = e.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            Throwable err2 = new FileNotFoundException("Cannot open fifo").initCause(e);
            throw (FileNotFoundException)err2;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    static OutputStream openWriteStream(SuFile file, boolean append) throws FileNotFoundException {
        if (file.isDirectory()) {
            throw new FileNotFoundException(file.getPath() + " is not a file but a directory");
        }
        if (file.isBlock() || file.isCharacter()) {
            append = false;
        }
        if (append && !file.canWrite() && !file.createNewFile()) {
            throw new FileNotFoundException("Cannot write to file " + file.getPath());
        }
        if (!file.clear()) {
            throw new FileNotFoundException("Failed to clear file " + file.getPath());
        }
        String op = append ? " >> " : " > ";
        File f = null;
        try {
            File fifo;
            f = fifo = FileUtils.createTempFIFO();
            file.getShell().execTask((in, out, err) -> {
                String cmd = "cat " + fifo + op + file.getEscapedPath() + " 2>/dev/null &";
                Utils.log((String)TAG, (Object)cmd);
                in.write(cmd.getBytes(StandardCharsets.UTF_8));
                in.write(10);
                in.flush();
                in.write(END_CMD);
                in.flush();
                out.read(IOFactory.JUNK);
            });
            Future<OutputStream> stream = Shell.EXECUTOR.submit(() -> new FileOutputStream(fifo));
            OutputStream outputStream = stream.get(250L, TimeUnit.MILLISECONDS);
            return outputStream;
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            Throwable cause = e.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            Throwable err2 = new FileNotFoundException("Cannot open fifo").initCause(e);
            throw (FileNotFoundException)err2;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }
}

