/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.FileUtils;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.internal.Utils;
import com.topjohnwu.superuser.io.SuFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class FifoOutputStream
extends FilterOutputStream {
    static final int FIFO_TIMEOUT = 250;
    static final String TAG = "FIFOIO";
    static final byte[] END_CMD = "echo\n".getBytes(StandardCharsets.UTF_8);
    private boolean append;

    FifoOutputStream(SuFile file, boolean append) throws FileNotFoundException {
        super(null);
        this.append = append;
        this.checkFile(file);
        File fifo = null;
        try {
            fifo = FileUtils.createTempFIFO();
            this.openStream(file, fifo);
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            Throwable cause = e.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            throw (FileNotFoundException)new FileNotFoundException("Cannot open fifo").initCause(e);
        }
        finally {
            if (fifo != null) {
                fifo.delete();
            }
        }
    }

    private void checkFile(SuFile file) throws FileNotFoundException {
        if (file.isDirectory()) {
            throw new FileNotFoundException(file.getAbsolutePath() + " is not a file but a directory");
        }
        if (file.isBlock() || file.isCharacter()) {
            this.append = false;
        }
        if (this.append && !file.canWrite() && !file.createNewFile()) {
            throw new FileNotFoundException("Can write to file " + file.getAbsolutePath());
        }
        if (!file.clear()) {
            throw new FileNotFoundException("Failed to clear file " + file.getAbsolutePath());
        }
    }

    private void openStream(SuFile file, File fifo) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        file.getShell().execTask((in, out, err) -> {
            String cmd = "cat " + fifo + this.op() + file.getEscapedPath() + " 2>/dev/null &";
            Utils.log((String)TAG, (Object)cmd);
            in.write(cmd.getBytes(StandardCharsets.UTF_8));
            in.write(10);
            in.flush();
            in.write(END_CMD);
            in.flush();
            out.read(IOFactory.JUNK);
        });
        Future<OutputStream> stream = Shell.EXECUTOR.submit(() -> new FileOutputStream(fifo));
        this.out = stream.get(250L, TimeUnit.MILLISECONDS);
    }

    private String op() {
        return this.append ? " >> " : " > ";
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }
}

