/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.FifoOutputStream;
import com.topjohnwu.superuser.internal.FileUtils;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.internal.Utils;
import com.topjohnwu.superuser.io.SuFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class FifoInputStream
extends FilterInputStream {
    FifoInputStream(SuFile file) throws FileNotFoundException {
        super(null);
        if (file.isDirectory() || !file.canRead()) {
            throw new FileNotFoundException("No such file or directory: " + file.getAbsolutePath());
        }
        File fifo = null;
        try {
            fifo = FileUtils.createTempFIFO();
            this.openStream(file, fifo);
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            Throwable cause = e.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            throw (FileNotFoundException)new FileNotFoundException("Cannot open fifo").initCause(e);
        }
        finally {
            if (fifo != null) {
                fifo.delete();
            }
        }
    }

    private void openStream(SuFile file, File fifo) throws IOException, ExecutionException, InterruptedException, TimeoutException {
        file.getShell().execTask((in, out, err) -> {
            String cmd = "cat " + file.getEscapedPath() + " > " + fifo + " 2>/dev/null &";
            Utils.log((String)"FIFOIO", (Object)cmd);
            in.write(cmd.getBytes(StandardCharsets.UTF_8));
            in.write(10);
            in.flush();
            in.write(FifoOutputStream.END_CMD);
            in.flush();
            out.read(IOFactory.JUNK);
        });
        Future<InputStream> stream = Shell.EXECUTOR.submit(() -> new FileInputStream(fifo));
        this.in = stream.get(250L, TimeUnit.MILLISECONDS);
    }
}

