/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.content.Context;
import android.system.ErrnoException;
import android.system.Os;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.FifoOutputStream;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.internal.Utils;
import com.topjohnwu.superuser.io.SuFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class FifoInputStream
extends FilterInputStream {
    private final File fifo;

    FifoInputStream(SuFile file) throws FileNotFoundException {
        super(null);
        if (file.isDirectory() || !file.canRead()) {
            throw new FileNotFoundException("No such file or directory");
        }
        Context c = Utils.getDeContext((Context)Utils.getContext());
        this.fifo = new File(c.getCacheDir(), UUID.randomUUID().toString());
        try {
            Os.mkfifo((String)this.fifo.getPath(), (int)384);
        }
        catch (ErrnoException e) {
            Utils.err((Throwable)e);
            throw (FileNotFoundException)new FileNotFoundException("Failed to mkfifo").initCause(e);
        }
        this.fifo.deleteOnExit();
        try {
            this.openStream(file);
        }
        catch (Exception e) {
            this.fifo.delete();
            throw e;
        }
    }

    private void openStream(SuFile file) throws FileNotFoundException {
        try {
            file.getShell().execTask((in, out, err) -> {
                String cmd = "cat " + file.getEscapedPath() + " > " + this.fifo + " 2>/dev/null &";
                Utils.log((String)"FIFOIO", (Object)cmd);
                in.write(cmd.getBytes(StandardCharsets.UTF_8));
                in.write(10);
                in.flush();
                in.write(FifoOutputStream.END_CMD);
                in.flush();
                out.read(IOFactory.JUNK);
            });
        }
        catch (IOException e) {
            throw (FileNotFoundException)new FileNotFoundException("Error during root command").initCause(e);
        }
        Future<InputStream> stream = Shell.EXECUTOR.submit(() -> new FileInputStream(this.fifo));
        try {
            this.in = stream.get(250L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            throw (FileNotFoundException)new FileNotFoundException("Cannot open fifo").initCause(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fifo.delete();
    }
}

