/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.ShellUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;

public class SuFile
extends File {
    private final String escapedPath = ShellUtils.escapedString((String)this.getPath());
    private Shell mShell;

    public static File open(String pathname) {
        return Shell.rootAccess() ? new SuFile(pathname) : new File(pathname);
    }

    public static File open(String parent, String child) {
        return Shell.rootAccess() ? new SuFile(parent, child) : new File(parent, child);
    }

    public static File open(File parent, String child) {
        return Shell.rootAccess() ? new SuFile(parent, child) : new File(parent, child);
    }

    public static File open(URI uri) {
        return Shell.rootAccess() ? new SuFile(uri) : new File(uri);
    }

    SuFile(@NonNull File file) {
        super(file.getAbsolutePath());
    }

    public SuFile(String pathname) {
        this(new File(pathname));
    }

    public SuFile(String parent, String child) {
        this(new File(parent, child));
    }

    public SuFile(File parent, String child) {
        this(parent.getAbsolutePath(), child);
    }

    public SuFile(URI uri) {
        this(new File(uri));
    }

    private String cmd(String c) {
        return ShellUtils.fastCmd((Shell)this.getShell(), (String[])new String[]{c.replace("@@", this.escapedPath)});
    }

    private boolean cmdBool(String c) {
        return ShellUtils.fastCmdResult((Shell)this.getShell(), (String[])new String[]{c.replace("@@", this.escapedPath)});
    }

    public void setShell(Shell shell) {
        this.mShell = shell;
    }

    public Shell getShell() {
        return this.mShell == null ? Shell.getShell() : this.mShell;
    }

    @NonNull
    public String getEscapedPath() {
        return this.escapedPath;
    }

    @Override
    public boolean canExecute() {
        return this.cmdBool("[ -x @@ ]");
    }

    @Override
    public boolean canRead() {
        return this.cmdBool("[ -r @@ ]");
    }

    @Override
    public boolean canWrite() {
        return this.cmdBool("[ -w @@ ]");
    }

    @Override
    public boolean createNewFile() {
        return this.cmdBool("[ ! -e @@ ] && echo -n > @@");
    }

    @Override
    public boolean delete() {
        return this.cmdBool("rm -f @@ || rmdir -f @@");
    }

    public boolean deleteRecursive() {
        return this.cmdBool("rm -rf @@");
    }

    public boolean clear() {
        return this.cmdBool("echo -n > @@");
    }

    @Override
    public void deleteOnExit() {
        throw new UnsupportedOperationException("Unsupported SuFile operation");
    }

    @Override
    public boolean exists() {
        return this.cmdBool("[ -e @@ ]");
    }

    @Override
    @NonNull
    public String getAbsolutePath() {
        return this.getPath();
    }

    @Override
    @NonNull
    public SuFile getAbsoluteFile() {
        return this;
    }

    @Override
    @NonNull
    public String getCanonicalPath() {
        String path = this.cmd("readlink -f @@");
        return path.isEmpty() ? this.getPath() : path;
    }

    @Override
    @NonNull
    public SuFile getCanonicalFile() {
        return new SuFile(this.getCanonicalPath());
    }

    @Override
    public SuFile getParentFile() {
        String parent = this.getParent();
        return parent == null ? null : new SuFile(parent);
    }

    private long statFS(String fmt) {
        String[] res = this.cmd("stat -fc '%S " + fmt + "' @@").split(" ");
        if (res.length != 2) {
            return Long.MAX_VALUE;
        }
        try {
            return Long.parseLong(res[0]) * Long.parseLong(res[1]);
        }
        catch (NumberFormatException e) {
            return Long.MAX_VALUE;
        }
    }

    @Override
    public long getFreeSpace() {
        return this.statFS("%f");
    }

    @Override
    public long getTotalSpace() {
        return this.statFS("%b");
    }

    @Override
    public long getUsableSpace() {
        return this.statFS("%a");
    }

    @Override
    public boolean isDirectory() {
        return this.cmdBool("[ -d @@ ]");
    }

    @Override
    public boolean isFile() {
        return this.cmdBool("[ -f @@ ]");
    }

    public boolean isBlock() {
        return this.cmdBool("[ -b @@ ]");
    }

    public boolean isCharacter() {
        return this.cmdBool("[ -c @@ ]");
    }

    public boolean isSymlink() {
        return this.cmdBool("[ -L @@ ]");
    }

    @Override
    public long lastModified() {
        try {
            return Long.parseLong(this.cmd("stat -c '%Y' @@")) * 1000L;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public long length() {
        try {
            return Long.parseLong(this.cmd("stat -c '%s' @@"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    @Override
    public boolean mkdir() {
        return this.cmdBool("mkdir @@");
    }

    @Override
    public boolean mkdirs() {
        return this.cmdBool("mkdir -p @@");
    }

    @Override
    public boolean renameTo(File dest) {
        String cmd = "mv -f " + this.escapedPath + " " + ShellUtils.escapedString((String)dest.getAbsolutePath());
        return ShellUtils.fastCmdResult((Shell)this.getShell(), (String[])new String[]{cmd});
    }

    private boolean setPerms(boolean set, boolean ownerOnly, int b) {
        char[] perms = this.cmd("stat -c '%a' @@").toCharArray();
        if (perms.length != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            int perm = perms[i] - 48;
            perm = set && (!ownerOnly || i == 0) ? (perm |= b) : (perm &= ~b);
            perms[i] = (char)(perm + 48);
        }
        return this.cmdBool("chmod " + new String(perms) + " @@");
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        return this.setPerms(executable, ownerOnly, 1);
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        return this.setPerms(readable, ownerOnly, 4);
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        return this.setPerms(writable, ownerOnly, 2);
    }

    @Override
    public boolean setReadOnly() {
        return this.setWritable(false, false) && this.setExecutable(false, false);
    }

    @Override
    public boolean setLastModified(long time) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
        String date = df.format(new Date(time));
        return this.cmdBool("[ -e @@ ] && touch -t " + date + " @@");
    }

    @Override
    public String[] list() {
        return this.list(null);
    }

    @Override
    public String[] list(FilenameFilter filter) {
        if (!this.isDirectory()) {
            return null;
        }
        String cmd = "ls -a " + this.escapedPath;
        List out = this.getShell().newJob().add(new String[]{cmd}).to(new LinkedList(), null).exec().getOut();
        ListIterator it = out.listIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!name.equals(".") && !name.equals("..") && (filter == null || filter.accept(this, name))) continue;
            it.remove();
        }
        return out.toArray(new String[0]);
    }

    @Nullable
    public SuFile[] listFiles() {
        if (!this.isDirectory()) {
            return null;
        }
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        SuFile[] fs = new SuFile[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = new SuFile(this, ss[i]);
        }
        return fs;
    }

    @Nullable
    public SuFile[] listFiles(FilenameFilter filter) {
        if (!this.isDirectory()) {
            return null;
        }
        String[] ss = this.list(filter);
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        SuFile[] fs = new SuFile[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = new SuFile(this, ss[i]);
        }
        return fs;
    }

    @Nullable
    public SuFile[] listFiles(FileFilter filter) {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        ArrayList<SuFile> files = new ArrayList<SuFile>();
        for (String s : ss) {
            SuFile f = new SuFile(this, s);
            if (filter != null && !filter.accept(f)) continue;
            files.add(f);
        }
        return files.toArray(new SuFile[0]);
    }
}

