/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import android.os.Build;
import androidx.annotation.NonNull;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.io.SuFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class SuFileOutputStream
extends BufferedOutputStream {
    @NonNull
    public static OutputStream open(@NonNull String path) throws FileNotFoundException {
        return SuFileOutputStream.open(new File(path), false);
    }

    @NonNull
    public static OutputStream open(@NonNull String path, boolean append) throws FileNotFoundException {
        return SuFileOutputStream.open(new File(path), append);
    }

    @NonNull
    public static OutputStream open(@NonNull File file) throws FileNotFoundException {
        return SuFileOutputStream.open(file, false);
    }

    @NonNull
    public static OutputStream open(@NonNull File file, boolean append) throws FileNotFoundException {
        if (file instanceof SuFile) {
            return SuFileOutputStream.fifo((SuFile)file, append);
        }
        try {
            return new FileOutputStream(file, append);
        }
        catch (FileNotFoundException e) {
            if (!Shell.rootAccess()) {
                throw e;
            }
            return SuFileOutputStream.fifo(new SuFile(file), append);
        }
    }

    @NonNull
    public static OutputStream openNoCopy(@NonNull String path) throws FileNotFoundException {
        return SuFileOutputStream.openNoCopy(new File(path), false);
    }

    @NonNull
    public static OutputStream openNoCopy(@NonNull String path, boolean append) throws FileNotFoundException {
        return SuFileOutputStream.openNoCopy(new File(path), append);
    }

    @NonNull
    public static OutputStream openNoCopy(@NonNull File file) throws FileNotFoundException {
        return SuFileOutputStream.openNoCopy(file, false);
    }

    @NonNull
    public static OutputStream openNoCopy(@NonNull File file, boolean append) throws FileNotFoundException {
        if (file instanceof SuFile) {
            return SuFileOutputStream.shell((SuFile)file, append);
        }
        try {
            return new FileOutputStream(file, append);
        }
        catch (FileNotFoundException e) {
            if (!Shell.rootAccess()) {
                throw e;
            }
            return SuFileOutputStream.shell(new SuFile(file), append);
        }
    }

    private static OutputStream fifo(SuFile file, boolean append) throws FileNotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return IOFactory.fifoOut(file, append);
        }
        return IOFactory.copyOut(file, append);
    }

    private static OutputStream shell(SuFile file, boolean append) throws FileNotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return IOFactory.fifoOut(file, append);
        }
        return IOFactory.shellOut(file, append);
    }

    @Deprecated
    public SuFileOutputStream(String path) throws FileNotFoundException {
        super(SuFileOutputStream.openNoCopy(path, false));
    }

    @Deprecated
    public SuFileOutputStream(String path, boolean append) throws FileNotFoundException {
        super(SuFileOutputStream.openNoCopy(path, append));
    }

    @Deprecated
    public SuFileOutputStream(File file) throws FileNotFoundException {
        super(SuFileOutputStream.openNoCopy(file, false));
    }

    @Deprecated
    public SuFileOutputStream(File file, boolean append) throws FileNotFoundException {
        super(SuFileOutputStream.openNoCopy(file, append));
    }
}

