/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.ShellUtils;
import com.topjohnwu.superuser.internal.Env;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;

public class SuFile
extends File {
    private String[] CMDs = new String[2];

    public static File open(String pathname) {
        return Shell.rootAccess() ? new SuFile(pathname) : new File(pathname);
    }

    public static File open(String parent, String child) {
        return Shell.rootAccess() ? new SuFile(parent, child) : new File(parent, child);
    }

    public static File open(File parent, String child) {
        return Shell.rootAccess() ? new SuFile(parent, child) : new File(parent, child);
    }

    public static File open(URI uri) {
        return Shell.rootAccess() ? new SuFile(uri) : new File(uri);
    }

    SuFile(@NonNull File file) {
        super(file.getAbsolutePath());
        this.CMDs[0] = "__F_='" + file.getAbsolutePath() + "'";
    }

    public SuFile(String pathname) {
        this(new File(pathname));
    }

    public SuFile(String parent, String child) {
        this(new File(parent, child));
    }

    public SuFile(File parent, String child) {
        this(parent.getAbsolutePath(), child);
    }

    public SuFile(URI uri) {
        this(new File(uri));
    }

    private String[] setCmd(String c) {
        this.CMDs[1] = c;
        return this.CMDs;
    }

    private String cmd(String c) {
        return ShellUtils.fastCmd((String[])this.setCmd(c));
    }

    private boolean cmdBool(String c) {
        return ShellUtils.fastCmdResult((String[])this.setCmd(c));
    }

    @Override
    public boolean canExecute() {
        return this.cmdBool("[ -x \"$__F_\" ]");
    }

    @Override
    public boolean canRead() {
        return this.cmdBool("[ -r \"$__F_\" ]");
    }

    @Override
    public boolean canWrite() {
        return this.cmdBool("[ -w \"$__F_\" ]");
    }

    @Override
    public boolean createNewFile() {
        return this.cmdBool("[ ! -e \"$__F_\" ] && touch \"$__F_\"");
    }

    @Override
    public boolean delete() {
        return this.cmdBool("rm -f \"$__F_\" || rmdir -f \"$__F_\"");
    }

    public boolean deleteRecursive() {
        return this.cmdBool("rm -rf \"$__F_\"");
    }

    public boolean clear() {
        return this.cmdBool("echo -n > \"$__F_\"");
    }

    @Override
    public void deleteOnExit() {
        throw new UnsupportedOperationException("Unsupported operation in shell backed File");
    }

    @Override
    public boolean exists() {
        return this.cmdBool("[ -e \"$__F_\" ]");
    }

    @Override
    @NonNull
    public SuFile getAbsoluteFile() {
        return this;
    }

    @Override
    @NonNull
    public String getCanonicalPath() {
        String path = this.cmd("readlink -f \"$__F_\"");
        return path.isEmpty() ? this.getAbsolutePath() : path;
    }

    @Override
    @NonNull
    public SuFile getCanonicalFile() {
        return new SuFile(this.getCanonicalPath());
    }

    @Override
    public SuFile getParentFile() {
        String parent = this.getParent();
        return parent == null ? null : new SuFile(parent);
    }

    private long statFS(String fmt) {
        if (!Env.stat()) {
            return Long.MAX_VALUE;
        }
        String[] res = this.cmd("stat -fc '%S " + fmt + "' \"$__F_\"").split(" ");
        if (res.length != 2) {
            return Long.MAX_VALUE;
        }
        try {
            return Long.parseLong(res[0]) * Long.parseLong(res[1]);
        }
        catch (NumberFormatException e) {
            return Long.MAX_VALUE;
        }
    }

    @Override
    public long getFreeSpace() {
        return this.statFS("%f");
    }

    @Override
    public long getTotalSpace() {
        return this.statFS("%b");
    }

    @Override
    public long getUsableSpace() {
        return this.statFS("%a");
    }

    @Override
    public boolean isDirectory() {
        return this.cmdBool("[ -d \"$__F_\" ]");
    }

    @Override
    public boolean isFile() {
        return this.cmdBool("[ -f \"$__F_\" ]");
    }

    public boolean isBlock() {
        return this.cmdBool("[ -b \"$__F_\" ]");
    }

    public boolean isCharacter() {
        return this.cmdBool("[ -c \"$__F_\" ]");
    }

    public boolean isSymlink() {
        return this.cmdBool("[ -L \"$__F_\" ]");
    }

    @Override
    public long lastModified() {
        try {
            if (!Env.stat()) {
                return 0L;
            }
            return Long.parseLong(this.cmd("stat -c '%Y' \"$__F_\"")) * 1000L;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public long length() {
        try {
            if (Env.stat()) {
                return Long.parseLong(this.cmd("stat -c '%s' \"$__F_\""));
            }
            if (Env.wc()) {
                return Long.parseLong(this.cmd("[ -f \"$__F_\" ] && wc -c < \"$__F_\" || echo 0"));
            }
            return 0L;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public boolean mkdir() {
        return this.cmdBool("mkdir \"$__F_\"");
    }

    @Override
    public boolean mkdirs() {
        return this.cmdBool("mkdir -p \"$__F_\"");
    }

    @Override
    public boolean renameTo(File dest) {
        return this.cmdBool("mv -f \"$__F_\" '" + dest.getAbsolutePath() + "'");
    }

    private boolean setPerms(boolean set, boolean ownerOnly, int b) {
        if (!Env.stat()) {
            return false;
        }
        char[] perms = this.cmd("stat -c '%a' \"$__F_\"").toCharArray();
        for (int i = 0; i < perms.length; ++i) {
            int perm = perms[i] - 48;
            perm = set && (!ownerOnly || i == 0) ? (perm |= b) : (perm &= ~b);
            perms[i] = (char)(perm + 48);
        }
        return this.cmdBool("chmod " + new String(perms) + " \"$__F_\"");
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        return this.setPerms(executable, ownerOnly, 1);
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        return this.setPerms(readable, ownerOnly, 4);
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        return this.setPerms(writable, ownerOnly, 2);
    }

    @Override
    public boolean setReadOnly() {
        return this.setWritable(false, false) && this.setExecutable(false, false);
    }

    @Override
    public boolean setLastModified(long time) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
        String date = df.format(new Date(time));
        return this.cmdBool("[ -e \"$__F_\" ] && touch -t " + date + " \"$__F_\"");
    }

    @Override
    public String[] list() {
        return this.list(null);
    }

    @Override
    public String[] list(FilenameFilter filter) {
        if (!this.isDirectory()) {
            return null;
        }
        FilenameFilter defFilter = (file, name) -> name.equals(".") || name.equals("..");
        List out = Shell.su((String[])this.setCmd("ls -a \"$__F_\"")).to(new LinkedList(), null).exec().getOut();
        ListIterator it = out.listIterator();
        while (it.hasNext()) {
            String name2 = (String)it.next();
            if (filter != null && !filter.accept(this, name2)) {
                it.remove();
                continue;
            }
            if (!defFilter.accept(this, name2)) continue;
            it.remove();
        }
        return out.toArray(new String[0]);
    }

    public SuFile[] listFiles() {
        if (!this.isDirectory()) {
            return null;
        }
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        SuFile[] fs = new SuFile[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = new SuFile(this, ss[i]);
        }
        return fs;
    }

    public SuFile[] listFiles(FilenameFilter filter) {
        if (!this.isDirectory()) {
            return null;
        }
        String[] ss = this.list(filter);
        if (ss == null) {
            return null;
        }
        int n = ss.length;
        SuFile[] fs = new SuFile[n];
        for (int i = 0; i < n; ++i) {
            fs[i] = new SuFile(this, ss[i]);
        }
        return fs;
    }

    public SuFile[] listFiles(FileFilter filter) {
        String[] ss = this.list();
        if (ss == null) {
            return null;
        }
        ArrayList<SuFile> files = new ArrayList<SuFile>();
        for (String s : ss) {
            SuFile f = new SuFile(this, s);
            if (filter != null && !filter.accept(f)) continue;
            files.add(f);
        }
        return files.toArray(new SuFile[0]);
    }
}

