/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.ShellUtils;
import com.topjohnwu.superuser.internal.DataInputImpl;
import com.topjohnwu.superuser.internal.DataOutputImpl;
import com.topjohnwu.superuser.internal.ShellBlockIO;
import com.topjohnwu.superuser.internal.Utils;
import com.topjohnwu.superuser.io.SuFile;
import com.topjohnwu.superuser.io.SuRandomAccessFile;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Locale;

class ShellIO
extends SuRandomAccessFile
implements DataInputImpl,
DataOutputImpl {
    private static final String TAG = "SHELLIO";
    private static final byte[] JUNK = new byte[1];
    private static final FileNotFoundException FNF = new FileNotFoundException("No such file or directory");
    private static final UnsupportedOperationException UOE = new UnsupportedOperationException("Unsupported operation in shell backed I/O");
    private final SuFile file;
    private boolean readOnly;
    boolean eof;
    long fileOff;
    String WRITE_CONV;

    ShellIO(SuFile file, String mode) throws FileNotFoundException {
        this.file = file;
        if (file.isDirectory()) {
            throw FNF;
        }
        this.fileOff = 0L;
        this.WRITE_CONV = "conv=notrunc";
        switch (mode) {
            case "r": {
                if (!file.exists()) {
                    throw FNF;
                }
                this.readOnly = true;
                break;
            }
            case "w": {
                if (file.clear()) break;
                throw FNF;
            }
            case "rw": {
                if (file.exists() || file.createNewFile()) break;
                throw FNF;
            }
        }
    }

    static ShellIO get(SuFile file, String mode) throws FileNotFoundException {
        if (file.isBlock()) {
            return new ShellBlockIO(file, mode);
        }
        return new ShellIO(file, mode);
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readOnly) {
            throw new IOException("File is opened as read-only");
        }
        if (this.fileOff > 0L && this.fileOff < 512L && len > 512) {
            int size = 512 - (int)this.fileOff;
            this.write0(b, off, size);
            len -= size;
            off += size;
        }
        this.write0(b, off, len);
    }

    private void write0(@NonNull byte[] b, int off, int len) throws IOException {
        Shell.getShell().execTask((in, out, err) -> {
            String cmd = this.fileOff == 0L ? String.format(Locale.ROOT, "dd of='%s' bs=%d count=1 %s 2>/dev/null; echo", this.file.getAbsolutePath(), len, this.WRITE_CONV) : String.format(Locale.ROOT, "dd of='%s' ibs=%d count=1 obs=%d seek=1 %s 2>/dev/null; echo", this.file.getAbsolutePath(), len, this.fileOff, this.WRITE_CONV);
            Utils.log((String)TAG, (Object)cmd);
            in.write(cmd.getBytes("UTF-8"));
            in.write(10);
            in.flush();
            in.write(b, off, len);
            in.flush();
            out.read(JUNK);
        });
        this.fileOff += (long)len;
    }

    void streamWrite(byte[] b, int off, int len) throws IOException {
        Shell.getShell().execTask((in, out, err) -> {
            String cmd = String.format(Locale.ROOT, "dd bs=%d count=1 >> '%s' 2>/dev/null; echo", len, this.file.getAbsolutePath());
            Utils.log((String)TAG, (Object)cmd);
            in.write(cmd.getBytes("UTF-8"));
            in.write(10);
            in.flush();
            in.write(b, off, len);
            in.flush();
            out.read(JUNK);
        });
        this.fileOff += (long)len;
    }

    @Override
    public void readFully(@NonNull byte[] b, int off, int len) throws IOException {
        if (this.read(b, off, len) != len) {
            throw new EOFException();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.eof) {
            return -1;
        }
        long gcd = ShellUtils.gcd((long)this.fileOff, (long)len);
        if (gcd >= 512L) {
            len = this.read(b, off, len, this.fileOff, gcd);
        } else {
            long end = (this.fileOff + (long)len + 511L) / 512L * 512L;
            long start = this.fileOff / 512L * 512L;
            byte[] buf = new byte[(int)(end - start)];
            if ((len = Math.min(this.read(buf, 0, buf.length, start, 512L), len)) > 0) {
                System.arraycopy(buf, (int)(this.fileOff - start), b, off, len);
            }
        }
        if (len > 0) {
            this.fileOff += (long)len;
        }
        return len;
    }

    int streamRead(byte[] b) throws IOException {
        int len = this.read(b, 0, b.length, this.fileOff, b.length);
        this.fileOff += (long)len;
        return len;
    }

    int read(byte[] b, int _off, int _len, long fileOff, long bs) throws IOException {
        if (this.eof) {
            return -1;
        }
        Int count = new Int();
        Shell.getShell().execTask((in, out, err) -> {
            int off = _off;
            int len = _len;
            String cmd = String.format(Locale.ROOT, "dd if='%s' ibs=%d skip=%d count=%d obs=%d 2>/dev/null; echo >&2", this.file.getAbsolutePath(), bs, fileOff / bs, (long)len / bs, len);
            Utils.log((String)TAG, (Object)cmd);
            in.write(cmd.getBytes("UTF-8"));
            in.write(10);
            in.flush();
            while (count.i != _len && err.available() == 0 || out.available() != 0) {
                int read = out.read(b, off, out.available());
                off += read;
                len -= read;
                count.i += read;
            }
            err.read(JUNK);
        });
        if (count.i != _len) {
            this.eof = true;
        }
        return count.i;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.fileOff = pos;
    }

    @Override
    public void setLength(long newLength) throws IOException {
        if (newLength == 0L) {
            if (!this.file.clear()) {
                throw new IOException("Cannot clear file");
            }
            return;
        }
        Shell.getShell().execTask((in, out, err) -> {
            String cmd = String.format(Locale.ROOT, "dd of='%s' bs=%d seek=1 count=0 2>/dev/null; echo", this.file.getAbsolutePath(), newLength);
            Utils.log((String)TAG, (Object)cmd);
            in.write(cmd.getBytes("UTF-8"));
            in.write(10);
            in.flush();
            out.read(JUNK);
        });
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public long getFilePointer() {
        return this.fileOff;
    }

    @Override
    public int skipBytes(int n) {
        long skip = Math.min(this.length(), this.fileOff + (long)n) - this.fileOff;
        this.fileOff += skip;
        return (int)skip;
    }

    @Override
    public void close() {
    }

    @Override
    public FileDescriptor getFD() {
        throw UOE;
    }

    @Override
    public FileChannel getChannel() {
        throw UOE;
    }

    private class Int {
        int i;

        private Int() {
        }
    }
}

