/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.io;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.io.SuFile;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class SuRandomAccessFile
implements DataInput,
DataOutput,
Closeable {
    public static SuRandomAccessFile open(File file, String mode) throws FileNotFoundException {
        if (file instanceof SuFile) {
            return IOFactory.createShellFileIO((SuFile)file, mode);
        }
        try {
            return IOFactory.createRandomAccessFileWrapper(file, mode);
        }
        catch (FileNotFoundException e) {
            return IOFactory.createShellFileIO(new SuFile(file), mode);
        }
    }

    public static SuRandomAccessFile open(String path, String mode) throws FileNotFoundException {
        return SuRandomAccessFile.open(new File(path), mode);
    }

    @Override
    public void readFully(@NonNull byte[] b, int off, int len) throws IOException {
        if (this.read(b, off, len) != len) {
            throw new EOFException();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        try {
            this.readFully(b);
        }
        catch (EOFException e) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public abstract void seek(long var1) throws IOException;

    public abstract void setLength(long var1) throws IOException;

    public abstract long length() throws IOException;

    public abstract long getFilePointer() throws IOException;
}

