/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import androidx.annotation.NonNull;
import com.topjohnwu.superuser.internal.ShellFileIO;
import com.topjohnwu.superuser.io.SuFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class ShellInputStream
extends InputStream {
    private ShellFileIO io;
    private byte[] buf;
    private int count;
    private int bufOff;

    ShellInputStream(SuFile file) throws FileNotFoundException {
        this.io = new ShellFileIO(file, "r");
        this.buf = new byte[0x400000];
        this.count = 0;
        this.bufOff = 0;
    }

    private boolean fillBuffer() throws IOException {
        this.bufOff = 0;
        this.count = this.io.read(this.buf);
        return this.count > 0;
    }

    @Override
    public int read() throws IOException {
        if (this.count < 0) {
            return -1;
        }
        if (this.bufOff >= this.count && !this.fillBuffer()) {
            return -1;
        }
        return this.buf[this.bufOff++] & 0xFF;
    }

    @Override
    public int read(@NonNull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NonNull byte[] b, int off, int len) throws IOException {
        int n;
        int size;
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.count < 0) {
            return -1;
        }
        for (n = 0; n < len; n += size) {
            if (this.bufOff >= this.count && !this.fillBuffer()) {
                return n == 0 ? -1 : n;
            }
            size = Math.min(this.count - this.bufOff, len - n);
            System.arraycopy(this.buf, this.bufOff, b, off + n, size);
            this.bufOff += size;
        }
        return n;
    }
}

