/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.ShellUtils;
import com.topjohnwu.superuser.internal.DataInputImpl;
import com.topjohnwu.superuser.internal.DataOutputImpl;
import com.topjohnwu.superuser.internal.InternalUtils;
import com.topjohnwu.superuser.io.SuFile;
import com.topjohnwu.superuser.io.SuRandomAccessFile;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;

class ShellFileIO
extends SuRandomAccessFile
implements DataInputImpl,
DataOutputImpl {
    private static final String TAG = "SHELLIO";
    private String path;
    private long fileOff;
    private long fileSize;

    ShellFileIO(SuFile file, String mode) throws FileNotFoundException {
        if (file.isCharacter()) {
            throw new FileNotFoundException("Does not support character files");
        }
        FileNotFoundException fnf = new FileNotFoundException("No such file or directory");
        if (file.isDirectory()) {
            throw fnf;
        }
        this.path = file.getPath();
        this.fileOff = 0L;
        if (TextUtils.equals((CharSequence)mode, (CharSequence)"r")) {
            if (!file.exists()) {
                throw fnf;
            }
            this.fileSize = file.length();
        } else if (TextUtils.equals((CharSequence)mode, (CharSequence)"w")) {
            if (!file.clear()) {
                throw fnf;
            }
            this.fileSize = 0L;
        } else if (TextUtils.equals((CharSequence)mode, (CharSequence)"rw")) {
            if (!file.exists() && !file.createNewFile()) {
                throw fnf;
            }
            this.fileSize = file.length();
        } else {
            throw new IllegalArgumentException("Illegal mode: " + mode);
        }
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        Shell.getShell().execTask((in, out, err) -> {
            String cmd = String.format(Locale.ROOT, "busybox dd of='%s' obs=%d seek=%d ibs=%d count=1 conv=notrunc 2>/dev/null; echo done", this.path, this.fileOff == 0L ? (long)len : this.fileOff, this.fileOff == 0L ? 0 : 1, len);
            InternalUtils.log((String)TAG, (Object)cmd);
            in.write(cmd.getBytes("UTF-8"));
            in.write(10);
            in.flush();
            in.write(b, off, len);
            in.flush();
            DataInputStream dis = new DataInputStream(out);
            dis.readFully(new byte[5]);
        });
        this.fileOff += (long)len;
        this.fileSize = Math.max(this.fileSize, this.fileOff);
    }

    void append(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        Shell.getShell().execTask((in, out, err) -> {
            String cmd = String.format(Locale.ROOT, "dd bs=%d count=1 >> '%s' 2>/dev/null; echo done", len, this.path);
            InternalUtils.log((String)TAG, (Object)cmd);
            in.write(cmd.getBytes("UTF-8"));
            in.write(10);
            in.flush();
            in.write(b, off, len);
            in.flush();
            DataInputStream dis = new DataInputStream(out);
            dis.readFully(new byte[5]);
        });
        this.fileSize += (long)len;
        this.fileOff = this.fileSize;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int actualLen = (int)Math.min((long)len, this.fileSize - this.fileOff);
        if (actualLen <= 0) {
            return -1;
        }
        long gcd = ShellUtils.gcd((long)this.fileOff, (long)actualLen);
        if (gcd >= 512L) {
            this.readBlocks(b, off, actualLen, this.fileOff, gcd);
        } else {
            long start = this.fileOff / 512L * 512L;
            long end = Math.min((this.fileOff + (long)len + 511L) / 512L * 512L, this.fileSize);
            int startOff = (int)(this.fileOff - start);
            int readLen = (int)(end - start);
            byte[] buf = new byte[readLen];
            this.readBlocks(buf, 0, readLen, start, 512L);
            System.arraycopy(buf, startOff, b, off, actualLen);
        }
        this.fileOff += (long)actualLen;
        return actualLen;
    }

    private void readBlocks(byte[] b, int off, int len, long fileOff, long bs) throws IOException {
        Shell.getShell().execTask((in, out, err) -> {
            String cmd = String.format(Locale.ROOT, "dd if='%s' ibs=%d skip=%d count=%d obs=%d 2>/dev/null", this.path, bs, fileOff / bs, ((long)len + bs - 1L) / bs, len);
            InternalUtils.log((String)TAG, (Object)cmd);
            in.write(cmd.getBytes("UTF-8"));
            in.write(10);
            in.flush();
            DataInputStream dis = new DataInputStream(out);
            dis.readFully(b, off, len);
        });
    }

    @Override
    public void seek(long pos) {
        this.fileOff = pos;
    }

    @Override
    public void setLength(long newLength) throws IOException {
        Shell.getShell().execTask((in, out, err) -> {
            String cmd = String.format(Locale.ROOT, "dd if=/dev/null of='%s' bs=%d seek=%d 2>/dev/null; echo done", this.path, newLength == 0L ? 1L : newLength, newLength == 0L ? 0 : 1);
            InternalUtils.log((String)TAG, (Object)cmd);
            in.write(cmd.getBytes("UTF-8"));
            in.write(10);
            in.flush();
            DataInputStream dis = new DataInputStream(out);
            dis.readFully(new byte[5]);
        });
        this.fileSize = newLength;
    }

    @Override
    public long length() {
        return this.fileSize;
    }

    @Override
    public long getFilePointer() {
        return this.fileOff;
    }

    @Override
    public int skipBytes(int n) {
        long skip = Math.min(this.fileSize, this.fileOff + (long)n) - this.fileOff;
        this.fileOff += skip;
        return (int)skip;
    }

    @Override
    public void close() {
    }
}

