/*
 * Decompiled with CFR 0.152.
 */
package com.github.topbottomsnackbar;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.design.R;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.SwipeDismissBehavior;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.support.v4.view.WindowInsetsCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.github.topbottomsnackbar.AnimationUtils;
import com.github.topbottomsnackbar.R;
import com.github.topbottomsnackbar.TBSnackbarManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class TBSnackbar {
    public static final int LENGTH_INDEFINITE = -2;
    public static final int LENGTH_SHORT = -1;
    public static final int LENGTH_LONG = 0;
    public static final int STYLE_SHOW_TOP = 1;
    public static final int STYLE_SHOW_BOTTOM = 2;
    public static final int STYLE_SHOW_TOP_FITSYSTEMWINDOW = 3;
    static final int ANIMATION_DURATION = 250;
    static final int ANIMATION_FADE_DURATION = 180;
    static final Handler sHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    ((TBSnackbar)message.obj).showView();
                    return true;
                }
                case 1: {
                    ((TBSnackbar)message.obj).hideView(message.arg1);
                    return true;
                }
            }
            return false;
        }
    });
    static final int MSG_SHOW = 0;
    static final int MSG_DISMISS = 1;
    private final ViewGroup mTargetParent;
    private final Context mContext;
    final SnackbarLayout mView;
    private int mDuration;
    private Callback mCallback;
    private int mStyle = 2;
    private final AccessibilityManager mAccessibilityManager;
    final TBSnackbarManager.Callback mManagerCallback = new TBSnackbarManager.Callback(){

        @Override
        public void show() {
            sHandler.sendMessage(sHandler.obtainMessage(0, (Object)TBSnackbar.this));
        }

        @Override
        public void dismiss(int event) {
            sHandler.sendMessage(sHandler.obtainMessage(1, event, 0, (Object)TBSnackbar.this));
        }
    };

    private TBSnackbar(ViewGroup parent) {
        this.mTargetParent = parent;
        this.mContext = parent.getContext();
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        this.mView = (SnackbarLayout)inflater.inflate(R.layout.design_layout_snackbar, this.mTargetParent, false);
        this.mAccessibilityManager = (AccessibilityManager)this.mContext.getSystemService("accessibility");
    }

    private static int getStatusBarHeight(Context context) {
        int result = 0;
        int resId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resId > 0) {
            result = context.getResources().getDimensionPixelOffset(resId);
        }
        return result;
    }

    private void changeLayoutParams(int gravity) {
        if (this.mTargetParent instanceof CoordinatorLayout) {
            CoordinatorLayout.LayoutParams layoutParams = (CoordinatorLayout.LayoutParams)this.mView.getLayoutParams();
            layoutParams.gravity = gravity;
            this.mView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else if (this.mTargetParent instanceof FrameLayout) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mView.getLayoutParams();
            layoutParams.gravity = gravity;
            this.mView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    @Deprecated
    private TBSnackbar addIcon(int resource_id, int size) {
        TextView tv = this.mView.getMessageView();
        tv.setCompoundDrawablesWithIntrinsicBounds((Drawable)new BitmapDrawable(Bitmap.createScaledBitmap((Bitmap)((BitmapDrawable)this.mContext.getResources().getDrawable(resource_id)).getBitmap(), (int)size, (int)size, (boolean)true)), null, null, null);
        return this;
    }

    public TBSnackbar setIconPadding(int padding) {
        TextView tv = this.mView.getMessageView();
        tv.setCompoundDrawablePadding(padding);
        return this;
    }

    public TBSnackbar setIconLeft(@DrawableRes int drawableRes, float sizeDp) {
        TextView tv = this.mView.getMessageView();
        Drawable drawable = ContextCompat.getDrawable((Context)this.mContext, (int)drawableRes);
        if (drawable == null) {
            throw new IllegalArgumentException("resource_id is not a valid drawable!");
        }
        drawable = this.fitDrawable(drawable, (int)TBSnackbar.convertDpToPixel(sizeDp, this.mContext));
        Drawable[] compoundDrawables = tv.getCompoundDrawables();
        tv.setCompoundDrawables(drawable, compoundDrawables[1], compoundDrawables[2], compoundDrawables[3]);
        return this;
    }

    public TBSnackbar setIconRight(@DrawableRes int drawableRes, float sizeDp) {
        TextView tv = this.mView.getMessageView();
        Drawable drawable = ContextCompat.getDrawable((Context)this.mContext, (int)drawableRes);
        if (drawable == null) {
            throw new IllegalArgumentException("resource_id is not a valid drawable!");
        }
        drawable = this.fitDrawable(drawable, (int)TBSnackbar.convertDpToPixel(sizeDp, this.mContext));
        Drawable[] compoundDrawables = tv.getCompoundDrawables();
        tv.setCompoundDrawables(compoundDrawables[0], compoundDrawables[1], drawable, compoundDrawables[3]);
        return this;
    }

    public TBSnackbar setMaxWidth(int maxWidth) {
        this.mView.mMaxWidth = maxWidth;
        return this;
    }

    private Drawable fitDrawable(Drawable drawable, int sizePx) {
        if ((drawable.getIntrinsicWidth() != sizePx || drawable.getIntrinsicHeight() != sizePx) && drawable instanceof BitmapDrawable) {
            drawable = new BitmapDrawable(this.mContext.getResources(), Bitmap.createScaledBitmap((Bitmap)TBSnackbar.getBitmap(drawable), (int)sizePx, (int)sizePx, (boolean)true));
        }
        drawable.setBounds(0, 0, sizePx, sizePx);
        return drawable;
    }

    private static float convertDpToPixel(float dp, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    @TargetApi(value=21)
    private static Bitmap getBitmap(VectorDrawable vectorDrawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)vectorDrawable.getIntrinsicWidth(), (int)vectorDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        vectorDrawable.draw(canvas);
        return bitmap;
    }

    private static Bitmap getBitmap(Drawable drawable) {
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        if (drawable instanceof VectorDrawable) {
            return TBSnackbar.getBitmap((VectorDrawable)drawable);
        }
        throw new IllegalArgumentException("unsupported drawable type");
    }

    @NonNull
    public static TBSnackbar make(@NonNull View view, @NonNull CharSequence text, int duration, int style) {
        TBSnackbar tbSnackbar = new TBSnackbar(TBSnackbar.findSuitableParent(view));
        tbSnackbar.mStyle = style;
        tbSnackbar.setText(text);
        tbSnackbar.setDuration(duration);
        return tbSnackbar;
    }

    @NonNull
    public static TBSnackbar make(@NonNull View view, @StringRes int resId, int duration, int style) {
        return TBSnackbar.make(view, view.getResources().getText(resId), duration, style);
    }

    private static ViewGroup findSuitableParent(View view) {
        ViewGroup fallback = null;
        do {
            if (view instanceof CoordinatorLayout) {
                return (ViewGroup)view;
            }
            if (view instanceof FrameLayout) {
                if (view.getId() == 0x1020002) {
                    return (ViewGroup)view;
                }
                fallback = (ViewGroup)view;
            }
            if (view == null) continue;
            ViewParent parent = view.getParent();
            View view2 = view = parent instanceof View ? (View)parent : null;
        } while (view != null);
        return fallback;
    }

    @NonNull
    public TBSnackbar setAction(@StringRes int resId, View.OnClickListener listener) {
        return this.setAction(this.mContext.getText(resId), listener);
    }

    @NonNull
    public TBSnackbar setAction(CharSequence text, final View.OnClickListener listener) {
        Button tv = this.mView.getActionView();
        if (TextUtils.isEmpty((CharSequence)text) || listener == null) {
            tv.setVisibility(8);
            tv.setOnClickListener(null);
        } else {
            tv.setVisibility(0);
            tv.setText(text);
            tv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    listener.onClick(view);
                    TBSnackbar.this.dispatchDismiss(1);
                }
            });
        }
        return this;
    }

    @NonNull
    public TBSnackbar setActionTextColor(ColorStateList colors) {
        Button tv = this.mView.getActionView();
        tv.setTextColor(colors);
        return this;
    }

    @NonNull
    public TBSnackbar setActionTextColor(@ColorInt int color) {
        Button tv = this.mView.getActionView();
        tv.setTextColor(color);
        return this;
    }

    @NonNull
    public TBSnackbar setText(@NonNull CharSequence message) {
        TextView tv = this.mView.getMessageView();
        tv.setText(message);
        return this;
    }

    @NonNull
    public TBSnackbar setText(@StringRes int resId) {
        return this.setText(this.mContext.getText(resId));
    }

    @NonNull
    public TBSnackbar setDuration(int duration) {
        this.mDuration = duration;
        return this;
    }

    public int getDuration() {
        return this.mDuration;
    }

    @NonNull
    public View getView() {
        return this.mView;
    }

    public void show() {
        if (this.mStyle == 2) {
            this.changeLayoutParams(80);
        } else {
            this.changeLayoutParams(48);
            if (this.mStyle == 3 && Build.VERSION.SDK_INT >= 19) {
                this.mView.setPadding(0, TBSnackbar.getStatusBarHeight(this.mContext), 0, 0);
            }
        }
        TBSnackbarManager.getInstance().show(this.mDuration, this.mManagerCallback);
    }

    public void dismiss() {
        this.dispatchDismiss(3);
    }

    void dispatchDismiss(int event) {
        TBSnackbarManager.getInstance().dismiss(this.mManagerCallback, event);
    }

    @NonNull
    public TBSnackbar setCallback(Callback callback) {
        this.mCallback = callback;
        return this;
    }

    public boolean isShown() {
        return TBSnackbarManager.getInstance().isCurrent(this.mManagerCallback);
    }

    public boolean isShownOrQueued() {
        return TBSnackbarManager.getInstance().isCurrentOrNext(this.mManagerCallback);
    }

    final void showView() {
        if (this.mView.getParent() == null) {
            ViewGroup.LayoutParams lp = this.mView.getLayoutParams();
            if (lp instanceof CoordinatorLayout.LayoutParams && this.mStyle == 2) {
                CoordinatorLayout.LayoutParams clp = (CoordinatorLayout.LayoutParams)lp;
                Behavior behavior = new Behavior();
                behavior.setStartAlphaSwipeDistance(0.1f);
                behavior.setEndAlphaSwipeDistance(0.6f);
                behavior.setSwipeDirection(0);
                behavior.setListener(new SwipeDismissBehavior.OnDismissListener(){

                    public void onDismiss(View view) {
                        view.setVisibility(8);
                        TBSnackbar.this.dispatchDismiss(0);
                    }

                    public void onDragStateChanged(int state) {
                        switch (state) {
                            case 1: 
                            case 2: {
                                TBSnackbarManager.getInstance().cancelTimeout(TBSnackbar.this.mManagerCallback);
                                break;
                            }
                            case 0: {
                                TBSnackbarManager.getInstance().restoreTimeout(TBSnackbar.this.mManagerCallback);
                            }
                        }
                    }
                });
                clp.setBehavior((CoordinatorLayout.Behavior)behavior);
                clp.insetEdge = 80;
            }
            this.mTargetParent.addView((View)this.mView);
        }
        this.mView.setOnAttachStateChangeListener(new SnackbarLayout.OnAttachStateChangeListener(){

            @Override
            public void onViewAttachedToWindow(View v) {
            }

            @Override
            public void onViewDetachedFromWindow(View v) {
                if (TBSnackbar.this.isShownOrQueued()) {
                    sHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            TBSnackbar.this.onViewHidden(3);
                        }
                    });
                }
            }
        });
        if (ViewCompat.isLaidOut((View)this.mView)) {
            if (this.shouldAnimate()) {
                this.animateViewIn();
            } else {
                this.onViewShown();
            }
        } else {
            this.mView.setOnLayoutChangeListener(new SnackbarLayout.OnLayoutChangeListener(){

                @Override
                public void onLayoutChange(View view, int left, int top, int right, int bottom) {
                    TBSnackbar.this.mView.setOnLayoutChangeListener(null);
                    if (TBSnackbar.this.shouldAnimate()) {
                        TBSnackbar.this.animateViewIn();
                    } else {
                        TBSnackbar.this.onViewShown();
                    }
                }
            });
        }
    }

    void animateViewIn() {
        if (Build.VERSION.SDK_INT >= 14) {
            if (this.mStyle == 2) {
                this.in(this.mView.getHeight());
            } else {
                this.in(-this.mView.getHeight());
            }
        } else if (this.mStyle == 2) {
            this.in2(R.anim.design_snackbar_in);
        } else {
            this.in2(R.anim.top_in);
        }
    }

    private void in2(int animId) {
        Animation anim2 = android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)animId);
        anim2.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        anim2.setDuration(250L);
        anim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                TBSnackbar.this.onViewShown();
            }

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mView.startAnimation(anim2);
    }

    private void in(int height) {
        ViewCompat.setTranslationY((View)this.mView, (float)height);
        ViewCompat.animate((View)this.mView).translationY(0.0f).setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR).setDuration(250L).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationStart(View view) {
                TBSnackbar.this.mView.animateChildrenIn(70, 180);
            }

            public void onAnimationEnd(View view) {
                TBSnackbar.this.onViewShown();
            }
        }).start();
    }

    private void animateViewOut(int event) {
        if (Build.VERSION.SDK_INT >= 14) {
            if (this.mStyle == 2) {
                this.out(event, this.mView.getHeight());
            } else {
                this.out(event, -this.mView.getHeight());
            }
        } else if (this.mStyle == 2) {
            this.out2(event, R.anim.design_snackbar_out);
        } else {
            this.out2(event, R.anim.top_out);
        }
    }

    private void out2(final int event, int animId) {
        Animation anim2 = android.view.animation.AnimationUtils.loadAnimation((Context)this.mView.getContext(), (int)animId);
        anim2.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        anim2.setDuration(250L);
        anim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                TBSnackbar.this.onViewHidden(event);
            }

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mView.startAnimation(anim2);
    }

    private void out(final int event, int height) {
        ViewCompat.animate((View)this.mView).translationY((float)height).setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR).setDuration(250L).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationStart(View view) {
                TBSnackbar.this.mView.animateChildrenOut(0, 180);
            }

            public void onAnimationEnd(View view) {
                TBSnackbar.this.onViewHidden(event);
            }
        }).start();
    }

    final void hideView(int event) {
        if (this.shouldAnimate() && this.mView.getVisibility() == 0) {
            this.animateViewOut(event);
        } else {
            this.onViewHidden(event);
        }
    }

    void onViewShown() {
        TBSnackbarManager.getInstance().onShown(this.mManagerCallback);
        if (this.mCallback != null) {
            this.mCallback.onShown(this);
        }
    }

    void onViewHidden(int event) {
        ViewParent parent;
        TBSnackbarManager.getInstance().onDismissed(this.mManagerCallback);
        if (this.mCallback != null) {
            this.mCallback.onDismissed(this, event);
        }
        if (Build.VERSION.SDK_INT < 11) {
            this.mView.setVisibility(8);
        }
        if ((parent = this.mView.getParent()) instanceof ViewGroup) {
            ((ViewGroup)parent).removeView((View)this.mView);
        }
    }

    boolean shouldAnimate() {
        return !this.mAccessibilityManager.isEnabled();
    }

    final class Behavior
    extends SwipeDismissBehavior<SnackbarLayout> {
        Behavior() {
        }

        public boolean canSwipeDismissView(View child) {
            return child instanceof SnackbarLayout;
        }

        public boolean onInterceptTouchEvent(CoordinatorLayout parent, SnackbarLayout child, MotionEvent event) {
            if (parent.isPointInChildBounds((View)child, (int)event.getX(), (int)event.getY())) {
                switch (event.getActionMasked()) {
                    case 0: {
                        TBSnackbarManager.getInstance().cancelTimeout(TBSnackbar.this.mManagerCallback);
                        break;
                    }
                    case 1: 
                    case 3: {
                        TBSnackbarManager.getInstance().restoreTimeout(TBSnackbar.this.mManagerCallback);
                    }
                }
            }
            return super.onInterceptTouchEvent(parent, (View)child, event);
        }
    }

    public static class SnackbarLayout
    extends LinearLayout {
        private TextView mMessageView;
        private Button mActionView;
        private int mMaxWidth;
        private int mMaxInlineActionWidth;
        private OnLayoutChangeListener mOnLayoutChangeListener;
        private OnAttachStateChangeListener mOnAttachStateChangeListener;

        public SnackbarLayout(Context context) {
            this(context, null);
        }

        public SnackbarLayout(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SnackbarLayout);
            this.mMaxWidth = a.getDimensionPixelSize(R.styleable.SnackbarLayout_android_maxWidth, -1);
            this.mMaxInlineActionWidth = a.getDimensionPixelSize(R.styleable.SnackbarLayout_maxActionInlineWidth, -1);
            if (a.hasValue(R.styleable.SnackbarLayout_elevation)) {
                ViewCompat.setElevation((View)this, (float)a.getDimensionPixelSize(R.styleable.SnackbarLayout_elevation, 0));
            }
            a.recycle();
            this.setClickable(true);
            LayoutInflater.from((Context)context).inflate(R.layout.design_layout_snackbar_include, (ViewGroup)this);
            ViewCompat.setAccessibilityLiveRegion((View)this, (int)1);
            ViewCompat.setImportantForAccessibility((View)this, (int)1);
            ViewCompat.setFitsSystemWindows((View)this, (boolean)true);
            ViewCompat.setOnApplyWindowInsetsListener((View)this, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

                public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                    v.setPadding(v.getPaddingLeft(), v.getPaddingTop(), v.getPaddingRight(), insets.getSystemWindowInsetBottom());
                    return insets;
                }
            });
        }

        protected void onFinishInflate() {
            super.onFinishInflate();
            this.mMessageView = (TextView)this.findViewById(R.id.snackbar_text);
            this.mActionView = (Button)this.findViewById(R.id.snackbar_action);
        }

        TextView getMessageView() {
            return this.mMessageView;
        }

        Button getActionView() {
            return this.mActionView;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (this.mMaxWidth > 0 && this.getMeasuredWidth() > this.mMaxWidth) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxWidth, (int)0x40000000);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
            int multiLineVPadding = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical_2lines);
            int singleLineVPadding = this.getResources().getDimensionPixelSize(R.dimen.design_snackbar_padding_vertical);
            boolean isMultiLine = this.mMessageView.getLayout().getLineCount() > 1;
            boolean remeasure = false;
            if (isMultiLine && this.mMaxInlineActionWidth > 0 && this.mActionView.getMeasuredWidth() > this.mMaxInlineActionWidth) {
                if (this.updateViewsWithinLayout(1, multiLineVPadding, multiLineVPadding - singleLineVPadding)) {
                    remeasure = true;
                }
            } else {
                int messagePadding;
                int n = messagePadding = isMultiLine ? multiLineVPadding : singleLineVPadding;
                if (this.updateViewsWithinLayout(0, messagePadding, messagePadding)) {
                    remeasure = true;
                }
            }
            if (remeasure) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }

        void animateChildrenIn(int delay, int duration) {
            ViewCompat.setAlpha((View)this.mMessageView, (float)0.0f);
            ViewCompat.animate((View)this.mMessageView).alpha(1.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            if (this.mActionView.getVisibility() == 0) {
                ViewCompat.setAlpha((View)this.mActionView, (float)0.0f);
                ViewCompat.animate((View)this.mActionView).alpha(1.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            }
        }

        void animateChildrenOut(int delay, int duration) {
            ViewCompat.setAlpha((View)this.mMessageView, (float)1.0f);
            ViewCompat.animate((View)this.mMessageView).alpha(0.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            if (this.mActionView.getVisibility() == 0) {
                ViewCompat.setAlpha((View)this.mActionView, (float)1.0f);
                ViewCompat.animate((View)this.mActionView).alpha(0.0f).setDuration((long)duration).setStartDelay((long)delay).start();
            }
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            if (this.mOnLayoutChangeListener != null) {
                this.mOnLayoutChangeListener.onLayoutChange((View)this, l, t, r, b);
            }
        }

        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            if (this.mOnAttachStateChangeListener != null) {
                this.mOnAttachStateChangeListener.onViewAttachedToWindow((View)this);
            }
            ViewCompat.requestApplyInsets((View)this);
        }

        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            if (this.mOnAttachStateChangeListener != null) {
                this.mOnAttachStateChangeListener.onViewDetachedFromWindow((View)this);
            }
        }

        void setOnLayoutChangeListener(OnLayoutChangeListener onLayoutChangeListener) {
            this.mOnLayoutChangeListener = onLayoutChangeListener;
        }

        void setOnAttachStateChangeListener(OnAttachStateChangeListener listener) {
            this.mOnAttachStateChangeListener = listener;
        }

        private boolean updateViewsWithinLayout(int orientation, int messagePadTop, int messagePadBottom) {
            boolean changed = false;
            if (orientation != this.getOrientation()) {
                this.setOrientation(orientation);
                changed = true;
            }
            if (this.mMessageView.getPaddingTop() != messagePadTop || this.mMessageView.getPaddingBottom() != messagePadBottom) {
                SnackbarLayout.updateTopBottomPadding((View)this.mMessageView, messagePadTop, messagePadBottom);
                changed = true;
            }
            return changed;
        }

        private static void updateTopBottomPadding(View view, int topPadding, int bottomPadding) {
            if (ViewCompat.isPaddingRelative((View)view)) {
                ViewCompat.setPaddingRelative((View)view, (int)ViewCompat.getPaddingStart((View)view), (int)topPadding, (int)ViewCompat.getPaddingEnd((View)view), (int)bottomPadding);
            } else {
                view.setPadding(view.getPaddingLeft(), topPadding, view.getPaddingRight(), bottomPadding);
            }
        }

        static interface OnAttachStateChangeListener {
            public void onViewAttachedToWindow(View var1);

            public void onViewDetachedFromWindow(View var1);
        }

        static interface OnLayoutChangeListener {
            public void onLayoutChange(View var1, int var2, int var3, int var4, int var5);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntRange(from=1L)
    public static @interface Style {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntRange(from=1L)
    public static @interface Duration {
    }

    public static abstract class Callback {
        public static final int DISMISS_EVENT_SWIPE = 0;
        public static final int DISMISS_EVENT_ACTION = 1;
        public static final int DISMISS_EVENT_TIMEOUT = 2;
        public static final int DISMISS_EVENT_MANUAL = 3;
        public static final int DISMISS_EVENT_CONSECUTIVE = 4;

        public void onDismissed(TBSnackbar TBSnackbar2, int event) {
        }

        public void onShown(TBSnackbar TBSnackbar2) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DismissEvent {
        }
    }
}

