/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.database;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.tonyodev.fetch2.EnqueueAction;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Priority;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.Converter;
import com.tonyodev.fetch2.database.DownloadDao;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2core.Extras;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class DownloadDao_Impl
implements DownloadDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<DownloadInfo> __insertionAdapterOfDownloadInfo;
    private final Converter __converter = new Converter();
    private final EntityDeletionOrUpdateAdapter<DownloadInfo> __deletionAdapterOfDownloadInfo;
    private final EntityDeletionOrUpdateAdapter<DownloadInfo> __updateAdapterOfDownloadInfo;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public DownloadDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfDownloadInfo = new EntityInsertionAdapter<DownloadInfo>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `requests` (`_id`,`_namespace`,`_url`,`_file`,`_group`,`_priority`,`_headers`,`_written_bytes`,`_total_bytes`,`_status`,`_error`,`_network_type`,`_created`,`_tag`,`_enqueue_action`,`_identifier`,`_download_on_enqueue`,`_extras`,`_auto_retry_max_attempts`,`_auto_retry_attempts`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, DownloadInfo value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getNamespace() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getNamespace());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUrl());
                }
                if (value.getFile() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getFile());
                }
                stmt.bindLong(5, (long)value.getGroup());
                int _tmp = DownloadDao_Impl.this.__converter.toPriorityValue(value.getPriority());
                stmt.bindLong(6, (long)_tmp);
                String _tmp_1 = DownloadDao_Impl.this.__converter.toHeaderStringsMap(value.getHeaders());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                stmt.bindLong(8, value.getDownloaded());
                stmt.bindLong(9, value.getTotal());
                int _tmp_2 = DownloadDao_Impl.this.__converter.toStatusValue(value.getStatus());
                stmt.bindLong(10, (long)_tmp_2);
                int _tmp_3 = DownloadDao_Impl.this.__converter.toErrorValue(value.getError());
                stmt.bindLong(11, (long)_tmp_3);
                int _tmp_4 = DownloadDao_Impl.this.__converter.toNetworkTypeValue(value.getNetworkType());
                stmt.bindLong(12, (long)_tmp_4);
                stmt.bindLong(13, value.getCreated());
                if (value.getTag() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getTag());
                }
                int _tmp_5 = DownloadDao_Impl.this.__converter.toEnqueueActionValue(value.getEnqueueAction());
                stmt.bindLong(15, (long)_tmp_5);
                stmt.bindLong(16, value.getIdentifier());
                int _tmp_6 = value.getDownloadOnEnqueue() ? 1 : 0;
                stmt.bindLong(17, (long)_tmp_6);
                String _tmp_7 = DownloadDao_Impl.this.__converter.fromExtrasToString(value.getExtras());
                if (_tmp_7 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_7);
                }
                stmt.bindLong(19, (long)value.getAutoRetryMaxAttempts());
                stmt.bindLong(20, (long)value.getAutoRetryAttempts());
            }
        };
        this.__deletionAdapterOfDownloadInfo = new EntityDeletionOrUpdateAdapter<DownloadInfo>(__db){

            public String createQuery() {
                return "DELETE FROM `requests` WHERE `_id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, DownloadInfo value) {
                stmt.bindLong(1, (long)value.getId());
            }
        };
        this.__updateAdapterOfDownloadInfo = new EntityDeletionOrUpdateAdapter<DownloadInfo>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `requests` SET `_id` = ?,`_namespace` = ?,`_url` = ?,`_file` = ?,`_group` = ?,`_priority` = ?,`_headers` = ?,`_written_bytes` = ?,`_total_bytes` = ?,`_status` = ?,`_error` = ?,`_network_type` = ?,`_created` = ?,`_tag` = ?,`_enqueue_action` = ?,`_identifier` = ?,`_download_on_enqueue` = ?,`_extras` = ?,`_auto_retry_max_attempts` = ?,`_auto_retry_attempts` = ? WHERE `_id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, DownloadInfo value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getNamespace() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getNamespace());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUrl());
                }
                if (value.getFile() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getFile());
                }
                stmt.bindLong(5, (long)value.getGroup());
                int _tmp = DownloadDao_Impl.this.__converter.toPriorityValue(value.getPriority());
                stmt.bindLong(6, (long)_tmp);
                String _tmp_1 = DownloadDao_Impl.this.__converter.toHeaderStringsMap(value.getHeaders());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                stmt.bindLong(8, value.getDownloaded());
                stmt.bindLong(9, value.getTotal());
                int _tmp_2 = DownloadDao_Impl.this.__converter.toStatusValue(value.getStatus());
                stmt.bindLong(10, (long)_tmp_2);
                int _tmp_3 = DownloadDao_Impl.this.__converter.toErrorValue(value.getError());
                stmt.bindLong(11, (long)_tmp_3);
                int _tmp_4 = DownloadDao_Impl.this.__converter.toNetworkTypeValue(value.getNetworkType());
                stmt.bindLong(12, (long)_tmp_4);
                stmt.bindLong(13, value.getCreated());
                if (value.getTag() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getTag());
                }
                int _tmp_5 = DownloadDao_Impl.this.__converter.toEnqueueActionValue(value.getEnqueueAction());
                stmt.bindLong(15, (long)_tmp_5);
                stmt.bindLong(16, value.getIdentifier());
                int _tmp_6 = value.getDownloadOnEnqueue() ? 1 : 0;
                stmt.bindLong(17, (long)_tmp_6);
                String _tmp_7 = DownloadDao_Impl.this.__converter.fromExtrasToString(value.getExtras());
                if (_tmp_7 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_7);
                }
                stmt.bindLong(19, (long)value.getAutoRetryMaxAttempts());
                stmt.bindLong(20, (long)value.getAutoRetryAttempts());
                stmt.bindLong(21, (long)value.getId());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM requests";
                return "DELETE FROM requests";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(DownloadInfo downloadInfo2) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfDownloadInfo.insertAndReturnId((Object)downloadInfo2);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> insert(List<? extends DownloadInfo> downloadInfoList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            List _result = this.__insertionAdapterOfDownloadInfo.insertAndReturnIdsList(downloadInfoList);
            this.__db.setTransactionSuccessful();
            List list = _result;
            return list;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(DownloadInfo downloadInfo2) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfDownloadInfo.handle((Object)downloadInfo2);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends DownloadInfo> downloadInfoList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfDownloadInfo.handleMultiple(downloadInfoList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(DownloadInfo download) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfDownloadInfo.handle((Object)download);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(List<? extends DownloadInfo> downloadInfoList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfDownloadInfo.handleMultiple(downloadInfoList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> get() {
        String _sql = "SELECT * FROM requests";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_namespace");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_url");
            int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_file");
            int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_group");
            int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_priority");
            int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_headers");
            int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_written_bytes");
            int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_total_bytes");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_status");
            int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_error");
            int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_network_type");
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_created");
            int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_tag");
            int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_enqueue_action");
            int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_identifier");
            int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_download_on_enqueue");
            int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_extras");
            int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_max_attempts");
            int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_attempts");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item.setGroup(_tmpGroup);
                int _tmp = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp);
                _item.setPriority(_tmpPriority);
                String _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_1);
                _item.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item.setTotal(_tmpTotal);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_2);
                _item.setStatus(_tmpStatus);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_3);
                _item.setError(_tmpError);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_4);
                _item.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item.setTag(_tmpTag);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_5);
                _item.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_6 != 0;
                _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_7);
                _item.setExtras(_tmpExtras);
                int _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
                _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
                int _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
                _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
                _result.add(_item);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadInfo get(int id) {
        String _sql = "SELECT * FROM requests WHERE _id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)id);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            DownloadInfo _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_namespace");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_url");
            int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_file");
            int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_group");
            int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_priority");
            int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_headers");
            int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_written_bytes");
            int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_total_bytes");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_status");
            int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_error");
            int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_network_type");
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_created");
            int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_tag");
            int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_enqueue_action");
            int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_identifier");
            int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_download_on_enqueue");
            int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_extras");
            int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_max_attempts");
            int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_attempts");
            if (_cursor.moveToFirst()) {
                _result = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _result.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _result.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _result.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _result.setGroup(_tmpGroup);
                int _tmp = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp);
                _result.setPriority(_tmpPriority);
                String _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_1);
                _result.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _result.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _result.setTotal(_tmpTotal);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_2);
                _result.setStatus(_tmpStatus);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_3);
                _result.setError(_tmpError);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_4);
                _result.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _result.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _result.setTag(_tmpTag);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_5);
                _result.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _result.setIdentifier(_tmpIdentifier);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_6 != 0;
                _result.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_7);
                _result.setExtras(_tmpExtras);
                int _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
                _result.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
                int _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
                _result.setAutoRetryAttempts(_tmpAutoRetryAttempts);
            } else {
                _result = null;
            }
            DownloadInfo downloadInfo2 = _result;
            return downloadInfo2;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> get(List<Integer> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT ");
        _stringBuilder.append("*");
        _stringBuilder.append(" FROM requests WHERE _id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (Integer _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindLong(_argIndex, (long)_item.intValue());
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_namespace");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_url");
            int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_file");
            int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_group");
            int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_priority");
            int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_headers");
            int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_written_bytes");
            int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_total_bytes");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_status");
            int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_error");
            int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_network_type");
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_created");
            int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_tag");
            int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_enqueue_action");
            int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_identifier");
            int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_download_on_enqueue");
            int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_extras");
            int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_max_attempts");
            int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_attempts");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item_1 = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item_1.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item_1.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item_1.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item_1.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item_1.setGroup(_tmpGroup);
                int _tmp = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp);
                _item_1.setPriority(_tmpPriority);
                String _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_1);
                _item_1.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item_1.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item_1.setTotal(_tmpTotal);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_2);
                _item_1.setStatus(_tmpStatus);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_3);
                _item_1.setError(_tmpError);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_4);
                _item_1.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item_1.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item_1.setTag(_tmpTag);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_5);
                _item_1.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item_1.setIdentifier(_tmpIdentifier);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_6 != 0;
                _item_1.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_7);
                _item_1.setExtras(_tmpExtras);
                int _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
                _item_1.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
                int _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
                _item_1.setAutoRetryAttempts(_tmpAutoRetryAttempts);
                _result.add(_item_1);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadInfo getByFile(String file) {
        String _sql = "SELECT * FROM requests WHERE _file = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _file = ?", (int)1);
        int _argIndex = 1;
        if (file == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, file);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            DownloadInfo _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_namespace");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_url");
            int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_file");
            int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_group");
            int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_priority");
            int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_headers");
            int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_written_bytes");
            int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_total_bytes");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_status");
            int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_error");
            int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_network_type");
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_created");
            int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_tag");
            int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_enqueue_action");
            int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_identifier");
            int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_download_on_enqueue");
            int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_extras");
            int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_max_attempts");
            int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_attempts");
            if (_cursor.moveToFirst()) {
                _result = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _result.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _result.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _result.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _result.setGroup(_tmpGroup);
                int _tmp = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp);
                _result.setPriority(_tmpPriority);
                String _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_1);
                _result.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _result.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _result.setTotal(_tmpTotal);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_2);
                _result.setStatus(_tmpStatus);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_3);
                _result.setError(_tmpError);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_4);
                _result.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _result.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _result.setTag(_tmpTag);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_5);
                _result.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _result.setIdentifier(_tmpIdentifier);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_6 != 0;
                _result.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_7);
                _result.setExtras(_tmpExtras);
                int _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
                _result.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
                int _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
                _result.setAutoRetryAttempts(_tmpAutoRetryAttempts);
            } else {
                _result = null;
            }
            DownloadInfo downloadInfo2 = _result;
            return downloadInfo2;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> getByStatus(Status status) {
        String _sql = "SELECT * FROM requests WHERE _status = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _status = ?", (int)1);
        int _argIndex = 1;
        int _tmp = this.__converter.toStatusValue(status);
        _statement.bindLong(_argIndex, (long)_tmp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_namespace");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_url");
            int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_file");
            int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_group");
            int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_priority");
            int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_headers");
            int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_written_bytes");
            int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_total_bytes");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_status");
            int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_error");
            int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_network_type");
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_created");
            int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_tag");
            int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_enqueue_action");
            int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_identifier");
            int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_download_on_enqueue");
            int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_extras");
            int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_max_attempts");
            int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_attempts");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item.setGroup(_tmpGroup);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp_1);
                _item.setPriority(_tmpPriority);
                String _tmp_2 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_2);
                _item.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item.setTotal(_tmpTotal);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_3);
                _item.setStatus(_tmpStatus);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_4);
                _item.setError(_tmpError);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_5);
                _item.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item.setTag(_tmpTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_6);
                _item.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_7 != 0;
                _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_8 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_8);
                _item.setExtras(_tmpExtras);
                int _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
                _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
                int _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
                _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
                _result.add(_item);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> getByStatus(List<Status> statuses) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT ");
        _stringBuilder.append("*");
        _stringBuilder.append(" FROM requests WHERE _status IN (");
        int _inputSize = statuses.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (Status _item : statuses) {
            int _tmp = this.__converter.toStatusValue(_item);
            _statement.bindLong(_argIndex, (long)_tmp);
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_namespace");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_url");
            int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_file");
            int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_group");
            int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_priority");
            int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_headers");
            int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_written_bytes");
            int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_total_bytes");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_status");
            int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_error");
            int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_network_type");
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_created");
            int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_tag");
            int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_enqueue_action");
            int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_identifier");
            int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_download_on_enqueue");
            int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_extras");
            int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_max_attempts");
            int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_attempts");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item_1 = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item_1.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item_1.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item_1.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item_1.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item_1.setGroup(_tmpGroup);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp_1);
                _item_1.setPriority(_tmpPriority);
                String _tmp_2 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_2);
                _item_1.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item_1.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item_1.setTotal(_tmpTotal);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_3);
                _item_1.setStatus(_tmpStatus);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_4);
                _item_1.setError(_tmpError);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_5);
                _item_1.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item_1.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item_1.setTag(_tmpTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_6);
                _item_1.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item_1.setIdentifier(_tmpIdentifier);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_7 != 0;
                _item_1.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_8 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_8);
                _item_1.setExtras(_tmpExtras);
                int _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
                _item_1.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
                int _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
                _item_1.setAutoRetryAttempts(_tmpAutoRetryAttempts);
                _result.add(_item_1);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> getByGroup(int group) {
        String _sql = "SELECT * FROM requests WHERE _group = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _group = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)group);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_namespace");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_url");
            int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_file");
            int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_group");
            int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_priority");
            int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_headers");
            int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_written_bytes");
            int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_total_bytes");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_status");
            int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_error");
            int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_network_type");
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_created");
            int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_tag");
            int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_enqueue_action");
            int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_identifier");
            int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_download_on_enqueue");
            int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_extras");
            int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_max_attempts");
            int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_attempts");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item.setGroup(_tmpGroup);
                int _tmp = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp);
                _item.setPriority(_tmpPriority);
                String _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_1);
                _item.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item.setTotal(_tmpTotal);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_2);
                _item.setStatus(_tmpStatus);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_3);
                _item.setError(_tmpError);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_4);
                _item.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item.setTag(_tmpTag);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_5);
                _item.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_6 != 0;
                _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_7);
                _item.setExtras(_tmpExtras);
                int _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
                _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
                int _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
                _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
                _result.add(_item);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> getByGroupWithStatus(int group, List<Status> statuses) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT ");
        _stringBuilder.append("*");
        _stringBuilder.append(" FROM requests WHERE _group = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" AND _status IN (");
        int _inputSize = statuses.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 1 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)group);
        _argIndex = 2;
        for (Status _item : statuses) {
            int _tmp = this.__converter.toStatusValue(_item);
            _statement.bindLong(_argIndex, (long)_tmp);
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_namespace");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_url");
            int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_file");
            int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_group");
            int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_priority");
            int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_headers");
            int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_written_bytes");
            int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_total_bytes");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_status");
            int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_error");
            int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_network_type");
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_created");
            int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_tag");
            int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_enqueue_action");
            int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_identifier");
            int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_download_on_enqueue");
            int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_extras");
            int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_max_attempts");
            int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_attempts");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item_1 = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item_1.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item_1.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item_1.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item_1.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item_1.setGroup(_tmpGroup);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp_1);
                _item_1.setPriority(_tmpPriority);
                String _tmp_2 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_2);
                _item_1.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item_1.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item_1.setTotal(_tmpTotal);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_3);
                _item_1.setStatus(_tmpStatus);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_4);
                _item_1.setError(_tmpError);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_5);
                _item_1.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item_1.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item_1.setTag(_tmpTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_6);
                _item_1.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item_1.setIdentifier(_tmpIdentifier);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_7 != 0;
                _item_1.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_8 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_8);
                _item_1.setExtras(_tmpExtras);
                int _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
                _item_1.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
                int _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
                _item_1.setAutoRetryAttempts(_tmpAutoRetryAttempts);
                _result.add(_item_1);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> getPendingDownloadsSorted(Status status) {
        String _sql = "SELECT * FROM requests WHERE _status = ? ORDER BY _priority DESC, _created ASC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _status = ? ORDER BY _priority DESC, _created ASC", (int)1);
        int _argIndex = 1;
        int _tmp = this.__converter.toStatusValue(status);
        _statement.bindLong(_argIndex, (long)_tmp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_namespace");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_url");
            int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_file");
            int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_group");
            int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_priority");
            int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_headers");
            int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_written_bytes");
            int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_total_bytes");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_status");
            int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_error");
            int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_network_type");
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_created");
            int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_tag");
            int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_enqueue_action");
            int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_identifier");
            int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_download_on_enqueue");
            int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_extras");
            int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_max_attempts");
            int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_attempts");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item.setGroup(_tmpGroup);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp_1);
                _item.setPriority(_tmpPriority);
                String _tmp_2 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_2);
                _item.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item.setTotal(_tmpTotal);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_3);
                _item.setStatus(_tmpStatus);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_4);
                _item.setError(_tmpError);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_5);
                _item.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item.setTag(_tmpTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_6);
                _item.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_7 != 0;
                _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_8 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_8);
                _item.setExtras(_tmpExtras);
                int _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
                _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
                int _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
                _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
                _result.add(_item);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> getPendingDownloadsSortedDesc(Status status) {
        String _sql = "SELECT * FROM requests WHERE _status = ? ORDER BY _priority DESC, _created DESC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _status = ? ORDER BY _priority DESC, _created DESC", (int)1);
        int _argIndex = 1;
        int _tmp = this.__converter.toStatusValue(status);
        _statement.bindLong(_argIndex, (long)_tmp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_namespace");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_url");
            int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_file");
            int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_group");
            int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_priority");
            int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_headers");
            int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_written_bytes");
            int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_total_bytes");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_status");
            int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_error");
            int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_network_type");
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_created");
            int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_tag");
            int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_enqueue_action");
            int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_identifier");
            int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_download_on_enqueue");
            int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_extras");
            int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_max_attempts");
            int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_attempts");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item.setGroup(_tmpGroup);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp_1);
                _item.setPriority(_tmpPriority);
                String _tmp_2 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_2);
                _item.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item.setTotal(_tmpTotal);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_3);
                _item.setStatus(_tmpStatus);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_4);
                _item.setError(_tmpError);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_5);
                _item.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item.setTag(_tmpTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_6);
                _item.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_7 != 0;
                _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_8 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_8);
                _item.setExtras(_tmpExtras);
                int _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
                _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
                int _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
                _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
                _result.add(_item);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> getDownloadsByRequestIdentifier(long identifier) {
        String _sql = "SELECT * FROM requests WHERE _identifier = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _identifier = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, identifier);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_namespace");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_url");
            int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_file");
            int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_group");
            int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_priority");
            int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_headers");
            int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_written_bytes");
            int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_total_bytes");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_status");
            int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_error");
            int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_network_type");
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_created");
            int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_tag");
            int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_enqueue_action");
            int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_identifier");
            int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_download_on_enqueue");
            int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_extras");
            int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_max_attempts");
            int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_attempts");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item.setGroup(_tmpGroup);
                int _tmp = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp);
                _item.setPriority(_tmpPriority);
                String _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_1);
                _item.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item.setTotal(_tmpTotal);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_2);
                _item.setStatus(_tmpStatus);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_3);
                _item.setError(_tmpError);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_4);
                _item.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item.setTag(_tmpTag);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_5);
                _item.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_6 != 0;
                _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_7);
                _item.setExtras(_tmpExtras);
                int _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
                _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
                int _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
                _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
                _result.add(_item);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> getDownloadsByTag(String tag) {
        String _sql = "SELECT * FROM requests WHERE _tag = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _tag = ?", (int)1);
        int _argIndex = 1;
        if (tag == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, tag);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            int _cursorIndexOfNamespace = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_namespace");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_url");
            int _cursorIndexOfFile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_file");
            int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_group");
            int _cursorIndexOfPriority = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_priority");
            int _cursorIndexOfHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_headers");
            int _cursorIndexOfDownloaded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_written_bytes");
            int _cursorIndexOfTotal = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_total_bytes");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_status");
            int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_error");
            int _cursorIndexOfNetworkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_network_type");
            int _cursorIndexOfCreated = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_created");
            int _cursorIndexOfTag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_tag");
            int _cursorIndexOfEnqueueAction = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_enqueue_action");
            int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_identifier");
            int _cursorIndexOfDownloadOnEnqueue = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_download_on_enqueue");
            int _cursorIndexOfExtras = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_extras");
            int _cursorIndexOfAutoRetryMaxAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_max_attempts");
            int _cursorIndexOfAutoRetryAttempts = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_auto_retry_attempts");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item.setGroup(_tmpGroup);
                int _tmp = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp);
                _item.setPriority(_tmpPriority);
                String _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_1);
                _item.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item.setTotal(_tmpTotal);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_2);
                _item.setStatus(_tmpStatus);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_3);
                _item.setError(_tmpError);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_4);
                _item.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item.setTag(_tmpTag);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_5);
                _item.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_6 != 0;
                _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_7);
                _item.setExtras(_tmpExtras);
                int _tmpAutoRetryMaxAttempts = _cursor.getInt(_cursorIndexOfAutoRetryMaxAttempts);
                _item.setAutoRetryMaxAttempts(_tmpAutoRetryMaxAttempts);
                int _tmpAutoRetryAttempts = _cursor.getInt(_cursorIndexOfAutoRetryAttempts);
                _item.setAutoRetryAttempts(_tmpAutoRetryAttempts);
                _result.add(_item);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getAllGroupIds() {
        String _sql = "SELECT DISTINCT _group from requests";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT DISTINCT _group from requests", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<Integer> _result = new ArrayList<Integer>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                Integer _item = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0));
                _result.add(_item);
            }
            ArrayList<Integer> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

