/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2okhttp;

import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.InterruptMonitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0007\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010\u001e\u001a\u00020\u001f2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0!0\u000fH\u0016J\u001f\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0016\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010)\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010*\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010+\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050-H\u0016J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050-2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010/\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u00100\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0018\u00101\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001fH\u0016R\u001a\u0010\t\u001a\u00020\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/tonyodev/fetch2okhttp/OkHttpDownloader;", "Lcom/tonyodev/fetch2core/Downloader;", "Lokhttp3/OkHttpClient;", "Lokhttp3/Request;", "fileDownloaderType", "Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;", "(Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;)V", "okHttpClient", "(Lokhttp3/OkHttpClient;Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;)V", "client", "getClient", "()Lokhttp3/OkHttpClient;", "setClient", "(Lokhttp3/OkHttpClient;)V", "connections", "", "Lcom/tonyodev/fetch2core/Downloader$Response;", "Lokhttp3/Response;", "getConnections", "()Ljava/util/Map;", "close", "", "closeResponse", "response", "disconnect", "execute", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "interruptMonitor", "Lcom/tonyodev/fetch2core/InterruptMonitor;", "getContentHash", "", "responseHeaders", "", "getFileSlicingCount", "", "contentLength", "", "(Lcom/tonyodev/fetch2core/Downloader$ServerRequest;J)Ljava/lang/Integer;", "getHeadRequestMethodSupported", "", "getRequestBufferSize", "getRequestContentLength", "getRequestFileDownloaderType", "supportedFileDownloaderTypes", "", "getRequestSupportedFileDownloaderTypes", "onPreClientExecute", "onServerResponse", "verifyContentHash", "hash", "fetch2okhttp_release"})
public class OkHttpDownloader
implements Downloader<OkHttpClient, Request> {
    @NotNull
    private final Map<Downloader.Response, Response> connections;
    @NotNull
    private volatile OkHttpClient client;
    private final Downloader.FileDownloaderType fileDownloaderType;

    @NotNull
    protected final Map<Downloader.Response, Response> getConnections() {
        return this.connections;
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    public final void setClient(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkParameterIsNotNull((Object)okHttpClient, (String)"<set-?>");
        this.client = okHttpClient;
    }

    @NotNull
    public Request onPreClientExecute(@NotNull OkHttpClient client, @NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Request.Builder okHttpRequestBuilder = new Request.Builder().url(request.getUrl()).method(request.getRequestMethod(), null);
        Iterable $receiver$iv = request.getHeaders().entrySet();
        for (Object element$iv : $receiver$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            okHttpRequestBuilder.addHeader((String)it.getKey(), (String)it.getValue());
        }
        Request request2 = okHttpRequestBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"okHttpRequestBuilder.build()");
        return request2;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Downloader.Response execute(@NotNull Downloader.ServerRequest request, @NotNull InterruptMonitor interruptMonitor) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)interruptMonitor, (String)"interruptMonitor");
        okHttpRequest = this.onPreClientExecute(this.client, request);
        okHttpResponse = this.client.newCall(okHttpRequest).execute();
        code = okHttpResponse.code();
        v0 = okHttpResponse;
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"okHttpResponse");
        success = v0.isSuccessful();
        v1 = okHttpResponse.body();
        contentLength = v1 != null ? v1.contentLength() : -1L;
        v2 = okHttpResponse.body();
        byteStream = v2 != null ? v2.byteStream() : null;
        responseHeaders = new LinkedHashMap<K, V>();
        okResponseHeaders = okHttpResponse.headers();
        var12_11 = 0;
        var13_13 = okResponseHeaders.size();
        while (var12_11 < var13_13) {
            key = okResponseHeaders.name((int)i);
            values = okResponseHeaders.values(key);
            var16_17 = responseHeaders;
            Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"key");
            Intrinsics.checkExpressionValueIsNotNull((Object)values, (String)"values");
            var16_17.put(var17_18, var18_19);
            ++i;
        }
        hash = this.getContentHash(responseHeaders);
        if (contentLength < 1L) {
            v3 = (List)responseHeaders.get("Content-Length");
            if (v3 != null && (v3 = (String)CollectionsKt.firstOrNull((List)v3)) != null) {
                var13_14 = v3;
                v4 = Long.parseLong((String)var13_14);
            } else {
                v4 = contentLength = -1L;
            }
        }
        if (code == 206) ** GOTO lbl-1000
        v5 = (List)responseHeaders.get("Accept-Ranges");
        if (Intrinsics.areEqual((Object)(v5 != null ? (String)CollectionsKt.firstOrNull((List)v5) : null), (Object)"bytes")) lbl-1000:
        // 2 sources

        {
            v6 = true;
        } else {
            v6 = false;
        }
        acceptsRanges = v6;
        this.onServerResponse(request, new Downloader.Response(code, success, contentLength, null, request, hash, responseHeaders, acceptsRanges));
        response = new Downloader.Response(code, success, contentLength, byteStream, request, hash, responseHeaders, acceptsRanges);
        var15_16 = this.connections;
        var16_17 = okHttpResponse;
        var15_16.put(response, (Response)var16_17);
        return response;
    }

    @NotNull
    public String getContentHash(@NotNull Map<String, List<String>> responseHeaders) {
        Intrinsics.checkParameterIsNotNull(responseHeaders, (String)"responseHeaders");
        List<String> list = responseHeaders.get("Content-MD5");
        if (list == null || (list = (String)CollectionsKt.firstOrNull(list)) == null) {
            list = "";
        }
        return list;
    }

    public void disconnect(@NotNull Downloader.Response response) {
        Map<Downloader.Response, Response> map;
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Map<Downloader.Response, Response> map2 = map = this.connections;
        if (map2.containsKey(response)) {
            Response okHttpResponse = this.connections.get(response);
            this.connections.remove(response);
            this.closeResponse(okHttpResponse);
        }
    }

    public void close() {
        Iterable $receiver$iv = this.connections.entrySet();
        for (Object element$iv : $receiver$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            this.closeResponse((Response)it.getValue());
        }
        this.connections.clear();
    }

    private final void closeResponse(Response response) {
        try {
            Response response2 = response;
            if (response2 != null) {
                response2.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public Integer getFileSlicingCount(@NotNull Downloader.ServerRequest request, long contentLength) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return null;
    }

    @NotNull
    public Downloader.FileDownloaderType getRequestFileDownloaderType(@NotNull Downloader.ServerRequest request, @NotNull Set<? extends Downloader.FileDownloaderType> supportedFileDownloaderTypes) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(supportedFileDownloaderTypes, (String)"supportedFileDownloaderTypes");
        return this.fileDownloaderType;
    }

    public boolean verifyContentHash(@NotNull Downloader.ServerRequest request, @NotNull String hash) {
        boolean bl;
        String fileMd5;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        CharSequence charSequence = hash;
        if (charSequence.length() == 0) {
            return true;
        }
        String string = fileMd5 = FetchCoreUtils.getFileMd5String((String)request.getFile());
        if (string != null) {
            String string2;
            String string3 = string2 = string;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            bl = string3.contentEquals(hash);
        } else {
            bl = true;
        }
        return bl;
    }

    public void onServerResponse(@NotNull Downloader.ServerRequest request, @NotNull Downloader.Response response) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
    }

    public boolean getHeadRequestMethodSupported(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return false;
    }

    public int getRequestBufferSize(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return 8192;
    }

    public long getRequestContentLength(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return FetchCoreUtils.getRequestContentLength((Downloader.ServerRequest)request, (Downloader)this);
    }

    @NotNull
    public Set<Downloader.FileDownloaderType> getRequestSupportedFileDownloaderTypes(@NotNull Downloader.ServerRequest request) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            set = FetchCoreUtils.getRequestSupportedFileDownloaderTypes((Downloader.ServerRequest)request, (Downloader)this);
        }
        catch (Exception e) {
            set = SetsKt.mutableSetOf((Object[])new Downloader.FileDownloaderType[]{this.fileDownloaderType});
        }
        return set;
    }

    @JvmOverloads
    public OkHttpDownloader(@Nullable OkHttpClient okHttpClient, @NotNull Downloader.FileDownloaderType fileDownloaderType) {
        Intrinsics.checkParameterIsNotNull((Object)fileDownloaderType, (String)"fileDownloaderType");
        this.fileDownloaderType = fileDownloaderType;
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.synchronized\u2026er.Response, Response>())");
        this.connections = map;
        OkHttpClient okHttpClient2 = okHttpClient;
        if (okHttpClient2 == null) {
            OkHttpClient okHttpClient3 = new OkHttpClient.Builder().readTimeout(20000L, TimeUnit.MILLISECONDS).connectTimeout(15000L, TimeUnit.MILLISECONDS).cache(null).followRedirects(true).followSslRedirects(true).retryOnConnectionFailure(false).build();
            okHttpClient2 = okHttpClient3;
            Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient3, (String)"OkHttpClient.Builder()\n \u2026lse)\n            .build()");
        }
        this.client = okHttpClient2;
    }

    @JvmOverloads
    public /* synthetic */ OkHttpDownloader(OkHttpClient okHttpClient, Downloader.FileDownloaderType fileDownloaderType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            okHttpClient = null;
        }
        if ((n & 2) != 0) {
            fileDownloaderType = Downloader.FileDownloaderType.SEQUENTIAL;
        }
        this(okHttpClient, fileDownloaderType);
    }

    @JvmOverloads
    public OkHttpDownloader(@Nullable OkHttpClient okHttpClient) {
        this(okHttpClient, null, 2, null);
    }

    @JvmOverloads
    public OkHttpDownloader() {
        this(null, null, 3, null);
    }

    public OkHttpDownloader(@NotNull Downloader.FileDownloaderType fileDownloaderType) {
        Intrinsics.checkParameterIsNotNull((Object)fileDownloaderType, (String)"fileDownloaderType");
        this(null, fileDownloaderType);
    }
}

