/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.model;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.FetchGroup;
import com.tonyodev.fetch2.FetchGroupObserver;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.fetch.FetchModulesBuilder;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FetchObserver;
import com.tonyodev.fetch2core.Reason;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u0017\u001a\u00020\u00182\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ!\u0010>\u001a\u00020\u00182\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0@\"\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010AJ!\u0010B\u001a\u00020\u00182\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0@\"\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010AR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0014\"\u0004\b\u001e\u0010\u0016R \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0014\"\u0004\b!\u0010\u0016R \u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0014\"\u0004\b$\u0010\u0016R \u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0014\"\u0004\b'\u0010\u0016R \u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0014\"\u0004\b*\u0010\u0016R \u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0014\"\u0004\b-\u0010\u0016R \u0010.\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0014\"\u0004\b0\u0010\u0016R \u00101\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0014\"\u0004\b3\u0010\u0016R \u00104\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0014\"\u0004\b6\u0010\u0016R\u0014\u00107\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\tR&\u00109\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100;0:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006C"}, d2={"Lcom/tonyodev/fetch2/model/FetchGroupInfo;", "Lcom/tonyodev/fetch2/FetchGroup;", "id", "", "namespace", "", "<init>", "(ILjava/lang/String;)V", "getId", "()I", "getNamespace", "()Ljava/lang/String;", "observerSet", "", "Lcom/tonyodev/fetch2/FetchGroupObserver;", "value", "", "Lcom/tonyodev/fetch2/Download;", "downloads", "getDownloads", "()Ljava/util/List;", "setDownloads", "(Ljava/util/List;)V", "update", "", "triggerDownload", "reason", "Lcom/tonyodev/fetch2core/Reason;", "queuedDownloads", "getQueuedDownloads", "setQueuedDownloads", "addedDownloads", "getAddedDownloads", "setAddedDownloads", "pausedDownloads", "getPausedDownloads", "setPausedDownloads", "downloadingDownloads", "getDownloadingDownloads", "setDownloadingDownloads", "completedDownloads", "getCompletedDownloads", "setCompletedDownloads", "cancelledDownloads", "getCancelledDownloads", "setCancelledDownloads", "failedDownloads", "getFailedDownloads", "setFailedDownloads", "deletedDownloads", "getDeletedDownloads", "setDeletedDownloads", "removedDownloads", "getRemovedDownloads", "setRemovedDownloads", "groupDownloadProgress", "getGroupDownloadProgress", "observers", "", "Lcom/tonyodev/fetch2core/FetchObserver;", "getObservers", "()Ljava/util/Set;", "addFetchGroupObservers", "fetchGroupObservers", "", "([Lcom/tonyodev/fetch2/FetchGroupObserver;)V", "removeFetchGroupObservers", "fetch2_release"})
@SourceDebugExtension(value={"SMAP\nFetchGroupInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FetchGroupInfo.kt\ncom/tonyodev/fetch2/model/FetchGroupInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,114:1\n774#2:115\n865#2,2:116\n774#2:118\n865#2,2:119\n774#2:121\n865#2,2:122\n774#2:124\n865#2,2:125\n774#2:127\n865#2,2:128\n774#2:130\n865#2,2:131\n774#2:133\n865#2,2:134\n774#2:136\n865#2,2:137\n774#2:139\n865#2,2:140\n1755#2,3:142\n32#3,2:145\n*S KotlinDebug\n*F\n+ 1 FetchGroupInfo.kt\ncom/tonyodev/fetch2/model/FetchGroupInfo\n*L\n21#1:115\n21#1:116,2\n22#1:118\n22#1:119,2\n23#1:121\n23#1:122,2\n24#1:124\n24#1:125,2\n25#1:127\n25#1:128,2\n26#1:130\n26#1:131,2\n27#1:133\n27#1:134,2\n28#1:136\n28#1:137,2\n29#1:139\n29#1:140,2\n68#1:142,3\n37#1:145,2\n*E\n"})
public final class FetchGroupInfo
implements FetchGroup {
    private final int id;
    @NotNull
    private final String namespace;
    @NotNull
    private final Set<FetchGroupObserver> observerSet;
    @NotNull
    private volatile List<? extends Download> downloads;
    @NotNull
    private List<? extends Download> queuedDownloads;
    @NotNull
    private List<? extends Download> addedDownloads;
    @NotNull
    private List<? extends Download> pausedDownloads;
    @NotNull
    private List<? extends Download> downloadingDownloads;
    @NotNull
    private List<? extends Download> completedDownloads;
    @NotNull
    private List<? extends Download> cancelledDownloads;
    @NotNull
    private List<? extends Download> failedDownloads;
    @NotNull
    private List<? extends Download> deletedDownloads;
    @NotNull
    private List<? extends Download> removedDownloads;

    public FetchGroupInfo(int id, @NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.id = id;
        this.namespace = namespace;
        this.observerSet = new LinkedHashSet();
        this.downloads = CollectionsKt.emptyList();
        this.queuedDownloads = CollectionsKt.emptyList();
        this.addedDownloads = CollectionsKt.emptyList();
        this.pausedDownloads = CollectionsKt.emptyList();
        this.downloadingDownloads = CollectionsKt.emptyList();
        this.completedDownloads = CollectionsKt.emptyList();
        this.cancelledDownloads = CollectionsKt.emptyList();
        this.failedDownloads = CollectionsKt.emptyList();
        this.deletedDownloads = CollectionsKt.emptyList();
        this.removedDownloads = CollectionsKt.emptyList();
    }

    public /* synthetic */ FetchGroupInfo(int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n, string2);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @NotNull
    public List<Download> getDownloads() {
        return this.downloads;
    }

    public void setDownloads(@NotNull List<? extends Download> value) {
        Download it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.downloads = value;
        Iterable iterable = value;
        FetchGroupInfo fetchGroupInfo = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Download)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == Status.QUEUED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fetchGroupInfo.setQueuedDownloads((List)destination$iv$iv);
        $this$filter$iv = value;
        fetchGroupInfo = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Download)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == Status.ADDED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fetchGroupInfo.setAddedDownloads((List)destination$iv$iv);
        $this$filter$iv = value;
        fetchGroupInfo = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Download)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == Status.PAUSED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fetchGroupInfo.setPausedDownloads((List)destination$iv$iv);
        $this$filter$iv = value;
        fetchGroupInfo = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Download)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == Status.DOWNLOADING)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fetchGroupInfo.setDownloadingDownloads((List)destination$iv$iv);
        $this$filter$iv = value;
        fetchGroupInfo = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Download)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == Status.COMPLETED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fetchGroupInfo.setCompletedDownloads((List)destination$iv$iv);
        $this$filter$iv = value;
        fetchGroupInfo = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Download)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == Status.CANCELLED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fetchGroupInfo.setCancelledDownloads((List)destination$iv$iv);
        $this$filter$iv = value;
        fetchGroupInfo = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Download)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == Status.FAILED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fetchGroupInfo.setFailedDownloads((List)destination$iv$iv);
        $this$filter$iv = value;
        fetchGroupInfo = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Download)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == Status.DELETED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fetchGroupInfo.setDeletedDownloads((List)destination$iv$iv);
        $this$filter$iv = value;
        fetchGroupInfo = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Download)element$iv$iv;
            boolean bl = false;
            if (!(it.getStatus() == Status.REMOVED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fetchGroupInfo.setRemovedDownloads((List)destination$iv$iv);
    }

    public final void update(@NotNull List<? extends Download> downloads, @Nullable Download triggerDownload, @NotNull Reason reason) {
        Intrinsics.checkNotNullParameter(downloads, (String)"downloads");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.setDownloads(downloads);
        if (reason != Reason.DOWNLOAD_BLOCK_UPDATED) {
            FetchModulesBuilder.INSTANCE.getMainUIHandler().post(() -> FetchGroupInfo.update$lambda$11(this, downloads, reason, triggerDownload));
        }
    }

    @Override
    @NotNull
    public List<Download> getQueuedDownloads() {
        return this.queuedDownloads;
    }

    public void setQueuedDownloads(@NotNull List<? extends Download> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.queuedDownloads = list;
    }

    @Override
    @NotNull
    public List<Download> getAddedDownloads() {
        return this.addedDownloads;
    }

    public void setAddedDownloads(@NotNull List<? extends Download> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.addedDownloads = list;
    }

    @Override
    @NotNull
    public List<Download> getPausedDownloads() {
        return this.pausedDownloads;
    }

    public void setPausedDownloads(@NotNull List<? extends Download> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.pausedDownloads = list;
    }

    @Override
    @NotNull
    public List<Download> getDownloadingDownloads() {
        return this.downloadingDownloads;
    }

    public void setDownloadingDownloads(@NotNull List<? extends Download> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.downloadingDownloads = list;
    }

    @Override
    @NotNull
    public List<Download> getCompletedDownloads() {
        return this.completedDownloads;
    }

    public void setCompletedDownloads(@NotNull List<? extends Download> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.completedDownloads = list;
    }

    @Override
    @NotNull
    public List<Download> getCancelledDownloads() {
        return this.cancelledDownloads;
    }

    public void setCancelledDownloads(@NotNull List<? extends Download> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.cancelledDownloads = list;
    }

    @Override
    @NotNull
    public List<Download> getFailedDownloads() {
        return this.failedDownloads;
    }

    public void setFailedDownloads(@NotNull List<? extends Download> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.failedDownloads = list;
    }

    @Override
    @NotNull
    public List<Download> getDeletedDownloads() {
        return this.deletedDownloads;
    }

    public void setDeletedDownloads(@NotNull List<? extends Download> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.deletedDownloads = list;
    }

    @Override
    @NotNull
    public List<Download> getRemovedDownloads() {
        return this.removedDownloads;
    }

    public void setRemovedDownloads(@NotNull List<? extends Download> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.removedDownloads = list;
    }

    @Override
    public int getGroupDownloadProgress() {
        boolean bl;
        block5: {
            Iterable $this$any$iv = this.getDownloads();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Download it = (Download)element$iv;
                    boolean bl2 = false;
                    if (!(it.getTotal() < 1L)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (!bl) {
            long downloaded = 0L;
            long total = 0L;
            for (Download download : this.getDownloads()) {
                downloaded += download.getDownloaded();
                total += download.getTotal();
            }
            return FetchCoreUtils.calculateProgress((long)downloaded, (long)total);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<FetchObserver<List<Download>>> getObservers() {
        Set set;
        Set<FetchGroupObserver> set2 = this.observerSet;
        synchronized (set2) {
            boolean bl = false;
            set = CollectionsKt.toMutableSet((Iterable)this.observerSet);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFetchGroupObservers(FetchGroupObserver ... fetchGroupObservers) {
        Intrinsics.checkNotNullParameter((Object)fetchGroupObservers, (String)"fetchGroupObservers");
        Set<FetchGroupObserver> set = this.observerSet;
        synchronized (set) {
            boolean bl = false;
            List newFetchGroupObservers = ArraysKt.distinct((Object[])fetchGroupObservers);
            List addedObservers = new ArrayList();
            for (FetchGroupObserver fetchGroupObserver : newFetchGroupObservers) {
                if (this.observerSet.contains(fetchGroupObserver)) continue;
                this.observerSet.add(fetchGroupObserver);
                addedObservers.add(fetchGroupObserver);
            }
            boolean bl2 = FetchModulesBuilder.INSTANCE.getMainUIHandler().post(() -> FetchGroupInfo.addFetchGroupObservers$lambda$15$lambda$14(addedObservers, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFetchGroupObservers(FetchGroupObserver ... fetchGroupObservers) {
        Intrinsics.checkNotNullParameter((Object)fetchGroupObservers, (String)"fetchGroupObservers");
        Set<FetchGroupObserver> set = this.observerSet;
        synchronized (set) {
            boolean bl = false;
            for (FetchGroupObserver fetchGroupObserver : fetchGroupObservers) {
                this.observerSet.remove(fetchGroupObserver);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void update$lambda$11(FetchGroupInfo this$0, List $downloads, Reason $reason, Download $triggerDownload) {
        Set<FetchGroupObserver> set = this$0.observerSet;
        synchronized (set) {
            boolean bl = false;
            Iterator<FetchGroupObserver> $this$forEach$iv = this$0.observerSet.iterator();
            boolean $i$f$forEach = false;
            Iterator<FetchGroupObserver> iterator = $this$forEach$iv;
            while (iterator.hasNext()) {
                FetchGroupObserver element$iv;
                FetchGroupObserver it = element$iv = iterator.next();
                boolean bl2 = false;
                it.onChanged($downloads, $reason);
                if ($triggerDownload == null) continue;
                it.onChanged($downloads, $triggerDownload, $reason);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void addFetchGroupObservers$lambda$15$lambda$14(List $addedObservers, FetchGroupInfo this$0) {
        for (FetchGroupObserver addedObserver : $addedObservers) {
            addedObserver.onChanged(this$0.getDownloads(), Reason.OBSERVER_ATTACHED);
        }
    }
}

