/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.helper;

import android.annotation.SuppressLint;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.PrioritySort;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.PriorityBackoffResetCallback;
import com.tonyodev.fetch2.helper.PriorityListProcessor;
import com.tonyodev.fetch2.helper.PriorityListProcessorImpl;
import com.tonyodev.fetch2.provider.DownloadProvider;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.HandlerWrapper;
import com.tonyodev.fetch2core.Logger;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\n\b\u0007\u0018\u0000 ?2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001?BO\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000201H\u0016J\b\u00103\u001a\u000201H\u0016J\b\u00104\u001a\u000201H\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u000206H\u0016J\u0012\u00107\u001a\u0002012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u00108\u001a\u000201H\u0002J\b\u00109\u001a\u000201H\u0002J\b\u0010:\u001a\u00020%H\u0002J\b\u0010;\u001a\u000201H\u0016J\b\u0010<\u001a\u000201H\u0016J\b\u0010=\u001a\u000201H\u0016J\b\u0010>\u001a\u000201H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/tonyodev/fetch2/helper/PriorityListProcessorImpl;", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "Lcom/tonyodev/fetch2/Download;", "Lcom/tonyodev/fetch2/helper/PriorityBackoffResetCallback;", "handlerWrapper", "Lcom/tonyodev/fetch2core/HandlerWrapper;", "downloadProvider", "Lcom/tonyodev/fetch2/provider/DownloadProvider;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "logger", "Lcom/tonyodev/fetch2core/Logger;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "downloadConcurrentLimit", "", "namespace", "", "prioritySort", "Lcom/tonyodev/fetch2/PrioritySort;", "<init>", "(Lcom/tonyodev/fetch2core/HandlerWrapper;Lcom/tonyodev/fetch2/provider/DownloadProvider;Lcom/tonyodev/fetch2/downloader/DownloadManager;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;Lcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;ILjava/lang/String;Lcom/tonyodev/fetch2/PrioritySort;)V", "getDownloadConcurrentLimit", "()I", "setDownloadConcurrentLimit", "(I)V", "lock", "", "globalNetworkType", "Lcom/tonyodev/fetch2/NetworkType;", "getGlobalNetworkType", "()Lcom/tonyodev/fetch2/NetworkType;", "setGlobalNetworkType", "(Lcom/tonyodev/fetch2/NetworkType;)V", "paused", "", "isPaused", "()Z", "stopped", "isStopped", "backOffTime", "", "networkChangeListener", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider$NetworkChangeListener;", "priorityIteratorRunnable", "Ljava/lang/Runnable;", "start", "", "stop", "pause", "resume", "getPriorityList", "", "onResetBackoffTime", "registerPriorityIterator", "unregisterPriorityIterator", "canContinueToProcess", "resetBackOffTime", "sendBackOffResetSignal", "close", "increaseBackOffTime", "Companion", "fetch2_release"})
@SuppressLint(value={"UnspecifiedRegisterReceiverFlag"})
public final class PriorityListProcessorImpl
implements PriorityListProcessor<Download>,
PriorityBackoffResetCallback {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final HandlerWrapper handlerWrapper;
    @NotNull
    private final DownloadProvider downloadProvider;
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final NetworkInfoProvider networkInfoProvider;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ListenerCoordinator listenerCoordinator;
    private volatile int downloadConcurrentLimit;
    @NotNull
    private final String namespace;
    @NotNull
    private final PrioritySort prioritySort;
    @NotNull
    private final Object lock;
    @NotNull
    private volatile NetworkType globalNetworkType;
    private volatile boolean paused;
    private volatile boolean stopped;
    private volatile long backOffTime;
    @NotNull
    private final NetworkInfoProvider.NetworkChangeListener networkChangeListener;
    @NotNull
    private final Runnable priorityIteratorRunnable;
    private static final long ONE_MINUTE_IN_MILLISECONDS = 60000L;

    public PriorityListProcessorImpl(@NotNull HandlerWrapper handlerWrapper, @NotNull DownloadProvider downloadProvider, @NotNull DownloadManager downloadManager, @NotNull NetworkInfoProvider networkInfoProvider, @NotNull Logger logger, @NotNull ListenerCoordinator listenerCoordinator, int downloadConcurrentLimit, @NotNull String namespace, @NotNull PrioritySort prioritySort) {
        Intrinsics.checkNotNullParameter((Object)handlerWrapper, (String)"handlerWrapper");
        Intrinsics.checkNotNullParameter((Object)downloadProvider, (String)"downloadProvider");
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)listenerCoordinator, (String)"listenerCoordinator");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)((Object)prioritySort), (String)"prioritySort");
        this.handlerWrapper = handlerWrapper;
        this.downloadProvider = downloadProvider;
        this.downloadManager = downloadManager;
        this.networkInfoProvider = networkInfoProvider;
        this.logger = logger;
        this.listenerCoordinator = listenerCoordinator;
        this.downloadConcurrentLimit = downloadConcurrentLimit;
        this.namespace = namespace;
        this.prioritySort = prioritySort;
        this.lock = new Object();
        this.globalNetworkType = NetworkType.GLOBAL_OFF;
        this.stopped = true;
        this.backOffTime = 500L;
        this.networkChangeListener = new NetworkInfoProvider.NetworkChangeListener(this){
            final /* synthetic */ PriorityListProcessorImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void onNetworkChanged() {
                PriorityListProcessorImpl.access$getHandlerWrapper$p(this.this$0).post(() -> networkChangeListener.1.onNetworkChanged$lambda$0(this.this$0));
            }

            private static final Unit onNetworkChanged$lambda$0(PriorityListProcessorImpl this$0) {
                if (!PriorityListProcessorImpl.access$getStopped$p(this$0) && !PriorityListProcessorImpl.access$getPaused$p(this$0) && PriorityListProcessorImpl.access$getNetworkInfoProvider$p(this$0).isNetworkAvailable() && PriorityListProcessorImpl.access$getBackOffTime$p(this$0) > 500L) {
                    this$0.resetBackOffTime();
                }
                return Unit.INSTANCE;
            }
        };
        this.networkInfoProvider.registerNetworkChangeListener(this.networkChangeListener);
        this.priorityIteratorRunnable = () -> PriorityListProcessorImpl.priorityIteratorRunnable$lambda$0(this);
    }

    @Override
    public int getDownloadConcurrentLimit() {
        return this.downloadConcurrentLimit;
    }

    @Override
    public void setDownloadConcurrentLimit(int n) {
        this.downloadConcurrentLimit = n;
    }

    @Override
    @NotNull
    public NetworkType getGlobalNetworkType() {
        return this.globalNetworkType;
    }

    @Override
    public void setGlobalNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkNotNullParameter((Object)((Object)networkType), (String)"<set-?>");
        this.globalNetworkType = networkType;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.resetBackOffTime();
            this.stopped = false;
            this.paused = false;
            this.registerPriorityIterator();
            this.logger.d("PriorityIterator started");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.unregisterPriorityIterator();
            this.paused = false;
            this.stopped = true;
            this.downloadManager.cancelAll();
            this.logger.d("PriorityIterator stop");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.unregisterPriorityIterator();
            this.paused = true;
            this.stopped = false;
            this.downloadManager.cancelAll();
            this.logger.d("PriorityIterator paused");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.resetBackOffTime();
            this.paused = false;
            this.stopped = false;
            this.registerPriorityIterator();
            this.logger.d("PriorityIterator resumed");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Download> getPriorityList() {
        Object object = this.lock;
        synchronized (object) {
            List list;
            boolean bl = false;
            try {
                list = this.downloadProvider.getPendingDownloadsSorted(this.prioritySort);
            }
            catch (Exception e) {
                this.logger.d("PriorityIterator failed access database", (Throwable)e);
                list = CollectionsKt.emptyList();
            }
            List list2 = list;
            return list2;
        }
    }

    @Override
    public void onResetBackoffTime(@Nullable String namespace) {
        this.handlerWrapper.post(() -> PriorityListProcessorImpl.onResetBackoffTime$lambda$6(this, namespace));
    }

    private final void registerPriorityIterator() {
        if (this.getDownloadConcurrentLimit() > 0) {
            this.handlerWrapper.postDelayed(this.priorityIteratorRunnable, this.backOffTime);
        }
    }

    private final void unregisterPriorityIterator() {
        if (this.getDownloadConcurrentLimit() > 0) {
            this.handlerWrapper.removeCallbacks(this.priorityIteratorRunnable);
        }
    }

    private final boolean canContinueToProcess() {
        return !this.stopped && !this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetBackOffTime() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.backOffTime = 500L;
            this.unregisterPriorityIterator();
            this.registerPriorityIterator();
            this.logger.d("PriorityIterator backoffTime reset to " + this.backOffTime + " milliseconds");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBackOffResetSignal() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.onResetBackoffTime(this.namespace);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.networkInfoProvider.unregisterNetworkChangeListener(this.networkChangeListener);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void increaseBackOffTime() {
        this.backOffTime = this.backOffTime == 500L ? 60000L : this.backOffTime * 2L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(this.backOffTime);
        this.logger.d("PriorityIterator backoffTime increased to " + minutes + " minute(s)");
    }

    private static final void priorityIteratorRunnable$lambda$0(PriorityListProcessorImpl this$0) {
        if (this$0.canContinueToProcess()) {
            if (this$0.downloadManager.canAccommodateNewDownload() && this$0.canContinueToProcess()) {
                List<Download> priorityList = this$0.getPriorityList();
                boolean shouldBackOff = false;
                if (priorityList.isEmpty() || !this$0.networkInfoProvider.isNetworkAvailable()) {
                    shouldBackOff = true;
                }
                if (!shouldBackOff) {
                    shouldBackOff = true;
                    int index = 0;
                    int n = CollectionsKt.getLastIndex(priorityList);
                    if (index <= n) {
                        Download download;
                        boolean isFetchServerRequest;
                        while (this$0.downloadManager.canAccommodateNewDownload() && this$0.canContinueToProcess() && ((isFetchServerRequest = FetchCoreUtils.isFetchFileServerUrl((String)(download = priorityList.get(index)).getUrl())) || this$0.networkInfoProvider.isNetworkAvailable()) && this$0.canContinueToProcess()) {
                            NetworkType networkType = this$0.getGlobalNetworkType() != NetworkType.GLOBAL_OFF ? this$0.getGlobalNetworkType() : (download.getNetworkType() == NetworkType.GLOBAL_OFF ? NetworkType.ALL : download.getNetworkType());
                            boolean properNetworkConditions = this$0.networkInfoProvider.isOnAllowedNetwork(networkType);
                            if (!properNetworkConditions) {
                                this$0.listenerCoordinator.getMainListener().onWaitingNetwork(download);
                            }
                            if (isFetchServerRequest || properNetworkConditions) {
                                shouldBackOff = false;
                                if (!this$0.downloadManager.contains(download.getId()) && this$0.canContinueToProcess()) {
                                    this$0.downloadManager.start(download);
                                }
                            }
                            if (index == n) break;
                            ++index;
                        }
                    }
                }
                if (shouldBackOff) {
                    this$0.increaseBackOffTime();
                }
            }
            if (this$0.canContinueToProcess()) {
                this$0.registerPriorityIterator();
            }
        }
    }

    private static final Unit onResetBackoffTime$lambda$6(PriorityListProcessorImpl this$0, String $namespace) {
        if (!this$0.stopped && !this$0.paused && Intrinsics.areEqual((Object)this$0.namespace, (Object)$namespace)) {
            this$0.resetBackOffTime();
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ HandlerWrapper access$getHandlerWrapper$p(PriorityListProcessorImpl $this) {
        return $this.handlerWrapper;
    }

    public static final /* synthetic */ boolean access$getStopped$p(PriorityListProcessorImpl $this) {
        return $this.stopped;
    }

    public static final /* synthetic */ boolean access$getPaused$p(PriorityListProcessorImpl $this) {
        return $this.paused;
    }

    public static final /* synthetic */ NetworkInfoProvider access$getNetworkInfoProvider$p(PriorityListProcessorImpl $this) {
        return $this.networkInfoProvider;
    }

    public static final /* synthetic */ long access$getBackOffTime$p(PriorityListProcessorImpl $this) {
        return $this.backOffTime;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/tonyodev/fetch2/helper/PriorityListProcessorImpl$Companion;", "", "<init>", "()V", "ONE_MINUTE_IN_MILLISECONDS", "", "fetch2_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

