/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.provider;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.FetchGroup;
import com.tonyodev.fetch2.model.FetchGroupInfo;
import com.tonyodev.fetch2.provider.DownloadProvider;
import com.tonyodev.fetch2core.Reason;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/tonyodev/fetch2/provider/GroupInfoProvider;", "", "namespace", "", "downloadProvider", "Lcom/tonyodev/fetch2/provider/DownloadProvider;", "<init>", "(Ljava/lang/String;Lcom/tonyodev/fetch2/provider/DownloadProvider;)V", "lock", "groupInfoMap", "", "", "Ljava/lang/ref/WeakReference;", "Lcom/tonyodev/fetch2/model/FetchGroupInfo;", "getGroupInfo", "id", "reason", "Lcom/tonyodev/fetch2core/Reason;", "getGroupReplace", "Lcom/tonyodev/fetch2/FetchGroup;", "download", "Lcom/tonyodev/fetch2/Download;", "postGroupReplace", "", "clean", "clear", "fetch2_release"})
public final class GroupInfoProvider {
    @NotNull
    private final String namespace;
    @NotNull
    private final DownloadProvider downloadProvider;
    @NotNull
    private final Object lock;
    @NotNull
    private final Map<Integer, WeakReference<FetchGroupInfo>> groupInfoMap;

    public GroupInfoProvider(@NotNull String namespace, @NotNull DownloadProvider downloadProvider) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)downloadProvider, (String)"downloadProvider");
        this.namespace = namespace;
        this.downloadProvider = downloadProvider;
        this.lock = new Object();
        this.groupInfoMap = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FetchGroupInfo getGroupInfo(int id, @NotNull Reason reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Object object = this.lock;
        synchronized (object) {
            FetchGroupInfo fetchGroupInfo;
            FetchGroupInfo info;
            boolean bl = false;
            WeakReference<FetchGroupInfo> weakReference = this.groupInfoMap.get(id);
            FetchGroupInfo fetchGroupInfo2 = info = weakReference != null ? (FetchGroupInfo)weakReference.get() : null;
            if (info == null) {
                FetchGroupInfo groupInfo = new FetchGroupInfo(id, this.namespace);
                groupInfo.update(this.downloadProvider.getByGroup(id), null, reason);
                Integer n = id;
                this.groupInfoMap.put(n, new WeakReference<FetchGroupInfo>(groupInfo));
                fetchGroupInfo = groupInfo;
            } else {
                fetchGroupInfo = info;
            }
            FetchGroupInfo fetchGroupInfo3 = fetchGroupInfo;
            return fetchGroupInfo3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FetchGroup getGroupReplace(int id, @NotNull Download download, @NotNull Reason reason) {
        FetchGroupInfo fetchGroupInfo;
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            FetchGroupInfo groupInfo = this.getGroupInfo(id, reason);
            groupInfo.update(this.downloadProvider.getByGroupReplace(id, download), download, reason);
            fetchGroupInfo = groupInfo;
        }
        return fetchGroupInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postGroupReplace(int id, @NotNull Download download, @NotNull Reason reason) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            FetchGroupInfo groupInfo;
            boolean bl = false;
            WeakReference<FetchGroupInfo> weakReference = this.groupInfoMap.get(id);
            FetchGroupInfo fetchGroupInfo = groupInfo = weakReference != null ? (FetchGroupInfo)weakReference.get() : null;
            if (fetchGroupInfo != null) {
                fetchGroupInfo.update(this.downloadProvider.getByGroupReplace(id, download), download, reason);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clean() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Iterator<Map.Entry<Integer, WeakReference<FetchGroupInfo>>> iterator = this.groupInfoMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, WeakReference<FetchGroupInfo>> ref = iterator.next();
                if (ref.getValue().get() != null) continue;
                iterator.remove();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.groupInfoMap.clear();
            Unit unit = Unit.INSTANCE;
        }
    }
}

