/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.helper;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.PrioritySort;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.PriorityListProcessor;
import com.tonyodev.fetch2.helper.PriorityListProcessorImpl;
import com.tonyodev.fetch2.provider.DownloadProvider;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.HandlerWrapper;
import com.tonyodev.fetch2core.Logger;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\b\u0007\u0018\u0000 A2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001ABW\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000204H\u0016J\b\u00106\u001a\u000204H\u0016J\b\u00107\u001a\u000204H\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u000209H\u0016J\b\u0010:\u001a\u000204H\u0002J\b\u0010;\u001a\u000204H\u0002J\b\u0010<\u001a\u00020&H\u0002J\b\u0010=\u001a\u000204H\u0016J\b\u0010>\u001a\u000204H\u0016J\b\u0010?\u001a\u000204H\u0016J\b\u0010@\u001a\u000204H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/tonyodev/fetch2/helper/PriorityListProcessorImpl;", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "Lcom/tonyodev/fetch2/Download;", "handlerWrapper", "Lcom/tonyodev/fetch2core/HandlerWrapper;", "downloadProvider", "Lcom/tonyodev/fetch2/provider/DownloadProvider;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "logger", "Lcom/tonyodev/fetch2core/Logger;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "downloadConcurrentLimit", "", "context", "Landroid/content/Context;", "namespace", "", "prioritySort", "Lcom/tonyodev/fetch2/PrioritySort;", "<init>", "(Lcom/tonyodev/fetch2core/HandlerWrapper;Lcom/tonyodev/fetch2/provider/DownloadProvider;Lcom/tonyodev/fetch2/downloader/DownloadManager;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;Lcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;ILandroid/content/Context;Ljava/lang/String;Lcom/tonyodev/fetch2/PrioritySort;)V", "getDownloadConcurrentLimit", "()I", "setDownloadConcurrentLimit", "(I)V", "lock", "", "globalNetworkType", "Lcom/tonyodev/fetch2/NetworkType;", "getGlobalNetworkType", "()Lcom/tonyodev/fetch2/NetworkType;", "setGlobalNetworkType", "(Lcom/tonyodev/fetch2/NetworkType;)V", "paused", "", "isPaused", "()Z", "stopped", "isStopped", "backOffTime", "", "networkChangeListener", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider$NetworkChangeListener;", "priorityBackoffResetReceiver", "Landroid/content/BroadcastReceiver;", "priorityIteratorRunnable", "Ljava/lang/Runnable;", "start", "", "stop", "pause", "resume", "getPriorityList", "", "registerPriorityIterator", "unregisterPriorityIterator", "canContinueToProcess", "resetBackOffTime", "sendBackOffResetSignal", "close", "increaseBackOffTime", "Companion", "fetch2_release"})
@SuppressLint(value={"UnspecifiedRegisterReceiverFlag"})
public final class PriorityListProcessorImpl
implements PriorityListProcessor<Download> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final HandlerWrapper handlerWrapper;
    @NotNull
    private final DownloadProvider downloadProvider;
    @NotNull
    private final DownloadManager downloadManager;
    @NotNull
    private final NetworkInfoProvider networkInfoProvider;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ListenerCoordinator listenerCoordinator;
    private volatile int downloadConcurrentLimit;
    @NotNull
    private final Context context;
    @NotNull
    private final String namespace;
    @NotNull
    private final PrioritySort prioritySort;
    @NotNull
    private final Object lock;
    @NotNull
    private volatile NetworkType globalNetworkType;
    private volatile boolean paused;
    private volatile boolean stopped;
    private volatile long backOffTime;
    @NotNull
    private final NetworkInfoProvider.NetworkChangeListener networkChangeListener;
    @NotNull
    private final BroadcastReceiver priorityBackoffResetReceiver;
    @NotNull
    private final Runnable priorityIteratorRunnable;
    private static final long ONE_MINUTE_IN_MILLISECONDS = 60000L;

    public PriorityListProcessorImpl(@NotNull HandlerWrapper handlerWrapper, @NotNull DownloadProvider downloadProvider, @NotNull DownloadManager downloadManager, @NotNull NetworkInfoProvider networkInfoProvider, @NotNull Logger logger, @NotNull ListenerCoordinator listenerCoordinator, int downloadConcurrentLimit, @NotNull Context context, @NotNull String namespace, @NotNull PrioritySort prioritySort) {
        Intrinsics.checkNotNullParameter((Object)handlerWrapper, (String)"handlerWrapper");
        Intrinsics.checkNotNullParameter((Object)downloadProvider, (String)"downloadProvider");
        Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)listenerCoordinator, (String)"listenerCoordinator");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)((Object)prioritySort), (String)"prioritySort");
        this.handlerWrapper = handlerWrapper;
        this.downloadProvider = downloadProvider;
        this.downloadManager = downloadManager;
        this.networkInfoProvider = networkInfoProvider;
        this.logger = logger;
        this.listenerCoordinator = listenerCoordinator;
        this.downloadConcurrentLimit = downloadConcurrentLimit;
        this.context = context;
        this.namespace = namespace;
        this.prioritySort = prioritySort;
        this.lock = new Object();
        this.globalNetworkType = NetworkType.GLOBAL_OFF;
        this.stopped = true;
        this.backOffTime = 500L;
        this.networkChangeListener = new NetworkInfoProvider.NetworkChangeListener(this){
            final /* synthetic */ PriorityListProcessorImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void onNetworkChanged() {
                PriorityListProcessorImpl.access$getHandlerWrapper$p(this.this$0).post(() -> networkChangeListener.1.onNetworkChanged$lambda$0(this.this$0));
            }

            private static final Unit onNetworkChanged$lambda$0(PriorityListProcessorImpl this$0) {
                if (!PriorityListProcessorImpl.access$getStopped$p(this$0) && !PriorityListProcessorImpl.access$getPaused$p(this$0) && PriorityListProcessorImpl.access$getNetworkInfoProvider$p(this$0).isNetworkAvailable() && PriorityListProcessorImpl.access$getBackOffTime$p(this$0) > 500L) {
                    this$0.resetBackOffTime();
                }
                return Unit.INSTANCE;
            }
        };
        this.priorityBackoffResetReceiver = new BroadcastReceiver(this){
            final /* synthetic */ PriorityListProcessorImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void onReceive(Context context, Intent intent) {
                String string2;
                if (context != null && intent != null && (string2 = intent.getAction()) != null) {
                    switch (string2.hashCode()) {
                        case -1500940653: {
                            if (!string2.equals("com.tonyodev.fetch2.action.QUEUE_BACKOFF_RESET") || PriorityListProcessorImpl.access$getStopped$p(this.this$0) || PriorityListProcessorImpl.access$getPaused$p(this.this$0) || !Intrinsics.areEqual((Object)PriorityListProcessorImpl.access$getNamespace$p(this.this$0), (Object)intent.getStringExtra("com.tonyodev.fetch2.extra.NAMESPACE"))) break;
                            this.this$0.resetBackOffTime();
                        }
                    }
                }
            }
        };
        this.networkInfoProvider.registerNetworkChangeListener(this.networkChangeListener);
        Intent intent = Build.VERSION.SDK_INT >= 33 ? this.context.registerReceiver(this.priorityBackoffResetReceiver, new IntentFilter("com.tonyodev.fetch2.action.QUEUE_BACKOFF_RESET"), 4) : this.context.registerReceiver(this.priorityBackoffResetReceiver, new IntentFilter("com.tonyodev.fetch2.action.QUEUE_BACKOFF_RESET"));
        this.priorityIteratorRunnable = () -> PriorityListProcessorImpl.priorityIteratorRunnable$lambda$0(this);
    }

    @Override
    public int getDownloadConcurrentLimit() {
        return this.downloadConcurrentLimit;
    }

    @Override
    public void setDownloadConcurrentLimit(int n) {
        this.downloadConcurrentLimit = n;
    }

    @Override
    @NotNull
    public NetworkType getGlobalNetworkType() {
        return this.globalNetworkType;
    }

    @Override
    public void setGlobalNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkNotNullParameter((Object)((Object)networkType), (String)"<set-?>");
        this.globalNetworkType = networkType;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.resetBackOffTime();
            this.stopped = false;
            this.paused = false;
            this.registerPriorityIterator();
            this.logger.d("PriorityIterator started");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.unregisterPriorityIterator();
            this.paused = false;
            this.stopped = true;
            this.downloadManager.cancelAll();
            this.logger.d("PriorityIterator stop");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.unregisterPriorityIterator();
            this.paused = true;
            this.stopped = false;
            this.downloadManager.cancelAll();
            this.logger.d("PriorityIterator paused");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.resetBackOffTime();
            this.paused = false;
            this.stopped = false;
            this.registerPriorityIterator();
            this.logger.d("PriorityIterator resumed");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Download> getPriorityList() {
        Object object = this.lock;
        synchronized (object) {
            List list;
            boolean bl = false;
            try {
                list = this.downloadProvider.getPendingDownloadsSorted(this.prioritySort);
            }
            catch (Exception e) {
                this.logger.d("PriorityIterator failed access database", (Throwable)e);
                list = CollectionsKt.emptyList();
            }
            List list2 = list;
            return list2;
        }
    }

    private final void registerPriorityIterator() {
        if (this.getDownloadConcurrentLimit() > 0) {
            this.handlerWrapper.postDelayed(this.priorityIteratorRunnable, this.backOffTime);
        }
    }

    private final void unregisterPriorityIterator() {
        if (this.getDownloadConcurrentLimit() > 0) {
            this.handlerWrapper.removeCallbacks(this.priorityIteratorRunnable);
        }
    }

    private final boolean canContinueToProcess() {
        return !this.stopped && !this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetBackOffTime() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.backOffTime = 500L;
            this.unregisterPriorityIterator();
            this.registerPriorityIterator();
            this.logger.d("PriorityIterator backoffTime reset to " + this.backOffTime + " milliseconds");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBackOffResetSignal() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Intent intent = new Intent("com.tonyodev.fetch2.action.QUEUE_BACKOFF_RESET");
            intent.putExtra("com.tonyodev.fetch2.extra.NAMESPACE", this.namespace);
            this.context.sendBroadcast(intent);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.networkInfoProvider.unregisterNetworkChangeListener(this.networkChangeListener);
            this.context.unregisterReceiver(this.priorityBackoffResetReceiver);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void increaseBackOffTime() {
        this.backOffTime = this.backOffTime == 500L ? 60000L : this.backOffTime * 2L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(this.backOffTime);
        this.logger.d("PriorityIterator backoffTime increased to " + minutes + " minute(s)");
    }

    private static final void priorityIteratorRunnable$lambda$0(PriorityListProcessorImpl this$0) {
        if (this$0.canContinueToProcess()) {
            if (this$0.downloadManager.canAccommodateNewDownload() && this$0.canContinueToProcess()) {
                List<Download> priorityList = this$0.getPriorityList();
                boolean shouldBackOff = false;
                if (priorityList.isEmpty() || !this$0.networkInfoProvider.isNetworkAvailable()) {
                    shouldBackOff = true;
                }
                if (!shouldBackOff) {
                    shouldBackOff = true;
                    int index = 0;
                    int n = CollectionsKt.getLastIndex(priorityList);
                    if (index <= n) {
                        Download download;
                        boolean isFetchServerRequest;
                        while (this$0.downloadManager.canAccommodateNewDownload() && this$0.canContinueToProcess() && ((isFetchServerRequest = FetchCoreUtils.isFetchFileServerUrl((String)(download = priorityList.get(index)).getUrl())) || this$0.networkInfoProvider.isNetworkAvailable()) && this$0.canContinueToProcess()) {
                            NetworkType networkType = this$0.getGlobalNetworkType() != NetworkType.GLOBAL_OFF ? this$0.getGlobalNetworkType() : (download.getNetworkType() == NetworkType.GLOBAL_OFF ? NetworkType.ALL : download.getNetworkType());
                            boolean properNetworkConditions = this$0.networkInfoProvider.isOnAllowedNetwork(networkType);
                            if (!properNetworkConditions) {
                                this$0.listenerCoordinator.getMainListener().onWaitingNetwork(download);
                            }
                            if (isFetchServerRequest || properNetworkConditions) {
                                shouldBackOff = false;
                                if (!this$0.downloadManager.contains(download.getId()) && this$0.canContinueToProcess()) {
                                    this$0.downloadManager.start(download);
                                }
                            }
                            if (index == n) break;
                            ++index;
                        }
                    }
                }
                if (shouldBackOff) {
                    this$0.increaseBackOffTime();
                }
            }
            if (this$0.canContinueToProcess()) {
                this$0.registerPriorityIterator();
            }
        }
    }

    public static final /* synthetic */ HandlerWrapper access$getHandlerWrapper$p(PriorityListProcessorImpl $this) {
        return $this.handlerWrapper;
    }

    public static final /* synthetic */ boolean access$getStopped$p(PriorityListProcessorImpl $this) {
        return $this.stopped;
    }

    public static final /* synthetic */ boolean access$getPaused$p(PriorityListProcessorImpl $this) {
        return $this.paused;
    }

    public static final /* synthetic */ NetworkInfoProvider access$getNetworkInfoProvider$p(PriorityListProcessorImpl $this) {
        return $this.networkInfoProvider;
    }

    public static final /* synthetic */ long access$getBackOffTime$p(PriorityListProcessorImpl $this) {
        return $this.backOffTime;
    }

    public static final /* synthetic */ String access$getNamespace$p(PriorityListProcessorImpl $this) {
        return $this.namespace;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/tonyodev/fetch2/helper/PriorityListProcessorImpl$Companion;", "", "<init>", "()V", "ONE_MINUTE_IN_MILLISECONDS", "", "fetch2_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

