/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import android.content.Context;
import android.content.Intent;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.downloader.DownloadManagerCoordinator;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.ParallelFileDownloaderImpl;
import com.tonyodev.fetch2.downloader.SequentialFileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.helper.FileDownloaderDelegate;
import com.tonyodev.fetch2.provider.GroupInfoProvider;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileServerDownloader;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.StorageResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0097\u0001\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\r\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020\u0005\u0012\u0006\u0010 \u001a\u00020\r\u00a2\u0006\u0004\b!\u0010\"J\u0010\u00104\u001a\u00020\r2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002082\u0006\u00105\u001a\u000206H\u0002J\u0010\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020\u0005H\u0016J\u0010\u0010;\u001a\u00020\r2\u0006\u0010:\u001a\u00020\u0005H\u0002J\b\u0010<\u001a\u000208H\u0016J\b\u0010=\u001a\u000208H\u0002J\b\u0010>\u001a\u000208H\u0002J\b\u0010?\u001a\u000208H\u0016J\u0010\u0010@\u001a\u00020\r2\u0006\u0010:\u001a\u00020\u0005H\u0016J\b\u0010A\u001a\u00020\rH\u0016J\b\u0010B\u001a\u00020\u0005H\u0016J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u0002060DH\u0016J\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00050DH\u0016J\b\u0010F\u001a\u000208H\u0002J\u0010\u0010G\u001a\u00020.2\u0006\u00105\u001a\u000206H\u0016J \u0010H\u001a\u00020.2\u0006\u00105\u001a\u0002062\u000e\u0010I\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003H\u0002J\b\u0010J\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020\u001c2\u0006\u00105\u001a\u000206H\u0016J\u0012\u0010M\u001a\u0004\u0018\u00010&2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R.\u0010,\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010.0-j\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010.`/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006N"}, d2={"Lcom/tonyodev/fetch2/downloader/DownloadManagerImpl;", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "concurrentLimit", "", "progressReportingIntervalMillis", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "downloadManagerCoordinator", "Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "fileServerDownloader", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "hashCheckingEnabled", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "context", "Landroid/content/Context;", "namespace", "", "groupInfoProvider", "Lcom/tonyodev/fetch2/provider/GroupInfoProvider;", "globalAutoRetryMaxAttempts", "preAllocateFileOnCreation", "<init>", "(Lcom/tonyodev/fetch2core/Downloader;IJLcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;ZLcom/tonyodev/fetch2/helper/DownloadInfoUpdater;Lcom/tonyodev/fetch2/downloader/DownloadManagerCoordinator;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;Lcom/tonyodev/fetch2core/FileServerDownloader;ZLcom/tonyodev/fetch2core/StorageResolver;Landroid/content/Context;Ljava/lang/String;Lcom/tonyodev/fetch2/provider/GroupInfoProvider;IZ)V", "lock", "", "executor", "Ljava/util/concurrent/ExecutorService;", "value", "getConcurrentLimit", "()I", "setConcurrentLimit", "(I)V", "currentDownloadsMap", "Ljava/util/HashMap;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "Lkotlin/collections/HashMap;", "downloadCounter", "closed", "isClosed", "()Z", "start", "download", "Lcom/tonyodev/fetch2/Download;", "removeDownloadMappings", "", "cancel", "downloadId", "cancelDownloadNoLock", "cancelAll", "cancelAllDownloads", "terminateAllDownloads", "close", "contains", "canAccommodateNewDownload", "getActiveDownloadCount", "getActiveDownloads", "", "getActiveDownloadsIds", "throwExceptionIfClosed", "getNewFileDownloaderForDownload", "getFileDownloader", "downloader", "getFileDownloaderDelegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getDownloadFileTempDir", "getNewDownloadExecutorService", "fetch2_release"})
@SourceDebugExtension(value={"SMAP\nDownloadManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadManagerImpl.kt\ncom/tonyodev/fetch2/downloader/DownloadManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,313:1\n1863#2,2:314\n1557#2:320\n1628#2,3:321\n32#3,2:316\n32#3,2:318\n535#4:324\n520#4,6:325\n126#5:331\n153#5,3:332\n*S KotlinDebug\n*F\n+ 1 DownloadManagerImpl.kt\ncom/tonyodev/fetch2/downloader/DownloadManagerImpl\n*L\n42#1:314,2\n233#1:320\n233#1:321,3\n167#1:316,2\n182#1:318,2\n240#1:324\n240#1:325,6\n240#1:331\n240#1:332,3\n*E\n"})
public final class DownloadManagerImpl
implements DownloadManager {
    @NotNull
    private final Downloader<?, ?> httpDownloader;
    private final long progressReportingIntervalMillis;
    @NotNull
    private final Logger logger;
    @NotNull
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;
    @NotNull
    private final DownloadInfoUpdater downloadInfoUpdater;
    @NotNull
    private final DownloadManagerCoordinator downloadManagerCoordinator;
    @NotNull
    private final ListenerCoordinator listenerCoordinator;
    @NotNull
    private final FileServerDownloader fileServerDownloader;
    private final boolean hashCheckingEnabled;
    @NotNull
    private final StorageResolver storageResolver;
    @NotNull
    private final Context context;
    @NotNull
    private final String namespace;
    @NotNull
    private final GroupInfoProvider groupInfoProvider;
    private final int globalAutoRetryMaxAttempts;
    private final boolean preAllocateFileOnCreation;
    @NotNull
    private final Object lock;
    @Nullable
    private ExecutorService executor;
    private volatile int concurrentLimit;
    @NotNull
    private final HashMap<Integer, FileDownloader> currentDownloadsMap;
    private volatile int downloadCounter;
    private volatile boolean closed;

    public DownloadManagerImpl(@NotNull Downloader<?, ?> httpDownloader, int concurrentLimit, long progressReportingIntervalMillis, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain, @NotNull DownloadInfoUpdater downloadInfoUpdater, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator, @NotNull FileServerDownloader fileServerDownloader, boolean hashCheckingEnabled, @NotNull StorageResolver storageResolver, @NotNull Context context, @NotNull String namespace, @NotNull GroupInfoProvider groupInfoProvider, int globalAutoRetryMaxAttempts, boolean preAllocateFileOnCreation) {
        Intrinsics.checkNotNullParameter(httpDownloader, (String)"httpDownloader");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkNotNullParameter((Object)downloadInfoUpdater, (String)"downloadInfoUpdater");
        Intrinsics.checkNotNullParameter((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
        Intrinsics.checkNotNullParameter((Object)listenerCoordinator, (String)"listenerCoordinator");
        Intrinsics.checkNotNullParameter((Object)fileServerDownloader, (String)"fileServerDownloader");
        Intrinsics.checkNotNullParameter((Object)storageResolver, (String)"storageResolver");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)groupInfoProvider, (String)"groupInfoProvider");
        this.httpDownloader = httpDownloader;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.downloadInfoUpdater = downloadInfoUpdater;
        this.downloadManagerCoordinator = downloadManagerCoordinator;
        this.listenerCoordinator = listenerCoordinator;
        this.fileServerDownloader = fileServerDownloader;
        this.hashCheckingEnabled = hashCheckingEnabled;
        this.storageResolver = storageResolver;
        this.context = context;
        this.namespace = namespace;
        this.groupInfoProvider = groupInfoProvider;
        this.globalAutoRetryMaxAttempts = globalAutoRetryMaxAttempts;
        this.preAllocateFileOnCreation = preAllocateFileOnCreation;
        this.lock = new Object();
        this.executor = this.getNewDownloadExecutorService(concurrentLimit);
        this.concurrentLimit = concurrentLimit;
        this.currentDownloadsMap = new HashMap();
    }

    @Override
    public int getConcurrentLimit() {
        return this.concurrentLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConcurrentLimit(int value) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            try {
                Iterable $this$forEach$iv = this.getActiveDownloadsIds();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int id = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    this.cancelDownloadNoLock(id);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ExecutorService executorService = this.executor;
                if (executorService != null) {
                    executorService.shutdown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.executor = this.getNewDownloadExecutorService(value);
            this.concurrentLimit = value;
            this.logger.d("DownloadManager concurrentLimit changed from " + this.concurrentLimit + " to " + value);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        Object object = this.lock;
        synchronized (object) {
            block8: {
                block7: {
                    block6: {
                        boolean bl2 = false;
                        this.throwExceptionIfClosed();
                        if (!this.currentDownloadsMap.containsKey(download.getId())) break block6;
                        this.logger.d("DownloadManager already running download " + download);
                        boolean bl3 = false;
                        return bl3;
                    }
                    if (this.downloadCounter < this.getConcurrentLimit()) break block7;
                    this.logger.d("DownloadManager cannot init download " + download + " because the download queue is full");
                    boolean bl4 = false;
                    return bl4;
                }
                ++this.downloadCounter;
                ((Map)this.currentDownloadsMap).put(download.getId(), null);
                this.downloadManagerCoordinator.addFileDownloader(download.getId(), null);
                ExecutorService downloadExecutor = this.executor;
                if (downloadExecutor == null || downloadExecutor.isShutdown()) break block8;
                downloadExecutor.execute(() -> DownloadManagerImpl.start$lambda$4$lambda$3(download, this));
                boolean bl5 = true;
                return bl5;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDownloadMappings(Download download) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.currentDownloadsMap.containsKey(download.getId())) {
                this.currentDownloadsMap.remove(download.getId());
                --this.downloadCounter;
            }
            this.downloadManagerCoordinator.removeFileDownloader(download.getId());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(int downloadId) {
        boolean bl;
        Object object = this.lock;
        synchronized (object) {
            boolean bl2 = false;
            bl = this.cancelDownloadNoLock(downloadId);
        }
        return bl;
    }

    private final boolean cancelDownloadNoLock(int downloadId) {
        boolean bl;
        this.throwExceptionIfClosed();
        FileDownloader fileDownloader = this.currentDownloadsMap.get(downloadId);
        if (fileDownloader != null) {
            fileDownloader.setInterrupted(true);
            this.currentDownloadsMap.remove(downloadId);
            --this.downloadCounter;
            this.downloadManagerCoordinator.removeFileDownloader(downloadId);
            this.logger.d("DownloadManager cancelled download " + fileDownloader.getDownload());
            bl = fileDownloader.getInterrupted();
        } else {
            this.downloadManagerCoordinator.interruptDownload(downloadId);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.throwExceptionIfClosed();
            this.cancelAllDownloads();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void cancelAllDownloads() {
        if (this.getConcurrentLimit() > 0) {
            Iterator<FileDownloader> $this$forEach$iv = this.downloadManagerCoordinator.getFileDownloaderList().iterator();
            boolean $i$f$forEach = false;
            Iterator<FileDownloader> iterator = $this$forEach$iv;
            while (iterator.hasNext()) {
                FileDownloader element$iv;
                FileDownloader it = element$iv = iterator.next();
                boolean bl = false;
                FileDownloader fileDownloader = it;
                if (fileDownloader == null) continue;
                fileDownloader.setInterrupted(true);
                this.downloadManagerCoordinator.removeFileDownloader(fileDownloader.getDownload().getId());
                this.logger.d("DownloadManager cancelled download " + fileDownloader.getDownload());
            }
        }
        this.currentDownloadsMap.clear();
        this.downloadCounter = 0;
    }

    private final void terminateAllDownloads() {
        Iterator $this$forEach$iv = ((Map)this.currentDownloadsMap).entrySet().iterator();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            FileDownloader fileDownloader = (FileDownloader)it.getValue();
            if (fileDownloader == null) continue;
            fileDownloader.setTerminated(true);
            this.logger.d("DownloadManager terminated download " + fileDownloader.getDownload());
            this.downloadManagerCoordinator.removeFileDownloader(((Number)it.getKey()).intValue());
        }
        this.currentDownloadsMap.clear();
        this.downloadCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.getConcurrentLimit() > 0) {
                this.terminateAllDownloads();
            }
            this.logger.d("DownloadManager closing download manager");
            try {
                Unit unit2;
                ExecutorService executorService = this.executor;
                if (executorService != null) {
                    executorService.shutdown();
                    unit2 = Unit.INSTANCE;
                } else {
                    unit2 = null;
                }
                unit = unit2;
            }
            catch (Exception exception) {
                unit = Unit.INSTANCE;
            }
            Unit unit3 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(int downloadId) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = !this.isClosed() && this.downloadManagerCoordinator.containsFileDownloader(downloadId);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAccommodateNewDownload() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = !this.closed && this.downloadCounter < this.getConcurrentLimit();
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveDownloadCount() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.throwExceptionIfClosed();
            int n = this.downloadCounter;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> getActiveDownloads() {
        Object object = this.lock;
        synchronized (object) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            this.throwExceptionIfClosed();
            Collection<FileDownloader> collection = this.currentDownloadsMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$map$iv = CollectionsKt.filterNotNull((Iterable)collection);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FileDownloader fileDownloader = (FileDownloader)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(it.getDownload());
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Integer> getActiveDownloadsIds() {
        Object object = this.lock;
        synchronized (object) {
            void $this$mapTo$iv$iv;
            Map.Entry it;
            Map $this$filterTo$iv$iv;
            boolean bl = false;
            this.throwExceptionIfClosed();
            Map $this$filter$iv = this.currentDownloadsMap;
            boolean $i$f$filter = false;
            Map map = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                if (!(it.getValue() != null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$map$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                it = item$iv$iv;
                Object object2 = destination$iv$iv;
                boolean bl3 = false;
                object2.add(((Number)it.getKey()).intValue());
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    private final void throwExceptionIfClosed() {
        if (this.closed) {
            throw new FetchException("DownloadManager is already shutdown.");
        }
    }

    @Override
    @NotNull
    public FileDownloader getNewFileDownloaderForDownload(@NotNull Download download) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        return !FetchCoreUtils.isFetchFileServerUrl((String)download.getUrl()) ? this.getFileDownloader(download, this.httpDownloader) : this.getFileDownloader(download, (Downloader)this.fileServerDownloader);
    }

    private final FileDownloader getFileDownloader(Download download, Downloader<?, ?> downloader) {
        Downloader.ServerRequest originalRequest = FetchUtils.getRequestForDownload$default(download, null, 2, null);
        Downloader.ServerRequest request = downloader.getHeadRequestMethodSupported(originalRequest) ? FetchUtils.getRequestForDownload(download, "HEAD") : originalRequest;
        Set supportedDownloadTypes = downloader.getRequestSupportedFileDownloaderTypes(request);
        return downloader.getRequestFileDownloaderType(request, supportedDownloadTypes) == Downloader.FileDownloaderType.SEQUENTIAL ? (FileDownloader)new SequentialFileDownloaderImpl(download, downloader, this.progressReportingIntervalMillis, this.logger, this.networkInfoProvider, this.retryOnNetworkGain, this.hashCheckingEnabled, this.storageResolver, this.preAllocateFileOnCreation) : (FileDownloader)new ParallelFileDownloaderImpl(download, downloader, this.progressReportingIntervalMillis, this.logger, this.networkInfoProvider, this.retryOnNetworkGain, this.storageResolver.getDirectoryForFileDownloaderTypeParallel(request), this.hashCheckingEnabled, this.storageResolver, this.preAllocateFileOnCreation);
    }

    @Override
    @NotNull
    public FileDownloader.Delegate getFileDownloaderDelegate() {
        return new FileDownloaderDelegate(this.downloadInfoUpdater, this.listenerCoordinator.getMainListener(), this.retryOnNetworkGain, this.globalAutoRetryMaxAttempts);
    }

    @Override
    @NotNull
    public String getDownloadFileTempDir(@NotNull Download download) {
        Intrinsics.checkNotNullParameter((Object)download, (String)"download");
        Downloader.ServerRequest request = FetchUtils.getRequestForDownload$default(download, null, 2, null);
        return this.storageResolver.getDirectoryForFileDownloaderTypeParallel(request);
    }

    private final ExecutorService getNewDownloadExecutorService(int concurrentLimit) {
        return concurrentLimit > 0 ? Executors.newFixedThreadPool(concurrentLimit) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void start$lambda$4$lambda$3(Download $download, DownloadManagerImpl this$0) {
        try {
            Thread.currentThread().setName($download.getNamespace() + "-" + $download.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            boolean bl;
            FileDownloader fileDownloader = this$0.getNewFileDownloaderForDownload($download);
            Object object = this$0.lock;
            synchronized (object) {
                boolean bl2;
                boolean bl3 = false;
                if (this$0.currentDownloadsMap.containsKey($download.getId())) {
                    fileDownloader.setDelegate(this$0.getFileDownloaderDelegate());
                    ((Map)this$0.currentDownloadsMap).put($download.getId(), fileDownloader);
                    this$0.downloadManagerCoordinator.addFileDownloader($download.getId(), fileDownloader);
                    this$0.logger.d("DownloadManager starting download " + $download);
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                bl = bl2;
            }
            boolean runDownload = bl;
            if (runDownload) {
                fileDownloader.run();
            }
            this$0.removeDownloadMappings($download);
            this$0.groupInfoProvider.clean();
        }
        catch (Exception e) {
            this$0.logger.e("DownloadManager failed to start download " + $download, (Throwable)e);
        }
        finally {
            this$0.removeDownloadMappings($download);
            Intent intent = new Intent("com.tonyodev.fetch2.action.QUEUE_BACKOFF_RESET");
            intent.setPackage(this$0.context.getPackageName());
            intent.putExtra("com.tonyodev.fetch2.extra.NAMESPACE", this$0.namespace);
            this$0.context.sendBroadcast(intent);
        }
    }
}

