/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.EnqueueAction;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchErrorUtils;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.ParallelFileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.helper.FileDownloaderDelegate;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.AverageCalculator;
import com.tonyodev.fetch2core.DownloadBlock;
import com.tonyodev.fetch2core.DownloadBlockInfo;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileSlice;
import com.tonyodev.fetch2core.FileSliceInfo;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.OutputResourceWrapper;
import com.tonyodev.fetch2core.StorageResolver;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ab\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004*\u0001Y\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\r\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\r\u00a2\u0006\u0004\b\u0014\u0010\u0015J\b\u0010G\u001a\u00020HH\u0016J\u001e\u0010I\u001a\b\u0012\u0004\u0012\u00020C0B2\u0006\u0010J\u001a\u00020\r2\u0006\u0010K\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020N2\u0006\u0010K\u001a\u00020LH\u0002J\b\u0010O\u001a\u00020\u0007H\u0002J\b\u0010P\u001a\u00020HH\u0002J\u001e\u0010Q\u001a\u00020H2\u0006\u0010K\u001a\u00020L2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020C0BH\u0002J\b\u0010S\u001a\u00020HH\u0002J\b\u0010T\u001a\u00020\rH\u0002J\u0010\u0010U\u001a\u00020H2\u0006\u0010V\u001a\u00020WH\u0002J\b\u0010[\u001a\u00020HH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u0014\u0010\u001f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0019R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001b\u0010'\u001a\u00020(8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b)\u0010*R\u0014\u0010-\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020C0BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010D\u001a\u0004\u0018\u00010EX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010X\u001a\u00020YX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010Z\u00a8\u0006\\"}, d2={"Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "initialDownload", "Lcom/tonyodev/fetch2/Download;", "downloader", "Lcom/tonyodev/fetch2core/Downloader;", "progressReportingIntervalMillis", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "fileTempDir", "", "hashCheckingEnabled", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "preAllocateFileOnCreation", "<init>", "(Lcom/tonyodev/fetch2/Download;Lcom/tonyodev/fetch2core/Downloader;JLcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;ZLjava/lang/String;ZLcom/tonyodev/fetch2core/StorageResolver;Z)V", "value", "interrupted", "getInterrupted", "()Z", "setInterrupted", "(Z)V", "terminated", "getTerminated", "setTerminated", "completedDownload", "getCompletedDownload", "delegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;)V", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "getDownloadInfo", "()Lcom/tonyodev/fetch2/database/DownloadInfo;", "downloadInfo$delegate", "Lkotlin/Lazy;", "download", "getDownload", "()Lcom/tonyodev/fetch2/Download;", "downloaded", "total", "totalUnknown", "averageDownloadedBytesPerSecond", "", "movingAverageCalculator", "Lcom/tonyodev/fetch2core/AverageCalculator;", "estimatedTimeRemainingInMilliseconds", "executorService", "Ljava/util/concurrent/ExecutorService;", "actionsCounter", "", "actionsTotal", "lock", "Ljava/lang/Object;", "throwable", "", "fileSlices", "", "Lcom/tonyodev/fetch2core/FileSlice;", "outputResourceWrapper", "Lcom/tonyodev/fetch2core/OutputResourceWrapper;", "totalDownloadBlocks", "run", "", "getFileSliceList", "acceptsRanges", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "getChuckInfo", "Lcom/tonyodev/fetch2core/FileSliceInfo;", "getAverageDownloadedBytesPerSecond", "waitAndPerformProgressReporting", "downloadSliceFiles", "fileSlicesDownloadsList", "incrementActionCompletedCount", "isDownloadComplete", "setIsTotalUnknown", "response", "Lcom/tonyodev/fetch2core/Downloader$Response;", "interruptMonitor", "com/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$interruptMonitor$1", "Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$interruptMonitor$1;", "throwExceptionIfFound", "fetch2_release"})
@SourceDebugExtension(value={"SMAP\nParallelFileDownloaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParallelFileDownloaderImpl.kt\ncom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,549:1\n774#2:550\n865#2,2:551\n1557#2:553\n1628#2,3:554\n1863#2,2:557\n1863#2,2:559\n*S KotlinDebug\n*F\n+ 1 ParallelFileDownloaderImpl.kt\ncom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl\n*L\n122#1:550\n122#1:551,2\n126#1:553\n126#1:554,3\n142#1:557,2\n178#1:559,2\n*E\n"})
public final class ParallelFileDownloaderImpl
implements FileDownloader {
    @NotNull
    private final Download initialDownload;
    @NotNull
    private final Downloader<?, ?> downloader;
    private final long progressReportingIntervalMillis;
    @NotNull
    private final Logger logger;
    @NotNull
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;
    @NotNull
    private final String fileTempDir;
    private final boolean hashCheckingEnabled;
    @NotNull
    private final StorageResolver storageResolver;
    private final boolean preAllocateFileOnCreation;
    private volatile boolean interrupted;
    private volatile boolean terminated;
    @Nullable
    private FileDownloader.Delegate delegate;
    @NotNull
    private final Lazy downloadInfo$delegate;
    private volatile long downloaded;
    private volatile long total;
    private volatile boolean totalUnknown;
    private double averageDownloadedBytesPerSecond;
    @NotNull
    private final AverageCalculator movingAverageCalculator;
    private long estimatedTimeRemainingInMilliseconds;
    @Nullable
    private ExecutorService executorService;
    private volatile int actionsCounter;
    private int actionsTotal;
    @NotNull
    private final Object lock;
    @Nullable
    private volatile Throwable throwable;
    @NotNull
    private List<FileSlice> fileSlices;
    @Nullable
    private OutputResourceWrapper outputResourceWrapper;
    private int totalDownloadBlocks;
    @NotNull
    private final interruptMonitor.1 interruptMonitor;

    public ParallelFileDownloaderImpl(@NotNull Download initialDownload, @NotNull Downloader<?, ?> downloader, long progressReportingIntervalMillis, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain, @NotNull String fileTempDir, boolean hashCheckingEnabled, @NotNull StorageResolver storageResolver, boolean preAllocateFileOnCreation) {
        Intrinsics.checkNotNullParameter((Object)initialDownload, (String)"initialDownload");
        Intrinsics.checkNotNullParameter(downloader, (String)"downloader");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkNotNullParameter((Object)fileTempDir, (String)"fileTempDir");
        Intrinsics.checkNotNullParameter((Object)storageResolver, (String)"storageResolver");
        this.initialDownload = initialDownload;
        this.downloader = downloader;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.fileTempDir = fileTempDir;
        this.hashCheckingEnabled = hashCheckingEnabled;
        this.storageResolver = storageResolver;
        this.preAllocateFileOnCreation = preAllocateFileOnCreation;
        this.downloadInfo$delegate = LazyKt.lazy(() -> ParallelFileDownloaderImpl.downloadInfo_delegate$lambda$0(this));
        this.total = -1L;
        this.movingAverageCalculator = new AverageCalculator(5);
        this.estimatedTimeRemainingInMilliseconds = -1L;
        this.lock = new Object();
        this.fileSlices = CollectionsKt.emptyList();
        this.interruptMonitor = new InterruptMonitor(this){
            final /* synthetic */ ParallelFileDownloaderImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean isInterrupted() {
                return this.this$0.getInterrupted();
            }
        };
    }

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted(boolean value) {
        FileDownloader.Delegate delegate = this.getDelegate();
        FileDownloaderDelegate fileDownloaderDelegate = delegate instanceof FileDownloaderDelegate ? (FileDownloaderDelegate)delegate : null;
        if (fileDownloaderDelegate != null) {
            fileDownloaderDelegate.setInterrupted(value);
        }
        this.interrupted = value;
    }

    @Override
    public boolean getTerminated() {
        return this.terminated;
    }

    @Override
    public void setTerminated(boolean value) {
        FileDownloader.Delegate delegate = this.getDelegate();
        FileDownloaderDelegate fileDownloaderDelegate = delegate instanceof FileDownloaderDelegate ? (FileDownloaderDelegate)delegate : null;
        if (fileDownloaderDelegate != null) {
            fileDownloaderDelegate.setInterrupted(value);
        }
        this.terminated = value;
    }

    @Override
    public boolean getCompletedDownload() {
        return this.isDownloadComplete();
    }

    @Override
    @Nullable
    public FileDownloader.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable FileDownloader.Delegate delegate) {
        this.delegate = delegate;
    }

    private final DownloadInfo getDownloadInfo() {
        Lazy lazy = this.downloadInfo$delegate;
        return (DownloadInfo)lazy.getValue();
    }

    @Override
    @NotNull
    public Download getDownload() {
        this.getDownloadInfo().setDownloaded(this.downloaded);
        this.getDownloadInfo().setTotal(this.total);
        return this.getDownloadInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void run() {
        block69: {
            block71: {
                block70: {
                    openingResponse = null;
                    this.downloaded = this.initialDownload.getDownloaded();
                    this.total = this.initialDownload.getTotal();
                    this.getDownloadInfo().setDownloaded(this.downloaded);
                    this.getDownloadInfo().setTotal(this.total);
                    openingRequest = this.downloader.getHeadRequestMethodSupported(FetchUtils.getRequestForDownload$default(this.initialDownload, null, 2, null)) != false ? FetchUtils.getRequestForDownload(this.initialDownload, "HEAD") : FetchUtils.getRequestForDownload$default(this.initialDownload, null, 2, null);
                    openingResponse = this.downloader.execute(openingRequest, (InterruptMonitor)this.interruptMonitor);
                    if (openingResponse != null) {
                        this.setIsTotalUnknown(openingResponse);
                    }
                    if (this.getInterrupted() || this.getTerminated()) ** GOTO lbl89
                    v0 = openingResponse;
                    v1 = v0 != null ? v0.isSuccessful() : false;
                    if (!v1) ** GOTO lbl89
                    this.total = openingResponse.getContentLength();
                    if (this.totalUnknown || this.total > 0L) {
                        this.downloaded = 0L;
                        this.getDownloadInfo().setDownloaded(this.downloaded);
                        this.getDownloadInfo().setTotal(this.total);
                        this.fileSlices = this.getFileSliceList(openingResponse.getAcceptsRanges(), openingRequest);
                        this.totalDownloadBlocks = this.fileSlices.size();
                        try {
                            this.downloader.disconnect(openingResponse);
                        }
                        catch (Exception e) {
                            this.logger.e("FileDownloader", (Throwable)e);
                        }
                        $this$filter$iv = this.fileSlices;
                        $i$f$filter = false;
                        var6_21 = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            it = (FileSlice)element$iv$iv;
                            $i$a$-filter-ParallelFileDownloaderImpl$run$sliceFileDownloadsList$1 = false;
                            if (!(it.isDownloaded() == false)) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        sliceFileDownloadsList = (List)destination$iv$iv /* !! */ ;
                        if (!this.getInterrupted() && !this.getTerminated()) {
                            this.getDownloadInfo().setDownloaded(this.downloaded);
                            this.getDownloadInfo().setTotal(this.total);
                            $this$map$iv = this.fileSlices;
                            $i$f$map = false;
                            destination$iv$iv /* !! */  = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            element$iv$iv = $this$mapTo$iv$iv.iterator();
                            while (element$iv$iv.hasNext()) {
                                item$iv$iv = element$iv$iv.next();
                                $i$a$-filter-ParallelFileDownloaderImpl$run$sliceFileDownloadsList$1 = (FileSlice)item$iv$iv;
                                var15_40 = destination$iv$iv;
                                $i$a$-map-ParallelFileDownloaderImpl$run$downloadBlocks$1 = false;
                                downloadBlock = new DownloadBlockInfo();
                                downloadBlock.setDownloadId(it.getId());
                                downloadBlock.setBlockPosition(it.getPosition());
                                downloadBlock.setDownloadedBytes(it.getDownloaded());
                                downloadBlock.setStartByte(it.getStartBytes());
                                downloadBlock.setEndByte(it.getEndBytes());
                                var15_40.add(downloadBlock);
                            }
                            downloadBlocks = (List)destination$iv$iv;
                            if (!this.getInterrupted() && !this.getTerminated()) {
                                this.getDownloadInfo().setEtaInMilliSeconds(-1L);
                                this.getDownloadInfo().setDownloadedBytesPerSecond(-1L);
                                v2 = this.getDelegate();
                                if (v2 != null) {
                                    v2.onStarted(this.getDownloadInfo(), downloadBlocks, this.totalDownloadBlocks);
                                }
                                $this$forEach$iv = downloadBlocks;
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    downloadBlock = (DownloadBlockInfo)element$iv;
                                    $i$a$-forEach-ParallelFileDownloaderImpl$run$1 = false;
                                    v3 = this.getDelegate();
                                    if (v3 != null) {
                                        v3.onDownloadBlockUpdated(this.getDownloadInfo(), (DownloadBlock)downloadBlock, this.totalDownloadBlocks);
                                    }
                                }
                            }
                            if (((Collection)sliceFileDownloadsList).isEmpty() == false) {
                                this.executorService = Executors.newFixedThreadPool(sliceFileDownloadsList.size());
                            }
                            this.downloadSliceFiles(openingRequest, sliceFileDownloadsList);
                            this.waitAndPerformProgressReporting();
                            this.getDownloadInfo().setDownloaded(this.downloaded);
                            this.getDownloadInfo().setTotal(this.total);
                        }
                    } else {
                        throw new FetchException("empty_response_body");
lbl89:
                        // 2 sources

                        if (!(openingResponse != null || this.getInterrupted() || this.getTerminated() || this.isDownloadComplete())) {
                            throw new FetchException("empty_response_body");
                        }
                        v4 = openingResponse;
                        v5 = v4 != null ? !v4.isSuccessful() : false;
                        if (v5 && !this.getInterrupted() && !this.getTerminated() && !this.isDownloadComplete()) {
                            throw new FetchException("request_not_successful");
                        }
                        if (!(this.getInterrupted() || this.getTerminated() || this.isDownloadComplete())) {
                            throw new FetchException("unknown");
                        }
                    }
                    this.getDownloadInfo().setDownloaded(this.downloaded);
                    this.getDownloadInfo().setTotal(this.total);
                    this.throwExceptionIfFound();
                    if (this.isDownloadComplete() || this.getTerminated() || this.getInterrupted()) break block70;
                    v6 = this.getDelegate();
                    if (v6 != null) {
                        v6.saveDownloadProgress(this.getDownloadInfo());
                    }
                    this.getDownloadInfo().setEtaInMilliSeconds(this.estimatedTimeRemainingInMilliseconds);
                    this.getDownloadInfo().setDownloadedBytesPerSecond(this.getAverageDownloadedBytesPerSecond());
                    v7 = this.getDelegate();
                    if (v7 != null) {
                        v7.onProgress(this.getDownloadInfo(), this.getDownloadInfo().getEtaInMilliSeconds(), this.getDownloadInfo().getDownloadedBytesPerSecond());
                    }
                    break block71;
                }
                if (this.getInterrupted() || this.getTerminated() || !this.isDownloadComplete()) break block71;
                if (!this.totalUnknown) {
                    fileSlicesTotal = 0L;
                    $this$forEach$iv = this.fileSlices;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (FileSlice)element$iv;
                        $i$a$-forEach-ParallelFileDownloaderImpl$run$2 = false;
                        fileSlicesTotal += it.getDownloaded();
                    }
                    if (fileSlicesTotal != this.total) {
                        this.throwable = new FetchException("download_incomplete");
                        this.throwExceptionIfFound();
                    }
                } else {
                    this.total = this.downloaded;
                    this.getDownloadInfo().setDownloaded(this.downloaded);
                    this.getDownloadInfo().setTotal(this.total);
                }
                if (!this.getTerminated() && !this.getInterrupted()) {
                    v8 = this.getDelegate();
                    if (v8 != null) {
                        v8.saveDownloadProgress(this.getDownloadInfo());
                    }
                }
                if (!this.hashCheckingEnabled) ** GOTO lbl152
                if (openingResponse != null && this.downloader.verifyContentHash(openingResponse.getRequest(), openingResponse.getHash())) {
                    FetchUtils.deleteAllInFolderForId(this.getDownloadInfo().getId(), this.fileTempDir);
                    if (!this.getInterrupted() && !this.getTerminated()) {
                        this.getDownloadInfo().setEtaInMilliSeconds(this.estimatedTimeRemainingInMilliseconds);
                        this.getDownloadInfo().setDownloadedBytesPerSecond(this.getAverageDownloadedBytesPerSecond());
                        completedDownload = this.getDownloadInfo().copy();
                        v9 = this.getDelegate();
                        if (v9 != null) {
                            v9.onProgress(this.getDownloadInfo(), this.getDownloadInfo().getEtaInMilliSeconds(), this.getDownloadInfo().getDownloadedBytesPerSecond());
                        }
                        this.getDownloadInfo().setEtaInMilliSeconds(-1L);
                        this.getDownloadInfo().setDownloadedBytesPerSecond(-1L);
                        v10 = this.getDelegate();
                        if (v10 != null) {
                            v10.onComplete(completedDownload);
                        }
                    }
                } else {
                    FetchUtils.deleteAllInFolderForId(this.getDownloadInfo().getId(), this.fileTempDir);
                    throw new FetchException("invalid content hash");
lbl152:
                    // 1 sources

                    FetchUtils.deleteAllInFolderForId(this.getDownloadInfo().getId(), this.fileTempDir);
                    if (!this.getInterrupted() && !this.getTerminated()) {
                        this.getDownloadInfo().setEtaInMilliSeconds(this.estimatedTimeRemainingInMilliseconds);
                        this.getDownloadInfo().setDownloadedBytesPerSecond(this.getAverageDownloadedBytesPerSecond());
                        completedDownload = this.getDownloadInfo().copy();
                        v11 = this.getDelegate();
                        if (v11 != null) {
                            v11.onProgress(this.getDownloadInfo(), this.getDownloadInfo().getEtaInMilliSeconds(), this.getDownloadInfo().getDownloadedBytesPerSecond());
                        }
                        this.getDownloadInfo().setEtaInMilliSeconds(-1L);
                        this.getDownloadInfo().setDownloadedBytesPerSecond(-1L);
                        v12 = this.getDelegate();
                        if (v12 != null) {
                            v12.onComplete(completedDownload);
                        }
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [1 : 1586->1607)] { 
lbl-1000:
            // 1 sources

            {
                v13 = this.executorService;
                if (v13 != null) {
                    v13.shutdown();
                }
            }
lbl172:
            // 1 sources

            catch (Exception e) {
                this.logger.e("FileDownloader", (Throwable)e);
            }
            try {
                v14 = this.outputResourceWrapper;
                if (v14 != null) {
                    v14.close();
                }
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", (Throwable)e);
            }
            if (openingResponse != null) {
                try {
                    this.downloader.disconnect(openingResponse);
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", (Throwable)e);
                }
            }
            this.setTerminated(true);
            break block69;
            catch (Exception e) {
                if (this.getInterrupted() || this.getTerminated()) break block69;
                this.logger.e("FileDownloader download:" + this.getDownload(), (Throwable)e);
                error = FetchErrorUtils.getErrorFromThrowable(e);
                error.setThrowable(e);
                if (openingResponse != null) {
                    error.setHttpResponse(FetchCoreUtils.copyDownloadResponseNoStream(openingResponse));
                }
                if (this.retryOnNetworkGain) {
                    disconnectDetected = this.networkInfoProvider.isNetworkAvailable() == false;
                    for (i = 1; i < 11; ++i) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            this.logger.e("FileDownloader", (Throwable)e);
                            break;
                        }
                        if (this.networkInfoProvider.isNetworkAvailable()) continue;
                        disconnectDetected = true;
                        break;
                    }
                    if (disconnectDetected) {
                        error = Error.NO_NETWORK_CONNECTION;
                    }
                }
                this.getDownloadInfo().setDownloaded(this.downloaded);
                this.getDownloadInfo().setTotal(this.total);
                this.getDownloadInfo().setError(error);
                if (!this.getTerminated() && !this.getInterrupted()) {
                    this.getDownloadInfo().setEtaInMilliSeconds(-1L);
                    this.getDownloadInfo().setDownloadedBytesPerSecond(-1L);
                    v15 = this.getDelegate();
                    if (v15 != null) {
                        v15.onError(this.getDownloadInfo(), error, e);
                    }
                }
                break block69;
            }
            finally {
                try {
                    v16 = this.executorService;
                    if (v16 != null) {
                        v16.shutdown();
                    }
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", (Throwable)e);
                }
                try {
                    v17 = this.outputResourceWrapper;
                    if (v17 != null) {
                        v17.close();
                    }
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", (Throwable)e);
                }
                if (openingResponse != null) {
                    try {
                        this.downloader.disconnect(openingResponse);
                    }
                    catch (Exception e) {
                        this.logger.e("FileDownloader", (Throwable)e);
                    }
                }
                this.setTerminated(true);
            }
        }
    }

    private final List<FileSlice> getFileSliceList(boolean acceptsRanges, Downloader.ServerRequest request) {
        List list;
        if (!this.storageResolver.fileExists(this.getDownloadInfo().getFile())) {
            FetchUtils.deleteAllInFolderForId(this.getDownloadInfo().getId(), this.fileTempDir);
        }
        int previousSliceSize = FetchUtils.getPreviousSliceCount(this.getDownloadInfo().getId(), this.fileTempDir);
        if (acceptsRanges && !this.totalUnknown) {
            FileSliceInfo fileSliceInfo = this.getChuckInfo(request);
            if (previousSliceSize != fileSliceInfo.getSlicingCount()) {
                FetchUtils.deleteAllInFolderForId(this.getDownloadInfo().getId(), this.fileTempDir);
            }
            FetchUtils.saveCurrentSliceCount(this.getDownloadInfo().getId(), fileSliceInfo.getSlicingCount(), this.fileTempDir);
            long counterBytes = 0L;
            List fileSlices = new ArrayList();
            int position = 1;
            int n = fileSliceInfo.getSlicingCount();
            if (position <= n) {
                while (!this.getInterrupted() && !this.getTerminated()) {
                    long endBytes;
                    long startBytes = counterBytes;
                    counterBytes = endBytes = fileSliceInfo.getSlicingCount() == position ? this.total : counterBytes + fileSliceInfo.getBytesPerFileSlice();
                    FileSlice fileSlice = new FileSlice(this.getDownloadInfo().getId(), position, startBytes, endBytes, FetchUtils.getSavedDownloadedInfo(this.getDownloadInfo().getId(), position, this.fileTempDir));
                    this.downloaded += fileSlice.getDownloaded();
                    fileSlices.add(fileSlice);
                    if (position == n) break;
                    ++position;
                }
            }
            list = fileSlices;
        } else {
            if (previousSliceSize != 1) {
                FetchUtils.deleteAllInFolderForId(this.getDownloadInfo().getId(), this.fileTempDir);
            }
            FetchUtils.saveCurrentSliceCount(this.getDownloadInfo().getId(), 1, this.fileTempDir);
            FileSlice fileSlice = new FileSlice(this.getDownloadInfo().getId(), 1, 0L, this.total, FetchUtils.getSavedDownloadedInfo(this.getDownloadInfo().getId(), 1, this.fileTempDir));
            this.downloaded += fileSlice.getDownloaded();
            list = CollectionsKt.listOf((Object)fileSlice);
        }
        return list;
    }

    private final FileSliceInfo getChuckInfo(Downloader.ServerRequest request) {
        Integer n = this.downloader.getFileSlicingCount(request, this.total);
        int fileSliceSize = n != null ? n : -1;
        return FetchUtils.getFileSliceInfo(fileSliceSize, this.total);
    }

    private final long getAverageDownloadedBytesPerSecond() {
        if (this.averageDownloadedBytesPerSecond < 1.0) {
            return 0L;
        }
        return (long)Math.ceil(this.averageDownloadedBytesPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void waitAndPerformProgressReporting() {
        long reportingStopTime = 0L;
        long downloadSpeedStopTime = 0L;
        long downloadedBytesPerSecond = this.downloaded;
        long reportingStartTime = System.nanoTime();
        long downloadSpeedStartTime = System.nanoTime();
        while (this.actionsCounter != this.actionsTotal && !this.getInterrupted() && !this.getTerminated()) {
            boolean hasReportingTimeElapsed;
            this.getDownloadInfo().setDownloaded(this.downloaded);
            this.getDownloadInfo().setTotal(this.total);
            downloadSpeedStopTime = System.nanoTime();
            boolean downloadSpeedCheckTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)downloadSpeedStartTime, (long)downloadSpeedStopTime, (long)1000L);
            if (downloadSpeedCheckTimeElapsed) {
                downloadedBytesPerSecond = this.downloaded - downloadedBytesPerSecond;
                this.movingAverageCalculator.add((double)downloadedBytesPerSecond);
                this.averageDownloadedBytesPerSecond = AverageCalculator.getMovingAverageWithWeightOnRecentValues$default((AverageCalculator)this.movingAverageCalculator, (int)0, (int)1, null);
                this.estimatedTimeRemainingInMilliseconds = FetchCoreUtils.calculateEstimatedTimeRemainingInMilliseconds((long)this.downloaded, (long)this.total, (long)this.getAverageDownloadedBytesPerSecond());
                downloadedBytesPerSecond = this.downloaded;
            }
            if (hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)(reportingStopTime = System.nanoTime()), (long)this.progressReportingIntervalMillis)) {
                Object object = this.lock;
                synchronized (object) {
                    boolean bl = false;
                    if (!this.getInterrupted() && !this.getTerminated()) {
                        this.getDownloadInfo().setDownloaded(this.downloaded);
                        this.getDownloadInfo().setTotal(this.total);
                        FileDownloader.Delegate delegate = this.getDelegate();
                        if (delegate != null) {
                            delegate.saveDownloadProgress(this.getDownloadInfo());
                        }
                        this.getDownloadInfo().setEtaInMilliSeconds(this.estimatedTimeRemainingInMilliseconds);
                        this.getDownloadInfo().setDownloadedBytesPerSecond(this.getAverageDownloadedBytesPerSecond());
                        FileDownloader.Delegate delegate2 = this.getDelegate();
                        if (delegate2 != null) {
                            delegate2.onProgress(this.getDownloadInfo(), this.getDownloadInfo().getEtaInMilliSeconds(), this.getDownloadInfo().getDownloadedBytesPerSecond());
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                reportingStartTime = System.nanoTime();
            }
            if (downloadSpeedCheckTimeElapsed) {
                downloadSpeedStartTime = System.nanoTime();
            }
            try {
                Thread.sleep(this.progressReportingIntervalMillis);
            }
            catch (InterruptedException e) {
                this.logger.e("FileDownloader", (Throwable)e);
            }
        }
    }

    private final void downloadSliceFiles(Downloader.ServerRequest request, List<FileSlice> fileSlicesDownloadsList) {
        this.actionsCounter = 0;
        this.actionsTotal = fileSlicesDownloadsList.size();
        if (!this.storageResolver.fileExists(request.getFile())) {
            this.storageResolver.createFile(request.getFile(), this.initialDownload.getEnqueueAction() == EnqueueAction.INCREMENT_FILE_NAME);
        }
        if (this.preAllocateFileOnCreation) {
            this.storageResolver.preAllocateFile(request.getFile(), this.getDownloadInfo().getTotal());
        }
        OutputResourceWrapper outputResourceWrapper = this.outputResourceWrapper = this.storageResolver.getRequestOutputResourceWrapper(request);
        if (outputResourceWrapper != null) {
            outputResourceWrapper.setWriteOffset(0L);
        }
        for (FileSlice fileSlice : fileSlicesDownloadsList) {
            if (this.getInterrupted() || this.getTerminated()) break;
            ExecutorService executorService = this.executorService;
            if (executorService == null) continue;
            executorService.execute(() -> ParallelFileDownloaderImpl.downloadSliceFiles$lambda$7(this, fileSlice));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void incrementActionCompletedCount() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            ++this.actionsCounter;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean isDownloadComplete() {
        return (this.downloaded > 0L && this.total > 0L || this.totalUnknown) && this.downloaded >= this.total;
    }

    private final void setIsTotalUnknown(Downloader.Response response2) {
        if (response2.isSuccessful() && response2.getContentLength() == -1L) {
            this.totalUnknown = true;
        }
    }

    private final void throwExceptionIfFound() {
        Throwable exception = this.throwable;
        if (exception != null) {
            throw exception;
        }
    }

    private static final DownloadInfo downloadInfo_delegate$lambda$0(ParallelFileDownloaderImpl this$0) {
        Download download = this$0.initialDownload;
        FileDownloader.Delegate delegate = this$0.getDelegate();
        Intrinsics.checkNotNull((Object)delegate);
        return FetchTypeConverterExtensions.toDownloadInfo(download, delegate.getNewDownloadInfoInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static final void downloadSliceFiles$lambda$7(ParallelFileDownloaderImpl this$0, FileSlice $fileSlice) {
        block41: {
            RandomAccessFile saveRandomAccessFile;
            Downloader.Response downloadResponse;
            block40: {
                try {
                    Thread.currentThread().setName(this$0.getDownloadInfo().getNamespace() + "-" + this$0.getDownloadInfo().getId() + "-Slice-" + $fileSlice.getPosition());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DownloadBlockInfo downloadBlock = new DownloadBlockInfo();
                downloadBlock.setDownloadId($fileSlice.getId());
                downloadBlock.setBlockPosition($fileSlice.getPosition());
                downloadBlock.setDownloadedBytes($fileSlice.getDownloaded());
                downloadBlock.setStartByte($fileSlice.getStartBytes());
                downloadBlock.setEndByte($fileSlice.getEndBytes());
                Downloader.ServerRequest downloadRequest = FetchUtils.getRequestForDownload$default(this$0.getDownloadInfo(), $fileSlice.getStartBytes() + $fileSlice.getDownloaded(), 0L, null, $fileSlice.getPosition() + 1, 12, null);
                downloadResponse = null;
                saveRandomAccessFile = null;
                File file = FetchCoreUtils.getFile((String)FetchUtils.getDownloadedInfoFilePath($fileSlice.getId(), $fileSlice.getPosition(), this$0.fileTempDir));
                saveRandomAccessFile = new RandomAccessFile(file, "rw");
                downloadResponse = this$0.downloader.execute(downloadRequest, (InterruptMonitor)this$0.interruptMonitor);
                if (!this$0.getTerminated() && !this$0.getInterrupted()) {
                    Downloader.Response response2 = downloadResponse;
                    boolean bl = response2 != null ? response2.isSuccessful() : false;
                    if (bl) {
                        long reportingStopTime = 0L;
                        int bufferSize = this$0.downloader.getRequestBufferSize(downloadRequest);
                        byte[] buffer = new byte[bufferSize];
                        InputStream inputStream = downloadResponse.getByteStream();
                        int read = inputStream != null ? inputStream.read(buffer, 0, bufferSize) : -1;
                        long naturalEnd = $fileSlice.getEndBytes() < 1L ? 0L : $fileSlice.getEndBytes();
                        long remainderBytes = naturalEnd - ($fileSlice.getStartBytes() + $fileSlice.getDownloaded());
                        long reportingStartTime = 0L;
                        reportingStartTime = System.nanoTime();
                        int streamBytes = 0;
                        long seekPosition = 0L;
                        while (!(!this$0.totalUnknown && remainderBytes <= 0L || read == -1 || this$0.getInterrupted() || this$0.getTerminated())) {
                            int n;
                            if (this$0.totalUnknown || (long)read <= remainderBytes) {
                                n = read;
                            } else {
                                read = -1;
                                n = (int)remainderBytes;
                            }
                            streamBytes = n;
                            seekPosition = $fileSlice.getStartBytes() + $fileSlice.getDownloaded();
                            Object object = this$0.lock;
                            synchronized (object) {
                                boolean bl2 = false;
                                if (!this$0.getInterrupted() && !this$0.getTerminated()) {
                                    boolean hasReportingTimeElapsed;
                                    OutputResourceWrapper outputResourceWrapper = this$0.outputResourceWrapper;
                                    if (outputResourceWrapper != null) {
                                        outputResourceWrapper.setWriteOffset(seekPosition);
                                    }
                                    OutputResourceWrapper outputResourceWrapper2 = this$0.outputResourceWrapper;
                                    if (outputResourceWrapper2 != null) {
                                        outputResourceWrapper2.write(buffer, 0, streamBytes);
                                    }
                                    if (!this$0.getInterrupted() && !this$0.getTerminated()) {
                                        $fileSlice.setDownloaded($fileSlice.getDownloaded() + (long)streamBytes);
                                        saveRandomAccessFile.seek(0L);
                                        saveRandomAccessFile.setLength(0L);
                                        saveRandomAccessFile.writeLong($fileSlice.getDownloaded());
                                        this$0.downloaded += (long)streamBytes;
                                    }
                                    if (hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)(reportingStopTime = System.nanoTime()), (long)this$0.progressReportingIntervalMillis)) {
                                        if (!this$0.getInterrupted() && !this$0.getTerminated()) {
                                            downloadBlock.setDownloadedBytes($fileSlice.getDownloaded());
                                            FileDownloader.Delegate delegate = this$0.getDelegate();
                                            if (delegate != null) {
                                                delegate.onDownloadBlockUpdated(this$0.getDownloadInfo(), (DownloadBlock)downloadBlock, this$0.totalDownloadBlocks);
                                            }
                                        }
                                        reportingStartTime = System.nanoTime();
                                    }
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            if (this$0.getInterrupted() || this$0.getTerminated() || read == -1) continue;
                            InputStream inputStream2 = downloadResponse.getByteStream();
                            int n2 = read = inputStream2 != null ? inputStream2.read(buffer, 0, bufferSize) : -1;
                            if (this$0.totalUnknown) continue;
                            remainderBytes = naturalEnd - ($fileSlice.getStartBytes() + $fileSlice.getDownloaded());
                        }
                        break block40;
                    }
                }
                if (downloadResponse == null && !this$0.getInterrupted() && !this$0.getTerminated()) {
                    throw new FetchException("empty_response_body");
                }
                Downloader.Response response3 = downloadResponse;
                boolean bl = response3 != null ? !response3.isSuccessful() : false;
                if (bl && !this$0.getInterrupted() && !this$0.getTerminated()) {
                    throw new FetchException("request_not_successful");
                }
                if (this$0.getInterrupted() || this$0.getTerminated()) break block40;
                throw new FetchException("unknown");
            }
            try {
                if (downloadResponse != null) {
                    this$0.downloader.disconnect(downloadResponse);
                }
            }
            catch (Exception e) {
                this$0.logger.e("FileDownloader", (Throwable)e);
            }
            try {
                saveRandomAccessFile.close();
            }
            catch (Exception e) {
                this$0.logger.e("FileDownloader", (Throwable)e);
            }
            this$0.incrementActionCompletedCount();
            break block41;
            catch (Exception e) {
                try {
                    this$0.logger.e("FileDownloader downloads slice " + $fileSlice, (Throwable)e);
                    this$0.throwable = e;
                }
                catch (Throwable throwable) {
                    try {
                        if (downloadResponse != null) {
                            this$0.downloader.disconnect(downloadResponse);
                        }
                    }
                    catch (Exception e2) {
                        this$0.logger.e("FileDownloader", (Throwable)e2);
                    }
                    try {
                        RandomAccessFile randomAccessFile = saveRandomAccessFile;
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                    }
                    catch (Exception e3) {
                        this$0.logger.e("FileDownloader", (Throwable)e3);
                    }
                    this$0.incrementActionCompletedCount();
                    throw throwable;
                }
                try {
                    if (downloadResponse != null) {
                        this$0.downloader.disconnect(downloadResponse);
                    }
                }
                catch (Exception e4) {
                    this$0.logger.e("FileDownloader", (Throwable)e4);
                }
                try {
                    RandomAccessFile randomAccessFile = saveRandomAccessFile;
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (Exception e5) {
                    this$0.logger.e("FileDownloader", (Throwable)e5);
                }
                this$0.incrementActionCompletedCount();
            }
        }
    }
}

