/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2;

import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.InterruptMonitor;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\t\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00014B\u001f\b\u0007\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nJ\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J8\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00170\r2\u001c\u0010\u0018\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00170\rH\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000eH\u0016J\"\u0010#\u001a\u00020\u00162\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00170\rH\u0016J\b\u0010$\u001a\u00020!H\u0016J\u0012\u0010%\u001a\u00020!2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0002J\u001f\u0010&\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(H\u0016\u00a2\u0006\u0002\u0010)J\u001e\u0010*\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070,H\u0016J\u0018\u0010-\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0016H\u0016J\u0018\u0010/\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u000eH\u0016J\u0010\u00100\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u00101\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u00102\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u00070,2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader;", "Lcom/tonyodev/fetch2core/Downloader;", "Ljava/net/HttpURLConnection;", "Ljava/lang/Void;", "httpUrlConnectionPreferences", "Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;", "fileDownloaderType", "Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;", "<init>", "(Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;)V", "(Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;)V", "connectionPrefs", "connections", "", "Lcom/tonyodev/fetch2core/Downloader$Response;", "cookieManager", "Ljava/net/CookieManager;", "onPreClientExecute", "client", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "getCleanedHeaders", "", "", "responseHeaders", "execute", "interruptMonitor", "Lcom/tonyodev/fetch2core/InterruptMonitor;", "isResponseOk", "", "responseCode", "", "disconnect", "", "response", "getContentHash", "close", "disconnectClient", "getFileSlicingCount", "contentLength", "", "(Lcom/tonyodev/fetch2core/Downloader$ServerRequest;J)Ljava/lang/Integer;", "getRequestFileDownloaderType", "supportedFileDownloaderTypes", "", "verifyContentHash", "hash", "onServerResponse", "getHeadRequestMethodSupported", "getRequestBufferSize", "getRequestContentLength", "getRequestSupportedFileDownloaderTypes", "HttpUrlConnectionPreferences", "fetch2_release"})
@SourceDebugExtension(value={"SMAP\nHttpUrlConnectionDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpUrlConnectionDownloader.kt\ncom/tonyodev/fetch2/HttpUrlConnectionDownloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n1863#2,2:220\n1863#2,2:222\n*S KotlinDebug\n*F\n+ 1 HttpUrlConnectionDownloader.kt\ncom/tonyodev/fetch2/HttpUrlConnectionDownloader\n*L\n43#1:220,2\n149#1:222,2\n*E\n"})
public class HttpUrlConnectionDownloader
implements Downloader<HttpURLConnection, Void> {
    @NotNull
    private final Downloader.FileDownloaderType fileDownloaderType;
    @NotNull
    private final HttpUrlConnectionPreferences connectionPrefs;
    @NotNull
    private final Map<Downloader.Response, HttpURLConnection> connections;
    @NotNull
    private final CookieManager cookieManager;

    @JvmOverloads
    public HttpUrlConnectionDownloader(@Nullable HttpUrlConnectionPreferences httpUrlConnectionPreferences, @NotNull Downloader.FileDownloaderType fileDownloaderType) {
        Intrinsics.checkNotNullParameter((Object)fileDownloaderType, (String)"fileDownloaderType");
        this.fileDownloaderType = fileDownloaderType;
        HttpUrlConnectionPreferences httpUrlConnectionPreferences2 = httpUrlConnectionPreferences;
        if (httpUrlConnectionPreferences2 == null) {
            httpUrlConnectionPreferences2 = new HttpUrlConnectionPreferences();
        }
        this.connectionPrefs = httpUrlConnectionPreferences2;
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        this.connections = map;
        this.cookieManager = FetchCoreUtils.getDefaultCookieManager();
    }

    public /* synthetic */ HttpUrlConnectionDownloader(HttpUrlConnectionPreferences httpUrlConnectionPreferences, Downloader.FileDownloaderType fileDownloaderType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            httpUrlConnectionPreferences = null;
        }
        if ((n & 2) != 0) {
            fileDownloaderType = Downloader.FileDownloaderType.SEQUENTIAL;
        }
        this(httpUrlConnectionPreferences, fileDownloaderType);
    }

    public HttpUrlConnectionDownloader(@NotNull Downloader.FileDownloaderType fileDownloaderType) {
        Intrinsics.checkNotNullParameter((Object)fileDownloaderType, (String)"fileDownloaderType");
        this(null, fileDownloaderType);
    }

    @Nullable
    public Void onPreClientExecute(@NotNull HttpURLConnection client, @NotNull Downloader.ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        client.setRequestMethod(request.getRequestMethod());
        client.setReadTimeout(this.connectionPrefs.getReadTimeout());
        client.setConnectTimeout(this.connectionPrefs.getConnectTimeout());
        client.setUseCaches(this.connectionPrefs.getUsesCache());
        client.setDefaultUseCaches(this.connectionPrefs.getUsesDefaultCache());
        client.setInstanceFollowRedirects(this.connectionPrefs.getFollowsRedirect());
        client.setDoInput(true);
        Iterable $this$forEach$iv = request.getHeaders().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            client.addRequestProperty((String)it.getKey(), (String)it.getValue());
        }
        return null;
    }

    private final Map<String, List<String>> getCleanedHeaders(Map<String, List<String>> responseHeaders) {
        Map headers = new LinkedHashMap();
        for (Map.Entry<String, List<String>> responseHeader : responseHeaders.entrySet()) {
            String key = responseHeader.getKey();
            if (key == null) continue;
            Map map = headers;
            List list = responseHeader.getValue();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List list2 = list;
            map.put(key, list2);
        }
        return headers;
    }

    @Nullable
    public Downloader.Response execute(@NotNull Downloader.ServerRequest request, @NotNull InterruptMonitor interruptMonitor2) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)interruptMonitor2, (String)"interruptMonitor");
        CookieHandler.setDefault(this.cookieManager);
        URL httpUrl = new URL(request.getUrl());
        URLConnection uRLConnection = httpUrl.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection client = (HttpURLConnection)uRLConnection;
        this.onPreClientExecute(client, request);
        if (client.getRequestProperty("Referer") == null) {
            String referer = FetchCoreUtils.getRefererFromUrl((String)request.getUrl());
            client.addRequestProperty("Referer", referer);
        }
        client.connect();
        Map<String, List<String>> map = client.getHeaderFields();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getHeaderFields(...)");
        Map<String, List<String>> responseHeaders = this.getCleanedHeaders(map);
        int code = client.getResponseCode();
        if ((code == 302 || code == 301 || code == 303) && FetchCoreUtils.getHeaderValue(responseHeaders, (String[])(stringArray = new String[]{"Location"})) != null) {
            try {
                client.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] stringArray2 = new String[]{"Location"};
            String string2 = FetchCoreUtils.getHeaderValue(responseHeaders, (String[])stringArray2);
            if (string2 == null) {
                string2 = "";
            }
            httpUrl = new URL(string2);
            URLConnection uRLConnection2 = httpUrl.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection2, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            client = (HttpURLConnection)uRLConnection2;
            this.onPreClientExecute(client, request);
            if (client.getRequestProperty("Referer") == null) {
                String referer = FetchCoreUtils.getRefererFromUrl((String)request.getUrl());
                client.addRequestProperty("Referer", referer);
            }
            client.connect();
            Map<String, List<String>> map2 = client.getHeaderFields();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getHeaderFields(...)");
            responseHeaders = this.getCleanedHeaders(map2);
            code = client.getResponseCode();
        }
        boolean success = false;
        long contentLength = -1L;
        InputStream byteStream = null;
        String errorResponseString = null;
        String hash = "";
        if (this.isResponseOk(code)) {
            success = true;
            contentLength = FetchCoreUtils.getContentLengthFromHeader(responseHeaders, (long)contentLength);
            byteStream = client.getInputStream();
            hash = this.getContentHash(responseHeaders);
        } else {
            errorResponseString = FetchCoreUtils.copyStreamToString((InputStream)client.getErrorStream(), (boolean)false);
        }
        boolean acceptsRanges = FetchCoreUtils.acceptRanges((int)code, responseHeaders);
        Map<String, List<String>> map3 = client.getHeaderFields();
        Intrinsics.checkNotNullExpressionValue(map3, (String)"getHeaderFields(...)");
        this.onServerResponse(request, new Downloader.Response(code, success, contentLength, null, request, hash, map3, acceptsRanges, errorResponseString));
        Downloader.Response response2 = new Downloader.Response(code, success, contentLength, byteStream, request, hash, responseHeaders, acceptsRanges, errorResponseString);
        this.connections.put(response2, client);
        return response2;
    }

    private final boolean isResponseOk(int responseCode) {
        return 200 <= responseCode ? responseCode < 300 : false;
    }

    public void disconnect(@NotNull Downloader.Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        if (this.connections.containsKey(response2)) {
            HttpURLConnection client = this.connections.get(response2);
            this.connections.remove(response2);
            this.disconnectClient(client);
        }
    }

    @NotNull
    public String getContentHash(@NotNull Map<String, List<String>> responseHeaders) {
        Intrinsics.checkNotNullParameter(responseHeaders, (String)"responseHeaders");
        String[] stringArray = new String[]{"Content-MD5"};
        String string2 = FetchCoreUtils.getHeaderValue(responseHeaders, (String[])stringArray);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public void close() {
        Iterable $this$forEach$iv = this.connections.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            this.disconnectClient((HttpURLConnection)it.getValue());
        }
        this.connections.clear();
    }

    private final void disconnectClient(HttpURLConnection client) {
        try {
            HttpURLConnection httpURLConnection = client;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public Integer getFileSlicingCount(@NotNull Downloader.ServerRequest request, long contentLength) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return null;
    }

    @NotNull
    public Downloader.FileDownloaderType getRequestFileDownloaderType(@NotNull Downloader.ServerRequest request, @NotNull Set<? extends Downloader.FileDownloaderType> supportedFileDownloaderTypes) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(supportedFileDownloaderTypes, (String)"supportedFileDownloaderTypes");
        return this.fileDownloaderType;
    }

    public boolean verifyContentHash(@NotNull Downloader.ServerRequest request, @NotNull String hash) {
        String fileHash;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        if (((CharSequence)hash).length() == 0) {
            return true;
        }
        String string2 = fileHash = FetchCoreUtils.getFileMd5String((String)request.getFile());
        return string2 != null ? string2.contentEquals(hash) : true;
    }

    public void onServerResponse(@NotNull Downloader.ServerRequest request, @NotNull Downloader.Response response2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
    }

    public boolean getHeadRequestMethodSupported(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return false;
    }

    public int getRequestBufferSize(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return 8192;
    }

    public long getRequestContentLength(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return FetchCoreUtils.getRequestContentLength((Downloader.ServerRequest)request, (Downloader)this);
    }

    @NotNull
    public Set<Downloader.FileDownloaderType> getRequestSupportedFileDownloaderTypes(@NotNull Downloader.ServerRequest request) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.fileDownloaderType == Downloader.FileDownloaderType.SEQUENTIAL) {
            Object[] objectArray = new Downloader.FileDownloaderType[]{this.fileDownloaderType};
            return SetsKt.mutableSetOf((Object[])objectArray);
        }
        try {
            set = FetchCoreUtils.getRequestSupportedFileDownloaderTypes((Downloader.ServerRequest)request, (Downloader)this);
        }
        catch (Exception e) {
            Object[] objectArray = new Downloader.FileDownloaderType[]{this.fileDownloaderType};
            set = SetsKt.mutableSetOf((Object[])objectArray);
        }
        return set;
    }

    @JvmOverloads
    public HttpUrlConnectionDownloader(@Nullable HttpUrlConnectionPreferences httpUrlConnectionPreferences) {
        this(httpUrlConnectionPreferences, null, 2, null);
    }

    @JvmOverloads
    public HttpUrlConnectionDownloader() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;", "", "<init>", "()V", "readTimeout", "", "getReadTimeout", "()I", "setReadTimeout", "(I)V", "connectTimeout", "getConnectTimeout", "setConnectTimeout", "usesCache", "", "getUsesCache", "()Z", "setUsesCache", "(Z)V", "usesDefaultCache", "getUsesDefaultCache", "setUsesDefaultCache", "followsRedirect", "getFollowsRedirect", "setFollowsRedirect", "fetch2_release"})
    public static class HttpUrlConnectionPreferences {
        private int readTimeout = 20000;
        private int connectTimeout = 15000;
        private boolean usesCache;
        private boolean usesDefaultCache;
        private boolean followsRedirect = true;

        public final int getReadTimeout() {
            return this.readTimeout;
        }

        public final void setReadTimeout(int n) {
            this.readTimeout = n;
        }

        public final int getConnectTimeout() {
            return this.connectTimeout;
        }

        public final void setConnectTimeout(int n) {
            this.connectTimeout = n;
        }

        public final boolean getUsesCache() {
            return this.usesCache;
        }

        public final void setUsesCache(boolean bl) {
            this.usesCache = bl;
        }

        public final boolean getUsesDefaultCache() {
            return this.usesDefaultCache;
        }

        public final void setUsesDefaultCache(boolean bl) {
            this.usesDefaultCache = bl;
        }

        public final boolean getFollowsRedirect() {
            return this.followsRedirect;
        }

        public final void setFollowsRedirect(boolean bl) {
            this.followsRedirect = bl;
        }
    }
}

