/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.tonyodev.fetch2.Fetch;
import com.tonyodev.fetch2.FetchNotificationManager;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.PrioritySort;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.database.FetchDatabaseManager;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.FetchHandler;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2core.DefaultStorageResolver;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FetchLogger;
import com.tonyodev.fetch2core.FileServerDownloader;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.StorageResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b*\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001YB\u00e1\u0001\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u000b\u0012\u0006\u0010\u0013\u001a\u00020\u000b\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u000b\u0012\u0006\u0010\u0017\u001a\u00020\u000b\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u0012\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d\u0012\b\u0010\u001f\u001a\u0004\u0018\u00010 \u0012\u0006\u0010!\u001a\u00020\"\u0012\b\u0010#\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010$\u001a\u00020\t\u0012\u0006\u0010%\u001a\u00020\u000b\u0012\u0006\u0010&\u001a\u00020\u0007\u0012\u0006\u0010'\u001a\u00020\u000b\u0012\b\u0010(\u001a\u0004\u0018\u00010)\u00a2\u0006\u0004\b*\u0010+J\u0006\u0010S\u001a\u00020TJ\u0013\u0010U\u001a\u00020\u000b2\b\u0010V\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010W\u001a\u00020\u0007H\u0016J\b\u0010X\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0019\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00105R\u0011\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u00105R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010\u0016\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u00105R\u0011\u0010\u0017\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u00105R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0019\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u0013\u0010#\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010/R\u0011\u0010$\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u00103R\u0011\u0010%\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u00105R\u0011\u0010&\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u00101R\u0011\u0010'\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u00105R\u0013\u0010(\u001a\u0004\u0018\u00010)\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010R\u00a8\u0006Z"}, d2={"Lcom/tonyodev/fetch2/FetchConfiguration;", "", "appContext", "Landroid/content/Context;", "namespace", "", "concurrentLimit", "", "progressReportingIntervalMillis", "", "loggingEnabled", "", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "globalNetworkType", "Lcom/tonyodev/fetch2/NetworkType;", "logger", "Lcom/tonyodev/fetch2core/Logger;", "autoStart", "retryOnNetworkGain", "fileServerDownloader", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "hashCheckingEnabled", "fileExistChecksEnabled", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "fetchNotificationManager", "Lcom/tonyodev/fetch2/FetchNotificationManager;", "fetchDatabaseManager", "Lcom/tonyodev/fetch2/database/FetchDatabaseManager;", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "backgroundHandler", "Landroid/os/Handler;", "prioritySort", "Lcom/tonyodev/fetch2/PrioritySort;", "internetCheckUrl", "activeDownloadsCheckInterval", "createFileOnEnqueue", "maxAutoRetryAttempts", "preAllocateFileOnCreation", "fetchHandler", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "<init>", "(Landroid/content/Context;Ljava/lang/String;IJZLcom/tonyodev/fetch2core/Downloader;Lcom/tonyodev/fetch2/NetworkType;Lcom/tonyodev/fetch2core/Logger;ZZLcom/tonyodev/fetch2core/FileServerDownloader;ZZLcom/tonyodev/fetch2core/StorageResolver;Lcom/tonyodev/fetch2/FetchNotificationManager;Lcom/tonyodev/fetch2/database/FetchDatabaseManager;Landroid/os/Handler;Lcom/tonyodev/fetch2/PrioritySort;Ljava/lang/String;JZIZLcom/tonyodev/fetch2/fetch/FetchHandler;)V", "getAppContext", "()Landroid/content/Context;", "getNamespace", "()Ljava/lang/String;", "getConcurrentLimit", "()I", "getProgressReportingIntervalMillis", "()J", "getLoggingEnabled", "()Z", "getHttpDownloader", "()Lcom/tonyodev/fetch2core/Downloader;", "getGlobalNetworkType", "()Lcom/tonyodev/fetch2/NetworkType;", "getLogger", "()Lcom/tonyodev/fetch2core/Logger;", "getAutoStart", "getRetryOnNetworkGain", "getFileServerDownloader", "()Lcom/tonyodev/fetch2core/FileServerDownloader;", "getHashCheckingEnabled", "getFileExistChecksEnabled", "getStorageResolver", "()Lcom/tonyodev/fetch2core/StorageResolver;", "getFetchNotificationManager", "()Lcom/tonyodev/fetch2/FetchNotificationManager;", "getFetchDatabaseManager", "()Lcom/tonyodev/fetch2/database/FetchDatabaseManager;", "getBackgroundHandler", "()Landroid/os/Handler;", "getPrioritySort", "()Lcom/tonyodev/fetch2/PrioritySort;", "getInternetCheckUrl", "getActiveDownloadsCheckInterval", "getCreateFileOnEnqueue", "getMaxAutoRetryAttempts", "getPreAllocateFileOnCreation", "getFetchHandler", "()Lcom/tonyodev/fetch2/fetch/FetchHandler;", "getNewFetchInstanceFromConfiguration", "Lcom/tonyodev/fetch2/Fetch;", "equals", "other", "hashCode", "toString", "Builder", "fetch2_release"})
public final class FetchConfiguration {
    @NotNull
    private final Context appContext;
    @NotNull
    private final String namespace;
    private final int concurrentLimit;
    private final long progressReportingIntervalMillis;
    private final boolean loggingEnabled;
    @NotNull
    private final Downloader<?, ?> httpDownloader;
    @NotNull
    private final NetworkType globalNetworkType;
    @NotNull
    private final Logger logger;
    private final boolean autoStart;
    private final boolean retryOnNetworkGain;
    @NotNull
    private final FileServerDownloader fileServerDownloader;
    private final boolean hashCheckingEnabled;
    private final boolean fileExistChecksEnabled;
    @NotNull
    private final StorageResolver storageResolver;
    @Nullable
    private final FetchNotificationManager fetchNotificationManager;
    @Nullable
    private final FetchDatabaseManager<DownloadInfo> fetchDatabaseManager;
    @Nullable
    private final Handler backgroundHandler;
    @NotNull
    private final PrioritySort prioritySort;
    @Nullable
    private final String internetCheckUrl;
    private final long activeDownloadsCheckInterval;
    private final boolean createFileOnEnqueue;
    private final int maxAutoRetryAttempts;
    private final boolean preAllocateFileOnCreation;
    @Nullable
    private final FetchHandler fetchHandler;

    private FetchConfiguration(Context appContext, String namespace, int concurrentLimit, long progressReportingIntervalMillis, boolean loggingEnabled, Downloader<?, ?> httpDownloader, NetworkType globalNetworkType, Logger logger, boolean autoStart, boolean retryOnNetworkGain, FileServerDownloader fileServerDownloader, boolean hashCheckingEnabled, boolean fileExistChecksEnabled, StorageResolver storageResolver, FetchNotificationManager fetchNotificationManager, FetchDatabaseManager<DownloadInfo> fetchDatabaseManager, Handler backgroundHandler, PrioritySort prioritySort, String internetCheckUrl, long activeDownloadsCheckInterval, boolean createFileOnEnqueue, int maxAutoRetryAttempts, boolean preAllocateFileOnCreation, FetchHandler fetchHandler) {
        this.appContext = appContext;
        this.namespace = namespace;
        this.concurrentLimit = concurrentLimit;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.loggingEnabled = loggingEnabled;
        this.httpDownloader = httpDownloader;
        this.globalNetworkType = globalNetworkType;
        this.logger = logger;
        this.autoStart = autoStart;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.fileServerDownloader = fileServerDownloader;
        this.hashCheckingEnabled = hashCheckingEnabled;
        this.fileExistChecksEnabled = fileExistChecksEnabled;
        this.storageResolver = storageResolver;
        this.fetchNotificationManager = fetchNotificationManager;
        this.fetchDatabaseManager = fetchDatabaseManager;
        this.backgroundHandler = backgroundHandler;
        this.prioritySort = prioritySort;
        this.internetCheckUrl = internetCheckUrl;
        this.activeDownloadsCheckInterval = activeDownloadsCheckInterval;
        this.createFileOnEnqueue = createFileOnEnqueue;
        this.maxAutoRetryAttempts = maxAutoRetryAttempts;
        this.preAllocateFileOnCreation = preAllocateFileOnCreation;
        this.fetchHandler = fetchHandler;
    }

    @NotNull
    public final Context getAppContext() {
        return this.appContext;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    public final int getConcurrentLimit() {
        return this.concurrentLimit;
    }

    public final long getProgressReportingIntervalMillis() {
        return this.progressReportingIntervalMillis;
    }

    public final boolean getLoggingEnabled() {
        return this.loggingEnabled;
    }

    @NotNull
    public final Downloader<?, ?> getHttpDownloader() {
        return this.httpDownloader;
    }

    @NotNull
    public final NetworkType getGlobalNetworkType() {
        return this.globalNetworkType;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final boolean getAutoStart() {
        return this.autoStart;
    }

    public final boolean getRetryOnNetworkGain() {
        return this.retryOnNetworkGain;
    }

    @NotNull
    public final FileServerDownloader getFileServerDownloader() {
        return this.fileServerDownloader;
    }

    public final boolean getHashCheckingEnabled() {
        return this.hashCheckingEnabled;
    }

    public final boolean getFileExistChecksEnabled() {
        return this.fileExistChecksEnabled;
    }

    @NotNull
    public final StorageResolver getStorageResolver() {
        return this.storageResolver;
    }

    @Nullable
    public final FetchNotificationManager getFetchNotificationManager() {
        return this.fetchNotificationManager;
    }

    @Nullable
    public final FetchDatabaseManager<DownloadInfo> getFetchDatabaseManager() {
        return this.fetchDatabaseManager;
    }

    @Nullable
    public final Handler getBackgroundHandler() {
        return this.backgroundHandler;
    }

    @NotNull
    public final PrioritySort getPrioritySort() {
        return this.prioritySort;
    }

    @Nullable
    public final String getInternetCheckUrl() {
        return this.internetCheckUrl;
    }

    public final long getActiveDownloadsCheckInterval() {
        return this.activeDownloadsCheckInterval;
    }

    public final boolean getCreateFileOnEnqueue() {
        return this.createFileOnEnqueue;
    }

    public final int getMaxAutoRetryAttempts() {
        return this.maxAutoRetryAttempts;
    }

    public final boolean getPreAllocateFileOnCreation() {
        return this.preAllocateFileOnCreation;
    }

    @Nullable
    public final FetchHandler getFetchHandler() {
        return this.fetchHandler;
    }

    @NotNull
    public final Fetch getNewFetchInstanceFromConfiguration() {
        return Fetch.Impl.getInstance(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.tonyodev.fetch2.FetchConfiguration");
        FetchConfiguration cfr_ignored_0 = (FetchConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.appContext, (Object)((FetchConfiguration)other).appContext)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.namespace, (Object)((FetchConfiguration)other).namespace)) {
            return false;
        }
        if (this.concurrentLimit != ((FetchConfiguration)other).concurrentLimit) {
            return false;
        }
        if (this.progressReportingIntervalMillis != ((FetchConfiguration)other).progressReportingIntervalMillis) {
            return false;
        }
        if (this.loggingEnabled != ((FetchConfiguration)other).loggingEnabled) {
            return false;
        }
        if (!Intrinsics.areEqual(this.httpDownloader, ((FetchConfiguration)other).httpDownloader)) {
            return false;
        }
        if (this.globalNetworkType != ((FetchConfiguration)other).globalNetworkType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.logger, (Object)((FetchConfiguration)other).logger)) {
            return false;
        }
        if (this.autoStart != ((FetchConfiguration)other).autoStart) {
            return false;
        }
        if (this.retryOnNetworkGain != ((FetchConfiguration)other).retryOnNetworkGain) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fileServerDownloader, (Object)((FetchConfiguration)other).fileServerDownloader)) {
            return false;
        }
        if (this.hashCheckingEnabled != ((FetchConfiguration)other).hashCheckingEnabled) {
            return false;
        }
        if (this.fileExistChecksEnabled != ((FetchConfiguration)other).fileExistChecksEnabled) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.storageResolver, (Object)((FetchConfiguration)other).storageResolver)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fetchNotificationManager, (Object)((FetchConfiguration)other).fetchNotificationManager)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.fetchDatabaseManager, ((FetchConfiguration)other).fetchDatabaseManager)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.backgroundHandler, (Object)((FetchConfiguration)other).backgroundHandler)) {
            return false;
        }
        if (this.prioritySort != ((FetchConfiguration)other).prioritySort) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.internetCheckUrl, (Object)((FetchConfiguration)other).internetCheckUrl)) {
            return false;
        }
        if (this.activeDownloadsCheckInterval != ((FetchConfiguration)other).activeDownloadsCheckInterval) {
            return false;
        }
        if (this.createFileOnEnqueue != ((FetchConfiguration)other).createFileOnEnqueue) {
            return false;
        }
        if (this.maxAutoRetryAttempts != ((FetchConfiguration)other).maxAutoRetryAttempts) {
            return false;
        }
        if (this.preAllocateFileOnCreation != ((FetchConfiguration)other).preAllocateFileOnCreation) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fetchHandler, (Object)((FetchConfiguration)other).fetchHandler);
    }

    public int hashCode() {
        int result = this.appContext.hashCode();
        result = 31 * result + this.namespace.hashCode();
        result = 31 * result + this.concurrentLimit;
        result = 31 * result + Long.hashCode(this.progressReportingIntervalMillis);
        result = 31 * result + Boolean.hashCode(this.loggingEnabled);
        result = 31 * result + this.httpDownloader.hashCode();
        result = 31 * result + this.globalNetworkType.hashCode();
        result = 31 * result + this.logger.hashCode();
        result = 31 * result + Boolean.hashCode(this.autoStart);
        result = 31 * result + Boolean.hashCode(this.retryOnNetworkGain);
        result = 31 * result + this.fileServerDownloader.hashCode();
        result = 31 * result + Boolean.hashCode(this.hashCheckingEnabled);
        result = 31 * result + Boolean.hashCode(this.fileExistChecksEnabled);
        result = 31 * result + this.storageResolver.hashCode();
        if (this.fetchNotificationManager != null) {
            result = 31 * result + this.fetchNotificationManager.hashCode();
        }
        if (this.fetchDatabaseManager != null) {
            result = 31 * result + this.fetchDatabaseManager.hashCode();
        }
        if (this.backgroundHandler != null) {
            result = 31 * result + this.backgroundHandler.hashCode();
        }
        if (this.fetchHandler != null) {
            result = 31 * result + this.fetchHandler.hashCode();
        }
        result = 31 * result + this.prioritySort.hashCode();
        if (this.internetCheckUrl != null) {
            result = 31 * result + this.internetCheckUrl.hashCode();
        }
        result = 31 * result + Long.hashCode(this.activeDownloadsCheckInterval);
        result = 31 * result + Boolean.hashCode(this.createFileOnEnqueue);
        result = 31 * result + Integer.hashCode(this.maxAutoRetryAttempts);
        result = 31 * result + Boolean.hashCode(this.preAllocateFileOnCreation);
        return result;
    }

    @NotNull
    public String toString() {
        return "FetchConfiguration(appContext=" + this.appContext + ", namespace='" + this.namespace + "', concurrentLimit=" + this.concurrentLimit + ", progressReportingIntervalMillis=" + this.progressReportingIntervalMillis + ", loggingEnabled=" + this.loggingEnabled + ", httpDownloader=" + this.httpDownloader + ", globalNetworkType=" + this.globalNetworkType + ", logger=" + this.logger + ", autoStart=" + this.autoStart + ", retryOnNetworkGain=" + this.retryOnNetworkGain + ", fileServerDownloader=" + this.fileServerDownloader + ", hashCheckingEnabled=" + this.hashCheckingEnabled + ", fileExistChecksEnabled=" + this.fileExistChecksEnabled + ", storageResolver=" + this.storageResolver + ", fetchNotificationManager=" + this.fetchNotificationManager + ", fetchDatabaseManager=" + this.fetchDatabaseManager + ", backgroundHandler=" + this.backgroundHandler + ", prioritySort=" + this.prioritySort + ", internetCheckUrl=" + this.internetCheckUrl + ", activeDownloadsCheckInterval=" + this.activeDownloadsCheckInterval + ", createFileOnEnqueue=" + this.createFileOnEnqueue + ", preAllocateFileOnCreation=" + this.preAllocateFileOnCreation + ", maxAutoRetryAttempts=" + this.maxAutoRetryAttempts + ", fetchHandler=" + this.fetchHandler + ")";
    }

    public /* synthetic */ FetchConfiguration(Context appContext, String namespace, int concurrentLimit, long progressReportingIntervalMillis, boolean loggingEnabled, Downloader httpDownloader, NetworkType globalNetworkType, Logger logger, boolean autoStart, boolean retryOnNetworkGain, FileServerDownloader fileServerDownloader, boolean hashCheckingEnabled, boolean fileExistChecksEnabled, StorageResolver storageResolver, FetchNotificationManager fetchNotificationManager, FetchDatabaseManager fetchDatabaseManager, Handler backgroundHandler, PrioritySort prioritySort, String internetCheckUrl, long activeDownloadsCheckInterval, boolean createFileOnEnqueue, int maxAutoRetryAttempts, boolean preAllocateFileOnCreation, FetchHandler fetchHandler, DefaultConstructorMarker $constructor_marker) {
        this(appContext, namespace, concurrentLimit, progressReportingIntervalMillis, loggingEnabled, httpDownloader, globalNetworkType, logger, autoStart, retryOnNetworkGain, fileServerDownloader, hashCheckingEnabled, fileExistChecksEnabled, storageResolver, fetchNotificationManager, fetchDatabaseManager, backgroundHandler, prioritySort, internetCheckUrl, activeDownloadsCheckInterval, createFileOnEnqueue, maxAutoRetryAttempts, preAllocateFileOnCreation, fetchHandler);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010/\u001a\u00020\u00002\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ\u0016\u00100\u001a\u00020\u00002\u000e\u00101\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0012J\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u00103\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\fJ\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0014J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0010J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010;\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0010J\u000e\u0010<\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0010J\u000e\u0010=\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0010J\u000e\u0010>\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0010J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010@\u001a\u00020\u00002\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u0016\u0010A\u001a\u00020\u00002\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"J\u000e\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020%J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.J\u000e\u0010E\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u0010\u0010F\u001a\u00020\u00002\b\u0010G\u001a\u0004\u0018\u00010\nJ\u000e\u0010H\u001a\u00020\u00002\u0006\u0010I\u001a\u00020\u000eJ\u000e\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0010J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\fJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u0010J\u0006\u0010O\u001a\u00020PR\u0018\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/tonyodev/fetch2/FetchConfiguration$Builder;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "appContext", "kotlin.jvm.PlatformType", "Landroid/content/Context;", "namespace", "", "concurrentLimit", "", "progressReportingIntervalMillis", "", "loggingEnabled", "", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "globalNetworkType", "Lcom/tonyodev/fetch2/NetworkType;", "logger", "Lcom/tonyodev/fetch2core/Logger;", "autoStart", "retryOnNetworkGain", "fileServerDownloader", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "hashCheckEnabled", "fileExistChecksEnabled", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "fetchNotificationManager", "Lcom/tonyodev/fetch2/FetchNotificationManager;", "fetchDatabaseManager", "Lcom/tonyodev/fetch2/database/FetchDatabaseManager;", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "backgroundHandler", "Landroid/os/Handler;", "prioritySort", "Lcom/tonyodev/fetch2/PrioritySort;", "internetCheckUrl", "activeDownloadCheckInterval", "createFileOnEnqueue", "maxAutoRetryAttempts", "preAllocateFileOnCreation", "fetchHandler", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "setNamespace", "setHttpDownloader", "downloader", "setFileServerDownloader", "setProgressReportingInterval", "setDownloadConcurrentLimit", "downloadConcurrentLimit", "setGlobalNetworkType", "networkType", "enableLogging", "enabled", "setLogger", "enableAutoStart", "enableRetryOnNetworkGain", "enableHashCheck", "enableFileExistChecks", "setStorageResolver", "setNotificationManager", "setDatabaseManager", "setBackgroundHandler", "handler", "setFetchHandler", "setPrioritySort", "setInternetAccessUrlCheck", "url", "setHasActiveDownloadsCheckInterval", "intervalInMillis", "createDownloadFileOnEnqueue", "create", "setAutoRetryMaxAttempts", "autoRetryMaxAttempts", "preAllocateFile", "build", "Lcom/tonyodev/fetch2/FetchConfiguration;", "fetch2_release"})
    public static final class Builder {
        private final Context appContext;
        @NotNull
        private String namespace;
        private int concurrentLimit;
        private long progressReportingIntervalMillis;
        private boolean loggingEnabled;
        @NotNull
        private Downloader<?, ?> httpDownloader;
        @NotNull
        private NetworkType globalNetworkType;
        @NotNull
        private Logger logger;
        private boolean autoStart;
        private boolean retryOnNetworkGain;
        @NotNull
        private FileServerDownloader fileServerDownloader;
        private boolean hashCheckEnabled;
        private boolean fileExistChecksEnabled;
        @NotNull
        private StorageResolver storageResolver;
        @Nullable
        private FetchNotificationManager fetchNotificationManager;
        @Nullable
        private FetchDatabaseManager<DownloadInfo> fetchDatabaseManager;
        @Nullable
        private Handler backgroundHandler;
        @NotNull
        private PrioritySort prioritySort;
        @Nullable
        private String internetCheckUrl;
        private long activeDownloadCheckInterval;
        private boolean createFileOnEnqueue;
        private int maxAutoRetryAttempts;
        private boolean preAllocateFileOnCreation;
        @Nullable
        private FetchHandler fetchHandler;

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.appContext = context.getApplicationContext();
            this.namespace = "LibGlobalFetchLib";
            this.concurrentLimit = 1;
            this.progressReportingIntervalMillis = 2000L;
            this.httpDownloader = FetchDefaults.getDefaultDownloader();
            this.globalNetworkType = FetchDefaults.getDefaultGlobalNetworkType();
            this.logger = FetchDefaults.getDefaultLogger();
            this.autoStart = true;
            this.retryOnNetworkGain = true;
            this.fileServerDownloader = FetchDefaults.getDefaultFileServerDownloader();
            this.fileExistChecksEnabled = true;
            Context context2 = this.appContext;
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"appContext");
            Context context3 = this.appContext;
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"appContext");
            this.storageResolver = (StorageResolver)new DefaultStorageResolver(context2, FetchCoreUtils.getFileTempDir((Context)context3));
            this.prioritySort = FetchDefaults.getDefaultPrioritySort();
            this.activeDownloadCheckInterval = 300000L;
            this.createFileOnEnqueue = true;
            this.maxAutoRetryAttempts = -1;
            this.preAllocateFileOnCreation = true;
        }

        @NotNull
        public final Builder setNamespace(@Nullable String namespace) {
            CharSequence charSequence = namespace;
            this.namespace = charSequence == null || charSequence.length() == 0 ? "LibGlobalFetchLib" : namespace;
            return this;
        }

        public static /* synthetic */ Builder setNamespace$default(Builder builder, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = null;
            }
            return builder.setNamespace(string2);
        }

        @NotNull
        public final Builder setHttpDownloader(@NotNull Downloader<?, ?> downloader) {
            Intrinsics.checkNotNullParameter(downloader, (String)"downloader");
            this.httpDownloader = downloader;
            return this;
        }

        @NotNull
        public final Builder setFileServerDownloader(@NotNull FileServerDownloader fileServerDownloader) {
            Intrinsics.checkNotNullParameter((Object)fileServerDownloader, (String)"fileServerDownloader");
            this.fileServerDownloader = fileServerDownloader;
            return this;
        }

        @NotNull
        public final Builder setProgressReportingInterval(long progressReportingIntervalMillis) {
            if (progressReportingIntervalMillis < 0L) {
                throw new FetchException("progressReportingIntervalMillis cannot be less than 0");
            }
            this.progressReportingIntervalMillis = progressReportingIntervalMillis;
            return this;
        }

        @NotNull
        public final Builder setDownloadConcurrentLimit(int downloadConcurrentLimit) {
            if (downloadConcurrentLimit < 0) {
                throw new FetchException("Concurrent limit cannot be less than 0");
            }
            this.concurrentLimit = downloadConcurrentLimit;
            return this;
        }

        @NotNull
        public final Builder setGlobalNetworkType(@NotNull NetworkType networkType) {
            Intrinsics.checkNotNullParameter((Object)((Object)networkType), (String)"networkType");
            this.globalNetworkType = networkType;
            return this;
        }

        @NotNull
        public final Builder enableLogging(boolean enabled) {
            this.loggingEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setLogger(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
            return this;
        }

        @NotNull
        public final Builder enableAutoStart(boolean enabled) {
            this.autoStart = enabled;
            return this;
        }

        @NotNull
        public final Builder enableRetryOnNetworkGain(boolean enabled) {
            this.retryOnNetworkGain = enabled;
            return this;
        }

        @NotNull
        public final Builder enableHashCheck(boolean enabled) {
            this.hashCheckEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder enableFileExistChecks(boolean enabled) {
            this.fileExistChecksEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setStorageResolver(@NotNull StorageResolver storageResolver) {
            Intrinsics.checkNotNullParameter((Object)storageResolver, (String)"storageResolver");
            this.storageResolver = storageResolver;
            return this;
        }

        @NotNull
        public final Builder setNotificationManager(@Nullable FetchNotificationManager fetchNotificationManager) {
            this.fetchNotificationManager = fetchNotificationManager;
            return this;
        }

        @NotNull
        public final Builder setDatabaseManager(@Nullable FetchDatabaseManager<DownloadInfo> fetchDatabaseManager) {
            this.fetchDatabaseManager = fetchDatabaseManager;
            return this;
        }

        @NotNull
        public final Builder setBackgroundHandler(@NotNull Handler handler) {
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            if (Intrinsics.areEqual((Object)handler.getLooper().getThread(), (Object)Looper.getMainLooper().getThread())) {
                throw new IllegalAccessException("The background handler cannot use the main/ui thread");
            }
            this.backgroundHandler = handler;
            return this;
        }

        @NotNull
        public final Builder setFetchHandler(@NotNull FetchHandler fetchHandler) {
            Intrinsics.checkNotNullParameter((Object)fetchHandler, (String)"fetchHandler");
            this.fetchHandler = fetchHandler;
            return this;
        }

        @NotNull
        public final Builder setPrioritySort(@NotNull PrioritySort prioritySort) {
            Intrinsics.checkNotNullParameter((Object)((Object)prioritySort), (String)"prioritySort");
            this.prioritySort = prioritySort;
            return this;
        }

        @NotNull
        public final Builder setInternetAccessUrlCheck(@Nullable String url) {
            this.internetCheckUrl = url;
            return this;
        }

        @NotNull
        public final Builder setHasActiveDownloadsCheckInterval(long intervalInMillis) {
            if (intervalInMillis < 0L) {
                throw new FetchException("intervalInMillis cannot be less than 0");
            }
            this.activeDownloadCheckInterval = intervalInMillis;
            return this;
        }

        @NotNull
        public final Builder createDownloadFileOnEnqueue(boolean create) {
            this.createFileOnEnqueue = create;
            return this;
        }

        @NotNull
        public final Builder setAutoRetryMaxAttempts(int autoRetryMaxAttempts) {
            if (autoRetryMaxAttempts < 0) {
                throw new IllegalArgumentException("The AutoRetryMaxAttempts has to be greater than -1");
            }
            this.maxAutoRetryAttempts = autoRetryMaxAttempts;
            return this;
        }

        @NotNull
        public final Builder preAllocateFileOnCreation(boolean preAllocateFile) {
            this.preAllocateFileOnCreation = preAllocateFile;
            return this;
        }

        @NotNull
        public final FetchConfiguration build() {
            Logger prefsLogger = this.logger;
            if (prefsLogger instanceof FetchLogger) {
                ((FetchLogger)prefsLogger).setEnabled(this.loggingEnabled);
                if (Intrinsics.areEqual((Object)((FetchLogger)prefsLogger).getTag(), (Object)"fetch2")) {
                    ((FetchLogger)prefsLogger).setTag(this.namespace);
                }
            } else {
                this.logger.setEnabled(this.loggingEnabled);
            }
            Context context = this.appContext;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"appContext");
            return new FetchConfiguration(context, this.namespace, this.concurrentLimit, this.progressReportingIntervalMillis, this.loggingEnabled, this.httpDownloader, this.globalNetworkType, prefsLogger, this.autoStart, this.retryOnNetworkGain, this.fileServerDownloader, this.hashCheckEnabled, this.fileExistChecksEnabled, this.storageResolver, this.fetchNotificationManager, this.fetchDatabaseManager, this.backgroundHandler, this.prioritySort, this.internetCheckUrl, this.activeDownloadCheckInterval, this.createFileOnEnqueue, this.maxAutoRetryAttempts, this.preAllocateFileOnCreation, this.fetchHandler, null);
        }
    }
}

