/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.provider;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.Build;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2core.FetchAndroidExtensions;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0013J\u0006\u0010\u001c\u001a\u00020\u0019J\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "", "context", "Landroid/content/Context;", "internetCheckUrl", "", "(Landroid/content/Context;Ljava/lang/String;)V", "broadcastRegistered", "", "connectivityManager", "Landroid/net/ConnectivityManager;", "isNetworkAvailable", "()Z", "lock", "networkCallback", "networkChangeBroadcastReceiver", "Landroid/content/BroadcastReceiver;", "networkChangeListenerSet", "Ljava/util/HashSet;", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider$NetworkChangeListener;", "Lkotlin/collections/HashSet;", "isOnAllowedNetwork", "networkType", "Lcom/tonyodev/fetch2/NetworkType;", "notifyNetworkChangeListeners", "", "registerNetworkChangeListener", "networkChangeListener", "unregisterAllNetworkChangeListeners", "unregisterNetworkChangeListener", "NetworkChangeListener", "fetch2_release"})
public final class NetworkInfoProvider {
    private final Object lock;
    private final HashSet<NetworkChangeListener> networkChangeListenerSet;
    private final ConnectivityManager connectivityManager;
    private final BroadcastReceiver networkChangeBroadcastReceiver;
    private boolean broadcastRegistered;
    private Object networkCallback;
    private final Context context;
    private final String internetCheckUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyNetworkChangeListeners() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Iterator<NetworkChangeListener> iterator = this.networkChangeListenerSet.iterator();
            Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"networkChangeListenerSet.iterator()");
            Iterator<NetworkChangeListener> $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator<NetworkChangeListener> iterator2 = $this$forEach$iv;
            boolean bl4 = false;
            Iterator<NetworkChangeListener> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                NetworkChangeListener element$iv;
                NetworkChangeListener listener = element$iv = iterator3.next();
                boolean bl5 = false;
                listener.onNetworkChanged();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerNetworkChangeListener(@NotNull NetworkChangeListener networkChangeListener2) {
        Intrinsics.checkParameterIsNotNull((Object)networkChangeListener2, (String)"networkChangeListener");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            bl2 = this.networkChangeListenerSet.add(networkChangeListener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterNetworkChangeListener(@NotNull NetworkChangeListener networkChangeListener2) {
        Intrinsics.checkParameterIsNotNull((Object)networkChangeListener2, (String)"networkChangeListener");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            bl2 = this.networkChangeListenerSet.remove(networkChangeListener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterAllNetworkChangeListeners() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Object networkCallback2;
            boolean bl3 = false;
            this.networkChangeListenerSet.clear();
            if (this.broadcastRegistered) {
                try {
                    this.context.unregisterReceiver(this.networkChangeBroadcastReceiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Build.VERSION.SDK_INT >= 21 && this.connectivityManager != null && (networkCallback2 = this.networkCallback) instanceof ConnectivityManager.NetworkCallback) {
                this.connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)networkCallback2);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean isOnAllowedNetwork(@NotNull NetworkType networkType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"networkType");
        if (networkType == NetworkType.WIFI_ONLY && FetchAndroidExtensions.isOnWiFi((Context)this.context)) {
            return true;
        }
        if (networkType == NetworkType.UNMETERED && !FetchAndroidExtensions.isOnMeteredConnection((Context)this.context)) {
            return true;
        }
        return networkType == NetworkType.ALL && FetchAndroidExtensions.isNetworkAvailable((Context)this.context);
    }

    public final boolean isNetworkAvailable() {
        boolean bl;
        String url = this.internetCheckUrl;
        if (url != null) {
            boolean bl2;
            try {
                URL urlConnection = new URL(url);
                URLConnection uRLConnection = urlConnection.openConnection();
                if (uRLConnection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
                }
                HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                connection.setConnectTimeout(15000);
                connection.setReadTimeout(20000);
                connection.setInstanceFollowRedirects(true);
                connection.setUseCaches(false);
                connection.setDefaultUseCaches(false);
                connection.connect();
                bl2 = connection.getResponseCode() != -1;
            }
            catch (Exception e) {
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = FetchAndroidExtensions.isNetworkAvailable((Context)this.context);
        }
        return bl;
    }

    public NetworkInfoProvider(@NotNull Context context, @Nullable String internetCheckUrl) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.internetCheckUrl = internetCheckUrl;
        this.lock = new Object();
        NetworkInfoProvider networkInfoProvider = this;
        boolean bl = false;
        HashSet hashSet = new HashSet();
        networkInfoProvider.networkChangeListenerSet = hashSet;
        Object object = this.context.getSystemService("connectivity");
        if (!(object instanceof ConnectivityManager)) {
            object = null;
        }
        this.connectivityManager = (ConnectivityManager)object;
        this.networkChangeBroadcastReceiver = new BroadcastReceiver(this){
            final /* synthetic */ NetworkInfoProvider this$0;

            public void onReceive(@Nullable Context context, @Nullable Intent intent) {
                NetworkInfoProvider.access$notifyNetworkChangeListeners(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        };
        if (Build.VERSION.SDK_INT >= 21 && this.connectivityManager != null) {
            NetworkRequest networkRequest = new NetworkRequest.Builder().addTransportType(0).addTransportType(1).addTransportType(3).build();
            ConnectivityManager.NetworkCallback networkCallback2 = new ConnectivityManager.NetworkCallback(this){
                final /* synthetic */ NetworkInfoProvider this$0;

                public void onLost(@Nullable Network network) {
                    NetworkInfoProvider.access$notifyNetworkChangeListeners(this.this$0);
                }

                public void onAvailable(@Nullable Network network) {
                    NetworkInfoProvider.access$notifyNetworkChangeListeners(this.this$0);
                }
                {
                    this.this$0 = $outer;
                }
            };
            this.networkCallback = networkCallback2;
            this.connectivityManager.registerNetworkCallback(networkRequest, networkCallback2);
        } else {
            try {
                this.context.registerReceiver(this.networkChangeBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                this.broadcastRegistered = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final /* synthetic */ void access$notifyNetworkChangeListeners(NetworkInfoProvider $this) {
        $this.notifyNetworkChangeListeners();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/tonyodev/fetch2/provider/NetworkInfoProvider$NetworkChangeListener;", "", "onNetworkChanged", "", "fetch2_release"})
    public static interface NetworkChangeListener {
        public void onNetworkChanged();
    }
}

