/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2;

import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.InterruptMonitor;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\t\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u00019B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0007\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0012\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u0002H\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J8\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0#0\u000e2\u001c\u0010$\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\f\u0012\n\u0012\u0004\u0012\u00020\"\u0018\u00010#0\u000eH\u0002J\"\u0010%\u001a\u00020\"2\u0018\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0#0\u000eH\u0016J\u001f\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0016\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010-\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010.\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001e\u0010/\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000501H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020'H\u0004J\u001a\u00105\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u00106\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0018\u00107\u001a\u00020,2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\"H\u0016R\u0014\u0010\n\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader;", "Lcom/tonyodev/fetch2core/Downloader;", "Ljava/net/HttpURLConnection;", "Ljava/lang/Void;", "fileDownloaderType", "Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;", "(Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;)V", "httpUrlConnectionPreferences", "Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;", "(Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;)V", "connectionPrefs", "getConnectionPrefs", "()Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;", "connections", "", "Lcom/tonyodev/fetch2core/Downloader$Response;", "getConnections", "()Ljava/util/Map;", "cookieManager", "Ljava/net/CookieManager;", "getCookieManager", "()Ljava/net/CookieManager;", "close", "", "disconnect", "response", "disconnectClient", "client", "execute", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "interruptMonitor", "Lcom/tonyodev/fetch2core/InterruptMonitor;", "getCleanedHeaders", "", "", "responseHeaders", "getContentHash", "getFileSlicingCount", "", "contentLength", "", "(Lcom/tonyodev/fetch2core/Downloader$ServerRequest;J)Ljava/lang/Integer;", "getHeadRequestMethodSupported", "", "getRequestBufferSize", "getRequestContentLength", "getRequestFileDownloaderType", "supportedFileDownloaderTypes", "", "getRequestSupportedFileDownloaderTypes", "isResponseOk", "responseCode", "onPreClientExecute", "onServerResponse", "verifyContentHash", "hash", "HttpUrlConnectionPreferences", "fetch2_release"})
public class HttpUrlConnectionDownloader
implements Downloader<HttpURLConnection, Void> {
    @NotNull
    private final HttpUrlConnectionPreferences connectionPrefs;
    @NotNull
    private final Map<Downloader.Response, HttpURLConnection> connections;
    @NotNull
    private final CookieManager cookieManager;
    private final Downloader.FileDownloaderType fileDownloaderType;

    @NotNull
    protected final HttpUrlConnectionPreferences getConnectionPrefs() {
        return this.connectionPrefs;
    }

    @NotNull
    protected final Map<Downloader.Response, HttpURLConnection> getConnections() {
        return this.connections;
    }

    @NotNull
    protected final CookieManager getCookieManager() {
        return this.cookieManager;
    }

    @Nullable
    public Void onPreClientExecute(@NotNull HttpURLConnection client, @NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        client.setRequestMethod(request.getRequestMethod());
        client.setReadTimeout(this.connectionPrefs.getReadTimeout());
        client.setConnectTimeout(this.connectionPrefs.getConnectTimeout());
        client.setUseCaches(this.connectionPrefs.getUsesCache());
        client.setDefaultUseCaches(this.connectionPrefs.getUsesDefaultCache());
        client.setInstanceFollowRedirects(this.connectionPrefs.getFollowsRedirect());
        client.setDoInput(true);
        Iterable $this$forEach$iv = request.getHeaders().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            client.addRequestProperty((String)it.getKey(), (String)it.getValue());
        }
        return null;
    }

    private final Map<String, List<String>> getCleanedHeaders(Map<String, List<String>> responseHeaders) {
        boolean bl = false;
        Map headers = new LinkedHashMap();
        Map<String, List<String>> map = responseHeaders;
        boolean bl2 = false;
        for (Map.Entry<String, List<String>> responseHeader : map.entrySet()) {
            String key = responseHeader.getKey();
            if (key == null) continue;
            List list = responseHeader.getValue();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            headers.put(key, list);
        }
        return headers;
    }

    @Nullable
    public Downloader.Response execute(@NotNull Downloader.ServerRequest request, @NotNull InterruptMonitor interruptMonitor2) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)interruptMonitor2, (String)"interruptMonitor");
        CookieHandler.setDefault(this.cookieManager);
        URL httpUrl = new URL(request.getUrl());
        URLConnection uRLConnection = httpUrl.openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection client = (HttpURLConnection)uRLConnection;
        this.onPreClientExecute(client, request);
        if (client.getRequestProperty("Referer") == null) {
            String referer = FetchCoreUtils.getRefererFromUrl((String)request.getUrl());
            client.addRequestProperty("Referer", referer);
        }
        client.connect();
        Map<String, List<String>> map = client.getHeaderFields();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"client.headerFields");
        Map<String, List<String>> responseHeaders = this.getCleanedHeaders(map);
        int code = client.getResponseCode();
        if ((code == 302 || code == 301 || code == 303) && FetchCoreUtils.getHeaderValue(responseHeaders, (String[])new String[]{"Location"}) != null) {
            String string2 = FetchCoreUtils.getHeaderValue(responseHeaders, (String[])new String[]{"Location"});
            if (string2 == null) {
                string2 = "";
            }
            httpUrl = new URL(string2);
            URLConnection uRLConnection2 = httpUrl.openConnection();
            if (uRLConnection2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            client = (HttpURLConnection)uRLConnection2;
            this.onPreClientExecute(client, request);
            if (client.getRequestProperty("Referer") == null) {
                String referer = FetchCoreUtils.getRefererFromUrl((String)request.getUrl());
                client.addRequestProperty("Referer", referer);
            }
            client.connect();
            Map<String, List<String>> map2 = client.getHeaderFields();
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"client.headerFields");
            responseHeaders = this.getCleanedHeaders(map2);
            code = client.getResponseCode();
        }
        boolean success = false;
        long contentLength = -1L;
        InputStream byteStream = null;
        String errorResponseString = null;
        String hash = "";
        if (this.isResponseOk(code)) {
            success = true;
            contentLength = FetchCoreUtils.getContentLengthFromHeader(responseHeaders, (long)contentLength);
            byteStream = client.getInputStream();
            hash = this.getContentHash(responseHeaders);
        } else {
            errorResponseString = FetchCoreUtils.copyStreamToString((InputStream)client.getErrorStream(), (boolean)false);
        }
        boolean acceptsRanges = FetchCoreUtils.acceptRanges((int)code, responseHeaders);
        Map<String, List<String>> map3 = client.getHeaderFields();
        Intrinsics.checkExpressionValueIsNotNull(map3, (String)"client.headerFields");
        this.onServerResponse(request, new Downloader.Response(code, success, contentLength, null, request, hash, map3, acceptsRanges, errorResponseString));
        Downloader.Response response2 = new Downloader.Response(code, success, contentLength, byteStream, request, hash, responseHeaders, acceptsRanges, errorResponseString);
        this.connections.put(response2, client);
        return response2;
    }

    protected final boolean isResponseOk(int responseCode) {
        int n = responseCode;
        return 200 <= n && 299 >= n;
    }

    public void disconnect(@NotNull Downloader.Response response2) {
        Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
        Map<Downloader.Response, HttpURLConnection> map = this.connections;
        boolean bl = false;
        Map<Downloader.Response, HttpURLConnection> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(response2)) {
            HttpURLConnection client = this.connections.get(response2);
            this.connections.remove(response2);
            this.disconnectClient(client);
        }
    }

    @NotNull
    public String getContentHash(@NotNull Map<String, List<String>> responseHeaders) {
        Intrinsics.checkParameterIsNotNull(responseHeaders, (String)"responseHeaders");
        String string2 = FetchCoreUtils.getHeaderValue(responseHeaders, (String[])new String[]{"Content-MD5"});
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public void close() {
        Iterable $this$forEach$iv = this.connections.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            this.disconnectClient((HttpURLConnection)it.getValue());
        }
        this.connections.clear();
    }

    private final void disconnectClient(HttpURLConnection client) {
        try {
            HttpURLConnection httpURLConnection = client;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public Integer getFileSlicingCount(@NotNull Downloader.ServerRequest request, long contentLength) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return null;
    }

    @NotNull
    public Downloader.FileDownloaderType getRequestFileDownloaderType(@NotNull Downloader.ServerRequest request, @NotNull Set<? extends Downloader.FileDownloaderType> supportedFileDownloaderTypes) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(supportedFileDownloaderTypes, (String)"supportedFileDownloaderTypes");
        return this.fileDownloaderType;
    }

    public boolean verifyContentHash(@NotNull Downloader.ServerRequest request, @NotNull String hash) {
        boolean bl;
        String fileHash;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        CharSequence charSequence = hash;
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            return true;
        }
        String string2 = fileHash = FetchCoreUtils.getFileMd5String((String)request.getFile());
        if (string2 != null) {
            String string3 = string2;
            boolean bl3 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            bl = string4.contentEquals(hash);
        } else {
            bl = true;
        }
        return bl;
    }

    public void onServerResponse(@NotNull Downloader.ServerRequest request, @NotNull Downloader.Response response2) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
    }

    public boolean getHeadRequestMethodSupported(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return false;
    }

    public int getRequestBufferSize(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return 8192;
    }

    public long getRequestContentLength(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return FetchCoreUtils.getRequestContentLength((Downloader.ServerRequest)request, (Downloader)this);
    }

    @NotNull
    public Set<Downloader.FileDownloaderType> getRequestSupportedFileDownloaderTypes(@NotNull Downloader.ServerRequest request) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        if (this.fileDownloaderType == Downloader.FileDownloaderType.SEQUENTIAL) {
            return SetsKt.mutableSetOf((Object[])new Downloader.FileDownloaderType[]{this.fileDownloaderType});
        }
        try {
            set = FetchCoreUtils.getRequestSupportedFileDownloaderTypes((Downloader.ServerRequest)request, (Downloader)this);
        }
        catch (Exception e) {
            set = SetsKt.mutableSetOf((Object[])new Downloader.FileDownloaderType[]{this.fileDownloaderType});
        }
        return set;
    }

    @JvmOverloads
    public HttpUrlConnectionDownloader(@Nullable HttpUrlConnectionPreferences httpUrlConnectionPreferences, @NotNull Downloader.FileDownloaderType fileDownloaderType) {
        Intrinsics.checkParameterIsNotNull((Object)fileDownloaderType, (String)"fileDownloaderType");
        this.fileDownloaderType = fileDownloaderType;
        HttpUrlConnectionPreferences httpUrlConnectionPreferences2 = httpUrlConnectionPreferences;
        if (httpUrlConnectionPreferences2 == null) {
            httpUrlConnectionPreferences2 = new HttpUrlConnectionPreferences();
        }
        this.connectionPrefs = httpUrlConnectionPreferences2;
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.synchronized\u2026se, HttpURLConnection>())");
        this.connections = map;
        this.cookieManager = FetchCoreUtils.getDefaultCookieManager();
    }

    public /* synthetic */ HttpUrlConnectionDownloader(HttpUrlConnectionPreferences httpUrlConnectionPreferences, Downloader.FileDownloaderType fileDownloaderType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            httpUrlConnectionPreferences = null;
        }
        if ((n & 2) != 0) {
            fileDownloaderType = Downloader.FileDownloaderType.SEQUENTIAL;
        }
        this(httpUrlConnectionPreferences, fileDownloaderType);
    }

    @JvmOverloads
    public HttpUrlConnectionDownloader(@Nullable HttpUrlConnectionPreferences httpUrlConnectionPreferences) {
        this(httpUrlConnectionPreferences, null, 2, null);
    }

    @JvmOverloads
    public HttpUrlConnectionDownloader() {
        this(null, null, 3, null);
    }

    public HttpUrlConnectionDownloader(@NotNull Downloader.FileDownloaderType fileDownloaderType) {
        Intrinsics.checkParameterIsNotNull((Object)fileDownloaderType, (String)"fileDownloaderType");
        this(null, fileDownloaderType);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;", "", "()V", "connectTimeout", "", "getConnectTimeout", "()I", "setConnectTimeout", "(I)V", "followsRedirect", "", "getFollowsRedirect", "()Z", "setFollowsRedirect", "(Z)V", "readTimeout", "getReadTimeout", "setReadTimeout", "usesCache", "getUsesCache", "setUsesCache", "usesDefaultCache", "getUsesDefaultCache", "setUsesDefaultCache", "fetch2_release"})
    public static class HttpUrlConnectionPreferences {
        private int readTimeout = 20000;
        private int connectTimeout = 15000;
        private boolean usesCache;
        private boolean usesDefaultCache;
        private boolean followsRedirect = true;

        public final int getReadTimeout() {
            return this.readTimeout;
        }

        public final void setReadTimeout(int n) {
            this.readTimeout = n;
        }

        public final int getConnectTimeout() {
            return this.connectTimeout;
        }

        public final void setConnectTimeout(int n) {
            this.connectTimeout = n;
        }

        public final boolean getUsesCache() {
            return this.usesCache;
        }

        public final void setUsesCache(boolean bl) {
            this.usesCache = bl;
        }

        public final boolean getUsesDefaultCache() {
            return this.usesDefaultCache;
        }

        public final void setUsesDefaultCache(boolean bl) {
            this.usesDefaultCache = bl;
        }

        public final boolean getFollowsRedirect() {
            return this.followsRedirect;
        }

        public final void setFollowsRedirect(boolean bl) {
            this.followsRedirect = bl;
        }
    }
}

