/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2;

import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.Extras;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileResource;
import com.tonyodev.fetch2core.FileServerDownloader;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2core.MutableExtras;
import com.tonyodev.fetch2core.server.FetchFileResourceTransporter;
import com.tonyodev.fetch2core.server.FileRequest;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00190\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00192\u0006\u0010 \u001a\u00020\u0013H\u0016J\u001f\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010)\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030+H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030+2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u00100\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00192\u0006\u00102\u001a\u00020\u0017H\u0002J\u0018\u00103\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u0017H\u0016R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/tonyodev/fetch2/FetchFileServerDownloader;", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "fileDownloaderType", "Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;", "timeout", "", "(Lcom/tonyodev/fetch2core/Downloader$FileDownloaderType;J)V", "connections", "", "Lcom/tonyodev/fetch2core/Downloader$Response;", "Lcom/tonyodev/fetch2core/server/FetchFileResourceTransporter;", "getConnections", "()Ljava/util/Map;", "close", "", "disconnect", "response", "execute", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "interruptMonitor", "Lcom/tonyodev/fetch2core/InterruptMonitor;", "getContentHash", "", "responseHeaders", "", "getExtrasFromCatalogItem", "Lcom/tonyodev/fetch2core/Extras;", "catalogItem", "Lorg/json/JSONObject;", "getFetchFileServerCatalog", "Lcom/tonyodev/fetch2core/FileResource;", "serverRequest", "getFileSlicingCount", "", "contentLength", "(Lcom/tonyodev/fetch2core/Downloader$ServerRequest;J)Ljava/lang/Integer;", "getHeadRequestMethodSupported", "", "getRequestBufferSize", "getRequestContentLength", "getRequestFileDownloaderType", "supportedFileDownloaderTypes", "", "getRequestSupportedFileDownloaderTypes", "onPreClientExecute", "Lcom/tonyodev/fetch2core/FileServerDownloader$TransporterRequest;", "client", "onServerResponse", "parseFileResourceList", "data", "verifyContentHash", "hash", "fetch2_release"})
public class FetchFileServerDownloader
implements FileServerDownloader {
    @NotNull
    private final Map<Downloader.Response, FetchFileResourceTransporter> connections;
    private final Downloader.FileDownloaderType fileDownloaderType;
    private final long timeout;

    @NotNull
    protected final Map<Downloader.Response, FetchFileResourceTransporter> getConnections() {
        return this.connections;
    }

    @NotNull
    public FileServerDownloader.TransporterRequest onPreClientExecute(@NotNull FetchFileResourceTransporter client, @NotNull Downloader.ServerRequest request) {
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Map headers = request.getHeaders();
        String string2 = (String)headers.get("Range");
        if (string2 == null) {
            string2 = "bytes=0-";
        }
        Pair range = FetchCoreUtils.getRangeForFetchFileServerRequest((String)string2);
        String string3 = (String)headers.get("Authorization");
        if (string3 == null) {
            string3 = "";
        }
        String authorization = string3;
        int port = FetchCoreUtils.getFetchFileServerPort((String)request.getUrl());
        String address = FetchCoreUtils.getFetchFileServerHostAddress((String)request.getUrl());
        MutableExtras extras = request.getExtras().toMutableExtras();
        Map $this$forEach$iv = request.getHeaders();
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            extras.putString((String)it.getKey(), (String)it.getValue());
        }
        FileServerDownloader.TransporterRequest transporterRequest = new FileServerDownloader.TransporterRequest();
        transporterRequest.setInetSocketAddress(new InetSocketAddress(address, port));
        String string4 = FetchCoreUtils.getFileResourceIdFromUrl((String)request.getUrl());
        long l = ((Number)range.getFirst()).longValue();
        long l2 = ((Number)range.getSecond()).longValue();
        String string5 = (String)headers.get("Client");
        if (string5 == null) {
            String string6 = UUID.randomUUID().toString();
            string5 = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"UUID.randomUUID().toString()");
        }
        transporterRequest.setFileRequest(new FileRequest(1, string4, l, l2, authorization, string5, (Extras)extras, (object2 = (String)headers.get("Page")) != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 0, (object = (String)headers.get("Size")) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0, false));
        return transporterRequest;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Downloader.Response execute(@NotNull Downloader.ServerRequest request, @NotNull InterruptMonitor interruptMonitor) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)interruptMonitor, (String)"interruptMonitor");
        transporter = new FetchFileResourceTransporter(null, 1, null);
        timeoutStop = 0L;
        timeoutStart = System.nanoTime();
        transporterRequest = this.onPreClientExecute(transporter, request);
        transporter.connect((SocketAddress)transporterRequest.getInetSocketAddress());
        transporter.sendFileRequest(transporterRequest.getFileRequest());
        while (!interruptMonitor.isInterrupted()) {
            block7: {
                serverResponse = transporter.receiveFileResponse();
                if (serverResponse == null) break block7;
                code = serverResponse.getStatus();
                isSuccessful = serverResponse.getConnection() == 1 && serverResponse.getType() == 1 && serverResponse.getStatus() == 206;
                contentLength = serverResponse.getContentLength();
                inputStream = transporter.getInputStream();
                errorResponse = isSuccessful == false ? FetchCoreUtils.copyStreamToString((InputStream)inputStream, (boolean)false) : null;
                var17_13 = false;
                responseHeaders = new LinkedHashMap<K, V>();
                try {
                    json = new JSONObject(serverResponse.getToJsonString());
                    v0 = json.keys();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"json.keys()");
                    $this$forEach$iv = v0;
                    $i$f$forEach = false;
                    var20_21 = $this$forEach$iv;
                    var21_22 = false;
                    var22_23 = var20_21;
                    while (var22_23.hasNext()) {
                        element$iv = var22_23.next();
                        it = (String)element$iv;
                        $i$a$-forEach-FetchFileServerDownloader$execute$1 = false;
                        v1 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                        responseHeaders.put(v1, CollectionsKt.listOf((Object)json.get(it).toString()));
                    }
                }
                catch (Exception json) {
                    // empty catch block
                }
                if (!responseHeaders.containsKey("Content-MD5")) {
                    responseHeaders.put("Content-MD5", CollectionsKt.listOf((Object)serverResponse.getMd5()));
                }
                hash = this.getContentHash(responseHeaders);
                if (code == 206) ** GOTO lbl-1000
                v2 = (List)responseHeaders.get("Accept-Ranges");
                if (Intrinsics.areEqual((Object)(v2 != null ? (String)CollectionsKt.firstOrNull((List)v2) : null), (Object)"bytes")) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                acceptsRanges = v3;
                this.onServerResponse(request, new Downloader.Response(code, isSuccessful, contentLength, null, request, hash, responseHeaders, acceptsRanges, errorResponse));
                response = new Downloader.Response(code, isSuccessful, contentLength, inputStream, request, hash, responseHeaders, acceptsRanges, errorResponse);
                this.connections.put(response, transporter);
                return response;
            }
            timeoutStop = System.nanoTime();
            if (!FetchCoreUtils.hasIntervalTimeElapsed((long)timeoutStart, (long)timeoutStop, (long)this.timeout)) continue;
            return null;
        }
        return null;
    }

    public void disconnect(@NotNull Downloader.Response response2) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
            Map<Downloader.Response, FetchFileResourceTransporter> map = this.connections;
            boolean bl = false;
            Map<Downloader.Response, FetchFileResourceTransporter> map2 = map;
            boolean bl2 = false;
            if (!map2.containsKey(response2)) break block1;
            FetchFileResourceTransporter transporter = this.connections.get(response2);
            this.connections.remove(response2);
            FetchFileResourceTransporter fetchFileResourceTransporter = transporter;
            if (fetchFileResourceTransporter != null) {
                fetchFileResourceTransporter.close();
            }
        }
    }

    public void close() {
        try {
            Iterable $this$forEach$iv = this.connections.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                ((FetchFileResourceTransporter)it.getValue()).close();
            }
            this.connections.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public Integer getFileSlicingCount(@NotNull Downloader.ServerRequest request, long contentLength) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return null;
    }

    @NotNull
    public Downloader.FileDownloaderType getRequestFileDownloaderType(@NotNull Downloader.ServerRequest request, @NotNull Set<? extends Downloader.FileDownloaderType> supportedFileDownloaderTypes) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(supportedFileDownloaderTypes, (String)"supportedFileDownloaderTypes");
        return this.fileDownloaderType;
    }

    public boolean verifyContentHash(@NotNull Downloader.ServerRequest request, @NotNull String hash) {
        boolean bl;
        String fileMd5;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        CharSequence charSequence = hash;
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            return true;
        }
        String string2 = fileMd5 = FetchCoreUtils.getFileMd5String((String)request.getFile());
        if (string2 != null) {
            String string3 = string2;
            boolean bl3 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            bl = string4.contentEquals(hash);
        } else {
            bl = true;
        }
        return bl;
    }

    @NotNull
    public String getContentHash(@NotNull Map<String, List<String>> responseHeaders) {
        Intrinsics.checkParameterIsNotNull(responseHeaders, (String)"responseHeaders");
        List<String> list = responseHeaders.get("Content-MD5");
        if (list == null || (list = (String)CollectionsKt.firstOrNull(list)) == null) {
            list = "";
        }
        return list;
    }

    public void onServerResponse(@NotNull Downloader.ServerRequest request, @NotNull Downloader.Response response2) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response2, (String)"response");
    }

    public boolean getHeadRequestMethodSupported(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return false;
    }

    public int getRequestBufferSize(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return 8192;
    }

    public long getRequestContentLength(@NotNull Downloader.ServerRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return FetchCoreUtils.getRequestContentLength((Downloader.ServerRequest)request, (Downloader)((Downloader)this));
    }

    @NotNull
    public List<FileResource> getFetchFileServerCatalog(@NotNull Downloader.ServerRequest serverRequest) {
        Downloader.Response response2;
        Intrinsics.checkParameterIsNotNull((Object)serverRequest, (String)"serverRequest");
        Downloader.Response response3 = response2 = this.execute(serverRequest, new InterruptMonitor(){

            public boolean isInterrupted() {
                return false;
            }
        });
        if ((response3 != null ? response3.getByteStream() : null) != null) {
            try {
                int type;
                int n;
                Object object = (List)response2.getResponseHeaders().get("Type");
                if (object != null && (object = (String)CollectionsKt.firstOrNull((List)object)) != null) {
                    Object object2 = object;
                    boolean bl = false;
                    n = Integer.parseInt((String)object2);
                } else {
                    n = type = -1;
                }
                if (type != 1) {
                    this.disconnect(response2);
                    throw (Throwable)new Exception("fetch_file_server_invalid_response_type");
                }
                int bufferSize = 1024;
                char[] buffer = new char[bufferSize];
                StringBuilder stringBuilder = new StringBuilder();
                InputStreamReader inputReader = new InputStreamReader(response2.getByteStream(), Charsets.UTF_8);
                int read = inputReader.read(buffer, 0, bufferSize);
                while (read != -1) {
                    stringBuilder.append(buffer, 0, read);
                    read = inputReader.read(buffer, 0, bufferSize);
                }
                inputReader.close();
                String string2 = stringBuilder.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"stringBuilder.toString()");
                String data = string2;
                CharSequence charSequence = data;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    List<FileResource> fileResourceList = this.parseFileResourceList(data);
                    this.disconnect(response2);
                    return fileResourceList;
                }
                throw (Throwable)new Exception("empty_response_body");
            }
            catch (Exception e) {
                this.disconnect(response2);
                throw (Throwable)e;
            }
        }
        throw (Throwable)new Exception("empty_response_body");
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileResource> parseFileResourceList(String data) {
        JSONObject json = new JSONObject(data);
        JSONArray catalogArray = new JSONArray(json.getString("catalog"));
        int size = catalogArray.length();
        int n = 0;
        List fileResourceList = new ArrayList();
        n = 0;
        int n2 = size;
        while (n < n2) {
            void index;
            FileResource fileResource = new FileResource();
            JSONObject catalogItem = catalogArray.getJSONObject((int)index);
            fileResource.setId(catalogItem.getLong("id"));
            String string2 = catalogItem.getString("name");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"catalogItem.getString(\"name\")");
            fileResource.setName(string2);
            fileResource.setLength(catalogItem.getLong("length"));
            JSONObject jSONObject = catalogItem;
            Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"catalogItem");
            fileResource.setExtras(this.getExtrasFromCatalogItem(jSONObject));
            String string3 = catalogItem.getString("md5");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"catalogItem.getString(\"md5\")");
            fileResource.setMd5(string3);
            fileResourceList.add(fileResource);
            ++index;
        }
        return fileResourceList;
    }

    private final Extras getExtrasFromCatalogItem(JSONObject catalogItem) {
        Extras extras;
        try {
            boolean bl = false;
            Map map = new LinkedHashMap();
            JSONObject customJson = new JSONObject(catalogItem.getString("extras"));
            Iterator iterator = customJson.keys();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"customJson.keys()");
            Iterator $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv;
            boolean bl2 = false;
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Object element$iv = iterator3.next();
                String it = (String)element$iv;
                boolean bl3 = false;
                String string2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
                String string3 = customJson.getString(it);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"customJson.getString(it)");
                map.put(string2, string3);
            }
            extras = new Extras(map);
        }
        catch (Exception e) {
            extras = Extras.CREATOR.getEmptyExtras();
        }
        return extras;
    }

    @NotNull
    public Set<Downloader.FileDownloaderType> getRequestSupportedFileDownloaderTypes(@NotNull Downloader.ServerRequest request) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            set = FetchCoreUtils.getRequestSupportedFileDownloaderTypes((Downloader.ServerRequest)request, (Downloader)((Downloader)this));
        }
        catch (Exception e) {
            set = SetsKt.mutableSetOf((Object[])new Downloader.FileDownloaderType[]{this.fileDownloaderType});
        }
        return set;
    }

    @JvmOverloads
    public FetchFileServerDownloader(@NotNull Downloader.FileDownloaderType fileDownloaderType, long timeout) {
        Intrinsics.checkParameterIsNotNull((Object)fileDownloaderType, (String)"fileDownloaderType");
        this.fileDownloaderType = fileDownloaderType;
        this.timeout = timeout;
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.synchronized\u2026leResourceTransporter>())");
        this.connections = map;
    }

    public /* synthetic */ FetchFileServerDownloader(Downloader.FileDownloaderType fileDownloaderType, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fileDownloaderType = Downloader.FileDownloaderType.SEQUENTIAL;
        }
        if ((n & 2) != 0) {
            l = 20000L;
        }
        this(fileDownloaderType, l);
    }

    @JvmOverloads
    public FetchFileServerDownloader(@NotNull Downloader.FileDownloaderType fileDownloaderType) {
        this(fileDownloaderType, 0L, 2, null);
    }

    @JvmOverloads
    public FetchFileServerDownloader() {
        this(null, 0L, 3, null);
    }
}

