/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.fetch;

import android.os.Handler;
import android.os.Looper;
import com.tonyodev.fetch2.CompletedDownload;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.EnqueueAction;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchErrorUtils;
import com.tonyodev.fetch2.FetchGroup;
import com.tonyodev.fetch2.FetchListener;
import com.tonyodev.fetch2.FetchNotificationManager;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.PrioritySort;
import com.tonyodev.fetch2.Request;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.database.FetchDatabaseManager;
import com.tonyodev.fetch2.database.FetchDatabaseManagerWrapper;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.FetchHandler;
import com.tonyodev.fetch2.fetch.FetchHandlerImpl$WhenMappings;
import com.tonyodev.fetch2.fetch.FetchModulesBuilder;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.PriorityListProcessor;
import com.tonyodev.fetch2.provider.GroupInfoProvider;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.DownloadBlock;
import com.tonyodev.fetch2core.DownloadBlockInfo;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.Extras;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FetchObserver;
import com.tonyodev.fetch2core.FileResource;
import com.tonyodev.fetch2core.FileServerDownloader;
import com.tonyodev.fetch2core.FileSliceInfo;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.Reason;
import com.tonyodev.fetch2core.StorageResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00fe\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u008d\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010 J5\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020#2\u001e\u0010*\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\n0,0+\"\b\u0012\u0004\u0012\u00020\n0,H\u0016\u00a2\u0006\u0002\u0010-J \u0010.\u001a\u00020(2\u0006\u0010/\u001a\u00020&2\u0006\u00100\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\n022\f\u00103\u001a\b\u0012\u0004\u0012\u00020#02H\u0016J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\n02H\u0016J\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020\n022\f\u00106\u001a\b\u0012\u0004\u0012\u00020702H\u0002J\u0016\u00108\u001a\u00020(2\f\u00106\u001a\b\u0012\u0004\u0012\u00020702H\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010:\u001a\u00020#H\u0016J\b\u0010;\u001a\u00020(H\u0016J\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020\n022\f\u00103\u001a\b\u0012\u0004\u0012\u00020#02H\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\n02H\u0016J$\u0010>\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010?\u001a\u00020#2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A02H\u0016J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010C\u001a\u00020AH\u0016J\u001c\u0010D\u001a\b\u0012\u0004\u0012\u00020\n022\f\u00106\u001a\b\u0012\u0004\u0012\u00020702H\u0002J\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010:\u001a\u00020#H\u0016J\u0010\u0010F\u001a\u00020(2\u0006\u0010G\u001a\u00020\u000eH\u0016J\u001c\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020J0I2\u0006\u0010K\u001a\u00020LH\u0016J(\u0010H\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020J0I022\f\u0010M\u001a\b\u0012\u0004\u0012\u00020L02H\u0016J(\u0010N\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\u000e0I022\f\u0010M\u001a\b\u0012\u0004\u0012\u00020L02H\u0016J\u0010\u0010O\u001a\u00020\n2\u0006\u0010P\u001a\u00020QH\u0016J\u001c\u0010R\u001a\b\u0012\u0004\u0012\u00020\n022\f\u0010S\u001a\b\u0012\u0004\u0012\u00020Q02H\u0016J(\u0010T\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020J0I022\f\u0010M\u001a\b\u0012\u0004\u0012\u00020L02H\u0002J\b\u0010U\u001a\u00020(H\u0016J\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020#02H\u0016J\u0018\u0010W\u001a\u00020X2\u0006\u0010K\u001a\u00020L2\u0006\u0010Y\u001a\u00020\u000eH\u0016J\u0012\u0010Z\u001a\u0004\u0018\u00010\n2\u0006\u0010:\u001a\u00020#H\u0016J\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\\022\u0006\u0010:\u001a\u00020#H\u0016J\u000e\u0010]\u001a\b\u0012\u0004\u0012\u00020\n02H\u0016J\u001c\u0010]\u001a\b\u0012\u0004\u0012\u00020\n022\f\u0010^\u001a\b\u0012\u0004\u0012\u00020#02H\u0016J\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010`\u001a\u00020XH\u0016J\u0016\u0010a\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010b\u001a\u00020\u0003H\u0016J\u0016\u0010c\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010:\u001a\u00020#H\u0016J$\u0010d\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010?\u001a\u00020#2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A02H\u0016J\u0016\u0010e\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010C\u001a\u00020AH\u0016J\u001c\u0010e\u001a\b\u0012\u0004\u0012\u00020\n022\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A02H\u0016J\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020g022\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010h\u001a\u00020i2\u0006\u0010:\u001a\u00020#H\u0016J\u000e\u0010j\u001a\b\u0012\u0004\u0012\u00020&0kH\u0016J\b\u0010l\u001a\u00020XH\u0016J&\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020\u00032\u0014\u0010p\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010qH\u0016J\u0010\u0010r\u001a\u00020\u000e2\u0006\u0010s\u001a\u00020\u000eH\u0016J\b\u0010t\u001a\u00020(H\u0016J\u001c\u0010u\u001a\b\u0012\u0004\u0012\u00020\n022\f\u00103\u001a\b\u0012\u0004\u0012\u00020#02H\u0016J\u000e\u0010v\u001a\b\u0012\u0004\u0012\u00020\n02H\u0016J\u001c\u0010w\u001a\b\u0012\u0004\u0012\u00020\n022\f\u00106\u001a\b\u0012\u0004\u0012\u00020702H\u0002J\u0016\u0010x\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010:\u001a\u00020#H\u0016J\u0010\u0010y\u001a\u00020(2\u0006\u0010z\u001a\u000207H\u0002J\u0010\u0010{\u001a\u00020\u000e2\u0006\u0010z\u001a\u000207H\u0002J\u001c\u0010|\u001a\b\u0012\u0004\u0012\u00020\n022\f\u00103\u001a\b\u0012\u0004\u0012\u00020#02H\u0016J\u000e\u0010}\u001a\b\u0012\u0004\u0012\u00020\n02H\u0016J$\u0010~\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010?\u001a\u00020#2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A02H\u0016J\u0016\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010C\u001a\u00020AH\u0016J\u001d\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020\n022\f\u00106\u001a\b\u0012\u0004\u0012\u00020702H\u0002J6\u0010\u0081\u0001\u001a\u00020(2\u0006\u0010)\u001a\u00020#2\u001e\u0010*\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\n0,0+\"\b\u0012\u0004\u0012\u00020\n0,H\u0016\u00a2\u0006\u0002\u0010-J\u0017\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010:\u001a\u00020#H\u0016J\u0011\u0010\u0083\u0001\u001a\u00020(2\u0006\u0010/\u001a\u00020&H\u0016J\u001a\u0010\u0084\u0001\u001a\u00020\n2\u0006\u0010:\u001a\u00020#2\u0007\u0010\u0085\u0001\u001a\u00020\u0003H\u0016J\u001b\u0010\u0086\u0001\u001a\u00020\n2\u0006\u0010:\u001a\u00020#2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0016J\u001c\u0010\u0089\u0001\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020#2\u0007\u0010\u008a\u0001\u001a\u00020\u000eH\u0016J\u001d\u0010\u008b\u0001\u001a\b\u0012\u0004\u0012\u00020\n022\f\u00103\u001a\b\u0012\u0004\u0012\u00020#02H\u0016J\u000f\u0010\u008c\u0001\u001a\b\u0012\u0004\u0012\u00020\n02H\u0016J\u001e\u0010\u008d\u0001\u001a\b\u0012\u0004\u0012\u00020\n022\r\u0010\u008e\u0001\u001a\b\u0012\u0004\u0012\u00020#02H\u0002J\u0017\u0010\u008f\u0001\u001a\b\u0012\u0004\u0012\u00020\n022\u0006\u0010:\u001a\u00020#H\u0016J\u001d\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020\n022\f\u00103\u001a\b\u0012\u0004\u0012\u00020#02H\u0016J\u0012\u0010\u0091\u0001\u001a\u00020(2\u0007\u0010\u0092\u0001\u001a\u00020#H\u0016J\u0013\u0010\u0093\u0001\u001a\u00020(2\b\u0010\u0094\u0001\u001a\u00030\u0095\u0001H\u0016J\t\u0010\u0096\u0001\u001a\u00020(H\u0002J\t\u0010\u0097\u0001\u001a\u00020(H\u0016J'\u0010\u0098\u0001\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0I2\u0007\u0010\u0099\u0001\u001a\u00020#2\u0007\u0010\u009a\u0001\u001a\u00020LH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009b\u0001"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchHandlerImpl;", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "namespace", "", "fetchDatabaseManagerWrapper", "Lcom/tonyodev/fetch2/database/FetchDatabaseManagerWrapper;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "priorityListProcessor", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "Lcom/tonyodev/fetch2/Download;", "logger", "Lcom/tonyodev/fetch2core/Logger;", "autoStart", "", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "fileServerDownloader", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "uiHandler", "Landroid/os/Handler;", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "fetchNotificationManager", "Lcom/tonyodev/fetch2/FetchNotificationManager;", "groupInfoProvider", "Lcom/tonyodev/fetch2/provider/GroupInfoProvider;", "prioritySort", "Lcom/tonyodev/fetch2/PrioritySort;", "createFileOnEnqueue", "(Ljava/lang/String;Lcom/tonyodev/fetch2/database/FetchDatabaseManagerWrapper;Lcom/tonyodev/fetch2/downloader/DownloadManager;Lcom/tonyodev/fetch2/helper/PriorityListProcessor;Lcom/tonyodev/fetch2core/Logger;ZLcom/tonyodev/fetch2core/Downloader;Lcom/tonyodev/fetch2core/FileServerDownloader;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;Landroid/os/Handler;Lcom/tonyodev/fetch2core/StorageResolver;Lcom/tonyodev/fetch2/FetchNotificationManager;Lcom/tonyodev/fetch2/provider/GroupInfoProvider;Lcom/tonyodev/fetch2/PrioritySort;Z)V", "isTerminating", "listenerId", "", "listenerSet", "", "Lcom/tonyodev/fetch2/FetchListener;", "addFetchObserversForDownload", "", "downloadId", "fetchObservers", "", "Lcom/tonyodev/fetch2core/FetchObserver;", "(I[Lcom/tonyodev/fetch2core/FetchObserver;)V", "addListener", "listener", "notify", "cancel", "", "ids", "cancelAll", "cancelDownloads", "downloads", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "cancelDownloadsIfDownloading", "cancelGroup", "id", "close", "delete", "deleteAll", "deleteAllInGroupWithStatus", "groupId", "statuses", "Lcom/tonyodev/fetch2/Status;", "deleteAllWithStatus", "status", "deleteDownloads", "deleteGroup", "enableLogging", "enabled", "enqueue", "Lkotlin/Pair;", "Lcom/tonyodev/fetch2/Error;", "request", "Lcom/tonyodev/fetch2/Request;", "requests", "enqueueBatch", "enqueueCompletedDownload", "completedDownload", "Lcom/tonyodev/fetch2/CompletedDownload;", "enqueueCompletedDownloads", "completedDownloads", "enqueueRequests", "freeze", "getAllGroupIds", "getContentLengthForRequest", "", "fromServer", "getDownload", "getDownloadBlocks", "Lcom/tonyodev/fetch2core/DownloadBlock;", "getDownloads", "idList", "getDownloadsByRequestIdentifier", "identifier", "getDownloadsByTag", "tag", "getDownloadsInGroup", "getDownloadsInGroupWithStatus", "getDownloadsWithStatus", "getFetchFileServerCatalog", "Lcom/tonyodev/fetch2core/FileResource;", "getFetchGroup", "Lcom/tonyodev/fetch2/FetchGroup;", "getListenerSet", "", "getPendingCount", "getServerResponse", "Lcom/tonyodev/fetch2core/Downloader$Response;", "url", "header", "", "hasActiveDownloads", "includeAddedDownloads", "init", "pause", "pauseAll", "pauseDownloads", "pausedGroup", "prepareCompletedDownloadInfoForEnqueue", "downloadInfo", "prepareDownloadInfoForEnqueue", "remove", "removeAll", "removeAllInGroupWithStatus", "removeAllWithStatus", "removeDownloads", "removeFetchObserversForDownload", "removeGroup", "removeListener", "renameCompletedDownloadFile", "newFileName", "replaceExtras", "extras", "Lcom/tonyodev/fetch2core/Extras;", "resetAutoRetryAttempts", "retryDownload", "resume", "resumeAll", "resumeDownloads", "downloadIds", "resumeGroup", "retry", "setDownloadConcurrentLimit", "downloadConcurrentLimit", "setGlobalNetworkType", "networkType", "Lcom/tonyodev/fetch2/NetworkType;", "startPriorityQueueIfNotStarted", "unfreeze", "updateRequest", "requestId", "newRequest", "fetch2_release"})
public final class FetchHandlerImpl
implements FetchHandler {
    private final int listenerId;
    private final Set<FetchListener> listenerSet;
    private volatile boolean isTerminating;
    private final String namespace;
    private final FetchDatabaseManagerWrapper fetchDatabaseManagerWrapper;
    private final DownloadManager downloadManager;
    private final PriorityListProcessor<Download> priorityListProcessor;
    private final Logger logger;
    private final boolean autoStart;
    private final Downloader<?, ?> httpDownloader;
    private final FileServerDownloader fileServerDownloader;
    private final ListenerCoordinator listenerCoordinator;
    private final Handler uiHandler;
    private final StorageResolver storageResolver;
    private final FetchNotificationManager fetchNotificationManager;
    private final GroupInfoProvider groupInfoProvider;
    private final PrioritySort prioritySort;
    private final boolean createFileOnEnqueue;

    @Override
    public void init() {
        if (this.fetchNotificationManager != null) {
            this.listenerCoordinator.addNotificationManager(this.fetchNotificationManager);
        }
        this.fetchDatabaseManagerWrapper.sanitizeOnFirstEntry();
        if (this.autoStart) {
            this.priorityListProcessor.start();
        }
    }

    @Override
    @NotNull
    public Pair<Download, Error> enqueue(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return (Pair)CollectionsKt.first(this.enqueueRequests(CollectionsKt.listOf((Object)request)));
    }

    @Override
    @NotNull
    public List<Pair<Download, Error>> enqueue(@NotNull List<? extends Request> requests) {
        Intrinsics.checkParameterIsNotNull(requests, (String)"requests");
        return this.enqueueRequests(requests);
    }

    @Override
    @NotNull
    public List<Pair<DownloadInfo, Boolean>> enqueueBatch(@NotNull List<? extends Request> requests) {
        Intrinsics.checkParameterIsNotNull(requests, (String)"requests");
        boolean bl = false;
        List downloadInfos = new ArrayList();
        Iterable $this$forEach$iv = requests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Request it = (Request)element$iv;
            boolean bl2 = false;
            DownloadInfo downloadInfo2 = FetchTypeConverterExtensions.toDownloadInfo(it, this.fetchDatabaseManagerWrapper.getNewDownloadInfoInstance());
            downloadInfo2.setNamespace(this.namespace);
            boolean existing = this.prepareDownloadInfoForEnqueue(downloadInfo2);
            downloadInfo2.setStatus(it.getDownloadOnEnqueue() ? Status.QUEUED : Status.ADDED);
            if (downloadInfo2.getStatus() == Status.COMPLETED || existing) continue;
            downloadInfos.add(downloadInfo2);
        }
        List<Pair<DownloadInfo, Boolean>> results = this.fetchDatabaseManagerWrapper.insert(downloadInfos);
        this.startPriorityQueueIfNotStarted();
        return results;
    }

    private final List<Pair<Download, Error>> enqueueRequests(List<? extends Request> requests) {
        boolean bl = false;
        List results = new ArrayList();
        Iterable $this$forEach$iv = requests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Request it = (Request)element$iv;
            boolean bl2 = false;
            DownloadInfo downloadInfo2 = FetchTypeConverterExtensions.toDownloadInfo(it, this.fetchDatabaseManagerWrapper.getNewDownloadInfoInstance());
            downloadInfo2.setNamespace(this.namespace);
            try {
                boolean existing = this.prepareDownloadInfoForEnqueue(downloadInfo2);
                if (downloadInfo2.getStatus() != Status.COMPLETED) {
                    downloadInfo2.setStatus(it.getDownloadOnEnqueue() ? Status.QUEUED : Status.ADDED);
                    if (!existing) {
                        Pair<DownloadInfo, Boolean> downloadPair = this.fetchDatabaseManagerWrapper.insert(downloadInfo2);
                        this.logger.d("Enqueued download " + (DownloadInfo)downloadPair.getFirst());
                        results.add(new Pair(downloadPair.getFirst(), (Object)Error.NONE));
                        this.startPriorityQueueIfNotStarted();
                    } else {
                        this.fetchDatabaseManagerWrapper.update(downloadInfo2);
                        this.logger.d("Updated download " + downloadInfo2);
                        results.add(new Pair((Object)downloadInfo2, (Object)Error.NONE));
                    }
                } else {
                    results.add(new Pair((Object)downloadInfo2, (Object)Error.NONE));
                }
                if (this.prioritySort != PrioritySort.DESC || this.downloadManager.canAccommodateNewDownload()) continue;
                this.priorityListProcessor.pause();
            }
            catch (Exception e) {
                Error error = FetchErrorUtils.getErrorFromThrowable(e);
                error.setThrowable(e);
                results.add(new Pair((Object)downloadInfo2, (Object)error));
            }
        }
        this.startPriorityQueueIfNotStarted();
        return results;
    }

    private final boolean prepareDownloadInfoForEnqueue(DownloadInfo downloadInfo2) {
        boolean bl;
        this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)downloadInfo2));
        DownloadInfo existingDownload = this.fetchDatabaseManagerWrapper.getByFile(downloadInfo2.getFile());
        if (existingDownload == null) {
            if (downloadInfo2.getEnqueueAction() != EnqueueAction.INCREMENT_FILE_NAME && this.createFileOnEnqueue) {
                StorageResolver.DefaultImpls.createFile$default((StorageResolver)this.storageResolver, (String)downloadInfo2.getFile(), (boolean)false, (int)2, null);
            }
        } else {
            this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)existingDownload));
            existingDownload = this.fetchDatabaseManagerWrapper.getByFile(downloadInfo2.getFile());
            if (existingDownload != null && existingDownload.getStatus() == Status.DOWNLOADING) {
                existingDownload.setStatus(Status.QUEUED);
                try {
                    this.fetchDatabaseManagerWrapper.update(existingDownload);
                }
                catch (Exception e) {
                    String string2 = e.getMessage();
                    if (string2 == null) {
                        string2 = "";
                    }
                    this.logger.e(string2, (Throwable)e);
                }
            } else {
                DownloadInfo downloadInfo3 = existingDownload;
                if ((downloadInfo3 != null ? downloadInfo3.getStatus() : null) == Status.COMPLETED && downloadInfo2.getEnqueueAction() == EnqueueAction.UPDATE_ACCORDINGLY && !this.storageResolver.fileExists(existingDownload.getFile())) {
                    try {
                        this.fetchDatabaseManagerWrapper.delete(existingDownload);
                    }
                    catch (Exception e) {
                        String string3 = e.getMessage();
                        if (string3 == null) {
                            string3 = "";
                        }
                        this.logger.e(string3, (Throwable)e);
                    }
                    existingDownload = null;
                    if (downloadInfo2.getEnqueueAction() != EnqueueAction.INCREMENT_FILE_NAME && this.createFileOnEnqueue) {
                        StorageResolver.DefaultImpls.createFile$default((StorageResolver)this.storageResolver, (String)downloadInfo2.getFile(), (boolean)false, (int)2, null);
                    }
                }
            }
        }
        switch (FetchHandlerImpl$WhenMappings.$EnumSwitchMapping$0[downloadInfo2.getEnqueueAction().ordinal()]) {
            case 1: {
                if (existingDownload != null) {
                    downloadInfo2.setDownloaded(existingDownload.getDownloaded());
                    downloadInfo2.setTotal(existingDownload.getTotal());
                    downloadInfo2.setError(existingDownload.getError());
                    downloadInfo2.setStatus(existingDownload.getStatus());
                    if (downloadInfo2.getStatus() != Status.COMPLETED) {
                        downloadInfo2.setStatus(Status.QUEUED);
                        downloadInfo2.setError(FetchDefaults.getDefaultNoError());
                    }
                    if (downloadInfo2.getStatus() == Status.COMPLETED && !this.storageResolver.fileExists(downloadInfo2.getFile())) {
                        if (this.createFileOnEnqueue) {
                            StorageResolver.DefaultImpls.createFile$default((StorageResolver)this.storageResolver, (String)downloadInfo2.getFile(), (boolean)false, (int)2, null);
                        }
                        downloadInfo2.setDownloaded(0L);
                        downloadInfo2.setTotal(-1L);
                        downloadInfo2.setStatus(Status.QUEUED);
                        downloadInfo2.setError(FetchDefaults.getDefaultNoError());
                    }
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (existingDownload != null) {
                    throw (Throwable)new FetchException("request_with_file_path_already_exist");
                }
                bl = false;
                break;
            }
            case 3: {
                if (existingDownload != null) {
                    this.deleteDownloads(CollectionsKt.listOf((Object)existingDownload));
                }
                this.deleteDownloads(CollectionsKt.listOf((Object)downloadInfo2));
                return false;
            }
            case 4: {
                if (this.createFileOnEnqueue) {
                    this.storageResolver.createFile(downloadInfo2.getFile(), true);
                }
                downloadInfo2.setFile(downloadInfo2.getFile());
                downloadInfo2.setId(FetchCoreUtils.getUniqueId((String)downloadInfo2.getUrl(), (String)downloadInfo2.getFile()));
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Download enqueueCompletedDownload(@NotNull CompletedDownload completedDownload) {
        Intrinsics.checkParameterIsNotNull((Object)completedDownload, (String)"completedDownload");
        return (Download)CollectionsKt.first(this.enqueueCompletedDownloads(CollectionsKt.listOf((Object)completedDownload)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> enqueueCompletedDownloads(@NotNull List<? extends CompletedDownload> completedDownloads) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(completedDownloads, (String)"completedDownloads");
        Iterable $this$map$iv = completedDownloads;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CompletedDownload completedDownload = (CompletedDownload)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DownloadInfo downloadInfo2 = FetchTypeConverterExtensions.toDownloadInfo((CompletedDownload)it, this.fetchDatabaseManagerWrapper.getNewDownloadInfoInstance());
            downloadInfo2.setNamespace(this.namespace);
            downloadInfo2.setStatus(Status.COMPLETED);
            this.prepareCompletedDownloadInfoForEnqueue(downloadInfo2);
            Pair<DownloadInfo, Boolean> downloadPair = this.fetchDatabaseManagerWrapper.insert(downloadInfo2);
            this.logger.d("Enqueued CompletedDownload " + (DownloadInfo)downloadPair.getFirst());
            DownloadInfo downloadInfo3 = (DownloadInfo)downloadPair.getFirst();
            collection.add(downloadInfo3);
        }
        return (List)destination$iv$iv;
    }

    private final void prepareCompletedDownloadInfoForEnqueue(DownloadInfo downloadInfo2) {
        DownloadInfo existingDownload = this.fetchDatabaseManagerWrapper.getByFile(downloadInfo2.getFile());
        if (existingDownload != null) {
            this.deleteDownloads(CollectionsKt.listOf((Object)downloadInfo2));
        }
    }

    @Override
    @NotNull
    public List<Download> pause(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.pauseDownloads(CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids)));
    }

    @Override
    @NotNull
    public List<Download> pausedGroup(int id) {
        return this.pauseDownloads(this.fetchDatabaseManagerWrapper.getByGroup(id));
    }

    private final List<Download> pauseDownloads(List<? extends DownloadInfo> downloads) {
        this.cancelDownloadsIfDownloading(downloads);
        boolean bl = false;
        List pausedDownloads = new ArrayList();
        Iterable $this$forEach$iv = downloads;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl2 = false;
            if (!FetchUtils.canPauseDownload(it)) continue;
            it.setStatus(Status.PAUSED);
            pausedDownloads.add(it);
        }
        this.fetchDatabaseManagerWrapper.update(pausedDownloads);
        return pausedDownloads;
    }

    @Override
    @NotNull
    public List<Download> pauseAll() {
        return this.pauseDownloads(this.fetchDatabaseManagerWrapper.get());
    }

    @Override
    public void freeze() {
        this.priorityListProcessor.pause();
        this.downloadManager.cancelAll();
    }

    @Override
    public void unfreeze() {
        this.priorityListProcessor.resume();
    }

    @Override
    @NotNull
    public List<Download> resume(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.resumeDownloads(ids);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> resumeGroup(int id) {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.fetchDatabaseManagerWrapper.getByGroup(id);
        FetchHandlerImpl fetchHandlerImpl = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DownloadInfo downloadInfo2 = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        return fetchHandlerImpl.resumeDownloads((List<Integer>)collection);
    }

    private final List<Download> resumeDownloads(List<Integer> downloadIds) {
        List downloads = CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(downloadIds));
        boolean bl = false;
        List resumedDownloads = new ArrayList();
        Iterable $this$forEach$iv = downloads;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl2 = false;
            if (this.downloadManager.contains(it.getId()) || !FetchUtils.canResumeDownload(it)) continue;
            it.setStatus(Status.QUEUED);
            resumedDownloads.add(it);
        }
        this.fetchDatabaseManagerWrapper.update(resumedDownloads);
        this.startPriorityQueueIfNotStarted();
        return resumedDownloads;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> resumeAll() {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.fetchDatabaseManagerWrapper.get();
        FetchHandlerImpl fetchHandlerImpl = this;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DownloadInfo downloadInfo2 = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        return fetchHandlerImpl.resumeDownloads((List<Integer>)collection);
    }

    @Override
    @NotNull
    public List<Download> remove(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.removeDownloads(CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids)));
    }

    @Override
    @NotNull
    public List<Download> removeGroup(int id) {
        return this.removeDownloads(this.fetchDatabaseManagerWrapper.getByGroup(id));
    }

    @Override
    @NotNull
    public List<Download> removeAll() {
        return this.removeDownloads(this.fetchDatabaseManagerWrapper.get());
    }

    @Override
    @NotNull
    public List<Download> removeAllWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        return this.removeDownloads(this.fetchDatabaseManagerWrapper.getByStatus(status));
    }

    @Override
    @NotNull
    public List<Download> removeAllInGroupWithStatus(int groupId, @NotNull List<? extends Status> statuses) {
        Intrinsics.checkParameterIsNotNull(statuses, (String)"statuses");
        return this.removeDownloads(this.fetchDatabaseManagerWrapper.getDownloadsInGroupWithStatus(groupId, statuses));
    }

    private final List<Download> removeDownloads(List<? extends DownloadInfo> downloads) {
        this.cancelDownloadsIfDownloading(downloads);
        this.fetchDatabaseManagerWrapper.delete((List<? extends DownloadInfo>)downloads);
        Iterable $this$forEach$iv = downloads;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl = false;
            it.setStatus(Status.REMOVED);
            FetchDatabaseManager.Delegate<DownloadInfo> delegate = this.fetchDatabaseManagerWrapper.getDelegate();
            if (delegate == null) continue;
            delegate.deleteTempFilesForDownload(it);
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<Download> delete(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.deleteDownloads(CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids)));
    }

    @Override
    @NotNull
    public List<Download> deleteGroup(int id) {
        return this.deleteDownloads(this.fetchDatabaseManagerWrapper.getByGroup(id));
    }

    @Override
    @NotNull
    public List<Download> deleteAll() {
        return this.deleteDownloads(this.fetchDatabaseManagerWrapper.get());
    }

    @Override
    @NotNull
    public List<Download> deleteAllWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        return this.deleteDownloads(this.fetchDatabaseManagerWrapper.getByStatus(status));
    }

    @Override
    @NotNull
    public List<Download> deleteAllInGroupWithStatus(int groupId, @NotNull List<? extends Status> statuses) {
        Intrinsics.checkParameterIsNotNull(statuses, (String)"statuses");
        return this.deleteDownloads(this.fetchDatabaseManagerWrapper.getDownloadsInGroupWithStatus(groupId, statuses));
    }

    private final List<Download> deleteDownloads(List<? extends DownloadInfo> downloads) {
        this.cancelDownloadsIfDownloading(downloads);
        this.fetchDatabaseManagerWrapper.delete((List<? extends DownloadInfo>)downloads);
        Iterable $this$forEach$iv = downloads;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl = false;
            it.setStatus(Status.DELETED);
            this.storageResolver.deleteFile(it.getFile());
            FetchDatabaseManager.Delegate<DownloadInfo> delegate = this.fetchDatabaseManagerWrapper.getDelegate();
            if (delegate == null) continue;
            delegate.deleteTempFilesForDownload(it);
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<Download> cancel(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.cancelDownloads(CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids)));
    }

    @Override
    @NotNull
    public List<Download> cancelGroup(int id) {
        return this.cancelDownloads(this.fetchDatabaseManagerWrapper.getByGroup(id));
    }

    @Override
    @NotNull
    public List<Download> cancelAll() {
        return this.cancelDownloads(this.fetchDatabaseManagerWrapper.get());
    }

    private final List<Download> cancelDownloads(List<? extends DownloadInfo> downloads) {
        this.cancelDownloadsIfDownloading(downloads);
        boolean bl = false;
        List cancelledDownloads = new ArrayList();
        Iterable $this$forEach$iv = downloads;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl2 = false;
            if (!FetchUtils.canCancelDownload(it)) continue;
            it.setStatus(Status.CANCELLED);
            it.setError(FetchDefaults.getDefaultNoError());
            cancelledDownloads.add(it);
        }
        this.fetchDatabaseManagerWrapper.update(cancelledDownloads);
        return cancelledDownloads;
    }

    @Override
    @NotNull
    public List<Download> retry(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        List downloadInfoList = CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids));
        boolean bl = false;
        List retryDownloads = new ArrayList();
        Iterable $this$forEach$iv = downloadInfoList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            boolean bl2 = false;
            if (!FetchUtils.canRetryDownload(it)) continue;
            it.setStatus(Status.QUEUED);
            it.setError(FetchDefaults.getDefaultNoError());
            retryDownloads.add(it);
        }
        this.fetchDatabaseManagerWrapper.update(retryDownloads);
        this.startPriorityQueueIfNotStarted();
        return retryDownloads;
    }

    @Override
    @Nullable
    public Download resetAutoRetryAttempts(int downloadId, boolean retryDownload) {
        DownloadInfo download = this.fetchDatabaseManagerWrapper.get(downloadId);
        if (download != null) {
            this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)download));
            if (retryDownload && FetchUtils.canRetryDownload(download)) {
                download.setStatus(Status.QUEUED);
                download.setError(FetchDefaults.getDefaultNoError());
            }
            download.setAutoRetryAttempts(0);
            this.fetchDatabaseManagerWrapper.update(download);
            this.startPriorityQueueIfNotStarted();
        }
        return download;
    }

    @Override
    @NotNull
    public Pair<Download, Boolean> updateRequest(int requestId, @NotNull Request newRequest) {
        Intrinsics.checkParameterIsNotNull((Object)newRequest, (String)"newRequest");
        DownloadInfo oldDownloadInfo = this.fetchDatabaseManagerWrapper.get(requestId);
        if (oldDownloadInfo != null) {
            this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)oldDownloadInfo));
            oldDownloadInfo = this.fetchDatabaseManagerWrapper.get(requestId);
        }
        if (oldDownloadInfo != null) {
            if (Intrinsics.areEqual((Object)newRequest.getFile(), (Object)oldDownloadInfo.getFile())) {
                DownloadInfo newDownloadInfo = FetchTypeConverterExtensions.toDownloadInfo(newRequest, this.fetchDatabaseManagerWrapper.getNewDownloadInfoInstance());
                newDownloadInfo.setNamespace(this.namespace);
                newDownloadInfo.setDownloaded(oldDownloadInfo.getDownloaded());
                newDownloadInfo.setTotal(oldDownloadInfo.getTotal());
                if (oldDownloadInfo.getStatus() == Status.DOWNLOADING) {
                    newDownloadInfo.setStatus(Status.QUEUED);
                    newDownloadInfo.setError(FetchDefaults.getDefaultNoError());
                } else {
                    newDownloadInfo.setStatus(oldDownloadInfo.getStatus());
                    newDownloadInfo.setError(oldDownloadInfo.getError());
                }
                this.fetchDatabaseManagerWrapper.delete(oldDownloadInfo);
                this.listenerCoordinator.getMainListener().onDeleted(oldDownloadInfo);
                this.fetchDatabaseManagerWrapper.insert(newDownloadInfo);
                this.startPriorityQueueIfNotStarted();
                return new Pair((Object)newDownloadInfo, (Object)true);
            }
        } else {
            throw (Throwable)new FetchException("request_does_not_exist");
        }
        this.delete(CollectionsKt.listOf((Object)requestId));
        Pair<Download, Error> enqueuePair = this.enqueue(newRequest);
        return new Pair(enqueuePair.getFirst(), (Object)((Error)((Object)enqueuePair.getSecond()) == Error.NONE ? 1 : 0));
    }

    @Override
    @NotNull
    public Download renameCompletedDownloadFile(int id, @NotNull String newFileName) {
        Intrinsics.checkParameterIsNotNull((Object)newFileName, (String)"newFileName");
        DownloadInfo downloadInfo2 = this.fetchDatabaseManagerWrapper.get(id);
        if (downloadInfo2 == null) {
            throw (Throwable)new FetchException("request_does_not_exist");
        }
        DownloadInfo download = downloadInfo2;
        if (download.getStatus() != Status.COMPLETED) {
            throw (Throwable)new FetchException("cannot rename file associated with incomplete download");
        }
        DownloadInfo downloadWithFile = this.fetchDatabaseManagerWrapper.getByFile(newFileName);
        if (downloadWithFile != null) {
            throw (Throwable)new FetchException("request_with_file_path_already_exist");
        }
        DownloadInfo copy = FetchTypeConverterExtensions.toDownloadInfo(download, this.fetchDatabaseManagerWrapper.getNewDownloadInfoInstance());
        copy.setId(FetchCoreUtils.getUniqueId((String)download.getUrl(), (String)newFileName));
        copy.setFile(newFileName);
        Pair<DownloadInfo, Boolean> pair = this.fetchDatabaseManagerWrapper.insert(copy);
        if (!((Boolean)pair.getSecond()).booleanValue()) {
            throw (Throwable)new FetchException("file_cannot_be_renamed");
        }
        boolean renamed = this.storageResolver.renameFile(download.getFile(), newFileName);
        if (!renamed) {
            this.fetchDatabaseManagerWrapper.delete(copy);
            throw (Throwable)new FetchException("file_cannot_be_renamed");
        }
        this.fetchDatabaseManagerWrapper.delete(download);
        return (Download)pair.getFirst();
    }

    @Override
    @NotNull
    public Download replaceExtras(int id, @NotNull Extras extras) {
        DownloadInfo downloadInfo2;
        Intrinsics.checkParameterIsNotNull((Object)extras, (String)"extras");
        DownloadInfo downloadInfo3 = this.fetchDatabaseManagerWrapper.get(id);
        if (downloadInfo3 != null) {
            this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)downloadInfo3));
            downloadInfo3 = this.fetchDatabaseManagerWrapper.get(id);
        }
        if (downloadInfo3 != null) {
            DownloadInfo download;
            downloadInfo2 = download = this.fetchDatabaseManagerWrapper.updateExtras(id, extras);
            if (downloadInfo2 == null) {
                throw (Throwable)new FetchException("request_does_not_exist");
            }
        } else {
            throw (Throwable)new FetchException("request_does_not_exist");
        }
        return downloadInfo2;
    }

    @Override
    @NotNull
    public List<Download> getDownloads() {
        return this.fetchDatabaseManagerWrapper.get();
    }

    @Override
    @Nullable
    public Download getDownload(int id) {
        return this.fetchDatabaseManagerWrapper.get(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloads(@NotNull List<Integer> idList) {
        Intrinsics.checkParameterIsNotNull(idList, (String)"idList");
        return CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(idList));
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroup(int id) {
        return this.fetchDatabaseManagerWrapper.getByGroup(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        return this.fetchDatabaseManagerWrapper.getByStatus(status);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsWithStatus(@NotNull List<? extends Status> statuses) {
        Intrinsics.checkParameterIsNotNull(statuses, (String)"statuses");
        return this.fetchDatabaseManagerWrapper.getByStatus(statuses);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroupWithStatus(int groupId, @NotNull List<? extends Status> statuses) {
        Intrinsics.checkParameterIsNotNull(statuses, (String)"statuses");
        return this.fetchDatabaseManagerWrapper.getDownloadsInGroupWithStatus(groupId, statuses);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsByRequestIdentifier(long identifier) {
        return this.fetchDatabaseManagerWrapper.getDownloadsByRequestIdentifier(identifier);
    }

    @Override
    @NotNull
    public List<Integer> getAllGroupIds() {
        return this.fetchDatabaseManagerWrapper.getAllGroupIds();
    }

    @Override
    @NotNull
    public List<Download> getDownloadsByTag(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        return this.fetchDatabaseManagerWrapper.getDownloadsByTag(tag);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadBlock> getDownloadBlocks(int id) {
        List list;
        DownloadInfo download = this.fetchDatabaseManagerWrapper.get(id);
        if (download != null) {
            String fileTempDir = this.downloadManager.getDownloadFileTempDir(download);
            FileSliceInfo fileSliceInfo = FetchUtils.getFileSliceInfo(FetchUtils.getPreviousSliceCount(download.getId(), fileTempDir), download.getTotal());
            if (download.getTotal() < 1L) {
                boolean bl = false;
                list = CollectionsKt.emptyList();
            } else if (fileSliceInfo.getSlicingCount() < 2) {
                DownloadBlockInfo downloadBlockInfo = new DownloadBlockInfo();
                downloadBlockInfo.setDownloadId(download.getId());
                downloadBlockInfo.setBlockPosition(1);
                downloadBlockInfo.setStartByte(0L);
                downloadBlockInfo.setEndByte(download.getTotal());
                downloadBlockInfo.setDownloadedBytes(download.getDownloaded());
                list = CollectionsKt.listOf((Object)downloadBlockInfo);
            } else {
                long counterBytes = 0L;
                int n = 0;
                List downloadBlocksList = new ArrayList();
                n = 1;
                int n2 = fileSliceInfo.getSlicingCount();
                if (n <= n2) {
                    while (true) {
                        void position;
                        long endBytes;
                        long startBytes = counterBytes;
                        counterBytes = endBytes = fileSliceInfo.getSlicingCount() == position ? download.getTotal() : counterBytes + fileSliceInfo.getBytesPerFileSlice();
                        DownloadBlockInfo downloadBlockInfo = new DownloadBlockInfo();
                        downloadBlockInfo.setDownloadId(download.getId());
                        downloadBlockInfo.setBlockPosition((int)position);
                        downloadBlockInfo.setStartByte(startBytes);
                        downloadBlockInfo.setEndByte(endBytes);
                        downloadBlockInfo.setDownloadedBytes(FetchUtils.getSavedDownloadedInfo(download.getId(), (int)position, fileTempDir));
                        downloadBlocksList.add(downloadBlockInfo);
                        if (position == n2) break;
                        ++position;
                    }
                }
                list = downloadBlocksList;
            }
        } else {
            return CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public long getContentLengthForRequest(@NotNull Request request, boolean fromServer) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        DownloadInfo download = this.fetchDatabaseManagerWrapper.get(request.getId());
        if (download != null && download.getTotal() > 0L) {
            return download.getTotal();
        }
        return fromServer ? (FetchCoreUtils.isFetchFileServerUrl((String)request.getUrl()) ? this.fileServerDownloader.getRequestContentLength(FetchUtils.getServerRequestFromRequest(request)) : this.httpDownloader.getRequestContentLength(FetchUtils.getServerRequestFromRequest(request))) : -1L;
    }

    @Override
    @NotNull
    public Downloader.Response getServerResponse(@NotNull String url, @Nullable Map<String, String> header) {
        Downloader.Response response2;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Request request = new Request(url, "");
        Map<String, String> map = header;
        if (map != null) {
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Map<String, String> map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl2 = false;
                request.addHeader(it.getKey(), it.getValue());
            }
        }
        Downloader.ServerRequest serverRequest = FetchUtils.getServerRequestFromRequest(request);
        InterruptMonitor interruptMonitor2 = new InterruptMonitor(){

            public boolean isInterrupted() {
                return false;
            }
        };
        if (FetchCoreUtils.isFetchFileServerUrl((String)request.getUrl())) {
            response2 = this.fileServerDownloader.execute(serverRequest, interruptMonitor2);
            if (response2 != null) {
                Downloader.Response copy = FetchCoreUtils.copyDownloadResponseNoStream((Downloader.Response)response2);
                this.fileServerDownloader.disconnect(response2);
                return copy;
            }
        } else {
            response2 = this.httpDownloader.execute(serverRequest, interruptMonitor2);
            if (response2 != null) {
                Downloader.Response copy = FetchCoreUtils.copyDownloadResponseNoStream((Downloader.Response)response2);
                this.httpDownloader.disconnect(response2);
                return copy;
            }
        }
        throw (Throwable)new IOException("request_not_successful");
    }

    @Override
    @NotNull
    public List<FileResource> getFetchFileServerCatalog(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return this.fileServerDownloader.getFetchFileServerCatalog(FetchUtils.getCatalogServerRequestFromRequest(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isTerminating) {
            return;
        }
        this.isTerminating = true;
        Set<FetchListener> set = this.listenerSet;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            Iterator<FetchListener> $this$forEach$iv = this.listenerSet.iterator();
            boolean $i$f$forEach = false;
            Iterator<FetchListener> iterator = $this$forEach$iv;
            boolean bl4 = false;
            Iterator<FetchListener> iterator2 = iterator;
            while (iterator2.hasNext()) {
                FetchListener element$iv;
                FetchListener it = element$iv = iterator2.next();
                boolean bl5 = false;
                this.listenerCoordinator.removeListener(this.listenerId, it);
            }
            this.listenerSet.clear();
            Unit unit = Unit.INSTANCE;
        }
        if (this.fetchNotificationManager != null) {
            this.listenerCoordinator.removeNotificationManager(this.fetchNotificationManager);
            this.listenerCoordinator.cancelOnGoingNotifications(this.fetchNotificationManager);
        }
        this.priorityListProcessor.stop();
        this.priorityListProcessor.close();
        this.downloadManager.close();
        FetchModulesBuilder.INSTANCE.removeNamespaceInstanceReference(this.namespace);
    }

    @Override
    public void setGlobalNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"networkType");
        this.priorityListProcessor.stop();
        this.priorityListProcessor.setGlobalNetworkType(networkType);
        List<Integer> ids = this.downloadManager.getActiveDownloadsIds();
        Collection collection = ids;
        boolean bl = false;
        if (!collection.isEmpty()) {
            List downloads = CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids));
            Collection collection2 = downloads;
            boolean bl2 = false;
            if (!collection2.isEmpty()) {
                this.cancelDownloadsIfDownloading(downloads);
                downloads = CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids));
                Iterable $this$forEach$iv = downloads;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DownloadInfo it = (DownloadInfo)element$iv;
                    boolean bl3 = false;
                    if (it.getStatus() != Status.DOWNLOADING) continue;
                    it.setStatus(Status.QUEUED);
                    it.setError(FetchDefaults.getDefaultNoError());
                }
                this.fetchDatabaseManagerWrapper.update(downloads);
            }
        }
        this.priorityListProcessor.start();
    }

    @Override
    public void setDownloadConcurrentLimit(int downloadConcurrentLimit) {
        this.priorityListProcessor.stop();
        List<Integer> ids = this.downloadManager.getActiveDownloadsIds();
        Collection collection = ids;
        boolean bl = false;
        if (!collection.isEmpty()) {
            List downloads = CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids));
            Collection collection2 = downloads;
            boolean bl2 = false;
            if (!collection2.isEmpty()) {
                this.cancelDownloadsIfDownloading(downloads);
                downloads = CollectionsKt.filterNotNull((Iterable)this.fetchDatabaseManagerWrapper.get(ids));
                this.downloadManager.setConcurrentLimit(downloadConcurrentLimit);
                this.priorityListProcessor.setDownloadConcurrentLimit(downloadConcurrentLimit);
                Iterable $this$forEach$iv = downloads;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DownloadInfo it = (DownloadInfo)element$iv;
                    boolean bl3 = false;
                    if (it.getStatus() != Status.DOWNLOADING) continue;
                    it.setStatus(Status.QUEUED);
                    it.setError(FetchDefaults.getDefaultNoError());
                }
                this.fetchDatabaseManagerWrapper.update(downloads);
            }
        }
        this.priorityListProcessor.start();
    }

    @Override
    public void enableLogging(boolean enabled) {
        this.logger.d("Enable logging - " + enabled);
        this.logger.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(@NotNull FetchListener listener, boolean notify, boolean autoStart) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Set<FetchListener> set = this.listenerSet;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.listenerSet.add(listener);
        }
        this.listenerCoordinator.addListener(this.listenerId, listener);
        if (notify) {
            List<DownloadInfo> downloads = this.fetchDatabaseManagerWrapper.get();
            Iterable $this$forEach$iv = downloads;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DownloadInfo it = (DownloadInfo)element$iv;
                boolean bl4 = false;
                this.uiHandler.post(new Runnable(it, this, listener){
                    final /* synthetic */ DownloadInfo $it;
                    final /* synthetic */ FetchHandlerImpl this$0;
                    final /* synthetic */ FetchListener $listener$inlined;
                    {
                        this.$it = downloadInfo2;
                        this.this$0 = fetchHandlerImpl;
                        this.$listener$inlined = fetchListener;
                    }

                    public final void run() {
                        switch (FetchHandlerImpl$WhenMappings.$EnumSwitchMapping$1[this.$it.getStatus().ordinal()]) {
                            case 1: {
                                this.$listener$inlined.onCompleted(this.$it);
                                break;
                            }
                            case 2: {
                                this.$listener$inlined.onError(this.$it, this.$it.getError(), null);
                                break;
                            }
                            case 3: {
                                this.$listener$inlined.onCancelled(this.$it);
                                break;
                            }
                            case 4: {
                                this.$listener$inlined.onDeleted(this.$it);
                                break;
                            }
                            case 5: {
                                this.$listener$inlined.onPaused(this.$it);
                                break;
                            }
                            case 6: {
                                this.$listener$inlined.onQueued(this.$it, false);
                                break;
                            }
                            case 7: {
                                this.$listener$inlined.onRemoved(this.$it);
                                break;
                            }
                            case 8: {
                                break;
                            }
                            case 9: {
                                this.$listener$inlined.onAdded(this.$it);
                            }
                        }
                    }
                });
            }
        }
        this.logger.d("Added listener " + listener);
        if (autoStart) {
            this.startPriorityQueueIfNotStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(@NotNull FetchListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Set<FetchListener> set = this.listenerSet;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            Iterator<FetchListener> iterator = this.listenerSet.iterator();
            while (iterator.hasNext()) {
                FetchListener fetchListener = iterator.next();
                if (!Intrinsics.areEqual((Object)fetchListener, (Object)listener)) continue;
                iterator.remove();
                this.logger.d("Removed listener " + listener);
                break;
            }
            this.listenerCoordinator.removeListener(this.listenerId, listener);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<FetchListener> getListenerSet() {
        Set set;
        Set<FetchListener> set2 = this.listenerSet;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set2) {
            boolean bl3 = false;
            set = CollectionsKt.toSet((Iterable)this.listenerSet);
        }
        return set;
    }

    @Override
    public boolean hasActiveDownloads(boolean includeAddedDownloads) {
        Thread thread = Thread.currentThread();
        Looper looper = Looper.getMainLooper();
        Intrinsics.checkExpressionValueIsNotNull((Object)looper, (String)"Looper.getMainLooper()");
        if (Intrinsics.areEqual((Object)thread, (Object)looper.getThread())) {
            throw (Throwable)new FetchException("blocking_call_on_ui_thread");
        }
        return this.fetchDatabaseManagerWrapper.getPendingCount(includeAddedDownloads) > 0L;
    }

    @Override
    public long getPendingCount() {
        return this.fetchDatabaseManagerWrapper.getPendingCount(false);
    }

    private final void cancelDownloadsIfDownloading(List<? extends DownloadInfo> downloads) {
        for (DownloadInfo downloadInfo2 : downloads) {
            this.downloadManager.cancel(downloadInfo2.getId());
        }
    }

    private final void startPriorityQueueIfNotStarted() {
        this.priorityListProcessor.sendBackOffResetSignal();
        if (this.priorityListProcessor.isStopped() && !this.isTerminating) {
            this.priorityListProcessor.start();
        }
        if (this.priorityListProcessor.isPaused() && !this.isTerminating) {
            this.priorityListProcessor.resume();
        }
    }

    @Override
    @NotNull
    public FetchGroup getFetchGroup(int id) {
        return this.groupInfoProvider.getGroupInfo(id, Reason.OBSERVER_ATTACHED);
    }

    @Override
    public void addFetchObserversForDownload(int downloadId, FetchObserver<Download> ... fetchObservers) {
        Intrinsics.checkParameterIsNotNull(fetchObservers, (String)"fetchObservers");
        this.listenerCoordinator.addFetchObserversForDownload(downloadId, Arrays.copyOf(fetchObservers, fetchObservers.length));
    }

    @Override
    public void removeFetchObserversForDownload(int downloadId, FetchObserver<Download> ... fetchObservers) {
        Intrinsics.checkParameterIsNotNull(fetchObservers, (String)"fetchObservers");
        this.listenerCoordinator.removeFetchObserversForDownload(downloadId, Arrays.copyOf(fetchObservers, fetchObservers.length));
    }

    public FetchHandlerImpl(@NotNull String namespace, @NotNull FetchDatabaseManagerWrapper fetchDatabaseManagerWrapper, @NotNull DownloadManager downloadManager, @NotNull PriorityListProcessor<? extends Download> priorityListProcessor, @NotNull Logger logger, boolean autoStart, @NotNull Downloader<?, ?> httpDownloader, @NotNull FileServerDownloader fileServerDownloader, @NotNull ListenerCoordinator listenerCoordinator, @NotNull Handler uiHandler, @NotNull StorageResolver storageResolver, @Nullable FetchNotificationManager fetchNotificationManager, @NotNull GroupInfoProvider groupInfoProvider, @NotNull PrioritySort prioritySort, boolean createFileOnEnqueue) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)fetchDatabaseManagerWrapper, (String)"fetchDatabaseManagerWrapper");
        Intrinsics.checkParameterIsNotNull((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkParameterIsNotNull(priorityListProcessor, (String)"priorityListProcessor");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull(httpDownloader, (String)"httpDownloader");
        Intrinsics.checkParameterIsNotNull((Object)fileServerDownloader, (String)"fileServerDownloader");
        Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
        Intrinsics.checkParameterIsNotNull((Object)uiHandler, (String)"uiHandler");
        Intrinsics.checkParameterIsNotNull((Object)storageResolver, (String)"storageResolver");
        Intrinsics.checkParameterIsNotNull((Object)groupInfoProvider, (String)"groupInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)((Object)prioritySort), (String)"prioritySort");
        this.namespace = namespace;
        this.fetchDatabaseManagerWrapper = fetchDatabaseManagerWrapper;
        this.downloadManager = downloadManager;
        this.priorityListProcessor = priorityListProcessor;
        this.logger = logger;
        this.autoStart = autoStart;
        this.httpDownloader = httpDownloader;
        this.fileServerDownloader = fileServerDownloader;
        this.listenerCoordinator = listenerCoordinator;
        this.uiHandler = uiHandler;
        this.storageResolver = storageResolver;
        this.fetchNotificationManager = fetchNotificationManager;
        this.groupInfoProvider = groupInfoProvider;
        this.prioritySort = prioritySort;
        this.createFileOnEnqueue = createFileOnEnqueue;
        this.listenerId = UUID.randomUUID().hashCode();
        FetchHandlerImpl fetchHandlerImpl = this;
        boolean bl = false;
        fetchHandlerImpl.listenerSet = set = (Set)new LinkedHashSet();
    }
}

