/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.EnqueueAction;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchErrorUtils;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.SequentialFileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.helper.FileDownloaderDelegate;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2core.AverageCalculator;
import com.tonyodev.fetch2core.DownloadBlock;
import com.tonyodev.fetch2core.DownloadBlockInfo;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2core.Logger;
import com.tonyodev.fetch2core.OutputResourceWrapper;
import com.tonyodev.fetch2core.StorageResolver;
import java.io.BufferedInputStream;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0093\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001,\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0012J\b\u0010<\u001a\u00020\u0007H\u0002J\b\u0010=\u001a\u00020>H\u0002J\b\u0010?\u001a\u00020\rH\u0002J\b\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020A2\u0006\u0010C\u001a\u00020DH\u0002J\"\u0010F\u001a\u00020A2\u0006\u0010G\u001a\u00020H2\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010K\u001a\u00020:H\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&R\u000e\u0010)\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010-R$\u0010/\u001a\u00020\r2\u0006\u0010.\u001a\u00020\r@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0017\"\u0004\b1\u00102R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00105\u001a\u00020\r2\u0006\u0010.\u001a\u00020\r@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0017\"\u0004\b7\u00102R\u000e\u00108\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/tonyodev/fetch2/downloader/SequentialFileDownloaderImpl;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "initialDownload", "Lcom/tonyodev/fetch2/Download;", "downloader", "Lcom/tonyodev/fetch2core/Downloader;", "progressReportingIntervalMillis", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "hashCheckingEnabled", "storageResolver", "Lcom/tonyodev/fetch2core/StorageResolver;", "preAllocateFileOnCreation", "(Lcom/tonyodev/fetch2/Download;Lcom/tonyodev/fetch2core/Downloader;JLcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;ZZLcom/tonyodev/fetch2core/StorageResolver;Z)V", "averageDownloadedBytesPerSecond", "", "completedDownload", "getCompletedDownload", "()Z", "delegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;)V", "download", "getDownload", "()Lcom/tonyodev/fetch2/Download;", "downloadBlock", "Lcom/tonyodev/fetch2core/DownloadBlockInfo;", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "getDownloadInfo", "()Lcom/tonyodev/fetch2/database/DownloadInfo;", "downloadInfo$delegate", "Lkotlin/Lazy;", "downloaded", "estimatedTimeRemainingInMilliseconds", "interruptMonitor", "com/tonyodev/fetch2/downloader/SequentialFileDownloaderImpl$interruptMonitor$1", "Lcom/tonyodev/fetch2/downloader/SequentialFileDownloaderImpl$interruptMonitor$1;", "value", "interrupted", "getInterrupted", "setInterrupted", "(Z)V", "movingAverageCalculator", "Lcom/tonyodev/fetch2core/AverageCalculator;", "terminated", "getTerminated", "setTerminated", "total", "totalDownloadBlocks", "", "totalUnknown", "getAverageDownloadedBytesPerSecond", "getRequest", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "isDownloadComplete", "run", "", "setIsTotalUnknown", "response", "Lcom/tonyodev/fetch2core/Downloader$Response;", "verifyDownloadCompletion", "writeToOutput", "input", "Ljava/io/BufferedInputStream;", "outputResourceWrapper", "Lcom/tonyodev/fetch2core/OutputResourceWrapper;", "bufferSize", "fetch2_release"})
public final class SequentialFileDownloaderImpl
implements FileDownloader {
    private volatile boolean interrupted;
    private volatile boolean terminated;
    @Nullable
    private FileDownloader.Delegate delegate;
    private volatile long total;
    private volatile boolean totalUnknown;
    private volatile long downloaded;
    private long estimatedTimeRemainingInMilliseconds;
    private final Lazy downloadInfo$delegate;
    private double averageDownloadedBytesPerSecond;
    private final AverageCalculator movingAverageCalculator;
    private final DownloadBlockInfo downloadBlock;
    private final int totalDownloadBlocks = 1;
    private final interruptMonitor.1 interruptMonitor;
    private final Download initialDownload;
    private final Downloader<?, ?> downloader;
    private final long progressReportingIntervalMillis;
    private final Logger logger;
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;
    private final boolean hashCheckingEnabled;
    private final StorageResolver storageResolver;
    private final boolean preAllocateFileOnCreation;

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted(boolean value) {
        FileDownloader.Delegate delegate = this.getDelegate();
        if (!(delegate instanceof FileDownloaderDelegate)) {
            delegate = null;
        }
        FileDownloaderDelegate fileDownloaderDelegate = (FileDownloaderDelegate)delegate;
        if (fileDownloaderDelegate != null) {
            fileDownloaderDelegate.setInterrupted(value);
        }
        this.interrupted = value;
    }

    @Override
    public boolean getTerminated() {
        return this.terminated;
    }

    @Override
    public void setTerminated(boolean value) {
        FileDownloader.Delegate delegate = this.getDelegate();
        if (!(delegate instanceof FileDownloaderDelegate)) {
            delegate = null;
        }
        FileDownloaderDelegate fileDownloaderDelegate = (FileDownloaderDelegate)delegate;
        if (fileDownloaderDelegate != null) {
            fileDownloaderDelegate.setInterrupted(value);
        }
        this.terminated = value;
    }

    @Override
    public boolean getCompletedDownload() {
        return this.isDownloadComplete();
    }

    @Override
    @Nullable
    public FileDownloader.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable FileDownloader.Delegate delegate) {
        this.delegate = delegate;
    }

    private final DownloadInfo getDownloadInfo() {
        Lazy lazy = this.downloadInfo$delegate;
        SequentialFileDownloaderImpl sequentialFileDownloaderImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DownloadInfo)lazy.getValue();
    }

    @Override
    @NotNull
    public Download getDownload() {
        this.getDownloadInfo().setDownloaded(this.downloaded);
        this.getDownloadInfo().setTotal(this.total);
        return this.getDownloadInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        block57: {
            OutputResourceWrapper outputResourceWrapper = null;
            BufferedInputStream input = null;
            Downloader.Response response2 = null;
            try {
                this.downloaded = this.initialDownload.getDownloaded();
                this.total = this.initialDownload.getTotal();
                this.getDownloadInfo().setDownloaded(this.downloaded);
                this.getDownloadInfo().setTotal(this.total);
                if (!this.getInterrupted() && !this.getTerminated()) {
                    boolean isResponseSuccessful;
                    Downloader.ServerRequest request = this.getRequest();
                    response2 = this.downloader.execute(request, (InterruptMonitor)this.interruptMonitor);
                    if (response2 != null) {
                        this.setIsTotalUnknown(response2);
                    }
                    Downloader.Response response3 = response2;
                    boolean bl = isResponseSuccessful = response3 != null ? response3.isSuccessful() : false;
                    if (!this.getInterrupted() && !this.getTerminated() && response2 != null && isResponseSuccessful) {
                        long l;
                        this.downloaded = response2.getCode() == 206 || response2.getAcceptsRanges() ? this.initialDownload.getDownloaded() : 0L;
                        this.total = response2.getContentLength();
                        if (response2.getCode() == 206) {
                            this.logger.d("FileDownloader resuming Download " + this.getDownload());
                            l = this.downloaded;
                        } else {
                            this.logger.d("FileDownloader starting Download " + this.getDownload());
                            l = 0L;
                        }
                        long seekPosition = l;
                        this.getDownloadInfo().setDownloaded(this.downloaded);
                        this.getDownloadInfo().setTotal(this.total);
                        if (!this.storageResolver.fileExists(request.getFile())) {
                            this.storageResolver.createFile(request.getFile(), this.initialDownload.getEnqueueAction() == EnqueueAction.INCREMENT_FILE_NAME);
                        }
                        if (this.preAllocateFileOnCreation) {
                            this.storageResolver.preAllocateFile(request.getFile(), this.getDownloadInfo().getTotal());
                        }
                        outputResourceWrapper = this.storageResolver.getRequestOutputResourceWrapper(request);
                        outputResourceWrapper.setWriteOffset(seekPosition);
                        if (!this.getInterrupted() && !this.getTerminated()) {
                            int bufferSize = this.downloader.getRequestBufferSize(request);
                            input = new BufferedInputStream(response2.getByteStream(), bufferSize);
                            this.getDownloadInfo().setDownloaded(this.downloaded);
                            this.getDownloadInfo().setTotal(this.total);
                            this.downloadBlock.setDownloadedBytes(this.downloaded);
                            this.downloadBlock.setStartByte(seekPosition);
                            this.downloadBlock.setEndByte(this.total);
                            if (!this.getTerminated() && !this.getInterrupted()) {
                                this.getDownloadInfo().setEtaInMilliSeconds(-1L);
                                this.getDownloadInfo().setDownloadedBytesPerSecond(-1L);
                                FileDownloader.Delegate delegate = this.getDelegate();
                                if (delegate != null) {
                                    delegate.onStarted(this.getDownloadInfo(), CollectionsKt.listOf((Object)this.downloadBlock), this.totalDownloadBlocks);
                                }
                                FileDownloader.Delegate delegate2 = this.getDelegate();
                                if (delegate2 != null) {
                                    delegate2.onDownloadBlockUpdated(this.getDownloadInfo(), (DownloadBlock)this.downloadBlock, this.totalDownloadBlocks);
                                }
                            }
                            this.writeToOutput(input, outputResourceWrapper, bufferSize);
                        }
                    } else {
                        if (!(response2 != null || this.getInterrupted() || this.getTerminated() || this.isDownloadComplete())) {
                            throw (Throwable)new FetchException("empty_response_body");
                        }
                        if (!(isResponseSuccessful || this.getInterrupted() || this.isDownloadComplete())) {
                            throw (Throwable)new FetchException("request_not_successful");
                        }
                        if (!(this.getInterrupted() || this.getTerminated() || this.downloaded >= this.total || this.isDownloadComplete())) {
                            throw (Throwable)new FetchException("unknown");
                        }
                    }
                }
                if (!(this.isDownloadComplete() || this.getTerminated() || this.getInterrupted())) {
                    this.getDownloadInfo().setDownloaded(this.downloaded);
                    this.getDownloadInfo().setTotal(this.total);
                    this.downloadBlock.setDownloadedBytes(this.downloaded);
                    this.downloadBlock.setEndByte(this.total);
                    if (!this.getTerminated() && !this.getInterrupted()) {
                        FileDownloader.Delegate delegate = this.getDelegate();
                        if (delegate != null) {
                            delegate.saveDownloadProgress(this.getDownloadInfo());
                        }
                        FileDownloader.Delegate delegate3 = this.getDelegate();
                        if (delegate3 != null) {
                            delegate3.onDownloadBlockUpdated(this.getDownloadInfo(), (DownloadBlock)this.downloadBlock, this.totalDownloadBlocks);
                        }
                        this.getDownloadInfo().setEtaInMilliSeconds(this.estimatedTimeRemainingInMilliseconds);
                        this.getDownloadInfo().setDownloadedBytesPerSecond(this.getAverageDownloadedBytesPerSecond());
                        FileDownloader.Delegate delegate4 = this.getDelegate();
                        if (delegate4 != null) {
                            delegate4.onProgress(this.getDownloadInfo(), this.getDownloadInfo().getEtaInMilliSeconds(), this.getDownloadInfo().getDownloadedBytesPerSecond());
                        }
                    }
                } else if (this.isDownloadComplete() && response2 != null) {
                    this.verifyDownloadCompletion(response2);
                }
            }
            catch (Exception e) {
                if (this.getInterrupted() || this.getTerminated()) break block57;
                this.logger.e("FileDownloader download:" + this.getDownload(), (Throwable)e);
                Error error = FetchErrorUtils.getErrorFromThrowable(e);
                error.setThrowable(e);
                if (response2 != null) {
                    error.setHttpResponse(FetchCoreUtils.copyDownloadResponseNoStream((Downloader.Response)response2));
                }
                if (this.retryOnNetworkGain) {
                    boolean disconnectDetected = !this.networkInfoProvider.isNetworkAvailable();
                    int n = 1;
                    int n2 = 10;
                    while (n <= n2) {
                        void i;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e2) {
                            this.logger.e("FileDownloader", (Throwable)e2);
                            break;
                        }
                        if (!this.networkInfoProvider.isNetworkAvailable()) {
                            disconnectDetected = true;
                            break;
                        }
                        ++i;
                    }
                    if (disconnectDetected) {
                        error = Error.NO_NETWORK_CONNECTION;
                    }
                }
                this.getDownloadInfo().setDownloaded(this.downloaded);
                this.getDownloadInfo().setTotal(this.total);
                this.getDownloadInfo().setError(error);
                this.downloadBlock.setDownloadedBytes(this.downloaded);
                this.downloadBlock.setEndByte(this.total);
                if (!this.getTerminated() && !this.getInterrupted()) {
                    this.getDownloadInfo().setEtaInMilliSeconds(-1L);
                    this.getDownloadInfo().setDownloadedBytesPerSecond(-1L);
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.onError(this.getDownloadInfo(), error, e);
                    }
                }
            }
            finally {
                try {
                    BufferedInputStream bufferedInputStream = input;
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", (Throwable)e);
                }
                if (response2 != null) {
                    try {
                        this.downloader.disconnect(response2);
                    }
                    catch (Exception e) {
                        this.logger.e("FileDownloader", (Throwable)e);
                    }
                }
                try {
                    OutputResourceWrapper outputResourceWrapper2 = outputResourceWrapper;
                    if (outputResourceWrapper2 != null) {
                        outputResourceWrapper2.close();
                    }
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", (Throwable)e);
                }
                this.setTerminated(true);
            }
        }
    }

    private final boolean isDownloadComplete() {
        return (this.downloaded > 0L && this.total > 0L || this.totalUnknown) && this.downloaded >= this.total;
    }

    private final void setIsTotalUnknown(Downloader.Response response2) {
        if (response2.isSuccessful() && response2.getContentLength() == -1L) {
            this.totalUnknown = true;
        }
    }

    private final void writeToOutput(BufferedInputStream input, OutputResourceWrapper outputResourceWrapper, int bufferSize) {
        block9: {
            long reportingStopTime = 0L;
            long downloadSpeedStopTime = 0L;
            long downloadedBytesPerSecond = this.downloaded;
            byte[] buffer = new byte[bufferSize];
            long reportingStartTime = System.nanoTime();
            long downloadSpeedStartTime = System.nanoTime();
            int read = input.read(buffer, 0, bufferSize);
            while (!this.getInterrupted() && !this.getTerminated() && read != -1) {
                boolean hasReportingTimeElapsed;
                OutputResourceWrapper outputResourceWrapper2 = outputResourceWrapper;
                if (outputResourceWrapper2 != null) {
                    outputResourceWrapper2.write(buffer, 0, read);
                }
                if (this.getTerminated() || this.getInterrupted()) continue;
                this.downloaded += (long)read;
                this.getDownloadInfo().setDownloaded(this.downloaded);
                this.getDownloadInfo().setTotal(this.total);
                this.downloadBlock.setDownloadedBytes(this.downloaded);
                this.downloadBlock.setEndByte(this.total);
                downloadSpeedStopTime = System.nanoTime();
                boolean downloadSpeedCheckTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)downloadSpeedStartTime, (long)downloadSpeedStopTime, (long)1000L);
                if (downloadSpeedCheckTimeElapsed) {
                    downloadedBytesPerSecond = this.downloaded - downloadedBytesPerSecond;
                    this.movingAverageCalculator.add((double)downloadedBytesPerSecond);
                    this.averageDownloadedBytesPerSecond = AverageCalculator.getMovingAverageWithWeightOnRecentValues$default((AverageCalculator)this.movingAverageCalculator, (int)0, (int)1, null);
                    this.estimatedTimeRemainingInMilliseconds = FetchCoreUtils.calculateEstimatedTimeRemainingInMilliseconds((long)this.downloaded, (long)this.total, (long)this.getAverageDownloadedBytesPerSecond());
                    downloadedBytesPerSecond = this.downloaded;
                }
                if (hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)(reportingStopTime = System.nanoTime()), (long)this.progressReportingIntervalMillis)) {
                    this.downloadBlock.setDownloadedBytes(this.downloaded);
                    if (!this.getTerminated() && !this.getInterrupted()) {
                        FileDownloader.Delegate delegate = this.getDelegate();
                        if (delegate != null) {
                            delegate.saveDownloadProgress(this.getDownloadInfo());
                        }
                        FileDownloader.Delegate delegate2 = this.getDelegate();
                        if (delegate2 != null) {
                            delegate2.onDownloadBlockUpdated(this.getDownloadInfo(), (DownloadBlock)this.downloadBlock, this.totalDownloadBlocks);
                        }
                        this.getDownloadInfo().setEtaInMilliSeconds(this.estimatedTimeRemainingInMilliseconds);
                        this.getDownloadInfo().setDownloadedBytesPerSecond(this.getAverageDownloadedBytesPerSecond());
                        FileDownloader.Delegate delegate3 = this.getDelegate();
                        if (delegate3 != null) {
                            delegate3.onProgress(this.getDownloadInfo(), this.getDownloadInfo().getEtaInMilliSeconds(), this.getDownloadInfo().getDownloadedBytesPerSecond());
                        }
                    }
                    reportingStartTime = System.nanoTime();
                }
                if (downloadSpeedCheckTimeElapsed) {
                    downloadSpeedStartTime = System.nanoTime();
                }
                read = input.read(buffer, 0, bufferSize);
            }
            OutputResourceWrapper outputResourceWrapper3 = outputResourceWrapper;
            if (outputResourceWrapper3 == null) break block9;
            outputResourceWrapper3.flush();
        }
    }

    private final void verifyDownloadCompletion(Downloader.Response response2) {
        block8: {
            block9: {
                block10: {
                    if (this.getInterrupted() || this.getTerminated() || !this.isDownloadComplete()) break block8;
                    this.total = this.downloaded;
                    this.getDownloadInfo().setDownloaded(this.downloaded);
                    this.getDownloadInfo().setTotal(this.total);
                    this.downloadBlock.setDownloadedBytes(this.downloaded);
                    this.downloadBlock.setEndByte(this.total);
                    if (!this.hashCheckingEnabled) break block9;
                    if (!this.downloader.verifyContentHash(response2.getRequest(), response2.getHash())) break block10;
                    if (this.getTerminated() || this.getInterrupted()) break block8;
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.saveDownloadProgress(this.getDownloadInfo());
                    }
                    FileDownloader.Delegate delegate2 = this.getDelegate();
                    if (delegate2 != null) {
                        delegate2.onDownloadBlockUpdated(this.getDownloadInfo(), (DownloadBlock)this.downloadBlock, this.totalDownloadBlocks);
                    }
                    this.getDownloadInfo().setEtaInMilliSeconds(this.estimatedTimeRemainingInMilliseconds);
                    this.getDownloadInfo().setDownloadedBytesPerSecond(this.getAverageDownloadedBytesPerSecond());
                    Download completedDownload = this.getDownloadInfo().copy();
                    FileDownloader.Delegate delegate3 = this.getDelegate();
                    if (delegate3 != null) {
                        delegate3.onProgress(this.getDownloadInfo(), this.getDownloadInfo().getEtaInMilliSeconds(), this.getDownloadInfo().getDownloadedBytesPerSecond());
                    }
                    this.getDownloadInfo().setEtaInMilliSeconds(-1L);
                    this.getDownloadInfo().setDownloadedBytesPerSecond(-1L);
                    FileDownloader.Delegate delegate4 = this.getDelegate();
                    if (delegate4 != null) {
                        delegate4.onComplete(completedDownload);
                    }
                    break block8;
                }
                throw (Throwable)new FetchException("invalid content hash");
            }
            if (this.getTerminated() || this.getInterrupted()) break block8;
            FileDownloader.Delegate delegate = this.getDelegate();
            if (delegate != null) {
                delegate.saveDownloadProgress(this.getDownloadInfo());
            }
            FileDownloader.Delegate delegate5 = this.getDelegate();
            if (delegate5 != null) {
                delegate5.onDownloadBlockUpdated(this.getDownloadInfo(), (DownloadBlock)this.downloadBlock, this.totalDownloadBlocks);
            }
            this.getDownloadInfo().setEtaInMilliSeconds(this.estimatedTimeRemainingInMilliseconds);
            this.getDownloadInfo().setDownloadedBytesPerSecond(this.getAverageDownloadedBytesPerSecond());
            Download completedDownload = this.getDownloadInfo().copy();
            FileDownloader.Delegate delegate6 = this.getDelegate();
            if (delegate6 != null) {
                delegate6.onProgress(this.getDownloadInfo(), this.getDownloadInfo().getEtaInMilliSeconds(), this.getDownloadInfo().getDownloadedBytesPerSecond());
            }
            this.getDownloadInfo().setEtaInMilliSeconds(-1L);
            this.getDownloadInfo().setDownloadedBytesPerSecond(-1L);
            FileDownloader.Delegate delegate7 = this.getDelegate();
            if (delegate7 != null) {
                delegate7.onComplete(completedDownload);
            }
        }
    }

    private final Downloader.ServerRequest getRequest() {
        Map headers = MapsKt.toMutableMap(this.initialDownload.getHeaders());
        headers.put("Range", "bytes=" + this.downloaded + '-');
        return new Downloader.ServerRequest(this.initialDownload.getId(), this.initialDownload.getUrl(), headers, this.initialDownload.getFile(), FetchCoreUtils.getFileUri((String)this.initialDownload.getFile()), this.initialDownload.getTag(), this.initialDownload.getIdentifier(), "GET", this.initialDownload.getExtras(), false, "", 1);
    }

    private final long getAverageDownloadedBytesPerSecond() {
        if (this.averageDownloadedBytesPerSecond < 1.0) {
            return 0L;
        }
        double d = this.averageDownloadedBytesPerSecond;
        boolean bl = false;
        return (long)Math.ceil(d);
    }

    public SequentialFileDownloaderImpl(@NotNull Download initialDownload, @NotNull Downloader<?, ?> downloader, long progressReportingIntervalMillis, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain, boolean hashCheckingEnabled, @NotNull StorageResolver storageResolver, boolean preAllocateFileOnCreation) {
        Intrinsics.checkParameterIsNotNull((Object)initialDownload, (String)"initialDownload");
        Intrinsics.checkParameterIsNotNull(downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)storageResolver, (String)"storageResolver");
        this.initialDownload = initialDownload;
        this.downloader = downloader;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.hashCheckingEnabled = hashCheckingEnabled;
        this.storageResolver = storageResolver;
        this.preAllocateFileOnCreation = preAllocateFileOnCreation;
        this.total = -1L;
        this.estimatedTimeRemainingInMilliseconds = -1L;
        this.downloadInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DownloadInfo>(this){
            final /* synthetic */ SequentialFileDownloaderImpl this$0;

            @NotNull
            public final DownloadInfo invoke() {
                Download download = SequentialFileDownloaderImpl.access$getInitialDownload$p(this.this$0);
                FileDownloader.Delegate delegate = this.this$0.getDelegate();
                if (delegate == null) {
                    Intrinsics.throwNpe();
                }
                return FetchTypeConverterExtensions.toDownloadInfo(download, delegate.getNewDownloadInfoInstance());
            }
            {
                this.this$0 = sequentialFileDownloaderImpl;
                super(0);
            }
        }));
        this.movingAverageCalculator = new AverageCalculator(5);
        this.downloadBlock = (DownloadBlockInfo)((Function0)new Function0<DownloadBlockInfo>(this){
            final /* synthetic */ SequentialFileDownloaderImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DownloadBlockInfo invoke() {
                void var1_1;
                DownloadBlockInfo downloadBlock2 = new DownloadBlockInfo();
                downloadBlock2.setBlockPosition(1);
                downloadBlock2.setDownloadId(SequentialFileDownloaderImpl.access$getInitialDownload$p(this.this$0).getId());
                return var1_1;
            }
            {
                this.this$0 = sequentialFileDownloaderImpl;
                super(0);
            }
        }).invoke();
        this.totalDownloadBlocks = 1;
        this.interruptMonitor = new InterruptMonitor(this){
            final /* synthetic */ SequentialFileDownloaderImpl this$0;

            public boolean isInterrupted() {
                return this.this$0.getInterrupted();
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ Download access$getInitialDownload$p(SequentialFileDownloaderImpl $this) {
        return $this.initialDownload;
    }
}

