/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.database;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DatabaseManager;
import com.tonyodev.fetch2.database.DatabaseManagerImpl$WhenMappings;
import com.tonyodev.fetch2.database.DownloadDatabase;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.database.migration.Migration;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.LiveSettings;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2core.DefaultStorageResolver;
import com.tonyodev.fetch2core.Extras;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020$H\u0016J\u0016\u0010'\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020$0*H\u0016J\b\u0010+\u001a\u00020&H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020$0*H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010$2\u0006\u0010-\u001a\u00020.H\u0016J\u001e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0*2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0*H\u0016J\u0012\u00100\u001a\u0004\u0018\u00010$2\u0006\u00101\u001a\u00020\u0005H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020$0*2\u0006\u00103\u001a\u00020.H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020$0*2\u0006\u00105\u001a\u000206H\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020$0*2\u0006\u00108\u001a\u000209H\u0016J$\u0010:\u001a\b\u0012\u0004\u0012\u00020$0*2\u0006\u0010;\u001a\u00020.2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002060*H\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020$0*H\u0002J\b\u0010>\u001a\u000209H\u0016J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020$0*H\u0016J\u001c\u0010@\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\f0A2\u0006\u0010(\u001a\u00020$H\u0016J(\u0010@\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\f0A0*2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020$0*H\u0016J\u001c\u0010B\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010C\u001a\u00020\fH\u0002J \u0010B\u001a\u00020\f2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020$0*2\b\b\u0002\u0010E\u001a\u00020\fH\u0002J\b\u0010F\u001a\u00020&H\u0016J\b\u0010G\u001a\u00020&H\u0002J\u0010\u0010H\u001a\u00020&2\u0006\u0010(\u001a\u00020$H\u0016J\u0016\u0010H\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020$0*H\u0016J\u001a\u0010I\u001a\u0004\u0018\u00010$2\u0006\u0010-\u001a\u00020.2\u0006\u0010J\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020&2\u0006\u0010(\u001a\u00020$H\u0016J\u0016\u0010M\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020$0*H\u0016R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/tonyodev/fetch2/database/DatabaseManagerImpl;", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "context", "Landroid/content/Context;", "namespace", "", "migrations", "", "Lcom/tonyodev/fetch2/database/migration/Migration;", "liveSettings", "Lcom/tonyodev/fetch2/fetch/LiveSettings;", "fileExistChecksEnabled", "", "defaultStorageResolver", "Lcom/tonyodev/fetch2core/DefaultStorageResolver;", "(Landroid/content/Context;Ljava/lang/String;[Lcom/tonyodev/fetch2/database/migration/Migration;Lcom/tonyodev/fetch2/fetch/LiveSettings;ZLcom/tonyodev/fetch2core/DefaultStorageResolver;)V", "closed", "database", "Landroid/arch/persistence/db/SupportSQLiteDatabase;", "delegate", "Lcom/tonyodev/fetch2/database/DatabaseManager$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/database/DatabaseManager$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/database/DatabaseManager$Delegate;)V", "didSanitizeOnFirstEntry", "getDidSanitizeOnFirstEntry", "()Z", "isClosed", "lock", "Ljava/lang/Object;", "pendingCountQuery", "requestDatabase", "Lcom/tonyodev/fetch2/database/DownloadDatabase;", "updatedDownloadsList", "", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "close", "", "delete", "downloadInfo", "downloadInfoList", "", "deleteAll", "get", "id", "", "ids", "getByFile", "file", "getByGroup", "group", "getByStatus", "status", "Lcom/tonyodev/fetch2/Status;", "getDownloadsByRequestIdentifier", "identifier", "", "getDownloadsInGroupWithStatus", "groupId", "statuses", "getDownloadsNoLock", "getPendingCount", "getPendingDownloadsSorted", "insert", "Lkotlin/Pair;", "sanitize", "initializing", "downloads", "firstEntry", "sanitizeOnFirstEntry", "throwExceptionIfClosed", "update", "updateExtras", "extras", "Lcom/tonyodev/fetch2core/Extras;", "updateFileBytesInfoAndStatusOnly", "updateNoLock", "fetch2_release"})
public final class DatabaseManagerImpl
implements DatabaseManager {
    private final Object lock;
    private volatile boolean closed;
    @Nullable
    private DatabaseManager.Delegate delegate;
    private final DownloadDatabase requestDatabase;
    private final SupportSQLiteDatabase database;
    private final String pendingCountQuery;
    private final List<DownloadInfo> updatedDownloadsList;
    private final String namespace;
    private final LiveSettings liveSettings;
    private final boolean fileExistChecksEnabled;
    private final DefaultStorageResolver defaultStorageResolver;

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean getDidSanitizeOnFirstEntry() {
        return this.liveSettings.getDidSanitizeDatabaseOnFirstEntry();
    }

    @Override
    @Nullable
    public DatabaseManager.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable DatabaseManager.Delegate delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Pair<DownloadInfo, Boolean> insert(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            long row = this.requestDatabase.requestDao().insert(downloadInfo);
            Pair pair = new Pair((Object)downloadInfo, (Object)this.requestDatabase.wasRowInserted(row));
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<DownloadInfo, Boolean>> insert(@NotNull List<DownloadInfo> downloadInfoList) {
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        Object object = this.lock;
        synchronized (object) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            this.throwExceptionIfClosed();
            List<Long> rowsList = this.requestDatabase.requestDao().insert(downloadInfoList);
            Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.getIndices((Collection)rowsList);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                Pair pair = new Pair((Object)downloadInfoList.get((int)it), (Object)this.requestDatabase.wasRowInserted(((Number)rowsList.get((int)it)).longValue()));
                collection.add(pair);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.requestDatabase.requestDao().delete(downloadInfo);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(@NotNull List<DownloadInfo> downloadInfoList) {
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.requestDatabase.requestDao().delete(downloadInfoList);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.requestDatabase.requestDao().deleteAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.requestDatabase.requestDao().update(downloadInfo);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(@NotNull List<DownloadInfo> downloadInfoList) {
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        Object object = this.lock;
        synchronized (object) {
            this.updateNoLock(downloadInfoList);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void updateNoLock(@NotNull List<DownloadInfo> downloadInfoList) {
        Intrinsics.checkParameterIsNotNull(downloadInfoList, (String)"downloadInfoList");
        this.throwExceptionIfClosed();
        this.requestDatabase.requestDao().update(downloadInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFileBytesInfoAndStatusOnly(@NotNull DownloadInfo downloadInfo) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfo, (String)"downloadInfo");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            try {
                this.database.beginTransaction();
                this.database.execSQL("UPDATE requests SET " + "_written_bytes = " + downloadInfo.getDownloaded() + ", " + "_total_bytes = " + downloadInfo.getTotal() + ", " + "_status = " + downloadInfo.getStatus().getValue() + ' ' + "WHERE _id = " + downloadInfo.getId());
                this.database.setTransactionSuccessful();
            }
            catch (SQLiteException sQLiteException) {
                // empty catch block
            }
            try {
                this.database.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                // empty catch block
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DownloadInfo updateExtras(int id, @NotNull Extras extras) {
        DownloadInfo downloadInfo;
        Intrinsics.checkParameterIsNotNull((Object)extras, (String)"extras");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.database.beginTransaction();
            this.database.execSQL("UPDATE requests SET " + "_extras = '" + extras.toJSONString() + "' " + "WHERE _id = " + id);
            this.database.setTransactionSuccessful();
            this.database.endTransaction();
            DownloadInfo download = this.requestDatabase.requestDao().get(id);
            DatabaseManagerImpl.sanitize$default(this, download, false, 2, null);
            downloadInfo = download;
        }
        return downloadInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<DownloadInfo> get() {
        Object object = this.lock;
        synchronized (object) {
            List<DownloadInfo> list = this.getDownloadsNoLock();
            return list;
        }
    }

    private final List<DownloadInfo> getDownloadsNoLock() {
        this.throwExceptionIfClosed();
        List<DownloadInfo> downloads = this.requestDatabase.requestDao().get();
        DatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
        return downloads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public DownloadInfo get(int id) {
        Object object = this.lock;
        synchronized (object) {
            void var3_3;
            this.throwExceptionIfClosed();
            DownloadInfo download = this.requestDatabase.requestDao().get(id);
            DatabaseManagerImpl.sanitize$default(this, download, false, 2, null);
            void var5_4 = var3_3;
            return var5_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> get(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        Object object = this.lock;
        synchronized (object) {
            void var3_3;
            this.throwExceptionIfClosed();
            List<DownloadInfo> downloads = this.requestDatabase.requestDao().get(ids);
            DatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
            void var5_4 = var3_3;
            return var5_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public DownloadInfo getByFile(@NotNull String file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Object object = this.lock;
        synchronized (object) {
            void var3_3;
            this.throwExceptionIfClosed();
            DownloadInfo download = this.requestDatabase.requestDao().getByFile(file);
            DatabaseManagerImpl.sanitize$default(this, download, false, 2, null);
            void var5_4 = var3_3;
            return var5_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getByStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        Object object = this.lock;
        synchronized (object) {
            void var3_3;
            this.throwExceptionIfClosed();
            List downloads = this.requestDatabase.requestDao().getByStatus(status);
            if (DatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null)) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)downloads;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    DownloadInfo it = (DownloadInfo)element$iv$iv;
                    if (!(it.getStatus() == status)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                downloads = (List)destination$iv$iv;
            }
            void var14_11 = var3_3;
            return var14_11;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getByGroup(int group) {
        Object object = this.lock;
        synchronized (object) {
            void var3_3;
            this.throwExceptionIfClosed();
            List<DownloadInfo> downloads = this.requestDatabase.requestDao().getByGroup(group);
            DatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
            void var5_4 = var3_3;
            return var5_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getDownloadsInGroupWithStatus(int groupId, @NotNull List<? extends Status> statuses) {
        Intrinsics.checkParameterIsNotNull(statuses, (String)"statuses");
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            List downloads = this.requestDatabase.requestDao().getByGroupWithStatus(groupId, CollectionsKt.toMutableList((Collection)statuses));
            if (DatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null)) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)downloads;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    boolean bl;
                    block8: {
                        DownloadInfo download = (DownloadInfo)element$iv$iv;
                        Iterable $receiver$iv2 = statuses;
                        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $receiver$iv2) {
                                Status it = (Status)((Object)element$iv);
                                if (!(it == download.getStatus())) continue;
                                bl = true;
                                break block8;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                downloads = (List)destination$iv$iv;
            }
            List list = downloads;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<DownloadInfo> getDownloadsByRequestIdentifier(long identifier) {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            List<DownloadInfo> downloads = this.requestDatabase.requestDao().getDownloadsByRequestIdentifier(identifier);
            DatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null);
            List<DownloadInfo> list = downloads;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadInfo> getPendingDownloadsSorted() {
        Object object = this.lock;
        synchronized (object) {
            void var2_2;
            this.throwExceptionIfClosed();
            List downloads = this.requestDatabase.requestDao().getPendingDownloadsSorted(Status.QUEUED);
            if (DatabaseManagerImpl.sanitize$default(this, downloads, false, 2, null)) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)downloads;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    DownloadInfo it = (DownloadInfo)element$iv$iv;
                    if (!(it.getStatus() == Status.QUEUED)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                downloads = (List)destination$iv$iv;
            }
            void var13_10 = var2_2;
            return var13_10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public long getPendingCount() {
        Object object = this.lock;
        synchronized (object) {
            long l;
            try {
                void var3_3;
                Cursor cursor;
                Cursor cursor2 = cursor = this.database.query(this.pendingCountQuery);
                long count = cursor2 != null ? (long)cursor2.getCount() : -1L;
                Cursor cursor3 = cursor;
                if (cursor3 != null) {
                    cursor3.close();
                }
                l = var3_3;
            }
            catch (Exception e) {
                l = -1L;
            }
            long l2 = l;
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sanitizeOnFirstEntry() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.liveSettings.execute((Function1<? super LiveSettings, Unit>)((Function1)new Function1<LiveSettings, Unit>(this){
                final /* synthetic */ DatabaseManagerImpl this$0;
                {
                    this.this$0 = databaseManagerImpl;
                    super(1);
                }

                public final void invoke(@NotNull LiveSettings it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (!it.getDidSanitizeDatabaseOnFirstEntry()) {
                        DatabaseManagerImpl.access$sanitize(this.this$0, DatabaseManagerImpl.access$getDownloadsNoLock(this.this$0), true);
                        it.setDidSanitizeDatabaseOnFirstEntry(true);
                    }
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean sanitize(List<DownloadInfo> downloads, boolean firstEntry) {
        this.updatedDownloadsList.clear();
        int n = 0;
        int n2 = downloads.size();
        while (n < n2) {
            void i;
            DownloadInfo downloadInfo = downloads.get((int)i);
            switch (DatabaseManagerImpl$WhenMappings.$EnumSwitchMapping$0[downloadInfo.getStatus().ordinal()]) {
                case 1: {
                    if (downloadInfo.getTotal() >= 1L || downloadInfo.getDownloaded() <= 0L) break;
                    downloadInfo.setTotal(downloadInfo.getDownloaded());
                    downloadInfo.setError(FetchDefaults.getDefaultNoError());
                    this.updatedDownloadsList.add(downloadInfo);
                    break;
                }
                case 2: {
                    if (!firstEntry) break;
                    Status status = downloadInfo.getDownloaded() > 0L && downloadInfo.getTotal() > 0L && downloadInfo.getDownloaded() >= downloadInfo.getTotal() ? Status.COMPLETED : Status.QUEUED;
                    downloadInfo.setStatus(status);
                    downloadInfo.setError(FetchDefaults.getDefaultNoError());
                    this.updatedDownloadsList.add(downloadInfo);
                    break;
                }
                case 3: 
                case 4: {
                    if (downloadInfo.getDownloaded() <= 0L || !this.fileExistChecksEnabled || this.defaultStorageResolver.fileExists(downloadInfo.getFile())) break;
                    downloadInfo.setDownloaded(0L);
                    downloadInfo.setTotal(-1L);
                    downloadInfo.setError(FetchDefaults.getDefaultNoError());
                    this.updatedDownloadsList.add(downloadInfo);
                    DatabaseManager.Delegate delegate = this.getDelegate();
                    if (delegate == null) break;
                    delegate.deleteTempFilesForDownload(downloadInfo);
                    break;
                }
            }
            ++i;
        }
        int updatedCount = this.updatedDownloadsList.size();
        if (updatedCount > 0) {
            try {
                this.updateNoLock(this.updatedDownloadsList);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.updatedDownloadsList.clear();
        return updatedCount > 0;
    }

    static /* synthetic */ boolean sanitize$default(DatabaseManagerImpl databaseManagerImpl, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return databaseManagerImpl.sanitize(list, bl);
    }

    private final boolean sanitize(DownloadInfo downloadInfo, boolean initializing) {
        return downloadInfo == null ? false : this.sanitize(CollectionsKt.listOf((Object)downloadInfo), initializing);
    }

    static /* synthetic */ boolean sanitize$default(DatabaseManagerImpl databaseManagerImpl, DownloadInfo downloadInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return databaseManagerImpl.sanitize(downloadInfo, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.requestDatabase.close();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void throwExceptionIfClosed() {
        if (this.closed) {
            throw (Throwable)new FetchException(this.namespace + " database is closed");
        }
    }

    public DatabaseManagerImpl(@NotNull Context context, @NotNull String namespace, @NotNull Migration[] migrations, @NotNull LiveSettings liveSettings, boolean fileExistChecksEnabled, @NotNull DefaultStorageResolver defaultStorageResolver) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)migrations, (String)"migrations");
        Intrinsics.checkParameterIsNotNull((Object)liveSettings, (String)"liveSettings");
        Intrinsics.checkParameterIsNotNull((Object)defaultStorageResolver, (String)"defaultStorageResolver");
        this.namespace = namespace;
        this.liveSettings = liveSettings;
        this.fileExistChecksEnabled = fileExistChecksEnabled;
        this.defaultStorageResolver = defaultStorageResolver;
        this.lock = new Object();
        RoomDatabase.Builder builder = Room.databaseBuilder((Context)context, DownloadDatabase.class, (String)(this.namespace + ".db"));
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"Room.databaseBuilder(con\u2026ss.java, \"$namespace.db\")");
        RoomDatabase.Builder builder2 = builder;
        android.arch.persistence.room.migration.Migration[] migrationArray = migrations;
        builder2.addMigrations(Arrays.copyOf(migrationArray, migrationArray.length));
        RoomDatabase roomDatabase = builder2.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)roomDatabase, (String)"builder.build()");
        this.requestDatabase = (DownloadDatabase)roomDatabase;
        SupportSQLiteOpenHelper supportSQLiteOpenHelper = this.requestDatabase.getOpenHelper();
        Intrinsics.checkExpressionValueIsNotNull((Object)supportSQLiteOpenHelper, (String)"requestDatabase.openHelper");
        SupportSQLiteDatabase supportSQLiteDatabase = supportSQLiteOpenHelper.getWritableDatabase();
        Intrinsics.checkExpressionValueIsNotNull((Object)supportSQLiteDatabase, (String)"requestDatabase.openHelper.writableDatabase");
        this.database = supportSQLiteDatabase;
        this.pendingCountQuery = "SELECT _id FROM requests" + " WHERE _status = '" + Status.QUEUED.getValue() + '\'' + " OR _status = '" + (Object)((Object)Status.DOWNLOADING) + '\'';
        DatabaseManagerImpl databaseManagerImpl = this;
        databaseManagerImpl.updatedDownloadsList = list = (List)new ArrayList();
    }

    public static final /* synthetic */ boolean access$sanitize(DatabaseManagerImpl $this, @NotNull List downloads, boolean firstEntry) {
        return $this.sanitize(downloads, firstEntry);
    }

    @NotNull
    public static final /* synthetic */ List access$getDownloadsNoLock(DatabaseManagerImpl $this) {
        return $this.getDownloadsNoLock();
    }
}

