/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.util;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Request;
import com.tonyodev.fetch2.util.FetchUtils$WhenMappings;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.Extras;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileSliceInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001e\u0010\u0011\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\u0019\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a,\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u00172\b\b\u0002\u0010\u001c\u001a\u00020\u00172\b\b\u0002\u0010\u001d\u001a\u00020\f\u001a\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u001d\u001a\u00020\f\u001a\u001e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001e\u0010 \u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\""}, d2={"canCancelDownload", "", "download", "Lcom/tonyodev/fetch2/Download;", "canPauseDownload", "canResumeDownload", "canRetryDownload", "deleteAllInFolderForId", "", "id", "", "fileTempDir", "", "getCatalogServerRequestFromRequest", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "request", "Lcom/tonyodev/fetch2/Request;", "getDownloadedInfoFilePath", "position", "getFileSliceInfo", "Lcom/tonyodev/fetch2core/FileSliceInfo;", "fileSliceSize", "totalBytes", "", "getMetaFilePath", "getPreviousSliceCount", "getRequestForDownload", "rangeStart", "rangeEnd", "requestMethod", "getSavedDownloadedInfo", "getServerRequestFromRequest", "saveCurrentSliceCount", "SliceCount", "fetch2_release"})
@JvmName(name="FetchUtils")
public final class FetchUtils {
    public static final boolean canPauseDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$0[download.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean canResumeDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$1[download.getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean canRetryDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$2[download.getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean canCancelDownload(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        switch (FetchUtils$WhenMappings.$EnumSwitchMapping$3[download.getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public static final Downloader.ServerRequest getRequestForDownload(@NotNull Download download, @NotNull String requestMethod) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Intrinsics.checkParameterIsNotNull((Object)requestMethod, (String)"requestMethod");
        return FetchUtils.getRequestForDownload(download, -1L, -1L, requestMethod);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Downloader.ServerRequest getRequestForDownload$default(Download download, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "GET";
        }
        return FetchUtils.getRequestForDownload(download, string);
    }

    @NotNull
    public static final Downloader.ServerRequest getRequestForDownload(@NotNull Download download, long rangeStart, long rangeEnd, @NotNull String requestMethod) {
        Map headers;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Intrinsics.checkParameterIsNotNull((Object)requestMethod, (String)"requestMethod");
        long start = rangeStart == -1L ? 0L : rangeStart;
        String end = rangeEnd == -1L ? "" : String.valueOf(rangeEnd);
        Map map = headers = MapsKt.toMutableMap(download.getHeaders());
        String string = "Range";
        String string2 = "bytes=" + start + '-' + end;
        map.put(string, string2);
        return new Downloader.ServerRequest(download.getId(), download.getUrl(), headers, download.getFile(), download.getTag(), download.getIdentifier(), requestMethod, download.getExtras());
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Downloader.ServerRequest getRequestForDownload$default(Download download, long l, long l2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            l = -1L;
        }
        if ((n & 4) != 0) {
            l2 = -1L;
        }
        if ((n & 8) != 0) {
            string = "GET";
        }
        return FetchUtils.getRequestForDownload(download, l, l2, string);
    }

    @NotNull
    public static final Downloader.ServerRequest getServerRequestFromRequest(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Extras extras = request.getExtras();
        String string = request.getFile();
        String string2 = "GET";
        long l = request.getIdentifier();
        String string3 = request.getTag();
        return new Downloader.ServerRequest(request.getId(), request.getUrl(), request.getHeaders(), string, string3, l, string2, extras);
    }

    @NotNull
    public static final Downloader.ServerRequest getCatalogServerRequestFromRequest(@NotNull Request request) {
        Map headers;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Map map = headers = MapsKt.toMutableMap(request.getHeaders());
        String string = "Range";
        String string2 = "bytes=0-";
        map.put(string, string2);
        map = headers;
        string = "Page";
        string2 = "-1";
        map.put(string, string2);
        map = headers;
        string = "Size";
        string2 = "-1";
        map.put(string, string2);
        map = headers;
        string = "Type";
        string2 = String.valueOf(1);
        map.put(string, string2);
        map = request.getExtras();
        string = request.getFile();
        string2 = "GET";
        long l = request.getIdentifier();
        String string3 = request.getTag();
        return new Downloader.ServerRequest(request.getId(), request.getUrl(), headers, string, string3, l, string2, (Extras)map);
    }

    public static final int getPreviousSliceCount(int id, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        int sliceCount = -1;
        try {
            Long l = FetchCoreUtils.getLongDataFromFile((String)FetchUtils.getMetaFilePath(id, fileTempDir));
            sliceCount = l != null ? (int)l.longValue() : -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sliceCount;
    }

    @NotNull
    public static final String getMetaFilePath(int id, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        return fileTempDir + '/' + id + ".meta.data";
    }

    public static final void saveCurrentSliceCount(int id, int SliceCount, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        try {
            FetchCoreUtils.writeLongToFile((String)FetchUtils.getMetaFilePath(id, fileTempDir), (long)SliceCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static final String getDownloadedInfoFilePath(int id, int position, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        return fileTempDir + '/' + id + '.' + position + ".data";
    }

    /*
     * WARNING - void declaration
     */
    public static final void deleteAllInFolderForId(int id, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        try {
            File[] files;
            File dir = new File(fileTempDir);
            if (dir.exists() && (files = dir.listFiles()) != null) {
                void $receiver$iv$iv;
                Object $receiver$iv;
                Object object = $receiver$iv = files;
                Collection destination$iv$iv = new ArrayList();
                int n = ((void)$receiver$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void file;
                    void v0 = file = (element$iv$iv = $receiver$iv$iv[i]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"file");
                    if (!StringsKt.startsWith$default((String)FilesKt.getNameWithoutExtension((File)v0), (String)("" + id + '.'), (boolean)false, (int)2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List filteredFilesList = (List)destination$iv$iv;
                $receiver$iv = filteredFilesList;
                object = $receiver$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    File file = (File)element$iv;
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final long getSavedDownloadedInfo(int id, int position, @NotNull String fileTempDir) {
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        long downloaded = 0L;
        try {
            Long l = FetchCoreUtils.getLongDataFromFile((String)FetchUtils.getDownloadedInfoFilePath(id, position, fileTempDir));
            downloaded = l != null ? l : 0L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return downloaded;
    }

    @NotNull
    public static final FileSliceInfo getFileSliceInfo(int fileSliceSize, long totalBytes) {
        FileSliceInfo fileSliceInfo;
        if (fileSliceSize == -1) {
            float fileSizeInMb = (float)totalBytes / 1024.0f * 1024.0f;
            float fileSizeInGb = (float)totalBytes / 1024.0f * 1024.0f * 1024.0f;
            if (fileSizeInGb >= 1.0f) {
                int slices = 6;
                float f = (float)totalBytes / (float)slices;
                long bytesPerSlice = (long)Math.ceil(f);
                fileSliceInfo = new FileSliceInfo(slices, bytesPerSlice);
            } else if (fileSizeInMb >= 1.0f) {
                int slices = 4;
                float f = (float)totalBytes / (float)slices;
                long bytesPerSlice = (long)Math.ceil(f);
                fileSliceInfo = new FileSliceInfo(slices, bytesPerSlice);
            } else {
                fileSliceInfo = new FileSliceInfo(2, totalBytes);
            }
        } else {
            float f = (float)totalBytes / (float)fileSliceSize;
            long bytesPerSlice = (long)Math.ceil(f);
            return new FileSliceInfo(fileSliceSize, bytesPerSlice);
        }
        return fileSliceInfo;
    }
}

