/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.database;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.arch.persistence.room.util.StringUtil;
import android.database.Cursor;
import com.tonyodev.fetch2.EnqueueAction;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Priority;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.Converter;
import com.tonyodev.fetch2.database.DownloadDao;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2core.Extras;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DownloadDao_Impl
implements DownloadDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfDownloadInfo;
    private final Converter __converter = new Converter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfDownloadInfo;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfDownloadInfo;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public DownloadDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfDownloadInfo = new EntityInsertionAdapter<DownloadInfo>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `requests`(`_id`,`_namespace`,`_url`,`_file`,`_group`,`_priority`,`_headers`,`_written_bytes`,`_total_bytes`,`_status`,`_error`,`_network_type`,`_created`,`_tag`,`_enqueue_action`,`_identifier`,`_download_on_enqueue`,`_extras`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, DownloadInfo value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getNamespace() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getNamespace());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUrl());
                }
                if (value.getFile() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getFile());
                }
                stmt.bindLong(5, (long)value.getGroup());
                int _tmp = DownloadDao_Impl.this.__converter.toPriorityValue(value.getPriority());
                stmt.bindLong(6, (long)_tmp);
                String _tmp_1 = DownloadDao_Impl.this.__converter.toHeaderStringsMap(value.getHeaders());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                stmt.bindLong(8, value.getDownloaded());
                stmt.bindLong(9, value.getTotal());
                int _tmp_2 = DownloadDao_Impl.this.__converter.toStatusValue(value.getStatus());
                stmt.bindLong(10, (long)_tmp_2);
                int _tmp_3 = DownloadDao_Impl.this.__converter.toErrorValue(value.getError());
                stmt.bindLong(11, (long)_tmp_3);
                int _tmp_4 = DownloadDao_Impl.this.__converter.toNetworkTypeValue(value.getNetworkType());
                stmt.bindLong(12, (long)_tmp_4);
                stmt.bindLong(13, value.getCreated());
                if (value.getTag() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getTag());
                }
                int _tmp_5 = DownloadDao_Impl.this.__converter.toEnqueueActionValue(value.getEnqueueAction());
                stmt.bindLong(15, (long)_tmp_5);
                stmt.bindLong(16, value.getIdentifier());
                int _tmp_6 = value.getDownloadOnEnqueue() ? 1 : 0;
                stmt.bindLong(17, (long)_tmp_6);
                String _tmp_7 = DownloadDao_Impl.this.__converter.fromExtrasToString(value.getExtras());
                if (_tmp_7 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_7);
                }
            }
        };
        this.__deletionAdapterOfDownloadInfo = new EntityDeletionOrUpdateAdapter<DownloadInfo>(__db){

            public String createQuery() {
                return "DELETE FROM `requests` WHERE `_id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, DownloadInfo value) {
                stmt.bindLong(1, (long)value.getId());
            }
        };
        this.__updateAdapterOfDownloadInfo = new EntityDeletionOrUpdateAdapter<DownloadInfo>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `requests` SET `_id` = ?,`_namespace` = ?,`_url` = ?,`_file` = ?,`_group` = ?,`_priority` = ?,`_headers` = ?,`_written_bytes` = ?,`_total_bytes` = ?,`_status` = ?,`_error` = ?,`_network_type` = ?,`_created` = ?,`_tag` = ?,`_enqueue_action` = ?,`_identifier` = ?,`_download_on_enqueue` = ?,`_extras` = ? WHERE `_id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, DownloadInfo value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getNamespace() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getNamespace());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUrl());
                }
                if (value.getFile() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getFile());
                }
                stmt.bindLong(5, (long)value.getGroup());
                int _tmp = DownloadDao_Impl.this.__converter.toPriorityValue(value.getPriority());
                stmt.bindLong(6, (long)_tmp);
                String _tmp_1 = DownloadDao_Impl.this.__converter.toHeaderStringsMap(value.getHeaders());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                stmt.bindLong(8, value.getDownloaded());
                stmt.bindLong(9, value.getTotal());
                int _tmp_2 = DownloadDao_Impl.this.__converter.toStatusValue(value.getStatus());
                stmt.bindLong(10, (long)_tmp_2);
                int _tmp_3 = DownloadDao_Impl.this.__converter.toErrorValue(value.getError());
                stmt.bindLong(11, (long)_tmp_3);
                int _tmp_4 = DownloadDao_Impl.this.__converter.toNetworkTypeValue(value.getNetworkType());
                stmt.bindLong(12, (long)_tmp_4);
                stmt.bindLong(13, value.getCreated());
                if (value.getTag() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getTag());
                }
                int _tmp_5 = DownloadDao_Impl.this.__converter.toEnqueueActionValue(value.getEnqueueAction());
                stmt.bindLong(15, (long)_tmp_5);
                stmt.bindLong(16, value.getIdentifier());
                int _tmp_6 = value.getDownloadOnEnqueue() ? 1 : 0;
                stmt.bindLong(17, (long)_tmp_6);
                String _tmp_7 = DownloadDao_Impl.this.__converter.fromExtrasToString(value.getExtras());
                if (_tmp_7 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_7);
                }
                stmt.bindLong(19, (long)value.getId());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM requests";
                return "DELETE FROM requests";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(DownloadInfo downloadInfo) {
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfDownloadInfo.insertAndReturnId((Object)downloadInfo);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> insert(List<DownloadInfo> downloadInfoList) {
        this.__db.beginTransaction();
        try {
            List _result = this.__insertionAdapterOfDownloadInfo.insertAndReturnIdsList(downloadInfoList);
            this.__db.setTransactionSuccessful();
            List list = _result;
            return list;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(DownloadInfo downloadInfo) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfDownloadInfo.handle((Object)downloadInfo);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<DownloadInfo> downloadInfoList) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfDownloadInfo.handleMultiple(downloadInfoList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(DownloadInfo download) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfDownloadInfo.handle((Object)download);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(List<DownloadInfo> downloadInfoList) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfDownloadInfo.handleMultiple(downloadInfoList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> get() {
        String _sql = "SELECT * FROM requests";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("_id");
            int _cursorIndexOfNamespace = _cursor.getColumnIndexOrThrow("_namespace");
            int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("_url");
            int _cursorIndexOfFile = _cursor.getColumnIndexOrThrow("_file");
            int _cursorIndexOfGroup = _cursor.getColumnIndexOrThrow("_group");
            int _cursorIndexOfPriority = _cursor.getColumnIndexOrThrow("_priority");
            int _cursorIndexOfHeaders = _cursor.getColumnIndexOrThrow("_headers");
            int _cursorIndexOfDownloaded = _cursor.getColumnIndexOrThrow("_written_bytes");
            int _cursorIndexOfTotal = _cursor.getColumnIndexOrThrow("_total_bytes");
            int _cursorIndexOfStatus = _cursor.getColumnIndexOrThrow("_status");
            int _cursorIndexOfError = _cursor.getColumnIndexOrThrow("_error");
            int _cursorIndexOfNetworkType = _cursor.getColumnIndexOrThrow("_network_type");
            int _cursorIndexOfCreated = _cursor.getColumnIndexOrThrow("_created");
            int _cursorIndexOfTag = _cursor.getColumnIndexOrThrow("_tag");
            int _cursorIndexOfEnqueueAction = _cursor.getColumnIndexOrThrow("_enqueue_action");
            int _cursorIndexOfIdentifier = _cursor.getColumnIndexOrThrow("_identifier");
            int _cursorIndexOfDownloadOnEnqueue = _cursor.getColumnIndexOrThrow("_download_on_enqueue");
            int _cursorIndexOfExtras = _cursor.getColumnIndexOrThrow("_extras");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item.setGroup(_tmpGroup);
                int _tmp = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp);
                _item.setPriority(_tmpPriority);
                String _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_1);
                _item.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item.setTotal(_tmpTotal);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_2);
                _item.setStatus(_tmpStatus);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_3);
                _item.setError(_tmpError);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_4);
                _item.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item.setTag(_tmpTag);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_5);
                _item.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_6 != 0;
                _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_7);
                _item.setExtras(_tmpExtras);
                _result.add(_item);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadInfo get(int id) {
        String _sql = "SELECT * FROM requests WHERE _id = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)id);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            DownloadInfo _result;
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("_id");
            int _cursorIndexOfNamespace = _cursor.getColumnIndexOrThrow("_namespace");
            int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("_url");
            int _cursorIndexOfFile = _cursor.getColumnIndexOrThrow("_file");
            int _cursorIndexOfGroup = _cursor.getColumnIndexOrThrow("_group");
            int _cursorIndexOfPriority = _cursor.getColumnIndexOrThrow("_priority");
            int _cursorIndexOfHeaders = _cursor.getColumnIndexOrThrow("_headers");
            int _cursorIndexOfDownloaded = _cursor.getColumnIndexOrThrow("_written_bytes");
            int _cursorIndexOfTotal = _cursor.getColumnIndexOrThrow("_total_bytes");
            int _cursorIndexOfStatus = _cursor.getColumnIndexOrThrow("_status");
            int _cursorIndexOfError = _cursor.getColumnIndexOrThrow("_error");
            int _cursorIndexOfNetworkType = _cursor.getColumnIndexOrThrow("_network_type");
            int _cursorIndexOfCreated = _cursor.getColumnIndexOrThrow("_created");
            int _cursorIndexOfTag = _cursor.getColumnIndexOrThrow("_tag");
            int _cursorIndexOfEnqueueAction = _cursor.getColumnIndexOrThrow("_enqueue_action");
            int _cursorIndexOfIdentifier = _cursor.getColumnIndexOrThrow("_identifier");
            int _cursorIndexOfDownloadOnEnqueue = _cursor.getColumnIndexOrThrow("_download_on_enqueue");
            int _cursorIndexOfExtras = _cursor.getColumnIndexOrThrow("_extras");
            if (_cursor.moveToFirst()) {
                _result = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _result.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _result.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _result.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _result.setGroup(_tmpGroup);
                int _tmp = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp);
                _result.setPriority(_tmpPriority);
                String _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_1);
                _result.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _result.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _result.setTotal(_tmpTotal);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_2);
                _result.setStatus(_tmpStatus);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_3);
                _result.setError(_tmpError);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_4);
                _result.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _result.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _result.setTag(_tmpTag);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_5);
                _result.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _result.setIdentifier(_tmpIdentifier);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_6 != 0;
                _result.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_7);
                _result.setExtras(_tmpExtras);
            } else {
                _result = null;
            }
            DownloadInfo downloadInfo = _result;
            return downloadInfo;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> get(List<Integer> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * FROM requests WHERE _id IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (Integer _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindLong(_argIndex, (long)_item.intValue());
            }
            ++_argIndex;
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("_id");
            int _cursorIndexOfNamespace = _cursor.getColumnIndexOrThrow("_namespace");
            int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("_url");
            int _cursorIndexOfFile = _cursor.getColumnIndexOrThrow("_file");
            int _cursorIndexOfGroup = _cursor.getColumnIndexOrThrow("_group");
            int _cursorIndexOfPriority = _cursor.getColumnIndexOrThrow("_priority");
            int _cursorIndexOfHeaders = _cursor.getColumnIndexOrThrow("_headers");
            int _cursorIndexOfDownloaded = _cursor.getColumnIndexOrThrow("_written_bytes");
            int _cursorIndexOfTotal = _cursor.getColumnIndexOrThrow("_total_bytes");
            int _cursorIndexOfStatus = _cursor.getColumnIndexOrThrow("_status");
            int _cursorIndexOfError = _cursor.getColumnIndexOrThrow("_error");
            int _cursorIndexOfNetworkType = _cursor.getColumnIndexOrThrow("_network_type");
            int _cursorIndexOfCreated = _cursor.getColumnIndexOrThrow("_created");
            int _cursorIndexOfTag = _cursor.getColumnIndexOrThrow("_tag");
            int _cursorIndexOfEnqueueAction = _cursor.getColumnIndexOrThrow("_enqueue_action");
            int _cursorIndexOfIdentifier = _cursor.getColumnIndexOrThrow("_identifier");
            int _cursorIndexOfDownloadOnEnqueue = _cursor.getColumnIndexOrThrow("_download_on_enqueue");
            int _cursorIndexOfExtras = _cursor.getColumnIndexOrThrow("_extras");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item_1 = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item_1.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item_1.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item_1.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item_1.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item_1.setGroup(_tmpGroup);
                int _tmp = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp);
                _item_1.setPriority(_tmpPriority);
                String _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_1);
                _item_1.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item_1.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item_1.setTotal(_tmpTotal);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_2);
                _item_1.setStatus(_tmpStatus);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_3);
                _item_1.setError(_tmpError);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_4);
                _item_1.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item_1.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item_1.setTag(_tmpTag);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_5);
                _item_1.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item_1.setIdentifier(_tmpIdentifier);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_6 != 0;
                _item_1.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_7);
                _item_1.setExtras(_tmpExtras);
                _result.add(_item_1);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadInfo getByFile(String file) {
        String _sql = "SELECT * FROM requests WHERE _file = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _file = ?", (int)1);
        int _argIndex = 1;
        if (file == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, file);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            DownloadInfo _result;
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("_id");
            int _cursorIndexOfNamespace = _cursor.getColumnIndexOrThrow("_namespace");
            int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("_url");
            int _cursorIndexOfFile = _cursor.getColumnIndexOrThrow("_file");
            int _cursorIndexOfGroup = _cursor.getColumnIndexOrThrow("_group");
            int _cursorIndexOfPriority = _cursor.getColumnIndexOrThrow("_priority");
            int _cursorIndexOfHeaders = _cursor.getColumnIndexOrThrow("_headers");
            int _cursorIndexOfDownloaded = _cursor.getColumnIndexOrThrow("_written_bytes");
            int _cursorIndexOfTotal = _cursor.getColumnIndexOrThrow("_total_bytes");
            int _cursorIndexOfStatus = _cursor.getColumnIndexOrThrow("_status");
            int _cursorIndexOfError = _cursor.getColumnIndexOrThrow("_error");
            int _cursorIndexOfNetworkType = _cursor.getColumnIndexOrThrow("_network_type");
            int _cursorIndexOfCreated = _cursor.getColumnIndexOrThrow("_created");
            int _cursorIndexOfTag = _cursor.getColumnIndexOrThrow("_tag");
            int _cursorIndexOfEnqueueAction = _cursor.getColumnIndexOrThrow("_enqueue_action");
            int _cursorIndexOfIdentifier = _cursor.getColumnIndexOrThrow("_identifier");
            int _cursorIndexOfDownloadOnEnqueue = _cursor.getColumnIndexOrThrow("_download_on_enqueue");
            int _cursorIndexOfExtras = _cursor.getColumnIndexOrThrow("_extras");
            if (_cursor.moveToFirst()) {
                _result = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _result.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _result.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _result.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _result.setGroup(_tmpGroup);
                int _tmp = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp);
                _result.setPriority(_tmpPriority);
                String _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_1);
                _result.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _result.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _result.setTotal(_tmpTotal);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_2);
                _result.setStatus(_tmpStatus);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_3);
                _result.setError(_tmpError);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_4);
                _result.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _result.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _result.setTag(_tmpTag);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_5);
                _result.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _result.setIdentifier(_tmpIdentifier);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_6 != 0;
                _result.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_7);
                _result.setExtras(_tmpExtras);
            } else {
                _result = null;
            }
            DownloadInfo downloadInfo = _result;
            return downloadInfo;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> getByStatus(Status status) {
        String _sql = "SELECT * FROM requests WHERE _status = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _status = ?", (int)1);
        int _argIndex = 1;
        int _tmp = this.__converter.toStatusValue(status);
        _statement.bindLong(_argIndex, (long)_tmp);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("_id");
            int _cursorIndexOfNamespace = _cursor.getColumnIndexOrThrow("_namespace");
            int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("_url");
            int _cursorIndexOfFile = _cursor.getColumnIndexOrThrow("_file");
            int _cursorIndexOfGroup = _cursor.getColumnIndexOrThrow("_group");
            int _cursorIndexOfPriority = _cursor.getColumnIndexOrThrow("_priority");
            int _cursorIndexOfHeaders = _cursor.getColumnIndexOrThrow("_headers");
            int _cursorIndexOfDownloaded = _cursor.getColumnIndexOrThrow("_written_bytes");
            int _cursorIndexOfTotal = _cursor.getColumnIndexOrThrow("_total_bytes");
            int _cursorIndexOfStatus = _cursor.getColumnIndexOrThrow("_status");
            int _cursorIndexOfError = _cursor.getColumnIndexOrThrow("_error");
            int _cursorIndexOfNetworkType = _cursor.getColumnIndexOrThrow("_network_type");
            int _cursorIndexOfCreated = _cursor.getColumnIndexOrThrow("_created");
            int _cursorIndexOfTag = _cursor.getColumnIndexOrThrow("_tag");
            int _cursorIndexOfEnqueueAction = _cursor.getColumnIndexOrThrow("_enqueue_action");
            int _cursorIndexOfIdentifier = _cursor.getColumnIndexOrThrow("_identifier");
            int _cursorIndexOfDownloadOnEnqueue = _cursor.getColumnIndexOrThrow("_download_on_enqueue");
            int _cursorIndexOfExtras = _cursor.getColumnIndexOrThrow("_extras");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item.setGroup(_tmpGroup);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp_1);
                _item.setPriority(_tmpPriority);
                String _tmp_2 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_2);
                _item.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item.setTotal(_tmpTotal);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_3);
                _item.setStatus(_tmpStatus);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_4);
                _item.setError(_tmpError);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_5);
                _item.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item.setTag(_tmpTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_6);
                _item.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_7 != 0;
                _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_8 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_8);
                _item.setExtras(_tmpExtras);
                _result.add(_item);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> getByGroup(int group) {
        String _sql = "SELECT * FROM requests WHERE _group = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _group = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)group);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("_id");
            int _cursorIndexOfNamespace = _cursor.getColumnIndexOrThrow("_namespace");
            int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("_url");
            int _cursorIndexOfFile = _cursor.getColumnIndexOrThrow("_file");
            int _cursorIndexOfGroup = _cursor.getColumnIndexOrThrow("_group");
            int _cursorIndexOfPriority = _cursor.getColumnIndexOrThrow("_priority");
            int _cursorIndexOfHeaders = _cursor.getColumnIndexOrThrow("_headers");
            int _cursorIndexOfDownloaded = _cursor.getColumnIndexOrThrow("_written_bytes");
            int _cursorIndexOfTotal = _cursor.getColumnIndexOrThrow("_total_bytes");
            int _cursorIndexOfStatus = _cursor.getColumnIndexOrThrow("_status");
            int _cursorIndexOfError = _cursor.getColumnIndexOrThrow("_error");
            int _cursorIndexOfNetworkType = _cursor.getColumnIndexOrThrow("_network_type");
            int _cursorIndexOfCreated = _cursor.getColumnIndexOrThrow("_created");
            int _cursorIndexOfTag = _cursor.getColumnIndexOrThrow("_tag");
            int _cursorIndexOfEnqueueAction = _cursor.getColumnIndexOrThrow("_enqueue_action");
            int _cursorIndexOfIdentifier = _cursor.getColumnIndexOrThrow("_identifier");
            int _cursorIndexOfDownloadOnEnqueue = _cursor.getColumnIndexOrThrow("_download_on_enqueue");
            int _cursorIndexOfExtras = _cursor.getColumnIndexOrThrow("_extras");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item.setGroup(_tmpGroup);
                int _tmp = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp);
                _item.setPriority(_tmpPriority);
                String _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_1);
                _item.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item.setTotal(_tmpTotal);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_2);
                _item.setStatus(_tmpStatus);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_3);
                _item.setError(_tmpError);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_4);
                _item.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item.setTag(_tmpTag);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_5);
                _item.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_6 != 0;
                _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_7);
                _item.setExtras(_tmpExtras);
                _result.add(_item);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> getByGroupWithStatus(int group, Status status) {
        String _sql = "SELECT * FROM requests WHERE _group = ? AND _status = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _group = ? AND _status = ?", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)group);
        _argIndex = 2;
        int _tmp = this.__converter.toStatusValue(status);
        _statement.bindLong(_argIndex, (long)_tmp);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("_id");
            int _cursorIndexOfNamespace = _cursor.getColumnIndexOrThrow("_namespace");
            int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("_url");
            int _cursorIndexOfFile = _cursor.getColumnIndexOrThrow("_file");
            int _cursorIndexOfGroup = _cursor.getColumnIndexOrThrow("_group");
            int _cursorIndexOfPriority = _cursor.getColumnIndexOrThrow("_priority");
            int _cursorIndexOfHeaders = _cursor.getColumnIndexOrThrow("_headers");
            int _cursorIndexOfDownloaded = _cursor.getColumnIndexOrThrow("_written_bytes");
            int _cursorIndexOfTotal = _cursor.getColumnIndexOrThrow("_total_bytes");
            int _cursorIndexOfStatus = _cursor.getColumnIndexOrThrow("_status");
            int _cursorIndexOfError = _cursor.getColumnIndexOrThrow("_error");
            int _cursorIndexOfNetworkType = _cursor.getColumnIndexOrThrow("_network_type");
            int _cursorIndexOfCreated = _cursor.getColumnIndexOrThrow("_created");
            int _cursorIndexOfTag = _cursor.getColumnIndexOrThrow("_tag");
            int _cursorIndexOfEnqueueAction = _cursor.getColumnIndexOrThrow("_enqueue_action");
            int _cursorIndexOfIdentifier = _cursor.getColumnIndexOrThrow("_identifier");
            int _cursorIndexOfDownloadOnEnqueue = _cursor.getColumnIndexOrThrow("_download_on_enqueue");
            int _cursorIndexOfExtras = _cursor.getColumnIndexOrThrow("_extras");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item.setGroup(_tmpGroup);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp_1);
                _item.setPriority(_tmpPriority);
                String _tmp_2 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_2);
                _item.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item.setTotal(_tmpTotal);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_3);
                _item.setStatus(_tmpStatus);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_4);
                _item.setError(_tmpError);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_5);
                _item.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item.setTag(_tmpTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_6);
                _item.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_7 != 0;
                _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_8 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_8);
                _item.setExtras(_tmpExtras);
                _result.add(_item);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> getPendingDownloadsSorted(Status status) {
        String _sql = "SELECT * FROM requests WHERE _status = ? ORDER BY _priority DESC, _created ASC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _status = ? ORDER BY _priority DESC, _created ASC", (int)1);
        int _argIndex = 1;
        int _tmp = this.__converter.toStatusValue(status);
        _statement.bindLong(_argIndex, (long)_tmp);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("_id");
            int _cursorIndexOfNamespace = _cursor.getColumnIndexOrThrow("_namespace");
            int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("_url");
            int _cursorIndexOfFile = _cursor.getColumnIndexOrThrow("_file");
            int _cursorIndexOfGroup = _cursor.getColumnIndexOrThrow("_group");
            int _cursorIndexOfPriority = _cursor.getColumnIndexOrThrow("_priority");
            int _cursorIndexOfHeaders = _cursor.getColumnIndexOrThrow("_headers");
            int _cursorIndexOfDownloaded = _cursor.getColumnIndexOrThrow("_written_bytes");
            int _cursorIndexOfTotal = _cursor.getColumnIndexOrThrow("_total_bytes");
            int _cursorIndexOfStatus = _cursor.getColumnIndexOrThrow("_status");
            int _cursorIndexOfError = _cursor.getColumnIndexOrThrow("_error");
            int _cursorIndexOfNetworkType = _cursor.getColumnIndexOrThrow("_network_type");
            int _cursorIndexOfCreated = _cursor.getColumnIndexOrThrow("_created");
            int _cursorIndexOfTag = _cursor.getColumnIndexOrThrow("_tag");
            int _cursorIndexOfEnqueueAction = _cursor.getColumnIndexOrThrow("_enqueue_action");
            int _cursorIndexOfIdentifier = _cursor.getColumnIndexOrThrow("_identifier");
            int _cursorIndexOfDownloadOnEnqueue = _cursor.getColumnIndexOrThrow("_download_on_enqueue");
            int _cursorIndexOfExtras = _cursor.getColumnIndexOrThrow("_extras");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item.setGroup(_tmpGroup);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp_1);
                _item.setPriority(_tmpPriority);
                String _tmp_2 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_2);
                _item.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item.setTotal(_tmpTotal);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_3);
                _item.setStatus(_tmpStatus);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_4);
                _item.setError(_tmpError);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_5);
                _item.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item.setTag(_tmpTag);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_6);
                _item.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                int _tmp_7 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_7 != 0;
                _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_8 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_8);
                _item.setExtras(_tmpExtras);
                _result.add(_item);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadInfo> getDownloadsByRequestIdentifier(long identifier) {
        String _sql = "SELECT * FROM requests WHERE _identifier = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM requests WHERE _identifier = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, identifier);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfId = _cursor.getColumnIndexOrThrow("_id");
            int _cursorIndexOfNamespace = _cursor.getColumnIndexOrThrow("_namespace");
            int _cursorIndexOfUrl = _cursor.getColumnIndexOrThrow("_url");
            int _cursorIndexOfFile = _cursor.getColumnIndexOrThrow("_file");
            int _cursorIndexOfGroup = _cursor.getColumnIndexOrThrow("_group");
            int _cursorIndexOfPriority = _cursor.getColumnIndexOrThrow("_priority");
            int _cursorIndexOfHeaders = _cursor.getColumnIndexOrThrow("_headers");
            int _cursorIndexOfDownloaded = _cursor.getColumnIndexOrThrow("_written_bytes");
            int _cursorIndexOfTotal = _cursor.getColumnIndexOrThrow("_total_bytes");
            int _cursorIndexOfStatus = _cursor.getColumnIndexOrThrow("_status");
            int _cursorIndexOfError = _cursor.getColumnIndexOrThrow("_error");
            int _cursorIndexOfNetworkType = _cursor.getColumnIndexOrThrow("_network_type");
            int _cursorIndexOfCreated = _cursor.getColumnIndexOrThrow("_created");
            int _cursorIndexOfTag = _cursor.getColumnIndexOrThrow("_tag");
            int _cursorIndexOfEnqueueAction = _cursor.getColumnIndexOrThrow("_enqueue_action");
            int _cursorIndexOfIdentifier = _cursor.getColumnIndexOrThrow("_identifier");
            int _cursorIndexOfDownloadOnEnqueue = _cursor.getColumnIndexOrThrow("_download_on_enqueue");
            int _cursorIndexOfExtras = _cursor.getColumnIndexOrThrow("_extras");
            ArrayList<DownloadInfo> _result = new ArrayList<DownloadInfo>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                DownloadInfo _item = new DownloadInfo();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpNamespace = _cursor.getString(_cursorIndexOfNamespace);
                _item.setNamespace(_tmpNamespace);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpFile = _cursor.getString(_cursorIndexOfFile);
                _item.setFile(_tmpFile);
                int _tmpGroup = _cursor.getInt(_cursorIndexOfGroup);
                _item.setGroup(_tmpGroup);
                int _tmp = _cursor.getInt(_cursorIndexOfPriority);
                Priority _tmpPriority = this.__converter.fromPriorityValue(_tmp);
                _item.setPriority(_tmpPriority);
                String _tmp_1 = _cursor.getString(_cursorIndexOfHeaders);
                Map<String, String> _tmpHeaders = this.__converter.fromJsonString(_tmp_1);
                _item.setHeaders(_tmpHeaders);
                long _tmpDownloaded = _cursor.getLong(_cursorIndexOfDownloaded);
                _item.setDownloaded(_tmpDownloaded);
                long _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
                _item.setTotal(_tmpTotal);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfStatus);
                Status _tmpStatus = this.__converter.fromStatusValue(_tmp_2);
                _item.setStatus(_tmpStatus);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfError);
                Error _tmpError = this.__converter.fromErrorValue(_tmp_3);
                _item.setError(_tmpError);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfNetworkType);
                NetworkType _tmpNetworkType = this.__converter.fromNetworkTypeValue(_tmp_4);
                _item.setNetworkType(_tmpNetworkType);
                long _tmpCreated = _cursor.getLong(_cursorIndexOfCreated);
                _item.setCreated(_tmpCreated);
                String _tmpTag = _cursor.getString(_cursorIndexOfTag);
                _item.setTag(_tmpTag);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfEnqueueAction);
                EnqueueAction _tmpEnqueueAction = this.__converter.fromEnqueueActionValue(_tmp_5);
                _item.setEnqueueAction(_tmpEnqueueAction);
                long _tmpIdentifier = _cursor.getLong(_cursorIndexOfIdentifier);
                _item.setIdentifier(_tmpIdentifier);
                int _tmp_6 = _cursor.getInt(_cursorIndexOfDownloadOnEnqueue);
                boolean _tmpDownloadOnEnqueue = _tmp_6 != 0;
                _item.setDownloadOnEnqueue(_tmpDownloadOnEnqueue);
                String _tmp_7 = _cursor.getString(_cursorIndexOfExtras);
                Extras _tmpExtras = this.__converter.fromExtrasJsonToExtras(_tmp_7);
                _item.setExtras(_tmpExtras);
                _result.add(_item);
            }
            ArrayList<DownloadInfo> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

