/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.helper;

import android.os.Handler;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchListener;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.helper.DownloadBlockReportingRunnable;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.helper.DownloadReportingRunnable;
import com.tonyodev.fetch2.helper.FileDownloaderDelegate;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2core.DownloadBlock;
import com.tonyodev.fetch2core.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\b\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004*\u0002\u000e\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/tonyodev/fetch2/helper/FileDownloaderDelegate;", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "uiHandler", "Landroid/os/Handler;", "fetchListener", "Lcom/tonyodev/fetch2/FetchListener;", "logger", "Lcom/tonyodev/fetch2core/Logger;", "retryOnNetworkGain", "", "(Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;Landroid/os/Handler;Lcom/tonyodev/fetch2/FetchListener;Lcom/tonyodev/fetch2core/Logger;Z)V", "downloadBlockProgressRunnable", "com/tonyodev/fetch2/helper/FileDownloaderDelegate$downloadBlockProgressRunnable$1", "Lcom/tonyodev/fetch2/helper/FileDownloaderDelegate$downloadBlockProgressRunnable$1;", "interrupted", "getInterrupted", "()Z", "setInterrupted", "(Z)V", "progressRunnable", "com/tonyodev/fetch2/helper/FileDownloaderDelegate$progressRunnable$1", "Lcom/tonyodev/fetch2/helper/FileDownloaderDelegate$progressRunnable$1;", "onComplete", "", "download", "Lcom/tonyodev/fetch2/Download;", "onDownloadBlockUpdated", "downloadBlock", "Lcom/tonyodev/fetch2core/DownloadBlock;", "totalBlocks", "", "onError", "onProgress", "etaInMilliSeconds", "", "downloadedBytesPerSecond", "onStarted", "saveDownloadProgress", "fetch2_release"})
public final class FileDownloaderDelegate
implements FileDownloader.Delegate {
    private volatile boolean interrupted;
    private final progressRunnable.1 progressRunnable;
    private final downloadBlockProgressRunnable.1 downloadBlockProgressRunnable;
    private final DownloadInfoUpdater downloadInfoUpdater;
    private final Handler uiHandler;
    private final FetchListener fetchListener;
    private final Logger logger;
    private final boolean retryOnNetworkGain;

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean bl) {
        this.interrupted = bl;
    }

    @Override
    public void onStarted(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            DownloadInfo downloadInfo = (DownloadInfo)download;
            downloadInfo.setStatus(Status.DOWNLOADING);
            try {
                this.downloadInfoUpdater.update(downloadInfo);
                this.uiHandler.post(new Runnable(this, download){
                    final /* synthetic */ FileDownloaderDelegate this$0;
                    final /* synthetic */ Download $download;

                    public final void run() {
                        FileDownloaderDelegate.access$getFetchListener$p(this.this$0).onStarted(this.$download);
                    }
                    {
                        this.this$0 = fileDownloaderDelegate;
                        this.$download = download;
                    }
                });
            }
            catch (Exception e) {
                this.logger.e("DownloadManagerDelegate", (Throwable)e);
            }
        }
    }

    @Override
    public void onProgress(@NotNull Download download, long etaInMilliSeconds, long downloadedBytesPerSecond) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            this.progressRunnable.setDownload(download);
            this.progressRunnable.setEtaInMilliSeconds(etaInMilliSeconds);
            this.progressRunnable.setDownloadedBytesPerSecond(downloadedBytesPerSecond);
            this.uiHandler.post((Runnable)this.progressRunnable);
        }
    }

    @Override
    public void onDownloadBlockUpdated(@NotNull Download download, @NotNull DownloadBlock downloadBlock2, int totalBlocks) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Intrinsics.checkParameterIsNotNull((Object)downloadBlock2, (String)"downloadBlock");
        if (!this.getInterrupted()) {
            this.downloadBlockProgressRunnable.setDownload(download);
            this.downloadBlockProgressRunnable.setDownloadBlock(downloadBlock2);
            this.downloadBlockProgressRunnable.setTotalBlocks(totalBlocks);
            this.uiHandler.post((Runnable)this.downloadBlockProgressRunnable);
        }
    }

    @Override
    public void onError(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            DownloadInfo downloadInfo = (DownloadInfo)download;
            try {
                if (this.retryOnNetworkGain && downloadInfo.getError() == Error.NO_NETWORK_CONNECTION) {
                    downloadInfo.setStatus(Status.QUEUED);
                    downloadInfo.setError(FetchDefaults.getDefaultNoError());
                    this.downloadInfoUpdater.update(downloadInfo);
                    this.uiHandler.post(new Runnable(this, downloadInfo){
                        final /* synthetic */ FileDownloaderDelegate this$0;
                        final /* synthetic */ DownloadInfo $downloadInfo;

                        public final void run() {
                            FileDownloaderDelegate.access$getFetchListener$p(this.this$0).onQueued(this.$downloadInfo, true);
                        }
                        {
                            this.this$0 = fileDownloaderDelegate;
                            this.$downloadInfo = downloadInfo;
                        }
                    });
                } else {
                    downloadInfo.setStatus(Status.FAILED);
                    this.downloadInfoUpdater.update(downloadInfo);
                    this.uiHandler.post(new Runnable(this, downloadInfo){
                        final /* synthetic */ FileDownloaderDelegate this$0;
                        final /* synthetic */ DownloadInfo $downloadInfo;

                        public final void run() {
                            FileDownloaderDelegate.access$getFetchListener$p(this.this$0).onError(this.$downloadInfo);
                        }
                        {
                            this.this$0 = fileDownloaderDelegate;
                            this.$downloadInfo = downloadInfo;
                        }
                    });
                }
            }
            catch (Exception e) {
                this.logger.e("DownloadManagerDelegate", (Throwable)e);
            }
        }
    }

    @Override
    public void onComplete(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            DownloadInfo downloadInfo = (DownloadInfo)download;
            downloadInfo.setStatus(Status.COMPLETED);
            try {
                this.downloadInfoUpdater.update(downloadInfo);
                this.uiHandler.post(new Runnable(this, downloadInfo){
                    final /* synthetic */ FileDownloaderDelegate this$0;
                    final /* synthetic */ DownloadInfo $downloadInfo;

                    public final void run() {
                        FileDownloaderDelegate.access$getFetchListener$p(this.this$0).onCompleted(this.$downloadInfo);
                    }
                    {
                        this.this$0 = fileDownloaderDelegate;
                        this.$downloadInfo = downloadInfo;
                    }
                });
            }
            catch (Exception e) {
                this.logger.e("DownloadManagerDelegate", (Throwable)e);
            }
        }
    }

    @Override
    public void saveDownloadProgress(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        if (!this.getInterrupted()) {
            try {
                DownloadInfo downloadInfo = (DownloadInfo)download;
                downloadInfo.setStatus(Status.DOWNLOADING);
                this.downloadInfoUpdater.updateFileBytesInfoAndStatusOnly(downloadInfo);
            }
            catch (Exception e) {
                this.logger.e("DownloadManagerDelegate", (Throwable)e);
            }
        }
    }

    public FileDownloaderDelegate(@NotNull DownloadInfoUpdater downloadInfoUpdater, @NotNull Handler uiHandler, @NotNull FetchListener fetchListener, @NotNull Logger logger, boolean retryOnNetworkGain) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfoUpdater, (String)"downloadInfoUpdater");
        Intrinsics.checkParameterIsNotNull((Object)uiHandler, (String)"uiHandler");
        Intrinsics.checkParameterIsNotNull((Object)fetchListener, (String)"fetchListener");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.downloadInfoUpdater = downloadInfoUpdater;
        this.uiHandler = uiHandler;
        this.fetchListener = fetchListener;
        this.logger = logger;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.progressRunnable = new DownloadReportingRunnable(this){
            final /* synthetic */ FileDownloaderDelegate this$0;

            public void run() {
                FileDownloaderDelegate.access$getFetchListener$p(this.this$0).onProgress(this.getDownload(), this.getEtaInMilliSeconds(), this.getDownloadedBytesPerSecond());
            }
            {
                this.this$0 = $outer;
            }
        };
        this.downloadBlockProgressRunnable = new DownloadBlockReportingRunnable(this){
            final /* synthetic */ FileDownloaderDelegate this$0;

            public void run() {
                FileDownloaderDelegate.access$getFetchListener$p(this.this$0).onDownloadBlockUpdated(this.getDownload(), this.getDownloadBlock(), this.getTotalBlocks());
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ FetchListener access$getFetchListener$p(FileDownloaderDelegate $this) {
        return $this.fetchListener;
    }
}

