/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.fetch;

import android.os.Handler;
import com.tonyodev.fetch2.CompletedDownload;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.EnqueueAction;
import com.tonyodev.fetch2.FetchListener;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Request;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DatabaseManager;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.fetch.FetchHandler;
import com.tonyodev.fetch2.fetch.FetchHandlerImpl$WhenMappings;
import com.tonyodev.fetch2.fetch.FetchModulesBuilder;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.PriorityListProcessor;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.DownloadBlock;
import com.tonyodev.fetch2core.DownloadBlockInfo;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.Extras;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileResource;
import com.tonyodev.fetch2core.FileServerDownloader;
import com.tonyodev.fetch2core.FileSliceInfo;
import com.tonyodev.fetch2core.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0#H\u0016J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0002J\u0016\u0010(\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u0010*\u001a\u00020\u001aH\u0016J\b\u0010+\u001a\u00020\u001fH\u0016J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0#H\u0016J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u000201H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u00100\u001a\u000201H\u0016J\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0002J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u0010*\u001a\u00020\u001aH\u0016J\u0010\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u000eH\u0016J\u0010\u00107\u001a\u00020\n2\u0006\u00108\u001a\u000209H\u0016J\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002090#H\u0016J\u0010\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020=H\u0016J\u001c\u0010>\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020=0#H\u0016J\u001c\u0010@\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002090#H\u0002J\b\u0010A\u001a\u00020\u001fH\u0016J\u0018\u0010B\u001a\u00020C2\u0006\u00108\u001a\u0002092\u0006\u0010D\u001a\u00020\u000eH\u0016J\u0012\u0010E\u001a\u0004\u0018\u00010\n2\u0006\u0010*\u001a\u00020\u001aH\u0016J\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020G0#2\u0006\u0010*\u001a\u00020\u001aH\u0016J\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00020\n0#H\u0016J\u001c\u0010H\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0016J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u0010K\u001a\u00020CH\u0016J\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u0010*\u001a\u00020\u001aH\u0016J\u001e\u0010M\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u000201H\u0016J\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u00100\u001a\u000201H\u0016J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020P0#2\u0006\u00108\u001a\u000209H\u0016J\b\u0010Q\u001a\u00020\u001fH\u0016J\u001c\u0010R\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0016J\u001c\u0010S\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0002J\u0016\u0010T\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u0010*\u001a\u00020\u001aH\u0016J\u0010\u0010U\u001a\u00020\u001f2\u0006\u0010V\u001a\u00020WH\u0002J\u0010\u0010X\u001a\u00020\u001f2\u0006\u0010V\u001a\u00020WH\u0002J\u001c\u0010Y\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0016J\u000e\u0010Z\u001a\b\u0012\u0004\u0012\u00020\n0#H\u0016J\u001e\u0010[\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u000201H\u0016J\u0016\u0010\\\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u00100\u001a\u000201H\u0016J\u001c\u0010]\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0002J\u0016\u0010^\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u0010*\u001a\u00020\u001aH\u0016J\u0010\u0010_\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0018\u0010`\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010a\u001a\u00020bH\u0016J\u001c\u0010c\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0016J\u001c\u0010d\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0002J\u0016\u0010e\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u0010*\u001a\u00020\u001aH\u0016J\u001c\u0010f\u001a\b\u0012\u0004\u0012\u00020\n0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0#H\u0016J\u0010\u0010g\u001a\u00020\u001f2\u0006\u0010h\u001a\u00020\u001aH\u0016J\u0010\u0010i\u001a\u00020\u001f2\u0006\u0010j\u001a\u00020kH\u0016J\b\u0010l\u001a\u00020\u001fH\u0002J\b\u0010m\u001a\u00020\u001fH\u0016J\u0018\u0010n\u001a\u00020\n2\u0006\u0010o\u001a\u00020\u001a2\u0006\u0010p\u001a\u000209H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchHandlerImpl;", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "namespace", "", "databaseManager", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "priorityListProcessor", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "Lcom/tonyodev/fetch2/Download;", "logger", "Lcom/tonyodev/fetch2core/Logger;", "autoStart", "", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "fileServerDownloader", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "uiHandler", "Landroid/os/Handler;", "(Ljava/lang/String;Lcom/tonyodev/fetch2/database/DatabaseManager;Lcom/tonyodev/fetch2/downloader/DownloadManager;Lcom/tonyodev/fetch2/helper/PriorityListProcessor;Lcom/tonyodev/fetch2core/Logger;ZLcom/tonyodev/fetch2core/Downloader;Lcom/tonyodev/fetch2core/FileServerDownloader;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;Landroid/os/Handler;)V", "isTerminating", "listenerId", "", "listenerSet", "", "Lcom/tonyodev/fetch2/FetchListener;", "addListener", "", "listener", "notify", "cancel", "", "ids", "cancelAll", "cancelDownloads", "downloadIds", "cancelDownloadsIfDownloading", "cancelGroup", "id", "close", "delete", "deleteAll", "deleteAllInGroupWithStatus", "groupId", "status", "Lcom/tonyodev/fetch2/Status;", "deleteAllWithStatus", "deleteDownloads", "deleteGroup", "enableLogging", "enabled", "enqueue", "request", "Lcom/tonyodev/fetch2/Request;", "requests", "enqueueCompletedDownload", "completedDownload", "Lcom/tonyodev/fetch2/CompletedDownload;", "enqueueCompletedDownloads", "completedDownloads", "enqueueRequests", "freeze", "getContentLengthForRequest", "", "fromServer", "getDownload", "getDownloadBlocks", "Lcom/tonyodev/fetch2core/DownloadBlock;", "getDownloads", "idList", "getDownloadsByRequestIdentifier", "identifier", "getDownloadsInGroup", "getDownloadsInGroupWithStatus", "getDownloadsWithStatus", "getFetchFileServerCatalog", "Lcom/tonyodev/fetch2core/FileResource;", "init", "pause", "pauseDownloads", "pausedGroup", "prepareCompletedDownloadInfoForEnqueue", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "prepareDownloadInfoForEnqueue", "remove", "removeAll", "removeAllInGroupWithStatus", "removeAllWithStatus", "removeDownloads", "removeGroup", "removeListener", "replaceExtras", "extras", "Lcom/tonyodev/fetch2core/Extras;", "resume", "resumeDownloads", "resumeGroup", "retry", "setDownloadConcurrentLimit", "downloadConcurrentLimit", "setGlobalNetworkType", "networkType", "Lcom/tonyodev/fetch2/NetworkType;", "startPriorityQueueIfNotStarted", "unfreeze", "updateRequest", "requestId", "newRequest", "fetch2_release"})
public final class FetchHandlerImpl
implements FetchHandler {
    private final int listenerId;
    private final Set<FetchListener> listenerSet;
    private volatile boolean isTerminating;
    private final String namespace;
    private final DatabaseManager databaseManager;
    private final DownloadManager downloadManager;
    private final PriorityListProcessor<Download> priorityListProcessor;
    private final Logger logger;
    private final boolean autoStart;
    private final Downloader httpDownloader;
    private final FileServerDownloader fileServerDownloader;
    private final ListenerCoordinator listenerCoordinator;
    private final Handler uiHandler;

    @Override
    public void init() {
        this.databaseManager.sanitizeOnFirstEntry();
        if (this.autoStart) {
            this.priorityListProcessor.start();
        }
    }

    @Override
    @NotNull
    public Download enqueue(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return (Download)CollectionsKt.first(this.enqueueRequests(CollectionsKt.listOf((Object)request)));
    }

    @Override
    @NotNull
    public List<Download> enqueue(@NotNull List<? extends Request> requests) {
        Intrinsics.checkParameterIsNotNull(requests, (String)"requests");
        return this.enqueueRequests(requests);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Download> enqueueRequests(List<? extends Request> requests) {
        void $receiver$iv$iv;
        Object key$iv;
        Request it;
        Iterable $receiver$iv = requests;
        Iterable<String> set$iv = new HashSet();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $receiver$iv) {
            it = (Request)e$iv;
            key$iv = it.getFile();
            if (!((HashSet)set$iv).add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $receiver$iv = list$iv;
        set$iv = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            key$iv = (Request)item$iv$iv;
            Collection collection = destination$iv$iv;
            DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(it);
            downloadInfo.setNamespace(this.namespace);
            this.prepareDownloadInfoForEnqueue(downloadInfo);
            downloadInfo.setStatus(it.getDownloadOnEnqueue() ? Status.QUEUED : Status.ADDED);
            Pair<DownloadInfo, Boolean> downloadPair = this.databaseManager.insert(downloadInfo);
            this.logger.d("Enqueued download " + (DownloadInfo)downloadPair.getFirst());
            DownloadInfo downloadInfo2 = (DownloadInfo)downloadPair.getFirst();
            collection.add(downloadInfo2);
        }
        List results = (List)destination$iv$iv;
        this.startPriorityQueueIfNotStarted();
        return results;
    }

    private final void prepareDownloadInfoForEnqueue(DownloadInfo downloadInfo) {
        DownloadInfo existingDownload = this.databaseManager.getByFile(downloadInfo.getFile());
        if (existingDownload == null) {
            FetchCoreUtils.createFileIfPossible((File)new File(downloadInfo.getFile()));
        }
        if (downloadInfo.getEnqueueAction() == EnqueueAction.DO_NOT_ENQUEUE_IF_EXISTING && existingDownload != null) {
            throw (Throwable)new FetchException("request_with_file_path_already_exist");
        }
        if (downloadInfo.getEnqueueAction() == EnqueueAction.REPLACE_EXISTING && existingDownload != null) {
            this.deleteDownloads(CollectionsKt.listOf((Object)downloadInfo.getId()));
        } else if (downloadInfo.getEnqueueAction() == EnqueueAction.INCREMENT_FILE_NAME && existingDownload != null) {
            File file = FetchCoreUtils.getIncrementedFileIfOriginalExists((String)downloadInfo.getFile());
            String string = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
            downloadInfo.setFile(string);
            downloadInfo.setId(FetchCoreUtils.getUniqueId((String)downloadInfo.getUrl(), (String)downloadInfo.getFile()));
            FetchCoreUtils.createFileIfPossible((File)file);
        }
    }

    @Override
    @NotNull
    public Download enqueueCompletedDownload(@NotNull CompletedDownload completedDownload) {
        Intrinsics.checkParameterIsNotNull((Object)completedDownload, (String)"completedDownload");
        return (Download)CollectionsKt.first(this.enqueueCompletedDownloads(CollectionsKt.listOf((Object)completedDownload)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> enqueueCompletedDownloads(@NotNull List<? extends CompletedDownload> completedDownloads) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(completedDownloads, (String)"completedDownloads");
        Iterable iterable = $receiver$iv = (Iterable)completedDownloads;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CompletedDownload completedDownload = (CompletedDownload)item$iv$iv;
            Collection collection = destination$iv$iv;
            DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo((CompletedDownload)it);
            downloadInfo.setNamespace(this.namespace);
            downloadInfo.setStatus(Status.COMPLETED);
            this.prepareCompletedDownloadInfoForEnqueue(downloadInfo);
            Pair<DownloadInfo, Boolean> downloadPair = this.databaseManager.insert(downloadInfo);
            this.logger.d("Enqueued CompletedDownload " + (DownloadInfo)downloadPair.getFirst());
            DownloadInfo downloadInfo2 = (DownloadInfo)downloadPair.getFirst();
            collection.add(downloadInfo2);
        }
        return (List)destination$iv$iv;
    }

    private final void prepareCompletedDownloadInfoForEnqueue(DownloadInfo downloadInfo) {
        DownloadInfo existingDownload = this.databaseManager.getByFile(downloadInfo.getFile());
        if (existingDownload != null) {
            this.deleteDownloads(CollectionsKt.listOf((Object)downloadInfo.getId()));
        }
    }

    @Override
    @NotNull
    public List<Download> pause(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.pauseDownloads(ids);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> pausedGroup(int id) {
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.databaseManager.getByGroup(id);
        FetchHandlerImpl fetchHandlerImpl = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        return fetchHandlerImpl.pauseDownloads((List<Integer>)collection);
    }

    private final List<Download> pauseDownloads(List<Integer> downloadIds) {
        this.cancelDownloadsIfDownloading(downloadIds);
        List downloads = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(downloadIds));
        List pausedDownloads = new ArrayList();
        Iterable $receiver$iv = downloads;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canPauseDownload(it)) continue;
            it.setStatus(Status.PAUSED);
            pausedDownloads.add(it);
        }
        this.databaseManager.update(pausedDownloads);
        return pausedDownloads;
    }

    @Override
    public void freeze() {
        this.priorityListProcessor.pause();
        this.downloadManager.cancelAll();
    }

    @Override
    public void unfreeze() {
        this.priorityListProcessor.resume();
    }

    @Override
    @NotNull
    public List<Download> resume(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.resumeDownloads(ids);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> resumeGroup(int id) {
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.databaseManager.getByGroup(id);
        FetchHandlerImpl fetchHandlerImpl = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        return fetchHandlerImpl.resumeDownloads((List<Integer>)collection);
    }

    private final List<Download> resumeDownloads(List<Integer> downloadIds) {
        this.startPriorityQueueIfNotStarted();
        List downloads = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(downloadIds));
        List resumedDownloads = new ArrayList();
        Iterable $receiver$iv = downloads;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (this.downloadManager.contains(it.getId()) || !FetchUtils.canResumeDownload(it)) continue;
            it.setStatus(Status.QUEUED);
            resumedDownloads.add(it);
        }
        this.databaseManager.update(resumedDownloads);
        return resumedDownloads;
    }

    @Override
    @NotNull
    public List<Download> remove(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.removeDownloads(ids);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> removeGroup(int id) {
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.databaseManager.getByGroup(id);
        FetchHandlerImpl fetchHandlerImpl = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        return fetchHandlerImpl.removeDownloads((List<Integer>)collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> removeAll() {
        void var3_4;
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.databaseManager.get();
        FetchHandlerImpl fetchHandlerImpl = this;
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)var3_4;
        return fetchHandlerImpl.removeDownloads((List<Integer>)collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> removeAllWithStatus(@NotNull Status status) {
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        Iterable iterable = this.databaseManager.getByStatus(status);
        FetchHandlerImpl fetchHandlerImpl = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        return fetchHandlerImpl.removeDownloads((List<Integer>)collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> removeAllInGroupWithStatus(int groupId, @NotNull Status status) {
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        Iterable iterable = this.databaseManager.getDownloadsInGroupWithStatus(groupId, status);
        FetchHandlerImpl fetchHandlerImpl = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        return fetchHandlerImpl.removeDownloads((List<Integer>)collection);
    }

    private final List<Download> removeDownloads(List<Integer> downloadIds) {
        this.cancelDownloadsIfDownloading(downloadIds);
        List downloads = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(downloadIds));
        this.databaseManager.delete(downloads);
        Iterable $receiver$iv = downloads;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(Status.REMOVED);
            DatabaseManager.Delegate delegate = this.databaseManager.getDelegate();
            if (delegate == null) continue;
            delegate.deleteTempFilesForDownload(it);
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<Download> delete(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.deleteDownloads(ids);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> deleteGroup(int id) {
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.databaseManager.getByGroup(id);
        FetchHandlerImpl fetchHandlerImpl = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        return fetchHandlerImpl.deleteDownloads((List<Integer>)collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> deleteAll() {
        void var3_4;
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.databaseManager.get();
        FetchHandlerImpl fetchHandlerImpl = this;
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)var3_4;
        return fetchHandlerImpl.deleteDownloads((List<Integer>)collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> deleteAllWithStatus(@NotNull Status status) {
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        Iterable iterable = this.databaseManager.getByStatus(status);
        FetchHandlerImpl fetchHandlerImpl = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        return fetchHandlerImpl.deleteDownloads((List<Integer>)collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> deleteAllInGroupWithStatus(int groupId, @NotNull Status status) {
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        Iterable iterable = this.databaseManager.getDownloadsInGroupWithStatus(groupId, status);
        FetchHandlerImpl fetchHandlerImpl = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        return fetchHandlerImpl.deleteDownloads((List<Integer>)collection);
    }

    private final List<Download> deleteDownloads(List<Integer> downloadIds) {
        this.cancelDownloadsIfDownloading(downloadIds);
        List downloads = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(downloadIds));
        this.databaseManager.delete(downloads);
        Iterable $receiver$iv = downloads;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(Status.DELETED);
            try {
                File file = new File(it.getFile());
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                this.logger.d("Failed to delete file " + it.getFile(), (Throwable)e);
            }
            DatabaseManager.Delegate delegate = this.databaseManager.getDelegate();
            if (delegate == null) continue;
            delegate.deleteTempFilesForDownload(it);
        }
        return downloads;
    }

    @Override
    @NotNull
    public List<Download> cancel(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.cancelDownloads(ids);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> cancelGroup(int id) {
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.databaseManager.getByGroup(id);
        FetchHandlerImpl fetchHandlerImpl = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)destination$iv$iv;
        return fetchHandlerImpl.cancelDownloads((List<Integer>)collection);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> cancelAll() {
        void var3_4;
        Collection<Integer> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.databaseManager.get();
        FetchHandlerImpl fetchHandlerImpl = this;
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DownloadInfo downloadInfo = (DownloadInfo)item$iv$iv;
            collection = destination$iv$iv;
            Integer n = it.getId();
            collection.add(n);
        }
        collection = (List)var3_4;
        return fetchHandlerImpl.cancelDownloads((List<Integer>)collection);
    }

    private final List<Download> cancelDownloads(List<Integer> downloadIds) {
        this.cancelDownloadsIfDownloading(downloadIds);
        List downloads = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(downloadIds));
        List cancelledDownloads = new ArrayList();
        Iterable $receiver$iv = downloads;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canCancelDownload(it)) continue;
            it.setStatus(Status.CANCELLED);
            it.setError(FetchDefaults.getDefaultNoError());
            cancelledDownloads.add(it);
        }
        this.databaseManager.update(cancelledDownloads);
        return cancelledDownloads;
    }

    @Override
    @NotNull
    public List<Download> retry(@NotNull List<Integer> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        this.startPriorityQueueIfNotStarted();
        List downloadInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ids));
        List retryDownloads = new ArrayList();
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canRetryDownload(it)) continue;
            it.setStatus(Status.QUEUED);
            it.setError(FetchDefaults.getDefaultNoError());
            retryDownloads.add(it);
        }
        this.databaseManager.update(retryDownloads);
        return retryDownloads;
    }

    @Override
    @NotNull
    public Download updateRequest(int requestId, @NotNull Request newRequest) {
        Intrinsics.checkParameterIsNotNull((Object)newRequest, (String)"newRequest");
        DownloadInfo oldDownloadInfo = this.databaseManager.get(requestId);
        if (oldDownloadInfo != null) {
            DownloadInfo newDownloadInfo = FetchTypeConverterExtensions.toDownloadInfo(newRequest);
            newDownloadInfo.setStatus(newRequest.getDownloadOnEnqueue() ? Status.QUEUED : Status.ADDED);
            newDownloadInfo.setNamespace(this.namespace);
            EnqueueAction enqueueAction = newDownloadInfo.getEnqueueAction();
            if (enqueueAction == EnqueueAction.REPLACE_EXISTING) {
                if (Intrinsics.areEqual((Object)newRequest.getFile(), (Object)oldDownloadInfo.getFile())) {
                    newDownloadInfo.setDownloaded(oldDownloadInfo.getDownloaded());
                    newDownloadInfo.setTotal(oldDownloadInfo.getTotal());
                }
                this.remove(CollectionsKt.listOf((Object)requestId));
            } else {
                this.delete(CollectionsKt.listOf((Object)requestId));
            }
            this.prepareDownloadInfoForEnqueue(newDownloadInfo);
            this.startPriorityQueueIfNotStarted();
            this.databaseManager.insert(newDownloadInfo);
            return newDownloadInfo;
        }
        throw (Throwable)new FetchException("request_does_not_exist");
    }

    @Override
    @NotNull
    public Download replaceExtras(int id, @NotNull Extras extras) {
        DownloadInfo downloadInfo;
        Intrinsics.checkParameterIsNotNull((Object)extras, (String)"extras");
        this.cancelDownloadsIfDownloading(CollectionsKt.listOf((Object)id));
        DownloadInfo downloadInfo2 = this.databaseManager.get(id);
        if (downloadInfo2 != null) {
            DownloadInfo download;
            downloadInfo = download = this.databaseManager.updateExtras(id, extras);
            if (downloadInfo == null) {
                throw (Throwable)new FetchException("request_does_not_exist");
            }
        } else {
            throw (Throwable)new FetchException("request_does_not_exist");
        }
        return downloadInfo;
    }

    @Override
    @NotNull
    public List<Download> getDownloads() {
        return this.databaseManager.get();
    }

    @Override
    @Nullable
    public Download getDownload(int id) {
        return this.databaseManager.get(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloads(@NotNull List<Integer> idList) {
        Intrinsics.checkParameterIsNotNull(idList, (String)"idList");
        return CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(idList));
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroup(int id) {
        return this.databaseManager.getByGroup(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        return this.databaseManager.getByStatus(status);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroupWithStatus(int groupId, @NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        return this.databaseManager.getDownloadsInGroupWithStatus(groupId, status);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsByRequestIdentifier(long identifier) {
        return this.databaseManager.getDownloadsByRequestIdentifier(identifier);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DownloadBlock> getDownloadBlocks(int id) {
        List list;
        DownloadInfo download = this.databaseManager.get(id);
        if (download != null) {
            String fileTempDir = this.downloadManager.getDownloadFileTempDir(download);
            FileSliceInfo fileSliceInfo = FetchUtils.getFileSliceInfo(FetchUtils.getPreviousSliceCount(download.getId(), fileTempDir), download.getTotal());
            if (download.getTotal() < 1L) {
                list = CollectionsKt.emptyList();
            } else if (fileSliceInfo.getSlicingCount() < 2) {
                DownloadBlockInfo downloadBlockInfo = new DownloadBlockInfo();
                downloadBlockInfo.setDownloadId(download.getId());
                downloadBlockInfo.setBlockPosition(1);
                downloadBlockInfo.setStartByte(0L);
                downloadBlockInfo.setEndByte(download.getTotal());
                downloadBlockInfo.setDownloadedBytes(download.getDownloaded());
                list = CollectionsKt.listOf((Object)downloadBlockInfo);
            } else {
                long counterBytes = 0L;
                List downloadBlocksList = new ArrayList();
                int n = 1;
                int n2 = fileSliceInfo.getSlicingCount();
                if (n <= n2) {
                    while (true) {
                        void position;
                        long endBytes;
                        long startBytes = counterBytes;
                        counterBytes = endBytes = fileSliceInfo.getSlicingCount() == position ? download.getTotal() : counterBytes + fileSliceInfo.getBytesPerFileSlice();
                        DownloadBlockInfo downloadBlockInfo = new DownloadBlockInfo();
                        downloadBlockInfo.setDownloadId(download.getId());
                        downloadBlockInfo.setBlockPosition((int)position);
                        downloadBlockInfo.setStartByte(startBytes);
                        downloadBlockInfo.setEndByte(endBytes);
                        downloadBlockInfo.setDownloadedBytes(FetchUtils.getSavedDownloadedInfo(download.getId(), (int)position, fileTempDir));
                        downloadBlocksList.add(downloadBlockInfo);
                        if (position == n2) break;
                        ++position;
                    }
                }
                list = downloadBlocksList;
            }
        } else {
            return CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public long getContentLengthForRequest(@NotNull Request request, boolean fromServer) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        DownloadInfo download = this.databaseManager.get(request.getId());
        if (download != null && download.getTotal() > 0L) {
            return download.getTotal();
        }
        return fromServer ? (FetchCoreUtils.isFetchFileServerUrl((String)request.getUrl()) ? this.fileServerDownloader.getRequestContentLength(FetchUtils.getServerRequestFromRequest(request)) : this.httpDownloader.getRequestContentLength(FetchUtils.getServerRequestFromRequest(request))) : -1L;
    }

    @Override
    @NotNull
    public List<FileResource> getFetchFileServerCatalog(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return this.fileServerDownloader.getFetchFileServerCatalog(FetchUtils.getCatalogServerRequestFromRequest(request));
    }

    @Override
    public void close() {
        Iterator<FetchListener> $receiver$iv;
        Iterator<FetchListener> iterator;
        if (this.isTerminating) {
            return;
        }
        this.isTerminating = true;
        Iterator<FetchListener> iterator2 = iterator = ($receiver$iv = this.listenerSet.iterator());
        while (iterator2.hasNext()) {
            FetchListener element$iv;
            FetchListener it = element$iv = iterator2.next();
            this.listenerCoordinator.removeListener(this.listenerId, it);
        }
        this.listenerSet.clear();
        this.priorityListProcessor.stop();
        this.downloadManager.close();
        FetchModulesBuilder.INSTANCE.removeNamespaceInstanceReference(this.namespace);
    }

    @Override
    public void setGlobalNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"networkType");
        this.priorityListProcessor.stop();
        this.priorityListProcessor.setGlobalNetworkType(networkType);
        List<Integer> ids = this.downloadManager.getActiveDownloadsIds();
        this.cancelDownloadsIfDownloading(ids);
        List downloads = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ids));
        Iterable $receiver$iv = downloads;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (it.getStatus() != Status.DOWNLOADING) continue;
            it.setStatus(Status.QUEUED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        this.databaseManager.update(downloads);
        this.priorityListProcessor.start();
    }

    @Override
    public void setDownloadConcurrentLimit(int downloadConcurrentLimit) {
        this.priorityListProcessor.stop();
        List<Integer> ids = this.downloadManager.getActiveDownloadsIds();
        this.cancelDownloadsIfDownloading(ids);
        this.downloadManager.setConcurrentLimit(downloadConcurrentLimit);
        this.priorityListProcessor.setDownloadConcurrentLimit(downloadConcurrentLimit);
        List downloads = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ids));
        Iterable $receiver$iv = downloads;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (it.getStatus() != Status.DOWNLOADING) continue;
            it.setStatus(Status.QUEUED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        this.databaseManager.update(downloads);
        this.priorityListProcessor.start();
    }

    @Override
    public void enableLogging(boolean enabled) {
        this.logger.d("Enable logging - " + enabled);
        this.logger.setEnabled(enabled);
    }

    @Override
    public void addListener(@NotNull FetchListener listener, boolean notify, boolean autoStart) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.listenerSet.add(listener);
        this.listenerCoordinator.addListener(this.listenerId, listener);
        if (notify) {
            List<DownloadInfo> downloads = this.databaseManager.get();
            Iterable $receiver$iv = downloads;
            for (Object element$iv : $receiver$iv) {
                DownloadInfo it = (DownloadInfo)element$iv;
                this.uiHandler.post(new Runnable(it, this, listener){
                    final /* synthetic */ DownloadInfo $it;
                    final /* synthetic */ FetchHandlerImpl this$0;
                    final /* synthetic */ FetchListener $listener$inlined;
                    {
                        this.$it = downloadInfo;
                        this.this$0 = fetchHandlerImpl;
                        this.$listener$inlined = fetchListener;
                    }

                    public final void run() {
                        switch (FetchHandlerImpl$WhenMappings.$EnumSwitchMapping$0[this.$it.getStatus().ordinal()]) {
                            case 1: {
                                this.$listener$inlined.onCompleted(this.$it);
                                break;
                            }
                            case 2: {
                                this.$listener$inlined.onError(this.$it, this.$it.getError(), null);
                                break;
                            }
                            case 3: {
                                this.$listener$inlined.onCancelled(this.$it);
                                break;
                            }
                            case 4: {
                                this.$listener$inlined.onDeleted(this.$it);
                                break;
                            }
                            case 5: {
                                this.$listener$inlined.onPaused(this.$it);
                                break;
                            }
                            case 6: {
                                this.$listener$inlined.onQueued(this.$it, false);
                                break;
                            }
                            case 7: {
                                this.$listener$inlined.onRemoved(this.$it);
                                break;
                            }
                            case 8: {
                                break;
                            }
                            case 9: {
                                this.$listener$inlined.onAdded(this.$it);
                            }
                        }
                    }
                });
            }
        }
        this.logger.d("Added listener " + listener);
        if (autoStart) {
            this.startPriorityQueueIfNotStarted();
        }
    }

    @Override
    public void removeListener(@NotNull FetchListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Iterator<FetchListener> iterator = this.listenerSet.iterator();
        while (iterator.hasNext()) {
            FetchListener fetchListener = iterator.next();
            if (!Intrinsics.areEqual((Object)fetchListener, (Object)listener)) continue;
            iterator.remove();
            this.logger.d("Removed listener " + listener);
            break;
        }
        this.listenerCoordinator.removeListener(this.listenerId, listener);
    }

    private final void cancelDownloadsIfDownloading(List<Integer> ids) {
        Iterable $receiver$iv = ids;
        for (Object element$iv : $receiver$iv) {
            int id = ((Number)element$iv).intValue();
            if (!this.downloadManager.contains(id)) continue;
            this.downloadManager.cancel(id);
        }
    }

    private final void startPriorityQueueIfNotStarted() {
        if (this.priorityListProcessor.isStopped() && !this.isTerminating) {
            this.priorityListProcessor.start();
        }
        if (this.priorityListProcessor.isPaused() && !this.isTerminating) {
            this.priorityListProcessor.resume();
        }
    }

    public FetchHandlerImpl(@NotNull String namespace, @NotNull DatabaseManager databaseManager, @NotNull DownloadManager downloadManager, @NotNull PriorityListProcessor<? extends Download> priorityListProcessor, @NotNull Logger logger, boolean autoStart, @NotNull Downloader httpDownloader, @NotNull FileServerDownloader fileServerDownloader, @NotNull ListenerCoordinator listenerCoordinator, @NotNull Handler uiHandler) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)databaseManager, (String)"databaseManager");
        Intrinsics.checkParameterIsNotNull((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkParameterIsNotNull(priorityListProcessor, (String)"priorityListProcessor");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)httpDownloader, (String)"httpDownloader");
        Intrinsics.checkParameterIsNotNull((Object)fileServerDownloader, (String)"fileServerDownloader");
        Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
        Intrinsics.checkParameterIsNotNull((Object)uiHandler, (String)"uiHandler");
        this.namespace = namespace;
        this.databaseManager = databaseManager;
        this.downloadManager = downloadManager;
        this.priorityListProcessor = priorityListProcessor;
        this.logger = logger;
        this.autoStart = autoStart;
        this.httpDownloader = httpDownloader;
        this.fileServerDownloader = fileServerDownloader;
        this.listenerCoordinator = listenerCoordinator;
        this.uiHandler = uiHandler;
        this.listenerId = UUID.randomUUID().hashCode();
        FetchHandlerImpl fetchHandlerImpl = this;
        fetchHandlerImpl.listenerSet = set = (Set)new LinkedHashSet();
    }
}

