/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.fetch;

import android.os.Handler;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.EnqueueAction;
import com.tonyodev.fetch2.FetchListener;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Request;
import com.tonyodev.fetch2.RequestInfo;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DatabaseManager;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.fetch.FetchHandler;
import com.tonyodev.fetch2.fetch.FetchHandlerImpl$WhenMappings;
import com.tonyodev.fetch2.fetch.FetchModulesBuilder;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.PriorityListProcessor;
import com.tonyodev.fetch2.util.FetchDatabaseExtensions;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u000eH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010#\u001a\u00020$H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\"H\u0016J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010'\u001a\u00020\u0019H\u0016J\b\u0010)\u001a\u00020\u001eH\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010#\u001a\u00020$H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\n0\"H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u0010\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\u000eH\u0016J\u0010\u00102\u001a\u00020\n2\u0006\u00103\u001a\u000204H\u0016J\u001c\u00102\u001a\b\u0012\u0004\u0012\u00020\n0\"2\f\u00105\u001a\b\u0012\u0004\u0012\u0002040\"H\u0016J\b\u00106\u001a\u00020\u001eH\u0016J\u0012\u00107\u001a\u0004\u0018\u00010\n2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\n0\"H\u0016J\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\n0\"2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00190\"H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010;\u001a\u00020<H\u0016J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u001e\u0010>\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010?\u001a\u00020\u00192\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010A\u001a\u00020\u001eH\u0016J\u0010\u0010B\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u0010\u0010E\u001a\u00020\u001e2\u0006\u0010F\u001a\u00020GH\u0002J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010#\u001a\u00020$H\u0016J\u000e\u0010I\u001a\b\u0012\u0004\u0012\u00020\n0\"H\u0016J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u0010\u0010L\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010'\u001a\u00020\u0019H\u0016J\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020\n0\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010P\u001a\u00020\u001e2\u0006\u0010Q\u001a\u00020RH\u0016J\b\u0010S\u001a\u00020\u001eH\u0002J\b\u0010T\u001a\u00020\u001eH\u0016J\u001a\u0010U\u001a\u0004\u0018\u00010\n2\u0006\u0010'\u001a\u00020\u00192\u0006\u0010V\u001a\u00020WH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchHandlerImpl;", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "namespace", "", "databaseManager", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "priorityListProcessor", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "Lcom/tonyodev/fetch2/Download;", "logger", "Lcom/tonyodev/fetch2core/Logger;", "autoStart", "", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "fileTempDir", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "uiHandler", "Landroid/os/Handler;", "(Ljava/lang/String;Lcom/tonyodev/fetch2/database/DatabaseManager;Lcom/tonyodev/fetch2/downloader/DownloadManager;Lcom/tonyodev/fetch2/helper/PriorityListProcessor;Lcom/tonyodev/fetch2core/Logger;ZLcom/tonyodev/fetch2core/Downloader;Ljava/lang/String;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;Landroid/os/Handler;)V", "isTerminating", "listenerId", "", "listenerSet", "", "Lcom/tonyodev/fetch2/FetchListener;", "addListener", "", "listener", "notify", "cancel", "", "ids", "", "cancelAll", "cancelDownload", "id", "cancelGroup", "close", "delete", "deleteAll", "deleteAllWithStatus", "status", "Lcom/tonyodev/fetch2/Status;", "deleteGroup", "enableLogging", "enabled", "enqueue", "request", "Lcom/tonyodev/fetch2/Request;", "requests", "freeze", "getDownload", "getDownloads", "idList", "getDownloadsByRequestIdentifier", "identifier", "", "getDownloadsInGroup", "getDownloadsInGroupWithStatus", "groupId", "getDownloadsWithStatus", "init", "isDownloading", "pause", "pausedGroup", "prepareDownloadInfoForEnqueue", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "remove", "removeAll", "removeAllWithStatus", "removeGroup", "removeListener", "resume", "resumeGroup", "retry", "setGlobalNetworkType", "networkType", "Lcom/tonyodev/fetch2/NetworkType;", "startPriorityQueueIfNotStarted", "unfreeze", "updateRequest", "requestInfo", "Lcom/tonyodev/fetch2/RequestInfo;", "fetch2_release"})
public final class FetchHandlerImpl
implements FetchHandler {
    private final int listenerId;
    private final Set<FetchListener> listenerSet;
    private volatile boolean isTerminating;
    private final String namespace;
    private final DatabaseManager databaseManager;
    private final DownloadManager downloadManager;
    private final PriorityListProcessor<Download> priorityListProcessor;
    private final Logger logger;
    private final boolean autoStart;
    private final Downloader httpDownloader;
    private final String fileTempDir;
    private final ListenerCoordinator listenerCoordinator;
    private final Handler uiHandler;

    @Override
    public void init() {
        FetchDatabaseExtensions.sanitize(this.databaseManager, true);
        if (this.autoStart) {
            this.priorityListProcessor.start();
        }
    }

    @Override
    @NotNull
    public Download enqueue(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(request);
        downloadInfo.setNamespace(this.namespace);
        downloadInfo.setStatus(Status.QUEUED);
        this.prepareDownloadInfoForEnqueue(downloadInfo);
        this.databaseManager.insert(downloadInfo);
        this.startPriorityQueueIfNotStarted();
        return downloadInfo;
    }

    private final void prepareDownloadInfoForEnqueue(DownloadInfo downloadInfo) {
        DownloadInfo existingDownload = this.databaseManager.getByFile(downloadInfo.getFile());
        if (downloadInfo.getEnqueueAction() == EnqueueAction.REPLACE_EXISTING && existingDownload != null) {
            if (this.isDownloading(existingDownload.getId())) {
                this.downloadManager.cancel(downloadInfo.getId());
            }
            FetchUtils.deleteRequestTempFiles(this.fileTempDir, this.httpDownloader, existingDownload);
            this.databaseManager.delete(existingDownload);
        } else if (downloadInfo.getEnqueueAction() == EnqueueAction.INCREMENT_FILE_NAME && existingDownload != null) {
            File file = FetchCoreUtils.getIncrementedFileIfOriginalExists((String)downloadInfo.getFile());
            String string = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
            downloadInfo.setFile(string);
            downloadInfo.setId(FetchCoreUtils.getUniqueId((String)downloadInfo.getUrl(), (String)downloadInfo.getFile()));
            FetchCoreUtils.createFileIfPossible((File)file);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> enqueue(@NotNull List<? extends Request> requests) {
        Pair it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        DownloadInfo downloadInfo;
        Collection collection;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Intrinsics.checkParameterIsNotNull(requests, (String)"requests");
        Iterable iterable = $receiver$iv2 = (Iterable)requests;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it2;
            Request request = (Request)item$iv$iv;
            collection = destination$iv$iv;
            DownloadInfo downloadInfo2 = FetchTypeConverterExtensions.toDownloadInfo((Request)it2);
            downloadInfo2.setNamespace(this.namespace);
            downloadInfo2.setStatus(Status.QUEUED);
            this.prepareDownloadInfoForEnqueue(downloadInfo2);
            downloadInfo = downloadInfo2;
            collection.add(downloadInfo);
        }
        List downloadInfoList = (List)destination$iv$iv;
        $receiver$iv$iv2 = this.databaseManager.insert(downloadInfoList);
        destination$iv$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Pair)element$iv$iv;
            if (!((Boolean)it.getSecond()).booleanValue()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            this.logger.d("Enqueued download " + (DownloadInfo)it.getFirst());
            downloadInfo = (DownloadInfo)it.getFirst();
            collection.add(downloadInfo);
        }
        List results = (List)destination$iv$iv2;
        this.startPriorityQueueIfNotStarted();
        return results;
    }

    @Override
    @NotNull
    public List<Download> pause(@NotNull int[] ids) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.startPriorityQueueIfNotStarted();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadsInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        Iterable $receiver$iv = downloadsInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canPauseDownload(it)) continue;
            it.setStatus(Status.PAUSED);
        }
        try {
            this.databaseManager.update(downloadsInfoList);
            list = downloadsInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> pausedGroup(int id) {
        List list;
        DownloadInfo it;
        this.startPriorityQueueIfNotStarted();
        List downloadInfoList = this.databaseManager.getByGroup(id);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.cancelDownload(it.getId());
        }
        downloadInfoList = this.databaseManager.getByGroup(id);
        $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!FetchUtils.canPauseDownload(it)) continue;
            it.setStatus(Status.PAUSED);
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public void freeze() {
        this.startPriorityQueueIfNotStarted();
        this.priorityListProcessor.pause();
        this.downloadManager.cancelAll();
        FetchDatabaseExtensions.sanitize(this.databaseManager, true);
    }

    @Override
    public void unfreeze() {
        this.startPriorityQueueIfNotStarted();
        FetchDatabaseExtensions.sanitize(this.databaseManager, true);
        this.priorityListProcessor.resume();
    }

    @Override
    @NotNull
    public List<Download> resume(@NotNull int[] ids) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.startPriorityQueueIfNotStarted();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadsInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        Iterable $receiver$iv = downloadsInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (this.isDownloading(it.getId()) || !FetchUtils.canResumeDownload(it)) continue;
            it.setStatus(Status.QUEUED);
        }
        try {
            this.databaseManager.update(downloadsInfoList);
            list = downloadsInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> resumeGroup(int id) {
        List list;
        Iterator $receiver$iv$iv;
        this.startPriorityQueueIfNotStarted();
        Iterable $receiver$iv = this.databaseManager.getByGroup(id);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            DownloadInfo it = (DownloadInfo)element$iv$iv;
            if (!(!this.isDownloading(it.getId()) && FetchUtils.canResumeDownload(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List downloadsInfoList = (List)destination$iv$iv;
        $receiver$iv = downloadsInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(Status.QUEUED);
        }
        try {
            this.databaseManager.update(downloadsInfoList);
            list = downloadsInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> remove(@NotNull int[] ids) {
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.startPriorityQueueIfNotStarted();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadsList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        this.databaseManager.delete(downloadsList);
        Status removedStatus = Status.REMOVED;
        Iterable $receiver$iv = downloadsList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(removedStatus);
            FetchUtils.deleteRequestTempFiles(this.fileTempDir, this.httpDownloader, it);
        }
        return downloadsList;
    }

    @Override
    @NotNull
    public List<Download> removeGroup(int id) {
        this.startPriorityQueueIfNotStarted();
        List<Download> downloadInfoList = this.databaseManager.getByGroup(id);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.cancelDownload(it.getId());
        }
        this.databaseManager.delete(downloadInfoList);
        Status removedStatus = Status.REMOVED;
        Iterable $receiver$iv2 = downloadInfoList;
        for (Object element$iv : $receiver$iv2) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(removedStatus);
            FetchUtils.deleteRequestTempFiles(this.fileTempDir, this.httpDownloader, it);
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> removeAll() {
        this.startPriorityQueueIfNotStarted();
        this.downloadManager.cancelAll();
        List<Download> downloadInfoList = this.databaseManager.get();
        this.databaseManager.deleteAll();
        Status removedStatus = Status.REMOVED;
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(removedStatus);
            FetchUtils.deleteRequestTempFiles(this.fileTempDir, this.httpDownloader, it);
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> removeAllWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        this.startPriorityQueueIfNotStarted();
        List<Download> downloadInfoList = this.databaseManager.getByStatus(status);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.cancelDownload(it.getId());
        }
        this.databaseManager.delete(downloadInfoList);
        Status removedStatus = Status.REMOVED;
        Iterable $receiver$iv2 = downloadInfoList;
        for (Object element$iv : $receiver$iv2) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(removedStatus);
            FetchUtils.deleteRequestTempFiles(this.fileTempDir, this.httpDownloader, it);
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> delete(@NotNull int[] ids) {
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.startPriorityQueueIfNotStarted();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadsList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        this.databaseManager.delete(downloadsList);
        Status deletedStatus = Status.DELETED;
        Iterable $receiver$iv = downloadsList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(deletedStatus);
            try {
                File file = new File(it.getFile());
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                this.logger.d("Failed to delete file " + it.getFile(), (Throwable)e);
            }
            FetchUtils.deleteRequestTempFiles(this.fileTempDir, this.httpDownloader, it);
        }
        return downloadsList;
    }

    @Override
    @NotNull
    public List<Download> deleteGroup(int id) {
        this.startPriorityQueueIfNotStarted();
        List<Download> downloadInfoList = this.databaseManager.getByGroup(id);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.cancelDownload(it.getId());
        }
        this.databaseManager.delete(downloadInfoList);
        Status deletedStatus = Status.DELETED;
        Iterable $receiver$iv2 = downloadInfoList;
        for (Object element$iv : $receiver$iv2) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(deletedStatus);
            try {
                File file = new File(it.getFile());
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                this.logger.d("Failed to delete file " + it.getFile(), (Throwable)e);
            }
            FetchUtils.deleteRequestTempFiles(this.fileTempDir, this.httpDownloader, it);
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> deleteAll() {
        this.startPriorityQueueIfNotStarted();
        this.downloadManager.cancelAll();
        List<Download> downloadInfoList = this.databaseManager.get();
        this.databaseManager.deleteAll();
        Status deletedStatus = Status.DELETED;
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(deletedStatus);
            try {
                File file = new File(it.getFile());
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                this.logger.d("Failed to delete file " + it.getFile(), (Throwable)e);
            }
            FetchUtils.deleteRequestTempFiles(this.fileTempDir, this.httpDownloader, it);
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> deleteAllWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        this.startPriorityQueueIfNotStarted();
        List<Download> downloadInfoList = this.databaseManager.getByStatus(status);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.cancelDownload(it.getId());
        }
        this.databaseManager.delete(downloadInfoList);
        Status deletedStatus = Status.DELETED;
        Iterable $receiver$iv2 = downloadInfoList;
        for (Object element$iv : $receiver$iv2) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(deletedStatus);
            try {
                File file = new File(it.getFile());
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception e) {
                this.logger.d("Failed to delete file " + it.getFile(), (Throwable)e);
            }
            FetchUtils.deleteRequestTempFiles(this.fileTempDir, this.httpDownloader, it);
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> cancel(@NotNull int[] ids) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.startPriorityQueueIfNotStarted();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canCancelDownload(it)) continue;
            it.setStatus(Status.CANCELLED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> cancelGroup(int id) {
        List list;
        DownloadInfo it;
        this.startPriorityQueueIfNotStarted();
        List downloadInfoList = this.databaseManager.getByGroup(id);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.downloadManager.cancel(it.getId());
        }
        downloadInfoList = this.databaseManager.getByGroup(id);
        $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!FetchUtils.canCancelDownload(it)) continue;
            it.setStatus(Status.CANCELLED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> cancelAll() {
        List list;
        DownloadInfo it;
        this.startPriorityQueueIfNotStarted();
        List downloadInfoList = this.databaseManager.get();
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.downloadManager.cancel(it.getId());
        }
        downloadInfoList = this.databaseManager.get();
        $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!FetchUtils.canCancelDownload(it)) continue;
            it.setStatus(Status.CANCELLED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> retry(@NotNull int[] ids) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.startPriorityQueueIfNotStarted();
        List downloadInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canRetryDownload(it)) continue;
            it.setStatus(Status.QUEUED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public Download updateRequest(int id, @NotNull RequestInfo requestInfo) {
        Intrinsics.checkParameterIsNotNull((Object)requestInfo, (String)"requestInfo");
        this.startPriorityQueueIfNotStarted();
        DownloadInfo downloadInfo = this.databaseManager.get(id);
        if (downloadInfo != null) {
            if (this.isDownloading(id)) {
                this.cancelDownload(id);
            }
            if ((downloadInfo = this.databaseManager.get(id)) != null) {
                downloadInfo.setGroup(requestInfo.getGroupId());
                downloadInfo.setHeaders(requestInfo.getHeaders());
                downloadInfo.setPriority(requestInfo.getPriority());
                downloadInfo.setNetworkType(requestInfo.getNetworkType());
                downloadInfo.setEnqueueAction(requestInfo.getEnqueueAction());
                this.databaseManager.update(downloadInfo);
                return downloadInfo;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<Download> getDownloads() {
        this.startPriorityQueueIfNotStarted();
        return this.databaseManager.get();
    }

    @Override
    @Nullable
    public Download getDownload(int id) {
        this.startPriorityQueueIfNotStarted();
        return this.databaseManager.get(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloads(@NotNull List<Integer> idList) {
        Intrinsics.checkParameterIsNotNull(idList, (String)"idList");
        this.startPriorityQueueIfNotStarted();
        List<DownloadInfo> downloads = this.databaseManager.get(idList);
        List results = new ArrayList();
        Iterable $receiver$iv = CollectionsKt.filterNotNull((Iterable)downloads);
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            results.add(it);
        }
        return results;
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroup(int id) {
        this.startPriorityQueueIfNotStarted();
        return this.databaseManager.getByGroup(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        this.startPriorityQueueIfNotStarted();
        return this.databaseManager.getByStatus(status);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroupWithStatus(int groupId, @NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        this.startPriorityQueueIfNotStarted();
        return this.databaseManager.getDownloadsInGroupWithStatus(groupId, status);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsByRequestIdentifier(long identifier) {
        this.startPriorityQueueIfNotStarted();
        return this.databaseManager.getDownloadsByRequestIdentifier(identifier);
    }

    @Override
    public void close() {
        Iterator<FetchListener> $receiver$iv;
        Iterator<FetchListener> iterator;
        if (this.isTerminating) {
            return;
        }
        this.isTerminating = true;
        Iterator<FetchListener> iterator2 = iterator = ($receiver$iv = this.listenerSet.iterator());
        while (iterator2.hasNext()) {
            FetchListener element$iv;
            FetchListener it = element$iv = iterator2.next();
            this.listenerCoordinator.removeListener(this.listenerId, it);
        }
        this.listenerSet.clear();
        this.priorityListProcessor.stop();
        this.downloadManager.close();
        FetchModulesBuilder.INSTANCE.removeNamespaceInstanceReference(this.namespace);
    }

    @Override
    public void setGlobalNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"networkType");
        this.startPriorityQueueIfNotStarted();
        this.priorityListProcessor.setGlobalNetworkType(networkType);
        this.downloadManager.cancelAll();
        FetchDatabaseExtensions.sanitize(this.databaseManager, true);
    }

    @Override
    public void enableLogging(boolean enabled) {
        this.startPriorityQueueIfNotStarted();
        this.logger.d("Enable logging - " + enabled);
        this.logger.setEnabled(enabled);
    }

    @Override
    public void addListener(@NotNull FetchListener listener, boolean notify) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.startPriorityQueueIfNotStarted();
        this.listenerSet.add(listener);
        this.listenerCoordinator.addListener(this.listenerId, listener);
        if (notify) {
            List<DownloadInfo> downloads = this.databaseManager.get();
            Iterable $receiver$iv = downloads;
            for (Object element$iv : $receiver$iv) {
                DownloadInfo it = (DownloadInfo)element$iv;
                this.uiHandler.post(new Runnable(it, this, listener){
                    final /* synthetic */ DownloadInfo $it;
                    final /* synthetic */ FetchHandlerImpl this$0;
                    final /* synthetic */ FetchListener $listener$inlined;
                    {
                        this.$it = downloadInfo;
                        this.this$0 = fetchHandlerImpl;
                        this.$listener$inlined = fetchListener;
                    }

                    public final void run() {
                        switch (FetchHandlerImpl$WhenMappings.$EnumSwitchMapping$0[this.$it.getStatus().ordinal()]) {
                            case 1: {
                                this.$listener$inlined.onCompleted(this.$it);
                                break;
                            }
                            case 2: {
                                this.$listener$inlined.onError(this.$it);
                                break;
                            }
                            case 3: {
                                this.$listener$inlined.onCancelled(this.$it);
                                break;
                            }
                            case 4: {
                                this.$listener$inlined.onDeleted(this.$it);
                                break;
                            }
                            case 5: {
                                this.$listener$inlined.onPaused(this.$it);
                                break;
                            }
                            case 6: {
                                this.$listener$inlined.onQueued(this.$it, false);
                                break;
                            }
                            case 7: {
                                this.$listener$inlined.onRemoved(this.$it);
                            }
                        }
                    }
                });
            }
        }
        this.logger.d("Added listener " + listener);
    }

    @Override
    public void removeListener(@NotNull FetchListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.startPriorityQueueIfNotStarted();
        Iterator<FetchListener> iterator = this.listenerSet.iterator();
        while (iterator.hasNext()) {
            FetchListener fetchListener = iterator.next();
            if (!Intrinsics.areEqual((Object)fetchListener, (Object)listener)) continue;
            iterator.remove();
            this.logger.d("Removed listener " + listener);
            break;
        }
        this.listenerCoordinator.removeListener(this.listenerId, listener);
    }

    @Override
    public boolean isDownloading(int id) {
        this.startPriorityQueueIfNotStarted();
        return this.downloadManager.contains(id);
    }

    @Override
    public boolean cancelDownload(int id) {
        this.startPriorityQueueIfNotStarted();
        return this.downloadManager.cancel(id);
    }

    private final void startPriorityQueueIfNotStarted() {
        if (this.priorityListProcessor.isStopped() && !this.isTerminating) {
            this.priorityListProcessor.start();
        }
        if (this.priorityListProcessor.isPaused() && !this.isTerminating) {
            this.priorityListProcessor.resume();
        }
    }

    public FetchHandlerImpl(@NotNull String namespace, @NotNull DatabaseManager databaseManager, @NotNull DownloadManager downloadManager, @NotNull PriorityListProcessor<? extends Download> priorityListProcessor, @NotNull Logger logger, boolean autoStart, @NotNull Downloader httpDownloader, @NotNull String fileTempDir, @NotNull ListenerCoordinator listenerCoordinator, @NotNull Handler uiHandler) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)databaseManager, (String)"databaseManager");
        Intrinsics.checkParameterIsNotNull((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkParameterIsNotNull(priorityListProcessor, (String)"priorityListProcessor");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)httpDownloader, (String)"httpDownloader");
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
        Intrinsics.checkParameterIsNotNull((Object)uiHandler, (String)"uiHandler");
        this.namespace = namespace;
        this.databaseManager = databaseManager;
        this.downloadManager = downloadManager;
        this.priorityListProcessor = priorityListProcessor;
        this.logger = logger;
        this.autoStart = autoStart;
        this.httpDownloader = httpDownloader;
        this.fileTempDir = fileTempDir;
        this.listenerCoordinator = listenerCoordinator;
        this.uiHandler = uiHandler;
        this.listenerId = UUID.randomUUID().hashCode();
        FetchHandlerImpl fetchHandlerImpl = this;
        fetchHandlerImpl.listenerSet = set = (Set)new LinkedHashSet();
    }
}

