/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2;

import com.tonyodev.fetch2.Error;
import java.io.IOException;
import java.net.SocketTimeoutException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"getErrorFromMessage", "Lcom/tonyodev/fetch2/Error;", "message", "", "getErrorFromThrowable", "throwable", "", "fetch2_release"})
@JvmName(name="FetchErrorUtils")
public final class FetchErrorUtils {
    @NotNull
    public static final Error getErrorFromThrowable(@NotNull Throwable throwable) {
        Error error;
        CharSequence charSequence;
        String message;
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        String string = throwable.getMessage();
        if (string == null) {
            string = message = "";
        }
        if (throwable instanceof SocketTimeoutException && (charSequence = (CharSequence)message).length() == 0) {
            message = "timeout";
        }
        return (error = FetchErrorUtils.getErrorFromMessage(message)) == Error.UNKNOWN && throwable instanceof SocketTimeoutException ? Error.CONNECTION_TIMED_OUT : (error == Error.UNKNOWN && throwable instanceof IOException ? Error.UNKNOWN_IO_ERROR : error);
    }

    @NotNull
    public static final Error getErrorFromMessage(@Nullable String message) {
        CharSequence charSequence;
        return message == null || (charSequence = (CharSequence)message).length() == 0 ? Error.UNKNOWN : (StringsKt.contains$default((CharSequence)message, (CharSequence)"UNIQUE constraint failed: requests._id", (boolean)false, (int)2, null) ? Error.REQUEST_WITH_ID_ALREADY_EXIST : (StringsKt.equals((String)message, (String)"empty_response_body", (boolean)true) ? Error.EMPTY_RESPONSE_FROM_SERVER : (StringsKt.equals((String)message, (String)"FNC", (boolean)true) || StringsKt.equals((String)message, (String)"open failed: ENOENT (No such file or directory)", (boolean)true) ? Error.FILE_NOT_CREATED : (StringsKt.contains((CharSequence)message, (CharSequence)"recvfrom failed: ETIMEDOUT (Connection timed out)", (boolean)true) || StringsKt.contains((CharSequence)message, (CharSequence)"timeout", (boolean)true) || StringsKt.contains((CharSequence)message, (CharSequence)"Software caused connection abort", (boolean)true) || StringsKt.contains((CharSequence)message, (CharSequence)"Read timed out at", (boolean)true) ? Error.CONNECTION_TIMED_OUT : (StringsKt.equals((String)message, (String)"java.io.IOException: 404", (boolean)true) || StringsKt.contains$default((CharSequence)message, (CharSequence)"No address associated with hostname", (boolean)false, (int)2, null) ? Error.HTTP_NOT_FOUND : (StringsKt.contains$default((CharSequence)message, (CharSequence)"Unable to resolve host", (boolean)false, (int)2, null) ? Error.UNKNOWN_HOST : (StringsKt.equals((String)message, (String)"open failed: EACCES (Permission denied)", (boolean)true) ? Error.WRITE_PERMISSION_DENIED : (StringsKt.equals((String)message, (String)"write failed: ENOSPC (No space left on device)", (boolean)true) || StringsKt.equals((String)message, (String)"database or disk is full (code 13)", (boolean)true) ? Error.NO_STORAGE_SPACE : (StringsKt.equals((String)message, (String)"UNIQUE constraint failed: requests._id (code 1555)", (boolean)true) ? Error.REQUEST_ALREADY_EXIST : (StringsKt.equals((String)message, (String)"fetch download not found", (boolean)true) ? Error.DOWNLOAD_NOT_FOUND : (StringsKt.equals((String)message, (String)"Fetch data base error", (boolean)true) ? Error.FETCH_DATABASE_ERROR : (StringsKt.contains((CharSequence)message, (CharSequence)"request_not_successful", (boolean)true) || StringsKt.contains((CharSequence)message, (CharSequence)"Failed to connect", (boolean)true) ? Error.REQUEST_NOT_SUCCESSFUL : (StringsKt.contains((CharSequence)message, (CharSequence)"invalid content md5", (boolean)true) ? Error.INVALID_CONTENT_MD5 : Error.UNKNOWN)))))))))))));
    }
}

