/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchErrorUtils;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.ParallelFileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.AverageCalculator;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.InterruptMonitor;
import com.tonyodev.fetch2core.Logger;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010*\u00010\u0018\u00002\u00020\u0001:\u0002]^BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0013J\b\u0010C\u001a\u00020DH\u0002J\u0010\u0010E\u001a\u00020D2\u0006\u0010F\u001a\u00020\tH\u0002J\u0018\u0010G\u001a\u00020D2\u0006\u0010F\u001a\u00020\t2\u0006\u0010H\u001a\u00020\tH\u0002J\u001e\u0010I\u001a\u00020D2\u0006\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002J\b\u0010M\u001a\u00020\u0007H\u0002J\u0010\u0010N\u001a\u00020O2\u0006\u0010J\u001a\u00020KH\u0002J\u0018\u0010P\u001a\u00020\u00112\u0006\u0010F\u001a\u00020\t2\u0006\u0010H\u001a\u00020\tH\u0002J\u001e\u0010Q\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010R\u001a\u00020\t2\u0006\u0010J\u001a\u00020KH\u0002J\u0010\u0010S\u001a\u00020\u00112\u0006\u0010F\u001a\u00020\tH\u0002J\u0010\u0010T\u001a\u00020\t2\u0006\u0010F\u001a\u00020\tH\u0002J\u0018\u0010U\u001a\u00020\u00072\u0006\u0010F\u001a\u00020\t2\u0006\u0010H\u001a\u00020\tH\u0002J\b\u0010V\u001a\u00020DH\u0002J\b\u0010W\u001a\u00020DH\u0016J\u0018\u0010X\u001a\u00020D2\u0006\u0010F\u001a\u00020\t2\u0006\u0010Y\u001a\u00020\tH\u0002J \u0010Z\u001a\u00020D2\u0006\u0010F\u001a\u00020\t2\u0006\u0010H\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0007H\u0002J\b\u0010[\u001a\u00020DH\u0002J\b\u0010\\\u001a\u00020DH\u0002R\u0012\u0010\u0014\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00101R\u001e\u00102\u001a\u00020\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u001a\"\u0004\b4\u0010\u001cR\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010=\u001a\u00020\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u001a\"\u0004\b?\u0010\u001cR\u0010\u0010@\u001a\u0004\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "initialDownload", "Lcom/tonyodev/fetch2/Download;", "downloader", "Lcom/tonyodev/fetch2core/Downloader;", "progressReportingIntervalMillis", "", "downloadBufferSizeBytes", "", "logger", "Lcom/tonyodev/fetch2core/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "fileTempDir", "", "md5CheckingEnabled", "(Lcom/tonyodev/fetch2/Download;Lcom/tonyodev/fetch2core/Downloader;JILcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;ZLjava/lang/String;Z)V", "actionsCounter", "actionsTotal", "averageDownloadedBytesPerSecond", "", "completedDownload", "getCompletedDownload", "()Z", "setCompletedDownload", "(Z)V", "delegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;)V", "download", "getDownload", "()Lcom/tonyodev/fetch2/Download;", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "downloaded", "estimatedTimeRemainingInMilliseconds", "executorService", "Ljava/util/concurrent/ExecutorService;", "fileSlices", "", "Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$FileSlice;", "interruptMonitor", "com/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$interruptMonitor$1", "Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$interruptMonitor$1;", "interrupted", "getInterrupted", "setInterrupted", "lock", "Ljava/lang/Object;", "movingAverageCalculator", "Lcom/tonyodev/fetch2core/AverageCalculator;", "outputStream", "Ljava/io/OutputStream;", "randomAccessFileOutput", "Ljava/io/RandomAccessFile;", "terminated", "getTerminated", "setTerminated", "throwable", "", "total", "deleteAllTempFiles", "", "deleteMetaFile", "id", "deleteTempFile", "position", "downloadSliceFiles", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "fileSlicesDownloadsList", "getAverageDownloadedBytesPerSecond", "getChuckInfo", "Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$FileSliceInfo;", "getDownloadedInfoFilePath", "getFileSliceList", "openingResponseCode", "getMetaFilePath", "getPreviousSliceCount", "getSavedDownloadedInfo", "incrementActionCompletedCount", "run", "saveCurrentSliceCount", "SliceCount", "saveDownloadedInfo", "throwExceptionIfFound", "waitAndPerformProgressReporting", "FileSlice", "FileSliceInfo", "fetch2_release"})
public final class ParallelFileDownloaderImpl
implements FileDownloader {
    private volatile boolean interrupted;
    private volatile boolean terminated;
    private volatile boolean completedDownload;
    @Nullable
    private FileDownloader.Delegate delegate;
    private DownloadInfo downloadInfo;
    private long downloaded;
    private long total;
    private double averageDownloadedBytesPerSecond;
    private final AverageCalculator movingAverageCalculator;
    private long estimatedTimeRemainingInMilliseconds;
    private ExecutorService executorService;
    private volatile int actionsCounter;
    private int actionsTotal;
    private final Object lock;
    private Throwable throwable;
    private List<FileSlice> fileSlices;
    private OutputStream outputStream;
    private RandomAccessFile randomAccessFileOutput;
    private final interruptMonitor.1 interruptMonitor;
    private final Download initialDownload;
    private final Downloader downloader;
    private final long progressReportingIntervalMillis;
    private final int downloadBufferSizeBytes;
    private final Logger logger;
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;
    private final String fileTempDir;
    private final boolean md5CheckingEnabled;

    @Override
    public boolean getInterrupted() {
        return this.interrupted;
    }

    @Override
    public void setInterrupted(boolean bl) {
        this.interrupted = bl;
    }

    @Override
    public boolean getTerminated() {
        return this.terminated;
    }

    @Override
    public void setTerminated(boolean bl) {
        this.terminated = bl;
    }

    @Override
    public boolean getCompletedDownload() {
        return this.completedDownload;
    }

    @Override
    public void setCompletedDownload(boolean bl) {
        this.completedDownload = bl;
    }

    @Override
    @Nullable
    public FileDownloader.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable FileDownloader.Delegate delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Download getDownload() {
        this.downloadInfo.setDownloaded(this.downloaded);
        this.downloadInfo.setTotal(this.total);
        return this.downloadInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Downloader.Response openingResponse = null;
        try {
            Downloader.ServerRequest openingRequest = FetchUtils.getRequestForDownload$default(this.initialDownload, 0L, 0L, 6, null);
            openingResponse = this.downloader.execute(openingRequest, (InterruptMonitor)this.interruptMonitor);
            if (!this.getInterrupted() && !this.getTerminated()) {
                Downloader.Response response = openingResponse;
                if (response != null) {
                    if (response.isSuccessful()) {
                        void $receiver$iv$iv;
                        Iterable $receiver$iv;
                        this.total = openingResponse.getContentLength();
                        if (this.total <= 0L) throw (Throwable)new FetchException("empty_response_body", FetchException.Code.EMPTY_RESPONSE_BODY);
                        this.fileSlices = this.getFileSliceList(openingResponse.getCode(), openingRequest);
                        try {
                            this.downloader.disconnect(openingResponse);
                        }
                        catch (Exception e) {
                            this.logger.e("FileDownloader", (Throwable)e);
                        }
                        Iterable iterable = $receiver$iv = (Iterable)this.fileSlices;
                        Collection destination$iv$iv = new ArrayList();
                        for (Object element$iv$iv : $receiver$iv$iv) {
                            FileSlice it = (FileSlice)element$iv$iv;
                            if (!(!it.isDownloaded())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List sliceFileDownloadsList = (List)destination$iv$iv;
                        if (this.getInterrupted() || this.getTerminated()) return;
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        FileDownloader.Delegate delegate = this.getDelegate();
                        if (delegate != null) {
                            delegate.onStarted(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                        }
                        $receiver$iv = sliceFileDownloadsList;
                        if (!$receiver$iv.isEmpty()) {
                            this.executorService = Executors.newFixedThreadPool(sliceFileDownloadsList.size());
                        }
                        this.downloadSliceFiles(openingRequest, sliceFileDownloadsList);
                        this.waitAndPerformProgressReporting();
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        if (!this.getInterrupted() && !this.getTerminated()) {
                            this.throwExceptionIfFound();
                            this.setCompletedDownload(true);
                            this.deleteAllTempFiles();
                            if (this.md5CheckingEnabled) {
                                if (!this.downloader.verifyContentMD5(openingResponse.getRequest(), openingResponse.getMd5())) throw (Throwable)new FetchException("invalid content md5", FetchException.Code.INVALID_CONTENT_MD5);
                                FileDownloader.Delegate delegate2 = this.getDelegate();
                                if (delegate2 != null) {
                                    delegate2.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                                }
                                FileDownloader.Delegate delegate3 = this.getDelegate();
                                if (delegate3 != null) {
                                    delegate3.onComplete(this.downloadInfo);
                                }
                            } else {
                                FileDownloader.Delegate delegate4 = this.getDelegate();
                                if (delegate4 != null) {
                                    delegate4.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                                }
                                FileDownloader.Delegate delegate5 = this.getDelegate();
                                if (delegate5 != null) {
                                    delegate5.onComplete(this.downloadInfo);
                                }
                            }
                        }
                        if (this.getCompletedDownload()) return;
                        this.downloadInfo.setDownloaded(this.downloaded);
                        this.downloadInfo.setTotal(this.total);
                        if (this.getTerminated()) return;
                        FileDownloader.Delegate delegate6 = this.getDelegate();
                        if (delegate6 != null) {
                            delegate6.saveDownloadProgress(this.downloadInfo);
                        }
                        FileDownloader.Delegate delegate7 = this.getDelegate();
                        if (delegate7 == null) return;
                        delegate7.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                        return;
                    }
                }
            }
            if (openingResponse == null && !this.getInterrupted() && !this.getTerminated()) {
                throw (Throwable)new FetchException("empty_response_body", FetchException.Code.EMPTY_RESPONSE_BODY);
            }
            Downloader.Response response = openingResponse;
            if (response != null) {
                if (!response.isSuccessful()) {
                    if (!this.getInterrupted() && !this.getTerminated()) {
                        throw (Throwable)new FetchException("request_not_successful", FetchException.Code.REQUEST_NOT_SUCCESSFUL);
                    }
                }
            }
            if (this.getInterrupted() || this.getTerminated()) return;
            throw (Throwable)new FetchException("unknown", FetchException.Code.UNKNOWN);
        }
        catch (Exception e) {
            if (this.getInterrupted() || this.getTerminated()) return;
            this.logger.e("FileDownloader", (Throwable)e);
            Error error = FetchErrorUtils.getErrorFromThrowable(e);
            error.setThrowable(e);
            if (this.retryOnNetworkGain) {
                boolean disconnectDetected = !this.networkInfoProvider.isNetworkAvailable();
                int $receiver$iv$iv = 1;
                int n = 10;
                while ($receiver$iv$iv <= n) {
                    void i;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e2) {
                        this.logger.e("FileDownloader", (Throwable)e2);
                        break;
                    }
                    if (!this.networkInfoProvider.isNetworkAvailable()) {
                        disconnectDetected = true;
                        break;
                    }
                    ++i;
                }
                if (disconnectDetected) {
                    error = Error.NO_NETWORK_CONNECTION;
                }
            }
            this.downloadInfo.setDownloaded(this.downloaded);
            this.downloadInfo.setTotal(this.total);
            this.downloadInfo.setError(error);
            if (this.getTerminated()) return;
            FileDownloader.Delegate delegate = this.getDelegate();
            if (delegate == null) return;
            delegate.onError(this.downloadInfo);
            return;
        }
        finally {
            try {
                ExecutorService executorService = this.executorService;
                if (executorService != null) {
                    executorService.shutdown();
                }
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", (Throwable)e);
            }
            try {
                RandomAccessFile randomAccessFile = this.randomAccessFileOutput;
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", (Throwable)e);
            }
            try {
                OutputStream outputStream = this.outputStream;
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                this.logger.e("FileDownloader", (Throwable)e);
            }
            if (openingResponse != null) {
                try {
                    this.downloader.disconnect(openingResponse);
                }
                catch (Exception e) {
                    this.logger.e("FileDownloader", (Throwable)e);
                }
            }
            this.setTerminated(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileSlice> getFileSliceList(int openingResponseCode, Downloader.ServerRequest request) {
        List list;
        File file = FetchCoreUtils.getFile((String)this.downloadInfo.getFile());
        if (!file.exists()) {
            this.deleteAllTempFiles();
        }
        int previousSliceSize = this.getPreviousSliceCount(this.downloadInfo.getId());
        if (openingResponseCode == 206) {
            FileSliceInfo fileSliceInfo = this.getChuckInfo(request);
            if (previousSliceSize != fileSliceInfo.getSlicingCount()) {
                this.deleteAllTempFiles();
            }
            this.saveCurrentSliceCount(this.downloadInfo.getId(), fileSliceInfo.getSlicingCount());
            long counterBytes = 0L;
            List fileSlices = new ArrayList();
            int n = 1;
            int n2 = fileSliceInfo.getSlicingCount();
            if (n <= n2) {
                while (!this.getInterrupted() && !this.getTerminated()) {
                    void position;
                    long endBytes;
                    long startBytes = counterBytes;
                    counterBytes = endBytes = fileSliceInfo.getSlicingCount() == position ? this.total : counterBytes + fileSliceInfo.getBytesPerFileSlice();
                    FileSlice fileSlice = new FileSlice(this.downloadInfo.getId(), (int)position, startBytes, endBytes, this.getSavedDownloadedInfo(this.downloadInfo.getId(), (int)position));
                    this.downloaded += fileSlice.getDownloaded();
                    fileSlices.add(fileSlice);
                    if (position == n2) break;
                    ++position;
                }
            }
            list = fileSlices;
        } else {
            if (previousSliceSize != 1) {
                this.deleteAllTempFiles();
            }
            this.saveCurrentSliceCount(this.downloadInfo.getId(), 1);
            FileSlice fileSlice = new FileSlice(this.downloadInfo.getId(), 1, 0L, this.total, this.getSavedDownloadedInfo(this.downloadInfo.getId(), 1));
            this.downloaded += fileSlice.getDownloaded();
            list = CollectionsKt.listOf((Object)fileSlice);
        }
        return list;
    }

    private final int getPreviousSliceCount(int id) {
        int sliceCount = -1;
        try {
            if (!this.getTerminated() && !this.getInterrupted()) {
                int n;
                String string = FetchCoreUtils.getSingleLineTextFromFile((String)this.getMetaFilePath(id));
                if (string != null) {
                    String string2 = string;
                    n = Integer.parseInt(string2);
                } else {
                    n = -1;
                }
                sliceCount = n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sliceCount;
    }

    private final void saveCurrentSliceCount(int id, int SliceCount) {
        try {
            if (!this.getTerminated() && !this.getInterrupted()) {
                FetchCoreUtils.writeTextToFile((String)this.getMetaFilePath(id), (String)String.valueOf(SliceCount));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final String getMetaFilePath(int id) {
        return "" + this.fileTempDir + '/' + id + ".meta.txt";
    }

    private final FileSliceInfo getChuckInfo(Downloader.ServerRequest request) {
        FileSliceInfo fileSliceInfo;
        int fileSliceSize;
        Integer n = this.downloader.getFileSlicingCount(request, this.total);
        int n2 = fileSliceSize = n != null ? n : -1;
        if (fileSliceSize == -1) {
            float fileSizeInMb = (float)this.total / 1024.0f * 1024.0f;
            float fileSizeInGb = (float)this.total / 1024.0f * 1024.0f * 1024.0f;
            if (fileSizeInGb >= 1.0f) {
                int slices = 6;
                float f = (float)this.total / (float)slices;
                long bytesPerSlice = (long)Math.ceil(f);
                fileSliceInfo = new FileSliceInfo(slices, bytesPerSlice);
            } else if (fileSizeInMb >= 1.0f) {
                int slices = 4;
                float f = (float)this.total / (float)slices;
                long bytesPerSlice = (long)Math.ceil(f);
                fileSliceInfo = new FileSliceInfo(slices, bytesPerSlice);
            } else {
                fileSliceInfo = new FileSliceInfo(2, this.total);
            }
        } else {
            float f = (float)this.total / (float)fileSliceSize;
            long bytesPerSlice = (long)Math.ceil(f);
            return new FileSliceInfo(fileSliceSize, bytesPerSlice);
        }
        return fileSliceInfo;
    }

    private final String getDownloadedInfoFilePath(int id, int position) {
        return "" + this.fileTempDir + '/' + id + '.' + position + ".txt";
    }

    private final void deleteTempFile(int id, int position) {
        try {
            File textFile;
            if (!this.getInterrupted() && !this.getTerminated() && (textFile = FetchCoreUtils.getFile((String)this.getDownloadedInfoFilePath(id, position))).exists()) {
                textFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void deleteMetaFile(int id) {
        try {
            File textFile;
            if (!this.getTerminated() && !this.getInterrupted() && (textFile = FetchCoreUtils.getFile((String)this.getMetaFilePath(id))).exists()) {
                textFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final long getSavedDownloadedInfo(int id, int position) {
        long downloaded = 0L;
        try {
            if (!this.getTerminated() && !this.getInterrupted()) {
                long l;
                String string = FetchCoreUtils.getSingleLineTextFromFile((String)this.getDownloadedInfoFilePath(id, position));
                if (string != null) {
                    String string2 = string;
                    l = Long.parseLong(string2);
                } else {
                    l = 0L;
                }
                downloaded = l;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return downloaded;
    }

    private final void saveDownloadedInfo(int id, int position, long downloaded) {
        try {
            FetchCoreUtils.writeTextToFile((String)this.getDownloadedInfoFilePath(id, position), (String)String.valueOf(downloaded));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final long getAverageDownloadedBytesPerSecond() {
        if (this.averageDownloadedBytesPerSecond < 1.0) {
            return 0L;
        }
        double d = this.averageDownloadedBytesPerSecond;
        return (long)Math.ceil(d);
    }

    private final void waitAndPerformProgressReporting() {
        long downloadedBytesPerSecond = this.downloaded;
        long reportingStartTime = System.nanoTime();
        long downloadSpeedStartTime = System.nanoTime();
        while (this.actionsCounter != this.actionsTotal && !this.getInterrupted() && !this.getTerminated()) {
            long reportingStopTime;
            boolean hasReportingTimeElapsed;
            this.downloadInfo.setDownloaded(this.downloaded);
            this.downloadInfo.setTotal(this.total);
            long downloadSpeedStopTime = System.nanoTime();
            boolean downloadSpeedCheckTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)downloadSpeedStartTime, (long)downloadSpeedStopTime, (long)1000L);
            if (downloadSpeedCheckTimeElapsed) {
                downloadedBytesPerSecond = this.downloaded - downloadedBytesPerSecond;
                this.movingAverageCalculator.add((double)downloadedBytesPerSecond);
                this.averageDownloadedBytesPerSecond = AverageCalculator.getMovingAverageWithWeightOnRecentValues$default((AverageCalculator)this.movingAverageCalculator, (int)0, (int)1, null);
                this.estimatedTimeRemainingInMilliseconds = FetchCoreUtils.calculateEstimatedTimeRemainingInMilliseconds((long)this.downloaded, (long)this.total, (long)this.getAverageDownloadedBytesPerSecond());
                downloadedBytesPerSecond = this.downloaded;
                if (this.progressReportingIntervalMillis > 1000L) {
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.saveDownloadProgress(this.downloadInfo);
                    }
                }
            }
            if (hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)(reportingStopTime = System.nanoTime()), (long)this.progressReportingIntervalMillis)) {
                if (this.progressReportingIntervalMillis <= 1000L) {
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.saveDownloadProgress(this.downloadInfo);
                    }
                }
                if (!this.getTerminated()) {
                    FileDownloader.Delegate delegate = this.getDelegate();
                    if (delegate != null) {
                        delegate.onProgress(this.downloadInfo, this.estimatedTimeRemainingInMilliseconds, this.getAverageDownloadedBytesPerSecond());
                    }
                }
                reportingStartTime = System.nanoTime();
            }
            if (!downloadSpeedCheckTimeElapsed) continue;
            downloadSpeedStartTime = System.nanoTime();
        }
    }

    private final void downloadSliceFiles(Downloader.ServerRequest request, List<FileSlice> fileSlicesDownloadsList) {
        this.actionsCounter = 0;
        this.actionsTotal = fileSlicesDownloadsList.size();
        this.outputStream = this.downloader.getRequestOutputStream(request, 0L);
        if (this.outputStream == null) {
            RandomAccessFile randomAccessFile = this.randomAccessFileOutput = new RandomAccessFile(this.downloadInfo.getFile(), "rw");
            if (randomAccessFile != null) {
                randomAccessFile.seek(0L);
            }
        }
        for (FileSlice fileSlice : fileSlicesDownloadsList) {
            if (this.getInterrupted() || this.getTerminated()) continue;
            ExecutorService executorService = this.executorService;
            if (executorService == null) continue;
            executorService.execute(new Runnable(this, fileSlice, request){
                final /* synthetic */ ParallelFileDownloaderImpl this$0;
                final /* synthetic */ FileSlice $fileSlice;
                final /* synthetic */ Downloader.ServerRequest $request;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    block32: {
                        Downloader.ServerRequest downloadRequest = FetchUtils.getRequestForDownload$default(ParallelFileDownloaderImpl.access$getDownloadInfo$p(this.this$0), this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded(), 0L, 4, null);
                        Downloader.Response downloadResponse = null;
                        try {
                            downloadResponse = ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).execute(downloadRequest, (InterruptMonitor)ParallelFileDownloaderImpl.access$getInterruptMonitor$p(this.this$0));
                            if (!this.this$0.getTerminated() && !this.this$0.getInterrupted()) {
                                Downloader.Response response = downloadResponse;
                                if (response != null) {
                                    if (response.isSuccessful()) {
                                        byte[] buffer = new byte[ParallelFileDownloaderImpl.access$getDownloadBufferSizeBytes$p(this.this$0)];
                                        InputStream inputStream = downloadResponse.getByteStream();
                                        int read = inputStream != null ? inputStream.read(buffer, 0, ParallelFileDownloaderImpl.access$getDownloadBufferSizeBytes$p(this.this$0)) : -1;
                                        long remainderBytes = this.$fileSlice.getEndBytes() - (this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded());
                                        long reportingStartTime = System.nanoTime();
                                        Ref.IntRef streamBytes = new Ref.IntRef();
                                        Ref.LongRef longRef = new Ref.LongRef();
                                        while (remainderBytes > 0L && read != -1 && !this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                            int n;
                                            if ((long)read <= remainderBytes) {
                                                n = read;
                                            } else {
                                                read = -1;
                                                n = (int)remainderBytes;
                                            }
                                            streamBytes.element = n;
                                            longRef.element = this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded();
                                            Object object = ParallelFileDownloaderImpl.access$getLock$p(this.this$0);
                                            synchronized (object) {
                                                if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                                    OutputStream outputStream = ParallelFileDownloaderImpl.access$getOutputStream$p(this.this$0);
                                                    if (outputStream != null) {
                                                        ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).seekOutputStreamToPosition(this.$request, outputStream, longRef.element);
                                                        outputStream.write(buffer, 0, streamBytes.element);
                                                    } else {
                                                        RandomAccessFile randomAccessFile = ParallelFileDownloaderImpl.access$getRandomAccessFileOutput$p(this.this$0);
                                                        if (randomAccessFile != null) {
                                                            randomAccessFile.seek(longRef.element);
                                                        }
                                                        RandomAccessFile randomAccessFile2 = ParallelFileDownloaderImpl.access$getRandomAccessFileOutput$p(this.this$0);
                                                        if (randomAccessFile2 != null) {
                                                            randomAccessFile2.write(buffer, 0, streamBytes.element);
                                                        }
                                                    }
                                                    FileSlice fileSlice = this.$fileSlice;
                                                    fileSlice.setDownloaded(fileSlice.getDownloaded() + (long)streamBytes.element);
                                                    ParallelFileDownloaderImpl parallelFileDownloaderImpl = this.this$0;
                                                    ParallelFileDownloaderImpl.access$setDownloaded$p(parallelFileDownloaderImpl, ParallelFileDownloaderImpl.access$getDownloaded$p(parallelFileDownloaderImpl) + (long)streamBytes.element);
                                                }
                                                Unit unit = Unit.INSTANCE;
                                            }
                                            if (this.this$0.getInterrupted() || this.this$0.getTerminated()) continue;
                                            long reportingStopTime = System.nanoTime();
                                            boolean hasReportingTimeElapsed = FetchCoreUtils.hasIntervalTimeElapsed((long)reportingStartTime, (long)reportingStopTime, (long)1000L);
                                            if (hasReportingTimeElapsed) {
                                                ParallelFileDownloaderImpl.access$saveDownloadedInfo(this.this$0, this.$fileSlice.getId(), this.$fileSlice.getPosition(), this.$fileSlice.getDownloaded());
                                                reportingStartTime = System.nanoTime();
                                            }
                                            if (read == -1) continue;
                                            InputStream inputStream2 = downloadResponse.getByteStream();
                                            read = inputStream2 != null ? inputStream2.read(buffer, 0, ParallelFileDownloaderImpl.access$getDownloadBufferSizeBytes$p(this.this$0)) : -1;
                                            remainderBytes = this.$fileSlice.getEndBytes() - (this.$fileSlice.getStartBytes() + this.$fileSlice.getDownloaded());
                                        }
                                        ParallelFileDownloaderImpl.access$saveDownloadedInfo(this.this$0, this.$fileSlice.getId(), this.$fileSlice.getPosition(), this.$fileSlice.getDownloaded());
                                        break block32;
                                    }
                                }
                            }
                            if (downloadResponse == null && !this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                throw (Throwable)new FetchException("empty_response_body", FetchException.Code.EMPTY_RESPONSE_BODY);
                            }
                            Downloader.Response response = downloadResponse;
                            if (response != null) {
                                if (!response.isSuccessful()) {
                                    if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                        throw (Throwable)new FetchException("request_not_successful", FetchException.Code.REQUEST_NOT_SUCCESSFUL);
                                    }
                                }
                            }
                            if (!this.this$0.getInterrupted() && !this.this$0.getTerminated()) {
                                throw (Throwable)new FetchException("unknown", FetchException.Code.UNKNOWN);
                            }
                        }
                        catch (Exception e) {
                            ParallelFileDownloaderImpl.access$setThrowable$p(this.this$0, e);
                        }
                        finally {
                            try {
                                if (downloadResponse != null) {
                                    ParallelFileDownloaderImpl.access$getDownloader$p(this.this$0).disconnect(downloadResponse);
                                }
                            }
                            catch (Exception e) {
                                ParallelFileDownloaderImpl.access$getLogger$p(this.this$0).e("FileDownloader", (Throwable)e);
                            }
                            ParallelFileDownloaderImpl.access$incrementActionCompletedCount(this.this$0);
                        }
                    }
                }
                {
                    this.this$0 = parallelFileDownloaderImpl;
                    this.$fileSlice = fileSlice;
                    this.$request = serverRequest;
                }
            });
        }
    }

    private final void deleteAllTempFiles() {
        try {
            for (FileSlice fileSlice : this.fileSlices) {
                if (this.getInterrupted() || this.getTerminated()) break;
                this.deleteTempFile(fileSlice.getId(), fileSlice.getPosition());
            }
            if (!this.getInterrupted() && !this.getTerminated()) {
                this.deleteMetaFile(this.downloadInfo.getId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void incrementActionCompletedCount() {
        Object object = this.lock;
        synchronized (object) {
            ++this.actionsCounter;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void throwExceptionIfFound() {
        Throwable exception = this.throwable;
        if (exception != null) {
            throw exception;
        }
    }

    public ParallelFileDownloaderImpl(@NotNull Download initialDownload, @NotNull Downloader downloader, long progressReportingIntervalMillis, int downloadBufferSizeBytes, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain, @NotNull String fileTempDir, boolean md5CheckingEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)initialDownload, (String)"initialDownload");
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        this.initialDownload = initialDownload;
        this.downloader = downloader;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.downloadBufferSizeBytes = downloadBufferSizeBytes;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.fileTempDir = fileTempDir;
        this.md5CheckingEnabled = md5CheckingEnabled;
        this.downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(this.initialDownload);
        this.total = -1L;
        this.movingAverageCalculator = new AverageCalculator(5);
        this.estimatedTimeRemainingInMilliseconds = -1L;
        this.lock = new Object();
        this.fileSlices = CollectionsKt.emptyList();
        this.interruptMonitor = new InterruptMonitor(this){
            final /* synthetic */ ParallelFileDownloaderImpl this$0;

            public boolean isInterrupted() {
                return this.this$0.getInterrupted();
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ DownloadInfo access$getDownloadInfo$p(ParallelFileDownloaderImpl $this) {
        return $this.downloadInfo;
    }

    public static final /* synthetic */ void access$setDownloadInfo$p(ParallelFileDownloaderImpl $this, @NotNull DownloadInfo downloadInfo) {
        $this.downloadInfo = downloadInfo;
    }

    @NotNull
    public static final /* synthetic */ Downloader access$getDownloader$p(ParallelFileDownloaderImpl $this) {
        return $this.downloader;
    }

    @NotNull
    public static final /* synthetic */ interruptMonitor.1 access$getInterruptMonitor$p(ParallelFileDownloaderImpl $this) {
        return $this.interruptMonitor;
    }

    public static final /* synthetic */ int access$getDownloadBufferSizeBytes$p(ParallelFileDownloaderImpl $this) {
        return $this.downloadBufferSizeBytes;
    }

    @NotNull
    public static final /* synthetic */ Object access$getLock$p(ParallelFileDownloaderImpl $this) {
        return $this.lock;
    }

    @Nullable
    public static final /* synthetic */ OutputStream access$getOutputStream$p(ParallelFileDownloaderImpl $this) {
        return $this.outputStream;
    }

    public static final /* synthetic */ void access$setOutputStream$p(ParallelFileDownloaderImpl $this, @Nullable OutputStream outputStream) {
        $this.outputStream = outputStream;
    }

    @Nullable
    public static final /* synthetic */ RandomAccessFile access$getRandomAccessFileOutput$p(ParallelFileDownloaderImpl $this) {
        return $this.randomAccessFileOutput;
    }

    public static final /* synthetic */ void access$setRandomAccessFileOutput$p(ParallelFileDownloaderImpl $this, @Nullable RandomAccessFile randomAccessFile) {
        $this.randomAccessFileOutput = randomAccessFile;
    }

    public static final /* synthetic */ long access$getDownloaded$p(ParallelFileDownloaderImpl $this) {
        return $this.downloaded;
    }

    public static final /* synthetic */ void access$setDownloaded$p(ParallelFileDownloaderImpl $this, long l) {
        $this.downloaded = l;
    }

    public static final /* synthetic */ void access$saveDownloadedInfo(ParallelFileDownloaderImpl $this, int id, int position, long downloaded) {
        $this.saveDownloadedInfo(id, position, downloaded);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(ParallelFileDownloaderImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$incrementActionCompletedCount(ParallelFileDownloaderImpl $this) {
        $this.incrementActionCompletedCount();
    }

    @Nullable
    public static final /* synthetic */ Throwable access$getThrowable$p(ParallelFileDownloaderImpl $this) {
        return $this.throwable;
    }

    public static final /* synthetic */ void access$setThrowable$p(ParallelFileDownloaderImpl $this, @Nullable Throwable throwable) {
        $this.throwable = throwable;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$FileSliceInfo;", "", "slicingCount", "", "bytesPerFileSlice", "", "(IJ)V", "getBytesPerFileSlice", "()J", "getSlicingCount", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "fetch2_release"})
    public static final class FileSliceInfo {
        private final int slicingCount;
        private final long bytesPerFileSlice;

        public final int getSlicingCount() {
            return this.slicingCount;
        }

        public final long getBytesPerFileSlice() {
            return this.bytesPerFileSlice;
        }

        public FileSliceInfo(int slicingCount, long bytesPerFileSlice) {
            this.slicingCount = slicingCount;
            this.bytesPerFileSlice = bytesPerFileSlice;
        }

        public final int component1() {
            return this.slicingCount;
        }

        public final long component2() {
            return this.bytesPerFileSlice;
        }

        @NotNull
        public final FileSliceInfo copy(int slicingCount, long bytesPerFileSlice) {
            return new FileSliceInfo(slicingCount, bytesPerFileSlice);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ FileSliceInfo copy$default(FileSliceInfo fileSliceInfo, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = fileSliceInfo.slicingCount;
            }
            if ((n2 & 2) != 0) {
                l = fileSliceInfo.bytesPerFileSlice;
            }
            return fileSliceInfo.copy(n, l);
        }

        public String toString() {
            return "FileSliceInfo(slicingCount=" + this.slicingCount + ", bytesPerFileSlice=" + this.bytesPerFileSlice + ")";
        }

        public int hashCode() {
            long l = this.bytesPerFileSlice;
            return this.slicingCount * 31 + (int)(l ^ l >>> 32);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FileSliceInfo)) break block3;
                    FileSliceInfo fileSliceInfo = (FileSliceInfo)object;
                    if (!(this.slicingCount == fileSliceInfo.slicingCount) || !(this.bytesPerFileSlice == fileSliceInfo.bytesPerFileSlice)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J;\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/tonyodev/fetch2/downloader/ParallelFileDownloaderImpl$FileSlice;", "", "id", "", "position", "startBytes", "", "endBytes", "downloaded", "(IIJJJ)V", "getDownloaded", "()J", "setDownloaded", "(J)V", "getEndBytes", "getId", "()I", "isDownloaded", "", "()Z", "getPosition", "getStartBytes", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "", "fetch2_release"})
    public static final class FileSlice {
        private final int id;
        private final int position;
        private final long startBytes;
        private final long endBytes;
        private long downloaded;

        public final boolean isDownloaded() {
            return this.startBytes + this.downloaded == this.endBytes;
        }

        public final int getId() {
            return this.id;
        }

        public final int getPosition() {
            return this.position;
        }

        public final long getStartBytes() {
            return this.startBytes;
        }

        public final long getEndBytes() {
            return this.endBytes;
        }

        public final long getDownloaded() {
            return this.downloaded;
        }

        public final void setDownloaded(long l) {
            this.downloaded = l;
        }

        public FileSlice(int id, int position, long startBytes, long endBytes, long downloaded) {
            this.id = id;
            this.position = position;
            this.startBytes = startBytes;
            this.endBytes = endBytes;
            this.downloaded = downloaded;
        }

        public /* synthetic */ FileSlice(int n, int n2, long l, long l2, long l3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            if ((n3 & 4) != 0) {
                l = 0L;
            }
            if ((n3 & 8) != 0) {
                l2 = 0L;
            }
            if ((n3 & 0x10) != 0) {
                l3 = 0L;
            }
            this(n, n2, l, l2, l3);
        }

        public FileSlice() {
            this(0, 0, 0L, 0L, 0L, 31, null);
        }

        public final int component1() {
            return this.id;
        }

        public final int component2() {
            return this.position;
        }

        public final long component3() {
            return this.startBytes;
        }

        public final long component4() {
            return this.endBytes;
        }

        public final long component5() {
            return this.downloaded;
        }

        @NotNull
        public final FileSlice copy(int id, int position, long startBytes, long endBytes, long downloaded) {
            return new FileSlice(id, position, startBytes, endBytes, downloaded);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ FileSlice copy$default(FileSlice fileSlice, int n, int n2, long l, long l2, long l3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = fileSlice.id;
            }
            if ((n3 & 2) != 0) {
                n2 = fileSlice.position;
            }
            if ((n3 & 4) != 0) {
                l = fileSlice.startBytes;
            }
            if ((n3 & 8) != 0) {
                l2 = fileSlice.endBytes;
            }
            if ((n3 & 0x10) != 0) {
                l3 = fileSlice.downloaded;
            }
            return fileSlice.copy(n, n2, l, l2, l3);
        }

        public String toString() {
            return "FileSlice(id=" + this.id + ", position=" + this.position + ", startBytes=" + this.startBytes + ", endBytes=" + this.endBytes + ", downloaded=" + this.downloaded + ")";
        }

        public int hashCode() {
            long l = this.startBytes;
            long l2 = this.endBytes;
            long l3 = this.downloaded;
            return (((this.id * 31 + this.position) * 31 + (int)(l ^ l >>> 32)) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (int)(l3 ^ l3 >>> 32);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FileSlice)) break block3;
                    FileSlice fileSlice = (FileSlice)object;
                    if (!(this.id == fileSlice.id) || !(this.position == fileSlice.position) || !(this.startBytes == fileSlice.startBytes) || !(this.endBytes == fileSlice.endBytes) || !(this.downloaded == fileSlice.downloaded)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

