/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import android.os.Handler;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.ParallelFileDownloaderImpl;
import com.tonyodev.fetch2.downloader.SequentialFileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.exception.FetchImplementationException;
import com.tonyodev.fetch2.fetch.DownloadManagerCoordinator;
import com.tonyodev.fetch2.fetch.ListenerCoordinator;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.helper.FileDownloaderDelegate;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import com.tonyodev.fetch2core.Downloader;
import com.tonyodev.fetch2core.FetchCoreUtils;
import com.tonyodev.fetch2core.FileServerDownloader;
import com.tonyodev.fetch2core.HandlerWrapper;
import com.tonyodev.fetch2core.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u007f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u000e\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\b\u0010,\u001a\u00020\u000eH\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0005H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0002J\b\u00102\u001a\u000200H\u0016J\u0010\u00103\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0005H\u0016J\b\u00104\u001a\u00020\u0005H\u0016J\u0010\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u000207H\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020709H\u0016J \u0010:\u001a\u00020\"2\u0006\u0010;\u001a\u00020<2\u0006\u00106\u001a\u0002072\u0006\u0010=\u001a\u00020\u0003H\u0002J\b\u0010>\u001a\u00020?H\u0016J\u0012\u0010@\u001a\u0004\u0018\u00010\"2\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010A\u001a\u00020\u000e2\u0006\u00106\u001a\u000207H\u0016J\b\u0010B\u001a\u000200H\u0002J\b\u0010C\u001a\u000200H\u0002R\u0012\u0010\u001f\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"0!j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"`#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n '*\u0004\u0018\u00010&0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/tonyodev/fetch2/downloader/DownloadManagerImpl;", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "httpDownloader", "Lcom/tonyodev/fetch2core/Downloader;", "concurrentLimit", "", "progressReportingIntervalMillis", "", "downloadBufferSizeBytes", "logger", "Lcom/tonyodev/fetch2core/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "uiHandler", "Landroid/os/Handler;", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "fileTempDir", "", "downloadManagerCoordinator", "Lcom/tonyodev/fetch2/fetch/DownloadManagerCoordinator;", "listenerCoordinator", "Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;", "fileServerDownloader", "Lcom/tonyodev/fetch2core/FileServerDownloader;", "md5CheckingEnabled", "downloadBlockHandlerWrapper", "Lcom/tonyodev/fetch2core/HandlerWrapper;", "(Lcom/tonyodev/fetch2core/Downloader;IJILcom/tonyodev/fetch2core/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;ZLandroid/os/Handler;Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;Ljava/lang/String;Lcom/tonyodev/fetch2/fetch/DownloadManagerCoordinator;Lcom/tonyodev/fetch2/fetch/ListenerCoordinator;Lcom/tonyodev/fetch2core/FileServerDownloader;ZLcom/tonyodev/fetch2core/HandlerWrapper;)V", "closed", "currentDownloadsMap", "Ljava/util/HashMap;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "Lkotlin/collections/HashMap;", "downloadCounter", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "isClosed", "()Z", "lock", "Ljava/lang/Object;", "canAccommodateNewDownload", "cancel", "id", "cancelAll", "", "cancelAllDownloads", "close", "contains", "getActiveDownloadCount", "getDownloadFileTempDir", "download", "Lcom/tonyodev/fetch2/Download;", "getDownloads", "", "getFileDownloader", "request", "Lcom/tonyodev/fetch2core/Downloader$ServerRequest;", "downloader", "getFileDownloaderDelegate", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "getNewFileDownloaderForDownload", "start", "terminateAllDownloads", "throwExceptionIfClosed", "fetch2_release"})
public final class DownloadManagerImpl
implements DownloadManager {
    private final Object lock;
    private final ExecutorService executor;
    private final HashMap<Integer, FileDownloader> currentDownloadsMap;
    private volatile int downloadCounter;
    private volatile boolean closed;
    private final Downloader httpDownloader;
    private final int concurrentLimit;
    private final long progressReportingIntervalMillis;
    private final int downloadBufferSizeBytes;
    private final Logger logger;
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;
    private final Handler uiHandler;
    private final DownloadInfoUpdater downloadInfoUpdater;
    private final String fileTempDir;
    private final DownloadManagerCoordinator downloadManagerCoordinator;
    private final ListenerCoordinator listenerCoordinator;
    private final FileServerDownloader fileServerDownloader;
    private final boolean md5CheckingEnabled;
    private final HandlerWrapper downloadBlockHandlerWrapper;

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start(@NotNull Download download) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Object object = this.lock;
        synchronized (object) {
            block12: {
                block11: {
                    this.throwExceptionIfClosed();
                    if (!this.currentDownloadsMap.containsKey(download.getId())) break block11;
                    this.logger.d("DownloadManager already running download " + download);
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.downloadCounter < this.concurrentLimit) break block12;
                this.logger.d("DownloadManager cannot init download " + download + " because " + "the download queue is full");
                boolean bl3 = false;
                return bl3;
            }
            FileDownloader.Delegate delegate = this.getFileDownloaderDelegate();
            try {
                boolean bl4;
                FileDownloader fileDownloader = this.getNewFileDownloaderForDownload(download);
                if (fileDownloader != null) {
                    boolean bl5;
                    fileDownloader.setDelegate(delegate);
                    ++this.downloadCounter;
                    Map map = this.currentDownloadsMap;
                    Integer n = download.getId();
                    FileDownloader fileDownloader2 = fileDownloader;
                    map.put(n, fileDownloader2);
                    this.downloadManagerCoordinator.addFileDownloader(download.getId(), fileDownloader);
                    try {
                        this.executor.execute(new Runnable(fileDownloader, this, download){
                            final /* synthetic */ FileDownloader $fileDownloader;
                            final /* synthetic */ DownloadManagerImpl this$0;
                            final /* synthetic */ Download $download$inlined;
                            {
                                this.$fileDownloader = fileDownloader;
                                this.this$0 = downloadManagerImpl;
                                this.$download$inlined = download;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void run() {
                                DownloadManagerImpl.access$getLogger$p(this.this$0).d("DownloadManager starting download " + this.$download$inlined);
                                this.$fileDownloader.run();
                                Object object = DownloadManagerImpl.access$getLock$p(this.this$0);
                                synchronized (object) {
                                    if (DownloadManagerImpl.access$getCurrentDownloadsMap$p(this.this$0).containsKey(this.$download$inlined.getId())) {
                                        DownloadManagerImpl.access$getCurrentDownloadsMap$p(this.this$0).remove(this.$download$inlined.getId());
                                        DownloadManagerImpl downloadManagerImpl = this.this$0;
                                        DownloadManagerImpl.access$setDownloadCounter$p(downloadManagerImpl, DownloadManagerImpl.access$getDownloadCounter$p(downloadManagerImpl) - 1);
                                    }
                                    DownloadManagerImpl.access$getDownloadManagerCoordinator$p(this.this$0).removeFileDownloader(this.$download$inlined.getId());
                                    Unit unit = Unit.INSTANCE;
                                }
                            }
                        });
                        bl5 = true;
                    }
                    catch (Exception e) {
                        this.logger.e("DownloadManager failed to start download " + download, (Throwable)e);
                        bl5 = false;
                    }
                    bl4 = bl5;
                } else {
                    DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(download);
                    downloadInfo.setError(Error.FETCH_FILE_SERVER_DOWNLOADER_NOT_SET);
                    delegate.onError(downloadInfo);
                    bl4 = false;
                }
                bl = bl4;
            }
            catch (Exception e) {
                DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(download);
                downloadInfo.setError(Error.FETCH_FILE_SERVER_URL_INVALID);
                delegate.onError(downloadInfo);
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(int id) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            this.throwExceptionIfClosed();
            if (this.currentDownloadsMap.containsKey(id)) {
                FileDownloader fileDownloader = this.currentDownloadsMap.get(id);
                if (fileDownloader == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.tonyodev.fetch2.downloader.FileDownloader");
                }
                FileDownloader fileDownloader2 = fileDownloader;
                fileDownloader2.setInterrupted(true);
                this.currentDownloadsMap.remove(id);
                --this.downloadCounter;
                this.downloadManagerCoordinator.removeFileDownloader(id);
                this.logger.d("DownloadManager cancelled download " + fileDownloader2.getDownload());
                bl = true;
            } else {
                this.downloadManagerCoordinator.interruptDownload(id);
                bl = false;
            }
            boolean bl2 = bl;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.cancelAllDownloads();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void cancelAllDownloads() {
        Iterator<FileDownloader> $receiver$iv;
        Iterator<FileDownloader> iterator;
        Iterator<FileDownloader> iterator2 = iterator = ($receiver$iv = this.downloadManagerCoordinator.getFileDownloaderList().iterator());
        while (iterator2.hasNext()) {
            FileDownloader element$iv;
            FileDownloader it = element$iv = iterator2.next();
            it.setInterrupted(true);
            this.downloadManagerCoordinator.removeFileDownloader(it.getDownload().getId());
            this.logger.d("DownloadManager cancelled download " + it.getDownload());
        }
        this.currentDownloadsMap.clear();
        this.downloadCounter = 0;
    }

    private final void terminateAllDownloads() {
        Iterator iterator;
        Map map = this.currentDownloadsMap;
        Iterator $receiver$iv = map.entrySet().iterator();
        Iterator iterator2 = iterator = $receiver$iv;
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            ((FileDownloader)it.getValue()).setTerminated(true);
            this.logger.d("DownloadManager terminated download " + ((FileDownloader)it.getValue()).getDownload());
            this.downloadManagerCoordinator.removeFileDownloader(((Number)it.getKey()).intValue());
        }
        this.currentDownloadsMap.clear();
        this.downloadCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.terminateAllDownloads();
            this.logger.d("DownloadManager closing download manager");
            this.executor.shutdown();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(int id) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = !this.isClosed() && this.downloadManagerCoordinator.containsFileDownloader(id);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAccommodateNewDownload() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = !this.closed && this.downloadCounter < this.concurrentLimit;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveDownloadCount() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            int n = this.downloadCounter;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> getDownloads() {
        Object object = this.lock;
        synchronized (object) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            this.throwExceptionIfClosed();
            Collection<FileDownloader> collection = this.currentDownloadsMap.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"currentDownloadsMap.values");
            Iterable iterable = $receiver$iv = (Iterable)collection;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                FileDownloader fileDownloader = (FileDownloader)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                Download download = it.getDownload();
                collection2.add(download);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    private final void throwExceptionIfClosed() {
        if (this.closed) {
            throw (Throwable)new FetchImplementationException("DownloadManager is already shutdown.", FetchException.Code.CLOSED);
        }
    }

    @Override
    @Nullable
    public FileDownloader getNewFileDownloaderForDownload(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Downloader.ServerRequest request = FetchUtils.getRequestForDownload$default(download, null, 2, null);
        return !FetchCoreUtils.isFetchFileServerUrl((String)request.getUrl()) ? this.getFileDownloader(request, download, this.httpDownloader) : (this.fileServerDownloader != null ? this.getFileDownloader(request, download, (Downloader)this.fileServerDownloader) : null);
    }

    private final FileDownloader getFileDownloader(Downloader.ServerRequest request, Download download, Downloader downloader) {
        FileDownloader fileDownloader;
        if (downloader.getFileDownloaderType(request) == Downloader.FileDownloaderType.SEQUENTIAL) {
            fileDownloader = new SequentialFileDownloaderImpl(download, downloader, this.progressReportingIntervalMillis, this.downloadBufferSizeBytes, this.logger, this.networkInfoProvider, this.retryOnNetworkGain, this.md5CheckingEnabled);
        } else {
            String string = downloader.getDirectoryForFileDownloaderTypeParallel(request);
            if (string == null) {
                string = this.fileTempDir;
            }
            String tempDir = string;
            fileDownloader = new ParallelFileDownloaderImpl(download, downloader, this.progressReportingIntervalMillis, this.downloadBufferSizeBytes, this.logger, this.networkInfoProvider, this.retryOnNetworkGain, tempDir, this.md5CheckingEnabled);
        }
        return fileDownloader;
    }

    @Override
    @NotNull
    public FileDownloader.Delegate getFileDownloaderDelegate() {
        return new FileDownloaderDelegate(this.downloadInfoUpdater, this.uiHandler, this.listenerCoordinator.getMainListener(), this.logger, this.retryOnNetworkGain, this.downloadBlockHandlerWrapper);
    }

    @Override
    @NotNull
    public String getDownloadFileTempDir(@NotNull Download download) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Downloader.ServerRequest request = FetchUtils.getRequestForDownload$default(download, null, 2, null);
        if (this.fileServerDownloader != null && FetchCoreUtils.isFetchFileServerUrl((String)request.getUrl())) {
            string = this.fileServerDownloader.getDirectoryForFileDownloaderTypeParallel(request);
            if (string == null) {
                string = this.fileTempDir;
            }
        } else {
            string = this.httpDownloader.getDirectoryForFileDownloaderTypeParallel(request);
            if (string == null) {
                string = this.fileTempDir;
            }
        }
        return string;
    }

    public DownloadManagerImpl(@NotNull Downloader httpDownloader, int concurrentLimit, long progressReportingIntervalMillis, int downloadBufferSizeBytes, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain, @NotNull Handler uiHandler, @NotNull DownloadInfoUpdater downloadInfoUpdater, @NotNull String fileTempDir, @NotNull DownloadManagerCoordinator downloadManagerCoordinator, @NotNull ListenerCoordinator listenerCoordinator, @Nullable FileServerDownloader fileServerDownloader, boolean md5CheckingEnabled, @NotNull HandlerWrapper downloadBlockHandlerWrapper) {
        Intrinsics.checkParameterIsNotNull((Object)httpDownloader, (String)"httpDownloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)uiHandler, (String)"uiHandler");
        Intrinsics.checkParameterIsNotNull((Object)downloadInfoUpdater, (String)"downloadInfoUpdater");
        Intrinsics.checkParameterIsNotNull((Object)fileTempDir, (String)"fileTempDir");
        Intrinsics.checkParameterIsNotNull((Object)downloadManagerCoordinator, (String)"downloadManagerCoordinator");
        Intrinsics.checkParameterIsNotNull((Object)listenerCoordinator, (String)"listenerCoordinator");
        Intrinsics.checkParameterIsNotNull((Object)downloadBlockHandlerWrapper, (String)"downloadBlockHandlerWrapper");
        this.httpDownloader = httpDownloader;
        this.concurrentLimit = concurrentLimit;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.downloadBufferSizeBytes = downloadBufferSizeBytes;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.uiHandler = uiHandler;
        this.downloadInfoUpdater = downloadInfoUpdater;
        this.fileTempDir = fileTempDir;
        this.downloadManagerCoordinator = downloadManagerCoordinator;
        this.listenerCoordinator = listenerCoordinator;
        this.fileServerDownloader = fileServerDownloader;
        this.md5CheckingEnabled = md5CheckingEnabled;
        this.downloadBlockHandlerWrapper = downloadBlockHandlerWrapper;
        this.lock = new Object();
        this.executor = Executors.newFixedThreadPool(this.concurrentLimit);
        DownloadManagerImpl downloadManagerImpl = this;
        HashMap hashMap = new HashMap();
        downloadManagerImpl.currentDownloadsMap = hashMap;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(DownloadManagerImpl $this) {
        return $this.logger;
    }

    @NotNull
    public static final /* synthetic */ Object access$getLock$p(DownloadManagerImpl $this) {
        return $this.lock;
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getCurrentDownloadsMap$p(DownloadManagerImpl $this) {
        return $this.currentDownloadsMap;
    }

    public static final /* synthetic */ int access$getDownloadCounter$p(DownloadManagerImpl $this) {
        return $this.downloadCounter;
    }

    public static final /* synthetic */ void access$setDownloadCounter$p(DownloadManagerImpl $this, int n) {
        $this.downloadCounter = n;
    }

    @NotNull
    public static final /* synthetic */ DownloadManagerCoordinator access$getDownloadManagerCoordinator$p(DownloadManagerImpl $this) {
        return $this.downloadManagerCoordinator;
    }
}

