/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.util;

import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\tJ\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\r\u0010\u0012\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0013J\r\u0010\u0014\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0015\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\u0003H\u0007J\u0012\u0010\u0017\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\u0003H\u0007J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/tonyodev/fetch2/util/AverageCalculator;", "", "discardLimit", "", "(I)V", "getDiscardLimit", "()I", "valueList", "Ljava/util/LinkedList;", "", "add", "", "value", "clear", "count", "getAverage", "getDenominator", "number", "getFirstInputValue", "()Ljava/lang/Double;", "getLastInputValue", "getMovingAverageWithWeightOnOlderValues", "inclusionCount", "getMovingAverageWithWeightOnRecentValues", "getValues", "", "hasInputValue", "", "fetch2_release"})
public final class AverageCalculator {
    private final LinkedList<Double> valueList;
    private final int discardLimit;

    public final void add(double value) {
        if (this.discardLimit > 0 && this.valueList.size() == this.discardLimit) {
            this.valueList.removeFirst();
        }
        this.valueList.addLast(value);
    }

    public final void clear() {
        this.valueList.clear();
    }

    public final int count() {
        return this.valueList.size();
    }

    @Nullable
    public final Double getLastInputValue() {
        return (Double)CollectionsKt.lastOrNull((List)this.valueList);
    }

    @Nullable
    public final Double getFirstInputValue() {
        return (Double)CollectionsKt.firstOrNull((List)this.valueList);
    }

    public final boolean hasInputValue(double value) {
        return this.valueList.contains(value);
    }

    @NotNull
    public final List<Double> getValues() {
        return CollectionsKt.toList((Iterable)this.valueList);
    }

    public final double getAverage() {
        int size = this.valueList.size();
        double total = CollectionsKt.sumOfDouble((Iterable)this.valueList);
        return total / (double)size;
    }

    @JvmOverloads
    public final double getMovingAverageWithWeightOnRecentValues(int inclusionCount) {
        if (inclusionCount < 1) {
            throw (Throwable)new IllegalArgumentException("inclusionCount cannot be less than 1.");
        }
        if (inclusionCount > this.valueList.size()) {
            throw (Throwable)new IllegalArgumentException("inclusionCount cannot be greater than the inserted value count.");
        }
        List values = CollectionsKt.reversed((Iterable)this.valueList).subList(0, inclusionCount);
        double movingAverage = 0.0;
        int weight = inclusionCount;
        double denominator = this.getDenominator(inclusionCount);
        Iterable $receiver$iv = values;
        for (Object element$iv : $receiver$iv) {
            double value = ((Number)element$iv).doubleValue();
            movingAverage += value * ((double)weight / denominator);
            weight += -1;
        }
        return movingAverage;
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ double getMovingAverageWithWeightOnRecentValues$default(AverageCalculator averageCalculator, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = averageCalculator.valueList.size();
        }
        return averageCalculator.getMovingAverageWithWeightOnRecentValues(n);
    }

    @JvmOverloads
    public final double getMovingAverageWithWeightOnRecentValues() {
        return AverageCalculator.getMovingAverageWithWeightOnRecentValues$default(this, 0, 1, null);
    }

    @JvmOverloads
    public final double getMovingAverageWithWeightOnOlderValues(int inclusionCount) {
        if (inclusionCount < 1) {
            throw (Throwable)new IllegalArgumentException("inclusionCount cannot be less than 1.");
        }
        if (inclusionCount > this.valueList.size()) {
            throw (Throwable)new IllegalArgumentException("inclusionCount cannot be greater than the inserted value count.");
        }
        List values = this.valueList.subList(0, inclusionCount);
        double movingAverage = 0.0;
        int weight = inclusionCount;
        double denominator = this.getDenominator(inclusionCount);
        List list = values;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"values");
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            Double value = (Double)element$iv;
            movingAverage += value * ((double)weight / denominator);
            weight += -1;
        }
        return movingAverage;
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ double getMovingAverageWithWeightOnOlderValues$default(AverageCalculator averageCalculator, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = averageCalculator.valueList.size();
        }
        return averageCalculator.getMovingAverageWithWeightOnOlderValues(n);
    }

    @JvmOverloads
    public final double getMovingAverageWithWeightOnOlderValues() {
        return AverageCalculator.getMovingAverageWithWeightOnOlderValues$default(this, 0, 1, null);
    }

    private final double getDenominator(int number) {
        int n = 1;
        return CollectionsKt.sumOfInt((Iterable)((Iterable)new IntRange(n, number)));
    }

    public final int getDiscardLimit() {
        return this.discardLimit;
    }

    @JvmOverloads
    public AverageCalculator(int discardLimit) {
        this.discardLimit = discardLimit;
        this.valueList = new LinkedList();
    }

    @JvmOverloads
    public /* synthetic */ AverageCalculator(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    @JvmOverloads
    public AverageCalculator() {
        this(0, 1, null);
    }
}

