/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.helper;

import android.os.Handler;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchListener;
import com.tonyodev.fetch2.Logger;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.util.FetchDefaults;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J \u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/tonyodev/fetch2/helper/DownloadInfoManagerDelegate;", "Lcom/tonyodev/fetch2/downloader/DownloadManager$Delegate;", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "uiHandler", "Landroid/os/Handler;", "fetchListener", "Lcom/tonyodev/fetch2/FetchListener;", "logger", "Lcom/tonyodev/fetch2/Logger;", "retryOnNetworkGain", "", "(Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;Landroid/os/Handler;Lcom/tonyodev/fetch2/FetchListener;Lcom/tonyodev/fetch2/Logger;Z)V", "onComplete", "", "download", "Lcom/tonyodev/fetch2/Download;", "onError", "onProgress", "etaInMilliSeconds", "", "downloadedBytesPerSecond", "onStarted", "etaInMilliseconds", "fetch2_release"})
public final class DownloadInfoManagerDelegate
implements DownloadManager.Delegate {
    private final DownloadInfoUpdater downloadInfoUpdater;
    private final Handler uiHandler;
    private final FetchListener fetchListener;
    private final Logger logger;
    private final boolean retryOnNetworkGain;

    @Override
    public void onStarted(@NotNull Download download, long etaInMilliseconds, long downloadedBytesPerSecond) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        DownloadInfo downloadInfo = (DownloadInfo)download;
        downloadInfo.setStatus(Status.DOWNLOADING);
        try {
            this.downloadInfoUpdater.update(downloadInfo);
            this.uiHandler.post(new Runnable(this, downloadInfo, etaInMilliseconds, downloadedBytesPerSecond){
                final /* synthetic */ DownloadInfoManagerDelegate this$0;
                final /* synthetic */ DownloadInfo $downloadInfo;
                final /* synthetic */ long $etaInMilliseconds;
                final /* synthetic */ long $downloadedBytesPerSecond;

                public final void run() {
                    DownloadInfoManagerDelegate.access$getFetchListener$p(this.this$0).onProgress(this.$downloadInfo, this.$etaInMilliseconds, this.$downloadedBytesPerSecond);
                }
                {
                    this.this$0 = downloadInfoManagerDelegate;
                    this.$downloadInfo = downloadInfo;
                    this.$etaInMilliseconds = l;
                    this.$downloadedBytesPerSecond = l2;
                }
            });
        }
        catch (Exception e) {
            this.logger.e("DownloadManagerDelegate", e);
        }
    }

    @Override
    public void onProgress(@NotNull Download download, long etaInMilliSeconds, long downloadedBytesPerSecond) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        try {
            DownloadInfo downloadInfo = (DownloadInfo)download;
            downloadInfo.setStatus(Status.DOWNLOADING);
            this.downloadInfoUpdater.updateFileBytesInfoAndStatusOnly(downloadInfo);
            this.uiHandler.post(new Runnable(this, download, etaInMilliSeconds, downloadedBytesPerSecond){
                final /* synthetic */ DownloadInfoManagerDelegate this$0;
                final /* synthetic */ Download $download;
                final /* synthetic */ long $etaInMilliSeconds;
                final /* synthetic */ long $downloadedBytesPerSecond;

                public final void run() {
                    DownloadInfoManagerDelegate.access$getFetchListener$p(this.this$0).onProgress(this.$download, this.$etaInMilliSeconds, this.$downloadedBytesPerSecond);
                }
                {
                    this.this$0 = downloadInfoManagerDelegate;
                    this.$download = download;
                    this.$etaInMilliSeconds = l;
                    this.$downloadedBytesPerSecond = l2;
                }
            });
        }
        catch (Exception e) {
            this.logger.e("DownloadManagerDelegate", e);
        }
    }

    @Override
    public void onError(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        DownloadInfo downloadInfo = (DownloadInfo)download;
        try {
            if (this.retryOnNetworkGain && Intrinsics.areEqual((Object)((Object)downloadInfo.getError()), (Object)((Object)Error.NO_NETWORK_CONNECTION))) {
                downloadInfo.setStatus(Status.QUEUED);
                downloadInfo.setError(FetchDefaults.getDefaultNoError());
                this.downloadInfoUpdater.update(downloadInfo);
                this.uiHandler.post(new Runnable(this, downloadInfo){
                    final /* synthetic */ DownloadInfoManagerDelegate this$0;
                    final /* synthetic */ DownloadInfo $downloadInfo;

                    public final void run() {
                        DownloadInfoManagerDelegate.access$getFetchListener$p(this.this$0).onQueued(this.$downloadInfo);
                    }
                    {
                        this.this$0 = downloadInfoManagerDelegate;
                        this.$downloadInfo = downloadInfo;
                    }
                });
            } else {
                downloadInfo.setStatus(Status.FAILED);
                this.downloadInfoUpdater.update(downloadInfo);
                this.uiHandler.post(new Runnable(this, downloadInfo){
                    final /* synthetic */ DownloadInfoManagerDelegate this$0;
                    final /* synthetic */ DownloadInfo $downloadInfo;

                    public final void run() {
                        DownloadInfoManagerDelegate.access$getFetchListener$p(this.this$0).onError(this.$downloadInfo);
                    }
                    {
                        this.this$0 = downloadInfoManagerDelegate;
                        this.$downloadInfo = downloadInfo;
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.e("DownloadManagerDelegate", e);
        }
    }

    @Override
    public void onComplete(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        DownloadInfo downloadInfo = (DownloadInfo)download;
        downloadInfo.setStatus(Status.COMPLETED);
        try {
            this.downloadInfoUpdater.update(downloadInfo);
            this.uiHandler.post(new Runnable(this, downloadInfo){
                final /* synthetic */ DownloadInfoManagerDelegate this$0;
                final /* synthetic */ DownloadInfo $downloadInfo;

                public final void run() {
                    DownloadInfoManagerDelegate.access$getFetchListener$p(this.this$0).onCompleted(this.$downloadInfo);
                }
                {
                    this.this$0 = downloadInfoManagerDelegate;
                    this.$downloadInfo = downloadInfo;
                }
            });
        }
        catch (Exception e) {
            this.logger.e("DownloadManagerDelegate", e);
        }
    }

    public DownloadInfoManagerDelegate(@NotNull DownloadInfoUpdater downloadInfoUpdater, @NotNull Handler uiHandler, @NotNull FetchListener fetchListener, @NotNull Logger logger, boolean retryOnNetworkGain) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfoUpdater, (String)"downloadInfoUpdater");
        Intrinsics.checkParameterIsNotNull((Object)uiHandler, (String)"uiHandler");
        Intrinsics.checkParameterIsNotNull((Object)fetchListener, (String)"fetchListener");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.downloadInfoUpdater = downloadInfoUpdater;
        this.uiHandler = uiHandler;
        this.fetchListener = fetchListener;
        this.logger = logger;
        this.retryOnNetworkGain = retryOnNetworkGain;
    }

    @NotNull
    public static final /* synthetic */ FetchListener access$getFetchListener$p(DownloadInfoManagerDelegate $this) {
        return $this.fetchListener;
    }
}

