/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.downloader;

import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Downloader;
import com.tonyodev.fetch2.Logger;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.downloader.FileDownloaderImpl;
import com.tonyodev.fetch2.exception.FetchException;
import com.tonyodev.fetch2.exception.FetchImplementationException;
import com.tonyodev.fetch2.provider.NetworkInfoProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010#\u001a\u00020\u000eH\u0016J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u0005H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020'H\u0016J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u0005H\u0016J\b\u0010+\u001a\u00020\u0005H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0016J\u0010\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020.H\u0016J\u0010\u00101\u001a\u00020\u000e2\u0006\u00100\u001a\u00020.H\u0016J\b\u00102\u001a\u00020'H\u0002R\u0012\u0010\u0010\u001a\u00020\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/tonyodev/fetch2/downloader/DownloadManagerImpl;", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "downloader", "Lcom/tonyodev/fetch2/Downloader;", "concurrentLimit", "", "progressReportingIntervalMillis", "", "downloadBufferSizeBytes", "logger", "Lcom/tonyodev/fetch2/Logger;", "networkInfoProvider", "Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;", "retryOnNetworkGain", "", "(Lcom/tonyodev/fetch2/Downloader;IJILcom/tonyodev/fetch2/Logger;Lcom/tonyodev/fetch2/provider/NetworkInfoProvider;Z)V", "closed", "currentDownloadsMap", "Ljava/util/HashMap;", "Lcom/tonyodev/fetch2/downloader/FileDownloader;", "Lkotlin/collections/HashMap;", "delegate", "Lcom/tonyodev/fetch2/downloader/DownloadManager$Delegate;", "getDelegate", "()Lcom/tonyodev/fetch2/downloader/DownloadManager$Delegate;", "setDelegate", "(Lcom/tonyodev/fetch2/downloader/DownloadManager$Delegate;)V", "downloadCounter", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "isClosed", "()Z", "lock", "Ljava/lang/Object;", "canAccommodateNewDownload", "cancel", "id", "cancelAll", "", "cancelAllDownloads", "close", "contains", "getActiveDownloadCount", "getDownloads", "", "Lcom/tonyodev/fetch2/Download;", "getNewFileDownloaderForDownload", "download", "start", "throwExceptionIfClosed", "fetch2_release"})
public final class DownloadManagerImpl
implements DownloadManager {
    private final Object lock;
    private final ExecutorService executor;
    private final HashMap<Integer, FileDownloader> currentDownloadsMap;
    @Nullable
    private DownloadManager.Delegate delegate;
    private volatile int downloadCounter;
    private volatile boolean closed;
    private final Downloader downloader;
    private final int concurrentLimit;
    private final long progressReportingIntervalMillis;
    private final int downloadBufferSizeBytes;
    private final Logger logger;
    private final NetworkInfoProvider networkInfoProvider;
    private final boolean retryOnNetworkGain;

    @Override
    @Nullable
    public DownloadManager.Delegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(@Nullable DownloadManager.Delegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            block8: {
                block7: {
                    this.throwExceptionIfClosed();
                    if (!this.currentDownloadsMap.containsKey(download.getId())) break block7;
                    this.logger.d("DownloadManager already running download " + download);
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.downloadCounter < this.concurrentLimit) break block8;
                this.logger.d("DownloadManager cannot init download " + download + " because " + "the download queue is full");
                boolean bl3 = false;
                return bl3;
            }
            FileDownloader fileDownloader = this.getNewFileDownloaderForDownload(download);
            fileDownloader.setDelegate(this.getDelegate());
            ++this.downloadCounter;
            Map map = this.currentDownloadsMap;
            Integer n = download.getId();
            FileDownloader fileDownloader2 = fileDownloader;
            map.put(n, fileDownloader2);
            try {
                this.executor.execute(new Runnable(fileDownloader, this, download){
                    final /* synthetic */ FileDownloader $fileDownloader;
                    final /* synthetic */ DownloadManagerImpl this$0;
                    final /* synthetic */ Download $download$inlined;
                    {
                        this.$fileDownloader = fileDownloader;
                        this.this$0 = downloadManagerImpl;
                        this.$download$inlined = download;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void run() {
                        DownloadManagerImpl.access$getLogger$p(this.this$0).d("DownloadManager starting download " + this.$download$inlined);
                        this.$fileDownloader.run();
                        Object object = DownloadManagerImpl.access$getLock$p(this.this$0);
                        synchronized (object) {
                            if (DownloadManagerImpl.access$getCurrentDownloadsMap$p(this.this$0).containsKey(this.$download$inlined.getId())) {
                                DownloadManagerImpl.access$getCurrentDownloadsMap$p(this.this$0).remove(this.$download$inlined.getId());
                                DownloadManagerImpl downloadManagerImpl = this.this$0;
                                DownloadManagerImpl.access$setDownloadCounter$p(downloadManagerImpl, DownloadManagerImpl.access$getDownloadCounter$p(downloadManagerImpl) - 1);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                });
                bl = true;
            }
            catch (Exception e) {
                this.logger.e("DownloadManager failed to start download " + download, e);
                bl = false;
            }
            boolean bl4 = bl;
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(int id) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            this.throwExceptionIfClosed();
            if (this.currentDownloadsMap.containsKey(id)) {
                FileDownloader fileDownloader = this.currentDownloadsMap.get(id);
                if (fileDownloader == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.tonyodev.fetch2.downloader.FileDownloader");
                }
                FileDownloader fileDownloader2 = fileDownloader;
                fileDownloader2.setInterrupted(true);
                while (!fileDownloader2.getTerminated()) {
                }
                this.currentDownloadsMap.remove(id);
                --this.downloadCounter;
                this.logger.d("DownloadManager cancelled download " + fileDownloader2.getDownload());
                bl = true;
            } else {
                bl = false;
            }
            boolean bl2 = bl;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            this.cancelAllDownloads();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void cancelAllDownloads() {
        Iterator iterator;
        Map map = this.currentDownloadsMap;
        Iterator $receiver$iv = map.entrySet().iterator();
        Iterator iterator2 = iterator = $receiver$iv;
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            ((FileDownloader)it.getValue()).setInterrupted(true);
            while (!((FileDownloader)it.getValue()).getTerminated()) {
            }
            this.logger.d("DownloadManager cancelled download " + ((FileDownloader)it.getValue()).getDownload());
        }
        this.currentDownloadsMap.clear();
        this.downloadCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.logger.d("DownloadManager closing download manager");
            this.cancelAllDownloads();
            this.executor.shutdown();
            this.downloader.close();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(int id) {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            boolean bl = this.currentDownloadsMap.containsKey(id);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAccommodateNewDownload() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            boolean bl = this.downloadCounter < this.concurrentLimit;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveDownloadCount() {
        Object object = this.lock;
        synchronized (object) {
            this.throwExceptionIfClosed();
            int n = this.downloadCounter;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> getDownloads() {
        Object object = this.lock;
        synchronized (object) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            this.throwExceptionIfClosed();
            Collection<FileDownloader> collection = this.currentDownloadsMap.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"currentDownloadsMap.values");
            Iterable iterable = $receiver$iv = (Iterable)collection;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                FileDownloader fileDownloader = (FileDownloader)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                Download download = it.getDownload();
                collection2.add(download);
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    private final void throwExceptionIfClosed() {
        if (this.closed) {
            throw (Throwable)new FetchImplementationException("DownloadManager is already shutdown.", FetchException.Code.CLOSED);
        }
    }

    @Override
    @NotNull
    public FileDownloader getNewFileDownloaderForDownload(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        return new FileDownloaderImpl(download, this.downloader, this.progressReportingIntervalMillis, this.downloadBufferSizeBytes, this.logger, this.networkInfoProvider, this.retryOnNetworkGain);
    }

    public DownloadManagerImpl(@NotNull Downloader downloader, int concurrentLimit, long progressReportingIntervalMillis, int downloadBufferSizeBytes, @NotNull Logger logger, @NotNull NetworkInfoProvider networkInfoProvider, boolean retryOnNetworkGain) {
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)networkInfoProvider, (String)"networkInfoProvider");
        this.downloader = downloader;
        this.concurrentLimit = concurrentLimit;
        this.progressReportingIntervalMillis = progressReportingIntervalMillis;
        this.downloadBufferSizeBytes = downloadBufferSizeBytes;
        this.logger = logger;
        this.networkInfoProvider = networkInfoProvider;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.lock = new Object();
        this.executor = Executors.newFixedThreadPool(this.concurrentLimit);
        DownloadManagerImpl downloadManagerImpl = this;
        HashMap hashMap = new HashMap();
        downloadManagerImpl.currentDownloadsMap = hashMap;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(DownloadManagerImpl $this) {
        return $this.logger;
    }

    @NotNull
    public static final /* synthetic */ Object access$getLock$p(DownloadManagerImpl $this) {
        return $this.lock;
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getCurrentDownloadsMap$p(DownloadManagerImpl $this) {
        return $this.currentDownloadsMap;
    }

    public static final /* synthetic */ int access$getDownloadCounter$p(DownloadManagerImpl $this) {
        return $this.downloadCounter;
    }

    public static final /* synthetic */ void access$setDownloadCounter$p(DownloadManagerImpl $this, int n) {
        $this.downloadCounter = n;
    }
}

