/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2;

import com.tonyodev.fetch2.Downloader;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0019B\u0013\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0004R\u0014\u0010\u0005\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader;", "Lcom/tonyodev/fetch2/Downloader;", "httpUrlConnectionPreferences", "Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;", "(Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;)V", "connectionPrefs", "getConnectionPrefs", "()Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;", "connections", "", "Lcom/tonyodev/fetch2/Downloader$Response;", "Ljava/net/HttpURLConnection;", "getConnections", "()Ljava/util/Map;", "close", "", "disconnect", "response", "execute", "request", "Lcom/tonyodev/fetch2/Downloader$Request;", "isResponseOk", "", "responseCode", "", "HttpUrlConnectionPreferences", "fetch2_release"})
public class HttpUrlConnectionDownloader
implements Downloader {
    @NotNull
    private final HttpUrlConnectionPreferences connectionPrefs;
    @NotNull
    private final Map<Downloader.Response, HttpURLConnection> connections;

    @NotNull
    protected final HttpUrlConnectionPreferences getConnectionPrefs() {
        return this.connectionPrefs;
    }

    @NotNull
    protected final Map<Downloader.Response, HttpURLConnection> getConnections() {
        return this.connections;
    }

    @Override
    @Nullable
    public Downloader.Response execute(@NotNull Downloader.Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        URL httpUrl = new URL(request.getUrl());
        URLConnection uRLConnection = httpUrl.openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection client = (HttpURLConnection)uRLConnection;
        client.setRequestMethod("GET");
        client.setReadTimeout(this.connectionPrefs.getReadTimeout());
        client.setConnectTimeout(this.connectionPrefs.getConnectTimeout());
        client.setUseCaches(this.connectionPrefs.getUsesCache());
        client.setDefaultUseCaches(this.connectionPrefs.getUsesDefaultCache());
        client.setInstanceFollowRedirects(this.connectionPrefs.getFollowsRedirect());
        client.setDoInput(true);
        Iterable $receiver$iv = request.getHeaders().entrySet();
        for (Object element$iv : $receiver$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            client.addRequestProperty((String)it.getKey(), (String)it.getValue());
        }
        client.connect();
        int code = client.getResponseCode();
        boolean success = false;
        long contentLength = -1L;
        InputStream byteStream = null;
        if (this.isResponseOk(code)) {
            long l;
            success = true;
            String string = client.getHeaderField("Content-Length");
            if (string != null) {
                String $i$f$forEach = string;
                l = Long.parseLong($i$f$forEach);
            } else {
                l = -1L;
            }
            contentLength = l;
            byteStream = client.getInputStream();
        }
        Downloader.Response response = new Downloader.Response(code, success, contentLength, byteStream);
        Map<Downloader.Response, HttpURLConnection> map = this.connections;
        HttpURLConnection httpURLConnection = client;
        map.put(response, httpURLConnection);
        return response;
    }

    protected final boolean isResponseOk(int responseCode) {
        int n = responseCode;
        return 200 <= n && 299 >= n;
    }

    @Override
    public void disconnect(@NotNull Downloader.Response response) {
        Map<Downloader.Response, HttpURLConnection> map;
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Map<Downloader.Response, HttpURLConnection> map2 = map = this.connections;
        if (map2.containsKey(response)) {
            HttpURLConnection httpURLConnection = this.connections.get(response);
            if (httpURLConnection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection client = httpURLConnection;
            this.connections.remove(response);
            client.disconnect();
        }
    }

    @Override
    public void close() {
        Iterable $receiver$iv = this.connections.entrySet();
        for (Object element$iv : $receiver$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            ((HttpURLConnection)it.getValue()).disconnect();
        }
        this.connections.clear();
    }

    @JvmOverloads
    public HttpUrlConnectionDownloader(@Nullable HttpUrlConnectionPreferences httpUrlConnectionPreferences) {
        HttpUrlConnectionPreferences httpUrlConnectionPreferences2 = httpUrlConnectionPreferences;
        if (httpUrlConnectionPreferences2 == null) {
            httpUrlConnectionPreferences2 = new HttpUrlConnectionPreferences();
        }
        this.connectionPrefs = httpUrlConnectionPreferences2;
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.synchronized\u2026se, HttpURLConnection>())");
        this.connections = map;
    }

    @JvmOverloads
    public /* synthetic */ HttpUrlConnectionDownloader(HttpUrlConnectionPreferences httpUrlConnectionPreferences, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            httpUrlConnectionPreferences = null;
        }
        this(httpUrlConnectionPreferences);
    }

    @JvmOverloads
    public HttpUrlConnectionDownloader() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/tonyodev/fetch2/HttpUrlConnectionDownloader$HttpUrlConnectionPreferences;", "", "()V", "connectTimeout", "", "getConnectTimeout", "()I", "setConnectTimeout", "(I)V", "followsRedirect", "", "getFollowsRedirect", "()Z", "setFollowsRedirect", "(Z)V", "readTimeout", "getReadTimeout", "setReadTimeout", "usesCache", "getUsesCache", "setUsesCache", "usesDefaultCache", "getUsesDefaultCache", "setUsesDefaultCache", "fetch2_release"})
    public static class HttpUrlConnectionPreferences {
        private int readTimeout = 20000;
        private int connectTimeout = 15000;
        private boolean usesCache;
        private boolean usesDefaultCache;
        private boolean followsRedirect = true;

        public final int getReadTimeout() {
            return this.readTimeout;
        }

        public final void setReadTimeout(int n) {
            this.readTimeout = n;
        }

        public final int getConnectTimeout() {
            return this.connectTimeout;
        }

        public final void setConnectTimeout(int n) {
            this.connectTimeout = n;
        }

        public final boolean getUsesCache() {
            return this.usesCache;
        }

        public final void setUsesCache(boolean bl) {
            this.usesCache = bl;
        }

        public final boolean getUsesDefaultCache() {
            return this.usesDefaultCache;
        }

        public final void setUsesDefaultCache(boolean bl) {
            this.usesDefaultCache = bl;
        }

        public final boolean getFollowsRedirect() {
            return this.followsRedirect;
        }

        public final void setFollowsRedirect(boolean bl) {
            this.followsRedirect = bl;
        }
    }
}

