/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.util;

import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DatabaseManager;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.util.FetchDatabaseExtensions$WhenMappings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u0007\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u0007\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u0007\u00a8\u0006\b"}, d2={"sanitize", "", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "downloadInfo", "Lcom/tonyodev/fetch2/database/DownloadInfo;", "initializing", "downloads", "", "fetch2_release"})
@JvmName(name="FetchDatabaseExtensions")
public final class FetchDatabaseExtensions {
    @JvmOverloads
    public static final boolean sanitize(@NotNull DatabaseManager $receiver, boolean initializing) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return FetchDatabaseExtensions.sanitize($receiver, $receiver.get(), initializing);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean sanitize$default(DatabaseManager databaseManager, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return FetchDatabaseExtensions.sanitize(databaseManager, bl);
    }

    @JvmOverloads
    public static final boolean sanitize(@NotNull DatabaseManager $receiver) {
        return FetchDatabaseExtensions.sanitize$default($receiver, false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public static final boolean sanitize(@NotNull DatabaseManager $receiver, @NotNull List<DownloadInfo> downloads, boolean initializing) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(downloads, (String)"downloads");
        List changedDownloadsList = new ArrayList();
        int n = 0;
        int n2 = downloads.size();
        while (n < n2) {
            void i;
            DownloadInfo downloadInfo = downloads.get((int)i);
            File file = new File(downloadInfo.getFile());
            long fileLength = file.length();
            boolean fileExist = file.exists();
            switch (FetchDatabaseExtensions$WhenMappings.$EnumSwitchMapping$0[downloadInfo.getStatus().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    if (!fileExist && Intrinsics.areEqual((Object)((Object)downloadInfo.getStatus()), (Object)((Object)Status.QUEUED)) ^ true) {
                        downloadInfo.setStatus(Status.FAILED);
                        downloadInfo.setError(Error.FILE_NOT_FOUND);
                        downloadInfo.setDownloaded(0L);
                        downloadInfo.setTotal(-1L);
                        changedDownloadsList.add(downloadInfo);
                        break;
                    }
                    boolean update = false;
                    if (downloadInfo.getDownloaded() != fileLength) {
                        downloadInfo.setDownloaded(fileLength);
                        update = true;
                    }
                    if (Intrinsics.areEqual((Object)((Object)downloadInfo.getStatus()), (Object)((Object)Status.COMPLETED)) && downloadInfo.getTotal() < 1L && downloadInfo.getDownloaded() > 0L) {
                        downloadInfo.setTotal(downloadInfo.getDownloaded());
                        update = true;
                    }
                    if (!update) break;
                    changedDownloadsList.add(downloadInfo);
                    break;
                }
                case 7: {
                    if (!initializing) break;
                    downloadInfo.setStatus(Status.QUEUED);
                    if (fileExist) {
                        downloadInfo.setDownloaded(fileLength);
                    }
                    changedDownloadsList.add(downloadInfo);
                }
            }
            ++i;
        }
        if (changedDownloadsList.size() > 0) {
            try {
                $receiver.updateNoLock(changedDownloadsList);
            }
            catch (Exception e) {
                $receiver.getLogger().e("Database sanitize update error", e);
            }
        }
        return changedDownloadsList.size() > 0;
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean sanitize$default(DatabaseManager databaseManager, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return FetchDatabaseExtensions.sanitize(databaseManager, list, bl);
    }

    @JvmOverloads
    public static final boolean sanitize(@NotNull DatabaseManager $receiver, @NotNull List<DownloadInfo> downloads) {
        return FetchDatabaseExtensions.sanitize$default($receiver, downloads, false, 2, null);
    }

    @JvmOverloads
    public static final boolean sanitize(@NotNull DatabaseManager $receiver, @Nullable DownloadInfo downloadInfo, boolean initializing) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return downloadInfo == null ? false : FetchDatabaseExtensions.sanitize($receiver, CollectionsKt.listOf((Object)downloadInfo), initializing);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean sanitize$default(DatabaseManager databaseManager, DownloadInfo downloadInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return FetchDatabaseExtensions.sanitize(databaseManager, downloadInfo, bl);
    }

    @JvmOverloads
    public static final boolean sanitize(@NotNull DatabaseManager $receiver, @Nullable DownloadInfo downloadInfo) {
        return FetchDatabaseExtensions.sanitize$default($receiver, downloadInfo, false, 2, null);
    }
}

