/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.helper;

import android.os.Handler;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.Error;
import com.tonyodev.fetch2.FetchListener;
import com.tonyodev.fetch2.Logger;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.FileDownloader;
import com.tonyodev.fetch2.helper.DownloadInfoUpdater;
import com.tonyodev.fetch2.helper.DownloadReportingRunnable;
import com.tonyodev.fetch2.helper.FileDownloaderDelegate;
import com.tonyodev.fetch2.util.FetchDefaults;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004*\u0001\u000e\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J \u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/tonyodev/fetch2/helper/FileDownloaderDelegate;", "Lcom/tonyodev/fetch2/downloader/FileDownloader$Delegate;", "downloadInfoUpdater", "Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;", "uiHandler", "Landroid/os/Handler;", "fetchListener", "Lcom/tonyodev/fetch2/FetchListener;", "logger", "Lcom/tonyodev/fetch2/Logger;", "retryOnNetworkGain", "", "(Lcom/tonyodev/fetch2/helper/DownloadInfoUpdater;Landroid/os/Handler;Lcom/tonyodev/fetch2/FetchListener;Lcom/tonyodev/fetch2/Logger;Z)V", "progressRunnable", "com/tonyodev/fetch2/helper/FileDownloaderDelegate$progressRunnable$1", "Lcom/tonyodev/fetch2/helper/FileDownloaderDelegate$progressRunnable$1;", "onComplete", "", "download", "Lcom/tonyodev/fetch2/Download;", "onError", "onProgress", "etaInMilliSeconds", "", "downloadedBytesPerSecond", "onStarted", "etaInMilliseconds", "fetch2_release"})
public final class FileDownloaderDelegate
implements FileDownloader.Delegate {
    private final progressRunnable.1 progressRunnable;
    private final DownloadInfoUpdater downloadInfoUpdater;
    private final Handler uiHandler;
    private final FetchListener fetchListener;
    private final Logger logger;
    private final boolean retryOnNetworkGain;

    @Override
    public void onStarted(@NotNull Download download, long etaInMilliseconds, long downloadedBytesPerSecond) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        DownloadInfo downloadInfo = (DownloadInfo)download;
        downloadInfo.setStatus(Status.DOWNLOADING);
        try {
            this.downloadInfoUpdater.update(downloadInfo);
            this.uiHandler.post(new Runnable(this, downloadInfo, etaInMilliseconds, downloadedBytesPerSecond){
                final /* synthetic */ FileDownloaderDelegate this$0;
                final /* synthetic */ DownloadInfo $downloadInfo;
                final /* synthetic */ long $etaInMilliseconds;
                final /* synthetic */ long $downloadedBytesPerSecond;

                public final void run() {
                    FileDownloaderDelegate.access$getFetchListener$p(this.this$0).onProgress(this.$downloadInfo, this.$etaInMilliseconds, this.$downloadedBytesPerSecond);
                }
                {
                    this.this$0 = fileDownloaderDelegate;
                    this.$downloadInfo = downloadInfo;
                    this.$etaInMilliseconds = l;
                    this.$downloadedBytesPerSecond = l2;
                }
            });
        }
        catch (Exception e) {
            this.logger.e("DownloadManagerDelegate", e);
        }
    }

    @Override
    public void onProgress(@NotNull Download download, long etaInMilliSeconds, long downloadedBytesPerSecond) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        try {
            DownloadInfo downloadInfo = (DownloadInfo)download;
            downloadInfo.setStatus(Status.DOWNLOADING);
            this.downloadInfoUpdater.updateFileBytesInfoAndStatusOnly(downloadInfo);
            this.progressRunnable.setDownload(download);
            this.progressRunnable.setEtaInMilliSeconds(etaInMilliSeconds);
            this.progressRunnable.setDownloadedBytesPerSecond(downloadedBytesPerSecond);
            this.uiHandler.post((Runnable)this.progressRunnable);
        }
        catch (Exception e) {
            this.logger.e("DownloadManagerDelegate", e);
        }
    }

    @Override
    public void onError(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        DownloadInfo downloadInfo = (DownloadInfo)download;
        try {
            if (this.retryOnNetworkGain && Intrinsics.areEqual((Object)((Object)downloadInfo.getError()), (Object)((Object)Error.NO_NETWORK_CONNECTION))) {
                downloadInfo.setStatus(Status.QUEUED);
                downloadInfo.setError(FetchDefaults.getDefaultNoError());
                this.downloadInfoUpdater.update(downloadInfo);
                this.uiHandler.post(new Runnable(this, downloadInfo){
                    final /* synthetic */ FileDownloaderDelegate this$0;
                    final /* synthetic */ DownloadInfo $downloadInfo;

                    public final void run() {
                        FileDownloaderDelegate.access$getFetchListener$p(this.this$0).onQueued(this.$downloadInfo);
                    }
                    {
                        this.this$0 = fileDownloaderDelegate;
                        this.$downloadInfo = downloadInfo;
                    }
                });
            } else {
                downloadInfo.setStatus(Status.FAILED);
                this.downloadInfoUpdater.update(downloadInfo);
                this.uiHandler.post(new Runnable(this, downloadInfo){
                    final /* synthetic */ FileDownloaderDelegate this$0;
                    final /* synthetic */ DownloadInfo $downloadInfo;

                    public final void run() {
                        FileDownloaderDelegate.access$getFetchListener$p(this.this$0).onError(this.$downloadInfo);
                    }
                    {
                        this.this$0 = fileDownloaderDelegate;
                        this.$downloadInfo = downloadInfo;
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.e("DownloadManagerDelegate", e);
        }
    }

    @Override
    public void onComplete(@NotNull Download download) {
        Intrinsics.checkParameterIsNotNull((Object)download, (String)"download");
        DownloadInfo downloadInfo = (DownloadInfo)download;
        downloadInfo.setStatus(Status.COMPLETED);
        try {
            this.downloadInfoUpdater.update(downloadInfo);
            this.uiHandler.post(new Runnable(this, downloadInfo){
                final /* synthetic */ FileDownloaderDelegate this$0;
                final /* synthetic */ DownloadInfo $downloadInfo;

                public final void run() {
                    FileDownloaderDelegate.access$getFetchListener$p(this.this$0).onCompleted(this.$downloadInfo);
                }
                {
                    this.this$0 = fileDownloaderDelegate;
                    this.$downloadInfo = downloadInfo;
                }
            });
        }
        catch (Exception e) {
            this.logger.e("DownloadManagerDelegate", e);
        }
    }

    public FileDownloaderDelegate(@NotNull DownloadInfoUpdater downloadInfoUpdater, @NotNull Handler uiHandler, @NotNull FetchListener fetchListener, @NotNull Logger logger, boolean retryOnNetworkGain) {
        Intrinsics.checkParameterIsNotNull((Object)downloadInfoUpdater, (String)"downloadInfoUpdater");
        Intrinsics.checkParameterIsNotNull((Object)uiHandler, (String)"uiHandler");
        Intrinsics.checkParameterIsNotNull((Object)fetchListener, (String)"fetchListener");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.downloadInfoUpdater = downloadInfoUpdater;
        this.uiHandler = uiHandler;
        this.fetchListener = fetchListener;
        this.logger = logger;
        this.retryOnNetworkGain = retryOnNetworkGain;
        this.progressRunnable = new DownloadReportingRunnable(this){
            final /* synthetic */ FileDownloaderDelegate this$0;

            public void run() {
                FileDownloaderDelegate.access$getFetchListener$p(this.this$0).onProgress(this.getDownload(), this.getEtaInMilliSeconds(), this.getDownloadedBytesPerSecond());
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ FetchListener access$getFetchListener$p(FileDownloaderDelegate $this) {
        return $this.fetchListener;
    }
}

