/*
 * Decompiled with CFR 0.152.
 */
package com.tonyodev.fetch2.fetch;

import android.os.Build;
import android.os.Handler;
import com.tonyodev.fetch2.Download;
import com.tonyodev.fetch2.FetchListener;
import com.tonyodev.fetch2.Logger;
import com.tonyodev.fetch2.NetworkType;
import com.tonyodev.fetch2.Request;
import com.tonyodev.fetch2.RequestInfo;
import com.tonyodev.fetch2.Status;
import com.tonyodev.fetch2.database.DatabaseManager;
import com.tonyodev.fetch2.database.DownloadInfo;
import com.tonyodev.fetch2.downloader.DownloadManager;
import com.tonyodev.fetch2.fetch.FetchHandler;
import com.tonyodev.fetch2.fetch.FetchModulesBuilder;
import com.tonyodev.fetch2.helper.PriorityListProcessor;
import com.tonyodev.fetch2.provider.ListenerProvider;
import com.tonyodev.fetch2.util.FetchDatabaseExtensions;
import com.tonyodev.fetch2.util.FetchDefaults;
import com.tonyodev.fetch2.util.FetchTypeConverterExtensions;
import com.tonyodev.fetch2.util.FetchUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\u0018H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010(\u001a\u00020)H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0012H\u0016J\u0010\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020/H\u0016J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\f\u00100\u001a\b\u0012\u0004\u0012\u00020/0\u001cH\u0016J\b\u00101\u001a\u00020\u0018H\u0016J\u0012\u00102\u001a\u0004\u0018\u00010\n2\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0016J\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\"0\u001cH\u0016J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u001e\u00106\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u00107\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0016J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010(\u001a\u00020)H\u0016J\b\u00109\u001a\u00020\u0018H\u0016J\u0010\u0010:\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\n0\u001cH\u0016J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010(\u001a\u00020)H\u0016J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010A\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010E\u001a\u00020\u00182\u0006\u0010F\u001a\u00020GH\u0016J\b\u0010H\u001a\u00020\u0018H\u0002J\b\u0010I\u001a\u00020\u0018H\u0016J\u001a\u0010J\u001a\u0004\u0018\u00010\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010K\u001a\u00020LH\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/tonyodev/fetch2/fetch/FetchHandlerImpl;", "Lcom/tonyodev/fetch2/fetch/FetchHandler;", "namespace", "", "databaseManager", "Lcom/tonyodev/fetch2/database/DatabaseManager;", "downloadManager", "Lcom/tonyodev/fetch2/downloader/DownloadManager;", "priorityListProcessor", "Lcom/tonyodev/fetch2/helper/PriorityListProcessor;", "Lcom/tonyodev/fetch2/Download;", "fetchListenerProvider", "Lcom/tonyodev/fetch2/provider/ListenerProvider;", "handler", "Landroid/os/Handler;", "logger", "Lcom/tonyodev/fetch2/Logger;", "autoStart", "", "(Ljava/lang/String;Lcom/tonyodev/fetch2/database/DatabaseManager;Lcom/tonyodev/fetch2/downloader/DownloadManager;Lcom/tonyodev/fetch2/helper/PriorityListProcessor;Lcom/tonyodev/fetch2/provider/ListenerProvider;Landroid/os/Handler;Lcom/tonyodev/fetch2/Logger;Z)V", "getFetchListenerProvider", "()Lcom/tonyodev/fetch2/provider/ListenerProvider;", "isTerminating", "addListener", "", "listener", "Lcom/tonyodev/fetch2/FetchListener;", "cancel", "", "ids", "", "cancelAll", "cancelDownload", "id", "", "cancelGroup", "close", "delete", "deleteAll", "deleteAllWithStatus", "status", "Lcom/tonyodev/fetch2/Status;", "deleteGroup", "enableLogging", "enabled", "enqueue", "request", "Lcom/tonyodev/fetch2/Request;", "requests", "freeze", "getDownload", "getDownloads", "idList", "getDownloadsInGroup", "getDownloadsInGroupWithStatus", "groupId", "getDownloadsWithStatus", "init", "isDownloading", "pause", "pausedGroup", "remove", "removeAll", "removeAllWithStatus", "removeGroup", "removeListener", "resume", "resumeGroup", "retry", "setGlobalNetworkType", "networkType", "Lcom/tonyodev/fetch2/NetworkType;", "startPriorityQueueIfNotStarted", "unfreeze", "updateRequest", "requestInfo", "Lcom/tonyodev/fetch2/RequestInfo;", "fetch2_release"})
public final class FetchHandlerImpl
implements FetchHandler {
    private volatile boolean isTerminating;
    private final String namespace;
    private final DatabaseManager databaseManager;
    private final DownloadManager downloadManager;
    private final PriorityListProcessor<Download> priorityListProcessor;
    @NotNull
    private final ListenerProvider fetchListenerProvider;
    private final Handler handler;
    private final Logger logger;
    private final boolean autoStart;

    @Override
    public void init() {
        FetchDatabaseExtensions.sanitize(this.databaseManager, true);
        if (this.autoStart) {
            this.priorityListProcessor.start();
        }
    }

    @Override
    @NotNull
    public Download enqueue(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        this.startPriorityQueueIfNotStarted();
        DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo(request);
        downloadInfo.setNamespace(this.namespace);
        downloadInfo.setStatus(Status.QUEUED);
        this.databaseManager.insert(downloadInfo);
        return downloadInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Download> enqueue(@NotNull List<? extends Request> requests) {
        Pair it;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(requests, (String)"requests");
        this.startPriorityQueueIfNotStarted();
        Iterable iterable = $receiver$iv = (Iterable)requests;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Request request = (Request)item$iv$iv;
            Collection collection = destination$iv$iv;
            DownloadInfo downloadInfo = FetchTypeConverterExtensions.toDownloadInfo((Request)it);
            downloadInfo.setNamespace(this.namespace);
            downloadInfo.setStatus(Status.QUEUED);
            DownloadInfo downloadInfo2 = downloadInfo;
            collection.add(downloadInfo2);
        }
        List downloadInfoList = (List)destination$iv$iv;
        List results = new ArrayList();
        List<Pair<DownloadInfo, Boolean>> insertedList = this.databaseManager.insert(downloadInfoList);
        Iterable $receiver$iv2 = insertedList;
        for (Object element$iv : $receiver$iv2) {
            it = (Pair)element$iv;
            if (!((Boolean)it.getSecond()).booleanValue()) continue;
            this.logger.d("Enqueued download " + (DownloadInfo)it.getFirst());
            results.add(it.getFirst());
        }
        return results;
    }

    @Override
    @NotNull
    public List<Download> pause(@NotNull int[] ids) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.startPriorityQueueIfNotStarted();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadsInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        Iterable $receiver$iv = downloadsInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canPauseDownload(it)) continue;
            it.setStatus(Status.PAUSED);
        }
        try {
            this.databaseManager.update(downloadsInfoList);
            list = downloadsInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> pausedGroup(int id) {
        List list;
        DownloadInfo it;
        this.startPriorityQueueIfNotStarted();
        List downloadInfoList = this.databaseManager.getByGroup(id);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.cancelDownload(it.getId());
        }
        downloadInfoList = this.databaseManager.getByGroup(id);
        $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!FetchUtils.canPauseDownload(it)) continue;
            it.setStatus(Status.PAUSED);
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public void freeze() {
        this.startPriorityQueueIfNotStarted();
        this.priorityListProcessor.pause();
        this.downloadManager.cancelAll();
        FetchDatabaseExtensions.sanitize(this.databaseManager, true);
    }

    @Override
    public void unfreeze() {
        this.startPriorityQueueIfNotStarted();
        FetchDatabaseExtensions.sanitize(this.databaseManager, true);
        this.priorityListProcessor.resume();
    }

    @Override
    @NotNull
    public List<Download> resume(@NotNull int[] ids) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.startPriorityQueueIfNotStarted();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadsInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        Iterable $receiver$iv = downloadsInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (this.isDownloading(it.getId()) || !FetchUtils.canResumeDownload(it)) continue;
            it.setStatus(Status.QUEUED);
        }
        try {
            this.databaseManager.update(downloadsInfoList);
            list = downloadsInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> resumeGroup(int id) {
        List list;
        Iterator $receiver$iv$iv;
        this.startPriorityQueueIfNotStarted();
        Iterable $receiver$iv = this.databaseManager.getByGroup(id);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            DownloadInfo it = (DownloadInfo)element$iv$iv;
            if (!(!this.isDownloading(it.getId()) && FetchUtils.canResumeDownload(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List downloadsInfoList = (List)destination$iv$iv;
        $receiver$iv = downloadsInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(Status.QUEUED);
        }
        try {
            this.databaseManager.update(downloadsInfoList);
            list = downloadsInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> remove(@NotNull int[] ids) {
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.startPriorityQueueIfNotStarted();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadsList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        this.databaseManager.delete(downloadsList);
        Status removedStatus = Status.REMOVED;
        Iterable $receiver$iv = downloadsList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(removedStatus);
        }
        return downloadsList;
    }

    @Override
    @NotNull
    public List<Download> removeGroup(int id) {
        this.startPriorityQueueIfNotStarted();
        List<Download> downloadInfoList = this.databaseManager.getByGroup(id);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.cancelDownload(it.getId());
        }
        this.databaseManager.delete(downloadInfoList);
        Status removedStatus = Status.REMOVED;
        Iterable $receiver$iv2 = downloadInfoList;
        for (Object element$iv : $receiver$iv2) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(removedStatus);
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> removeAll() {
        this.startPriorityQueueIfNotStarted();
        this.downloadManager.cancelAll();
        List<Download> downloadInfoList = this.databaseManager.get();
        this.databaseManager.deleteAll();
        Status removedStatus = Status.REMOVED;
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(removedStatus);
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> removeAllWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        this.startPriorityQueueIfNotStarted();
        List<Download> downloadInfoList = this.databaseManager.getByStatus(status);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.cancelDownload(it.getId());
        }
        this.databaseManager.delete(downloadInfoList);
        Status removedStatus = Status.REMOVED;
        Iterable $receiver$iv2 = downloadInfoList;
        for (Object element$iv : $receiver$iv2) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(removedStatus);
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> delete(@NotNull int[] ids) {
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.startPriorityQueueIfNotStarted();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadsList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        this.databaseManager.delete(downloadsList);
        Status deletedStatus = Status.DELETED;
        Iterable $receiver$iv = downloadsList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(deletedStatus);
            try {
                File file = new File(it.getFile());
                if (!file.exists()) continue;
                file.delete();
            }
            catch (Exception e) {
                this.logger.d("Failed to delete file " + it.getFile(), e);
            }
        }
        return downloadsList;
    }

    @Override
    @NotNull
    public List<Download> deleteGroup(int id) {
        this.startPriorityQueueIfNotStarted();
        List<Download> downloadInfoList = this.databaseManager.getByGroup(id);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.cancelDownload(it.getId());
        }
        this.databaseManager.delete(downloadInfoList);
        Status deletedStatus = Status.DELETED;
        Iterable $receiver$iv2 = downloadInfoList;
        for (Object element$iv : $receiver$iv2) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(deletedStatus);
            try {
                File file = new File(it.getFile());
                if (!file.exists()) continue;
                file.delete();
            }
            catch (Exception e) {
                this.logger.d("Failed to delete file " + it.getFile(), e);
            }
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> deleteAll() {
        this.startPriorityQueueIfNotStarted();
        this.downloadManager.cancelAll();
        List<Download> downloadInfoList = this.databaseManager.get();
        this.databaseManager.deleteAll();
        Status deletedStatus = Status.DELETED;
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(deletedStatus);
            try {
                File file = new File(it.getFile());
                if (!file.exists()) continue;
                file.delete();
            }
            catch (Exception e) {
                this.logger.d("Failed to delete file " + it.getFile(), e);
            }
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> deleteAllWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        this.startPriorityQueueIfNotStarted();
        List<Download> downloadInfoList = this.databaseManager.getByStatus(status);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.cancelDownload(it.getId());
        }
        this.databaseManager.delete(downloadInfoList);
        Status deletedStatus = Status.DELETED;
        Iterable $receiver$iv2 = downloadInfoList;
        for (Object element$iv : $receiver$iv2) {
            DownloadInfo it = (DownloadInfo)element$iv;
            it.setStatus(deletedStatus);
            try {
                File file = new File(it.getFile());
                if (!file.exists()) continue;
                file.delete();
            }
            catch (Exception e) {
                this.logger.d("Failed to delete file " + it.getFile(), e);
            }
        }
        return downloadInfoList;
    }

    @Override
    @NotNull
    public List<Download> cancel(@NotNull int[] ids) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.startPriorityQueueIfNotStarted();
        for (int element$iv : ids) {
            int it = element$iv;
            if (!this.isDownloading(it)) continue;
            this.cancelDownload(it);
        }
        List downloadInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canCancelDownload(it)) continue;
            it.setStatus(Status.CANCELLED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> cancelGroup(int id) {
        List list;
        DownloadInfo it;
        this.startPriorityQueueIfNotStarted();
        List downloadInfoList = this.databaseManager.getByGroup(id);
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.downloadManager.cancel(it.getId());
        }
        downloadInfoList = this.databaseManager.getByGroup(id);
        $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!FetchUtils.canCancelDownload(it)) continue;
            it.setStatus(Status.CANCELLED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> cancelAll() {
        List list;
        DownloadInfo it;
        this.startPriorityQueueIfNotStarted();
        List downloadInfoList = this.databaseManager.get();
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!this.isDownloading(it.getId())) continue;
            this.downloadManager.cancel(it.getId());
        }
        downloadInfoList = this.databaseManager.get();
        $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            it = (DownloadInfo)element$iv;
            if (!FetchUtils.canCancelDownload(it)) continue;
            it.setStatus(Status.CANCELLED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Download> retry(@NotNull int[] ids) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)ids, (String)"ids");
        this.startPriorityQueueIfNotStarted();
        List downloadInfoList = CollectionsKt.filterNotNull((Iterable)this.databaseManager.get(ArraysKt.toList((int[])ids)));
        Iterable $receiver$iv = downloadInfoList;
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            if (!FetchUtils.canRetryDownload(it)) continue;
            it.setStatus(Status.QUEUED);
            it.setError(FetchDefaults.getDefaultNoError());
        }
        try {
            this.databaseManager.update(downloadInfoList);
            list = downloadInfoList;
        }
        catch (Exception e) {
            this.logger.e("Fetch data base error", e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public Download updateRequest(int id, @NotNull RequestInfo requestInfo) {
        Intrinsics.checkParameterIsNotNull((Object)requestInfo, (String)"requestInfo");
        this.startPriorityQueueIfNotStarted();
        DownloadInfo downloadInfo = this.databaseManager.get(id);
        if (downloadInfo != null) {
            if (this.isDownloading(id)) {
                this.cancelDownload(id);
            }
            if ((downloadInfo = this.databaseManager.get(id)) != null) {
                downloadInfo.setGroup(requestInfo.getGroupId());
                downloadInfo.setHeaders(requestInfo.getHeaders());
                downloadInfo.setPriority(requestInfo.getPriority());
                downloadInfo.setNetworkType(requestInfo.getNetworkType());
                this.databaseManager.update(downloadInfo);
                return downloadInfo;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<Download> getDownloads() {
        this.startPriorityQueueIfNotStarted();
        return this.databaseManager.get();
    }

    @Override
    @Nullable
    public Download getDownload(int id) {
        this.startPriorityQueueIfNotStarted();
        return this.databaseManager.get(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloads(@NotNull List<Integer> idList) {
        Intrinsics.checkParameterIsNotNull(idList, (String)"idList");
        this.startPriorityQueueIfNotStarted();
        List<DownloadInfo> downloads = this.databaseManager.get(idList);
        List results = new ArrayList();
        Iterable $receiver$iv = CollectionsKt.filterNotNull((Iterable)downloads);
        for (Object element$iv : $receiver$iv) {
            DownloadInfo it = (DownloadInfo)element$iv;
            results.add(it);
        }
        return results;
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroup(int id) {
        this.startPriorityQueueIfNotStarted();
        return this.databaseManager.getByGroup(id);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsWithStatus(@NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        this.startPriorityQueueIfNotStarted();
        return this.databaseManager.getByStatus(status);
    }

    @Override
    @NotNull
    public List<Download> getDownloadsInGroupWithStatus(int groupId, @NotNull Status status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        this.startPriorityQueueIfNotStarted();
        return this.databaseManager.getDownloadsInGroupWithStatus(groupId, status);
    }

    @Override
    public void close() {
        if (this.isTerminating) {
            return;
        }
        this.isTerminating = true;
        this.getFetchListenerProvider().getListeners().clear();
        this.priorityListProcessor.stop();
        this.downloadManager.terminateAllDownloads();
        this.handler.post(new Runnable(this){
            final /* synthetic */ FetchHandlerImpl this$0;

            public final void run() {
                try {
                    FetchHandlerImpl.access$getDownloadManager$p(this.this$0).close();
                    FetchHandlerImpl.access$getDatabaseManager$p(this.this$0).close();
                    if (Build.VERSION.SDK_INT >= 18) {
                        FetchHandlerImpl.access$getHandler$p(this.this$0).getLooper().quitSafely();
                    } else {
                        FetchHandlerImpl.access$getHandler$p(this.this$0).getLooper().quit();
                    }
                }
                catch (Exception e) {
                    FetchHandlerImpl.access$getLogger$p(this.this$0).e("FetchHandler", e);
                }
            }
            {
                this.this$0 = fetchHandlerImpl;
            }
        });
        FetchModulesBuilder.INSTANCE.removeActiveFetchHandlerNamespaceInstance(this.namespace);
    }

    @Override
    public void setGlobalNetworkType(@NotNull NetworkType networkType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)networkType), (String)"networkType");
        this.startPriorityQueueIfNotStarted();
        this.priorityListProcessor.setGlobalNetworkType(networkType);
        this.downloadManager.cancelAll();
        FetchDatabaseExtensions.sanitize(this.databaseManager, true);
    }

    @Override
    public void enableLogging(boolean enabled) {
        this.startPriorityQueueIfNotStarted();
        this.logger.d("Enable logging - " + enabled);
        this.logger.setEnabled(enabled);
    }

    @Override
    public void addListener(@NotNull FetchListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.startPriorityQueueIfNotStarted();
        this.getFetchListenerProvider().getListeners().add(listener);
        this.logger.d("Added listener " + listener);
    }

    @Override
    public void removeListener(@NotNull FetchListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.startPriorityQueueIfNotStarted();
        Iterator<FetchListener> iterator = this.getFetchListenerProvider().getListeners().iterator();
        while (iterator.hasNext()) {
            if (!Intrinsics.areEqual((Object)iterator.next(), (Object)listener)) continue;
            this.logger.d("Removed listener " + listener);
            iterator.remove();
            break;
        }
    }

    @Override
    public boolean isDownloading(int id) {
        this.startPriorityQueueIfNotStarted();
        return this.downloadManager.contains(id);
    }

    @Override
    public boolean cancelDownload(int id) {
        this.startPriorityQueueIfNotStarted();
        return this.downloadManager.cancel(id);
    }

    private final void startPriorityQueueIfNotStarted() {
        if (this.priorityListProcessor.isStopped() && !this.isTerminating) {
            this.priorityListProcessor.start();
        }
        if (this.priorityListProcessor.isPaused() && !this.isTerminating) {
            this.priorityListProcessor.resume();
        }
    }

    @Override
    @NotNull
    public ListenerProvider getFetchListenerProvider() {
        return this.fetchListenerProvider;
    }

    public FetchHandlerImpl(@NotNull String namespace, @NotNull DatabaseManager databaseManager, @NotNull DownloadManager downloadManager, @NotNull PriorityListProcessor<? extends Download> priorityListProcessor, @NotNull ListenerProvider fetchListenerProvider, @NotNull Handler handler, @NotNull Logger logger, boolean autoStart) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)databaseManager, (String)"databaseManager");
        Intrinsics.checkParameterIsNotNull((Object)downloadManager, (String)"downloadManager");
        Intrinsics.checkParameterIsNotNull(priorityListProcessor, (String)"priorityListProcessor");
        Intrinsics.checkParameterIsNotNull((Object)fetchListenerProvider, (String)"fetchListenerProvider");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.namespace = namespace;
        this.databaseManager = databaseManager;
        this.downloadManager = downloadManager;
        this.priorityListProcessor = priorityListProcessor;
        this.fetchListenerProvider = fetchListenerProvider;
        this.handler = handler;
        this.logger = logger;
        this.autoStart = autoStart;
    }

    @NotNull
    public static final /* synthetic */ DownloadManager access$getDownloadManager$p(FetchHandlerImpl $this) {
        return $this.downloadManager;
    }

    @NotNull
    public static final /* synthetic */ DatabaseManager access$getDatabaseManager$p(FetchHandlerImpl $this) {
        return $this.databaseManager;
    }

    @NotNull
    public static final /* synthetic */ Handler access$getHandler$p(FetchHandlerImpl $this) {
        return $this.handler;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(FetchHandlerImpl $this) {
        return $this.logger;
    }
}

