/*
 * Decompiled with CFR 0.152.
 */
package com.github.tony19.loggly;

import com.github.tony19.loggly.ILogglyClient;
import com.github.tony19.loggly.ILogglyRestService;
import com.github.tony19.loggly.LogglyResponse;
import java.util.Arrays;
import java.util.Collection;
import retrofit.Callback;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.client.Response;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogglyClient
implements ILogglyClient {
    private static final String API_URL = "http://logs-01.loggly.com/";
    private final ILogglyRestService loggly;
    private final String token;
    private String tags;

    public LogglyClient(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("token cannot be empty");
        }
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint(API_URL).build();
        this.token = string;
        this.loggly = (ILogglyRestService)restAdapter.create(ILogglyRestService.class);
    }

    LogglyClient(String string, ILogglyRestService iLogglyRestService) {
        this.token = string;
        this.loggly = iLogglyRestService;
    }

    @Override
    public void setTags(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : stringArray) {
            for (String string2 : string.split(",")) {
                if (!(string2 = string2.trim()).isEmpty()) {
                    if (!bl) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(string2);
                }
                bl = false;
            }
        }
        this.tags = stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    @Override
    public boolean log(String string) {
        boolean bl;
        if (string == null) {
            return false;
        }
        try {
            bl = this.loggly.log(this.token, this.tags, (TypedInput)new TypedString(string)).isOk();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @Override
    public void log(String string, final ILogglyClient.Callback callback) {
        if (string == null) {
            return;
        }
        this.loggly.log(this.token, this.tags, (TypedInput)new TypedString(string), new Callback<LogglyResponse>(){

            public void success(LogglyResponse logglyResponse, Response response) {
                callback.success();
            }

            public void failure(RetrofitError retrofitError) {
                callback.failure(retrofitError.getMessage());
            }
        });
    }

    @Override
    public boolean logBulk(String ... stringArray) {
        if (stringArray == null) {
            return false;
        }
        return this.logBulk(Arrays.asList(stringArray));
    }

    @Override
    public boolean logBulk(Collection<String> collection) {
        boolean bl;
        if (collection == null) {
            return false;
        }
        String string = this.joinStrings(collection);
        if (string.isEmpty()) {
            return false;
        }
        try {
            bl = this.loggly.logBulk(this.token, this.tags, (TypedInput)new TypedString(string)).isOk();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @Override
    public void logBulk(Collection<String> collection, final ILogglyClient.Callback callback) {
        if (collection == null) {
            return;
        }
        String string = this.joinStrings(collection);
        if (string.isEmpty()) {
            return;
        }
        this.loggly.logBulk(this.token, this.tags, (TypedInput)new TypedString(string), new Callback<LogglyResponse>(){

            public void success(LogglyResponse logglyResponse, Response response) {
                callback.success();
            }

            public void failure(RetrofitError retrofitError) {
                callback.failure(retrofitError.getMessage());
            }
        });
    }

    private String joinStrings(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : collection) {
            if (string == null || string.isEmpty()) continue;
            stringBuilder.append(string.replaceAll("[\r\n]", "\r")).append('\n');
        }
        return stringBuilder.toString();
    }
}

